<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use \Illuminate\Http\UploadedFile;
use App\Archivos;
use File;

class ArchivosController extends Controller
{   
    public function deleteFiles(Request $request)
    {
        $str_ruta       = $request->ruta;
        $nm_archivo     = $request->nm_archivo;
        $id_consulta    = $request->id_consulta;

        $public_path    = public_path();
        $url            = \Storage::disk('public')->getAdapter()->getPathPrefix().$str_ruta;

        Archivos::where('nr_id','=',$id_consulta)
                    ->where('nm_archivo','=',$nm_archivo)
                    ->delete();

        if(file_exists($url))
            File::delete($url);

        return [
            'error'  =>  0,
            'title'  =>  'Eliminando Archivos.',
            'msj'    =>  'Se ha borrado archivo adjunto.'
        ];
    }

    public function getFile(Request $request)
    {
        $str_ruta       = $request->ruta;
        $public_path    = public_path();
        $url            = \Storage::disk('public')->getAdapter()->getPathPrefix().$str_ruta;

        if(file_exists($url))
            return response()->download($url);
        else
            abort(404);
    }

    public function getPreview(Request $request)
    {
        $str_ruta   =   $request->ruta;
        $subpath    =   'public/'.$str_ruta;
        $path       =   storage_path('app/'.$subpath);

        if (file_exists($path)) {
            $docContent     =   \Storage::get($subpath);
            $type           =   \Storage::mimeType($subpath);
           
            return \Response::make($docContent, 200, [
                'Content-Type'        => $type,
                //'Content-Disposition' => 'inline; filename="'.$manuscript->file_name.'"',
            ]);
        }
        else {
            return response()->json([
                'error'     =>  true,
                'title'     =>  'Revisar Archivo',
                'msj'       =>  'Archivo no encontrado.',
            ], 400);
        }
    }

    public static function registrarArchivo($tp_tabla, $nr_id, $arr_files = [], $arr_files_obs = [])
    {
        $ruta           =   '';
        $file           =   '';
        $ext            =   '';
        $fecha          =   '';
        $nm_archivo     =   '';
        $descripcion    =   '';
        $tp_activo      =   1;
        $valida         =   [];

        try {
            $valida     =   [
                                'error'     =>  0,
                                'title'     =>  'Almacenando Archivos',
                                'msj'       =>  'Registrando archivos adjuntos',
                            ];

            if($arr_files)
            {
                $fecha  =   Date("YmdHis");

                for ($i=0; $i < count($arr_files); $i++) 
                { 
                    $file           =   $arr_files[$i];
                    $str_obs        =   (isset($arr_files_obs[$i]) && trim($arr_files_obs[$i]) !== '') ? trim($arr_files_obs[$i]) : '';
                    $nm_archivo     =   $file->getClientOriginalName();
                    $ext            =   $file->getClientOriginalExtension();
                    $ruta           =   'Unidad_Territorial/'.$tp_tabla.'/'.$nr_id.'/'.'archivo'.'_'.$i.'_'.$fecha.'.'. $ext;

                    // Alamacena archivo
                    \Storage::disk('public')->put($ruta, \File::get($file));
                    

                    // Registra archivo
                    $documento                  =       new Archivos();
                    $documento->tp_tabla        =       $tp_tabla;
                    $documento->nr_id           =       $nr_id;
                    $documento->nm_archivo      =       $nm_archivo;
                    $documento->str_observacion =       $str_obs;
                    $documento->str_archivo     =       $ruta;
                    $documento->ext_archivo     =       $ext;
                    $documento->tp_activo       =       $tp_activo;
                    $documento->save();
                }
            }
        } catch (Exception $e) {
            $valida     =   [
                                'error'     =>  1,
                                'title'     =>  'Almacenando Archivos',
                                'msj'       =>  'Se ha producido una exepción, no se ha competado el registro de los archivos adjuntos',
                            ];

            $arr_error  =   [
                                'exception' =>  $e->getMessage(),
                                'toString'  =>  $e->__toString(),
                            ];

            \Log::debug(__METHOD__ . " Errors : " . print_r($arr_error, true));
        }

        return $valida;
    }
}
