<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use App\User;
use Exception;
use Mail;

use Illuminate\Http\Request;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/home';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except(['logout','change']);
    }

    /**
     * @param  \Illuminate\Http\Request $request
     */
    protected function credentials(Request $request) {
        $rut = $request->input('rut');
        $password = $request->input('password');
        return ['rut' => $rut, 'password' => $password, 'tp_activo' => 1];
    }

    public function showLoginForm()
    {
        // Get URLs
        $urlPrevious = url()->previous();
        $urlBase = url()->to('/');

        // Set the previous url that we came from to redirect to after successful login but only if is internal
        if(($urlPrevious != $urlBase . '/login') && (substr($urlPrevious, 0, strlen($urlBase)) === $urlBase)) {
            //session()->put('url.intended', $urlPrevious);
        }
        
        return view('template.Adminlte.auth.login');
    }

    public function login(Request $request)
    {
        $this->validateLogin($request);

        $data   = []; 
        $error  = '';

        if ($this->attemptLogin($request)) {
            $user = $this->guard()->user();
            $user->generateToken();

            $data = $user->toArray();


        }else{
            $error = 'Login incorrecto';
        }


        if ($request->expectsJson()) {
            return response()->json([
                'data' => $data, 'error' => $error
            ]);
        }

        return $this->sendFailedLoginResponse($request);
    }

    public function logout(Request $request)
    {

        if ($request->expectsJson()) {

            $user = Auth::guard('api')->user();

              if ($user) {
                $user->api_token = null;
                $user->save();
                
                return response()->json(['data' =>[], 'error' => 'User logged out.'], 200);
            }else{
                return response()->json(['data' =>[], 'error' => 'Invalid Token'], 200);
            }

            
        }


        $this->guard()->logout();

        $request->session()->invalidate();

        return $this->loggedOut($request) ?: redirect('/login');

    }

    public function reset(Request $request)
    {
        $error = '';

        try{
            $tmp_passwd = Str::random(5);
            $email      = $request->email;
            $from       = env('MAIL_FROM_ADDRESS','app@api.sanmiguel.cl');
    
            $usuario = User::where('email',$request->email);

            if($usuario->count()){

                $usuario->update([
                    'password'          => Hash::make($tmp_passwd),
                    'has_reset_passwd'  => 1    
                ]);
        
                //enviar correo con la clave de reseteo
        
                Mail::send('emails.reset',['password' => $tmp_passwd

                                                ],function($message) use ($email,$from) 
                                                    {
                                                        $message->to($email)
                                                                ->subject('App San Miguel - Clave Temporal')                          // Asunto
                                                                ->from($from,'Reset Password'); // Desde
                                                    }
                );

            }else{
                $error = 'El correo electrónico no está registrado.';
            }

        }catch(Exception $e){
            $error = 'Se produjo un error al intentar resetear el password.';
        }


        return response()->json(['data' =>[], 'error' => $error], 200);
    }

    public function change(Request $request)
    {
        $error = '';

        try{

            $usuario = User::where('api_token',$request->api_token)->update([
                'password'          => Hash::make($request->new_password),
                'has_reset_passwd'  => 0    
            ]);
    
        }catch(Exception $e){
            $error = 'Se produjo un error al intentar cambiar el password.';
        }
        
        return response()->json(['data' =>[], 'error' => $error], 200);
    }

    public function username()
    {
        return 'rut';
    }
    
}
