<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;
use App\Comunas;



class BusController extends Controller
{

    public static function parseRutRC($body)
    {
        $token      =   env('TOKEN_API');
        $headers    =   [
                            'Authorization' => 'Bearer ' . $token,
                            'Accept'        => 'application/json',
                            'Content-Type'  => 'application/json'
                        ];

        $options    =   ['body' => json_encode($body->all()),'headers' => $headers ];

        return $options;
    }


    public static function storeVecino(Request $request)
    {
        $arr_error              =   ['error' => 0];
        $request['origen']      =   'ATENCION VECINO';
        $request['nombre']      =   $request['nm_vecino'];
        $request['rut']         =   $request['rut_vecino'];
        $request['email']       =   $request['nm_mail'];
        $request['celular']     =   $request['pre_fijo'][-1].$request['nr_telefono'];
        $id_comuna              =   $request['nr_comuna'];

        $comuna                 =   Comunas::where('id','=',$id_comuna)->first();

        if(!$comuna)
            $cod_comuna = 13130;

        else
        {
            $cod_comuna            = $comuna->cod_comuna;
            $request['cod_comuna'] = $cod_comuna;
        }

        if($id_comuna == 287)
        {
            $info =  json_decode($request['arr_ubicacion_vecino'][0],True,2);
            $request['id_direccion'] = $info['value'];
            $request['nm_direccion'] = $info['label'];
        }
        else
        {
            $request['nm_direccion'] = $request['nm_ubicacion_vecino'];
            $request['id_direccion'] = Null;
        }


        $options    =   self::parseRutRC($request);
        // dd($request->all());
        \Log::error($options);

        try {
            $client     =   new Client(["base_uri" => env('HOST_BUS')]);
            $response   =   $client->post("/api/maestros/vecinos", $options);
            $temp       =   json_decode($response->getBody());
        } catch (RequestException $e) {
            $arr_error  =   [
                                'error'     =>  $e->getMessage(),
                                'request'   =>  $e->getRequest(),
                            ];

            if($e->hasResponse()){
                if ($e->getResponse()->getStatusCode() == '400'){
                    $arr_error  =   array_merge($arr_error, ['response' => $e->getResponse()]);
                }
            }

            \Log::debug(__METHOD__ . " Servicio BusDatos : " . print_r($arr_error, true));
        }catch(Exception $e){
            $arr_error  =   [
                                'msj'       =>  'Se ha producido una exepción, no se ha competado el registro ',
                                'error'     =>  $e->getMessage(),
                                'toString'  =>  $e->__toString(),
                            ];

            \Log::debug(__METHOD__ . " Servicio BusDatos : " . print_r($arr_error, true));
        }

        return $arr_error;
    }
}
