<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Carbon;

/*
*  Controlador de Clave Única que realiza petición a la pasarela de Clave Única de San Miguel 
*  con su respectivo KEY y SECRET, con el cual diferencia a los sistemas que realizan a petición 
*  al realizar la conexión exitosa este deriva a la petición de Clave Única del Gobierno el cual 
*  al validar correctamente retorna el formualrio de clave unica para el inicio de sesión.
*  Se delcara tambien la variable CU_REDIRECT_TO para redireccionar una vez iniciada la sesión 
*  correctamente en el formulario de Clave Única a la vista correspondiente
*/

class ClaveUnicaMLCController extends Controller
{

    private $base_uri       = 'https://claveunica.sanmiguel.cl';
    private $key;
    private $secret;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->key    = ENV('CU_KEY');
        $this->secret = ENV('CU_SECRET');
        $this->redirect_to = ENV('CU_REDIRECT_TO','/');
    }

    public function envia()
    {
        $state = bin2hex(random_bytes(16));

        $url = "{$this->base_uri}/clave-unica/$this->key/{$state}";

        return Redirect::to($url);
    }

    public function recibe()
    {
        $state  = Input::get('estado');
        $code   = Input::get('codigo');

        $params = [
                    'secret'    => $this->secret,
                    'code'      => $code,
        ];

        $url = $this->base_uri."/clave-unica/auth-info";

        $config = [
            'query'         => http_build_query($params),
            'httpHeaders'   => [
                                    "cache-control: no-cache"
                                ],
        ];

        $response = $this->llamadaApi($url,$config);

        $data = json_decode($response);

        Session::put('clave-unica',$data);

        return redirect($this->redirect_to);
    }

    public function logout(){
        Session::forget('clave-unica');
        return redirect('/');
    }

    public function vars(){
        dump(session()->all());
    }

    private function llamadaApi($url,$config){

            $curl = curl_init();
            
            curl_setopt_array($curl, array(
                                            CURLOPT_URL             => $url,
                                            CURLOPT_RETURNTRANSFER  => true,
                                            CURLOPT_ENCODING        => "",
                                            CURLOPT_MAXREDIRS       => 10,
                                            CURLOPT_TIMEOUT         => 30,
                                            CURLOPT_HTTP_VERSION    => CURL_HTTP_VERSION_1_1,
                                            CURLOPT_CUSTOMREQUEST   => "POST",
                                            CURLOPT_POSTFIELDS      => $config['query'],
                                            CURLOPT_HTTPHEADER      => $config['httpHeaders']
                                            )
            );
            
            $response = curl_exec($curl);
            $err = curl_error($curl);
            
            curl_close($curl);

            if ($err) {
                echo "cURL Error #:" . $err;
            } else {
                return $response;
            }


    }



}
