<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use App\Tipo;
use App\Solicitud;
use App\Vecino;
use App\Territorial;
use App\MacroTerritorio;
use App\User;
use App\Roles;
use App\DistribucionTerritorio;
use App\Notificacion;
use Mail;
use DB;
use Exception;
use Swift_TransportException;
use Swift_RfcComplianceException;

use App\Http\Controllers\UtilController;

class EmailController extends Controller
{
    public static function logicaCorreo($tp_correo = 1, $nr_solicitud = 1)
    {
            $emails             =   [];
            $tmp                =   [];
            $data               =   [];
            $arr_info           =   null;
            $solicitud          =   null;
            $servicio           =   null;
            $nr_ticket          =   null;
            $id_unidadvecinal   =   null;
            $id_macroterritorio =   null;
            $tp_visado_mt       =   null;
            $id_tipo            =   null;
            $id_estado          =   null;
            $rut_vecino         =   null;
            $id_autor           =   null;
            $id_direccion       =   null;
            $id_depto           =   null;
            $nr_nivel           =   null;
            $tp_macrozona       =   null;
            $tp_asignacion      =   null;
            $id_user            =   @Auth::user()->id?:-1;
            $id_territorial     =   @Auth::user()->id_territorial?:-1;
            $name               =   @Auth::user()->name?:"Web";
            $id_user            =   @Auth::user()->id?:-1;
            $asunto             =   '';
            $id_direccion       =   1;
            $rut_municipal      =   '69070400-5';
            
            $tp_aviso           =   1;
            $arr_valida         =   [];

            try {
                $solicitud      =   UtilController::getDataSolicitud($nr_solicitud);
                $servicio       =   UtilController::getDataServicio($solicitud->id_tipo);

                if($solicitud && $servicio)
                {
                    $arr_info   =   UtilController::getConsultaSolicitud($nr_solicitud);

                    $nr_ticket          =   $solicitud->nr_ticket;
                    $id_unidadvecinal   =   $solicitud->id_unidadvecinal;
                    $id_macroterritorio =   $solicitud->id_macroterritorio;
                    $tp_visado_mt       =   $solicitud->tp_visado_mt;
                    $id_tipo            =   $solicitud->id_tipo;
                    $id_estado          =   $solicitud->id_estado;
                    $rut_vecino         =   $solicitud->nr_rut_vecino;
                    $id_autor           =   $solicitud->id_autor;
                    $id_direccion       =   $servicio->id_direccion;
                    $id_depto           =   $servicio->id_depto;
                    $nr_nivel           =   $servicio->nr_nivel;
                    $tp_macrozona       =   $servicio->tp_macrozona;
                    $tp_asignacion      =   $servicio->tp_asignacion;

                    //  1. formulario | 2. territorial | 3. funcionario | 5. administrador | 4. macrozona | 6. Reuniones Comunitarias | 7. Redes Sociales | 8. Concejales | 9. App Movil 
                    if(in_array($tp_correo, [1,2,3,4,5,6,7,8,9,10]) && $tp_macrozona == 1 && $id_estado == 1) // Por validar
                    {
                        $tp_aviso   =   1;
                        $asunto     =   'Validar Solicitud Ingresada - Ticket #' . $nr_ticket;
                        $data       =   DistribucionTerritorio::
                                        join('users as u','u.id','=','gsut_distribucion_territorio.id_user')
                                        ->select('u.name','u.email')
                                        ->where('gsut_distribucion_territorio.tp_tabla','=','tb_macroterritorio')
                                        ->where('gsut_distribucion_territorio.nr_id','=',$id_macroterritorio)
                                        ->where('u.tp_activo','1')
                                        ->get();
                    }
                    else if(in_array($tp_correo, [1,2,3,4,5,6,7,8,9,10]) && ($tp_macrozona == 0 || $tp_macrozona == 1) && $tp_asignacion == 1 && $id_estado == 2) // Por Asignar
                    {
                        $tp_aviso   =   2;
                        $asunto     =   'Asignar Solicitud Ingresada - Ticket #' . $nr_ticket;
                        $data       =   Roles::
                                        join('users as u','u.id_rol','=','gsut_roles.id')
                                        ->select('u.name','u.email')
                                        ->where('gsut_roles.id','=',9) // Rol Asignador
                                        ->where('u.tp_activo','1')
                                        ->get();
                    }
                    else if(in_array($tp_correo,[1,2,3,4,5,6,7,8,9,10]) && $id_estado == 3) // En Gestion
                    {
                        $tp_aviso   =   3;
                        $asunto     =   'Revisar Solicitud Ingresada - Ticket #' . $nr_ticket;
                        $data       =   User::
                                        join('gsut_encargado_solicitud as es','es.id_encargado','=','users.id')
                                        ->select('users.name','users.email')
                                        ->where('es.id_solicitud','=',$nr_solicitud)
                                        ->where('es.tp_activo','=','1')
                                        ->where('users.tp_activo','1')
                                        ->get();
                    }
                    else if(in_array($tp_correo,[1,2,3,4,5,6,7,8,9,10]) && $id_estado == 4) // En Revision
                    {
                        $tp_aviso   =   4;
                        $asunto     =   'Revisar Solicitud Ingresada - Ticket #' . $nr_ticket;
                        $data       =   User::
                                        join('gsut_encargado_solicitud as es','es.id_encargado','=','users.id')
                                        ->select('users.name','users.email')
                                        ->where('es.id_solicitud','=',$nr_solicitud)
                                        ->where('users.tp_activo','1')
                                        ->get();
                    }
                    else if(in_array($tp_correo,[2,3,4,5,6,7]) && $id_estado == 5) // Publicada
                    {
                        $tp_aviso   =   5;
                        $asunto     =   'Solicitud Publicada - Ticket #' . $nr_ticket;
                        $data       =   User::
                                        join('gsut_encargado_solicitud as es','es.id_encargado','=','users.id')
                                        ->select('users.name','users.email')
                                        ->where('es.id_solicitud','=',$nr_solicitud)
                                        ->where('users.tp_activo','1')
                                        ->get();
                    }
                    else if(in_array($tp_correo,[2,3,4,5,6,7]) && $id_estado == 6) // Finalizada 
                    {
                        $tp_aviso   =   6;
                        $asunto     =   'Solicitud Finalizada - Ticket #' . $nr_ticket;
                        $data       =   User::
                                        join('gsut_encargado_solicitud as es','es.id_encargado','=','users.id')
                                        ->select('users.name','users.email')
                                        ->where('es.id_solicitud','=',$nr_solicitud)
                                        ->where('users.tp_activo','1')
                                        ->get();
                    }
                    else if(in_array($tp_correo,[2,3,4,5,6,7]) && $id_estado == 7) // Anulada
                    {
                        $tp_aviso   =   7;
                        $asunto     =   'Solicitud Anulada - Ticket #' . $nr_ticket;
                        $temp       =   [];
                        $autor      =   null;
                        $macrozona  =   null;
                        $asignador  =   null;
                        $encargado  =   null;

                        if($id_autor != 0)
                        {
                            $temp       =   User::
                                            join('gsut_encargado_solicitud as es','es.id_encargado','=','users.id')
                                            ->select('users.name','users.email')
                                            ->where('es.id_solicitud','=',$nr_solicitud)
                                            ->where('users.tp_activo','1');

                            if($temp->count())
                                $autor  =   $temp;
                        }

                        if($tp_macrozona == 1 && $id_estado >= 1)
                        {
                            $temp       =   DistribucionTerritorio::
                                            join('users as u','u.id','=','gsut_distribucion_territorio.id_user')
                                            ->select('u.name','u.email')
                                            ->where('gsut_distribucion_territorio.tp_tabla','=','tb_macroterritorio')
                                            ->where('gsut_distribucion_territorio.nr_id','=',$id_macroterritorio)
                                            ->where('u.tp_activo','1');

                            if($temp->count())
                                $macrozona  =   $temp;
                        }

                        if($tp_asignacion == 1 && $id_estado >= 2)
                        {
                            $temp       =   Roles::
                                            join('users as u','u.id_rol','=','gsut_roles.id')
                                            ->select('u.name','u.email')
                                            ->where('gsut_roles.id','=',9) // Rol Asignador
                                            ->where('u.tp_activo','1');

                            if($temp->count())
                                $asignador  =   $temp;
                        }

                        if($id_estado >= 3)
                        {
                            $temp       =   User::
                                            join('gsut_encargado_solicitud as es','es.id_encargado','=','users.id')
                                            ->select('users.name','users.email')
                                            ->where('es.id_solicitud','=',$nr_solicitud)
                                            ->where('users.tp_activo','1');

                            if($temp->count())
                                $encargado  =   $temp;
                        }

                        /*
                        dd([
                            'autor'         =>  ($autor != null) ? $autor->get()->toArray() : null,
                            'macrozona'     =>  ($macrozona != null) ? $macrozona->get()->toArray() : null,
                            'asignador'     =>  ($asignador != null) ? $asignador->get()->toArray() : null,
                            'encargado'     =>  ($encargado != null) ? $encargado->get()->toArray() : null,
                        ]);
                        */
                        
                        if($autor != null && $macrozona != null && $asignador != null && $encargado != null)
                            $data   =   $autor->union($macrozona, $asignador, $encargado)->get();
                        if($autor == null && $macrozona != null && $asignador != null && $encargado != null)
                            $data   =   $macrozona->union($asignador, $encargado)->get();
                        if($autor == null && $macrozona == null && $asignador != null && $encargado != null)
                            $data   =   $asignador->union($encargado)->get();
                        if($autor == null && $macrozona == null && $asignador == null && $encargado != null)
                            $data   =   $encargado->get();
                        if($autor != null && $macrozona == null && $asignador != null && $encargado != null)
                            $data   =   $autor->union($asignador, $encargado)->get();
                        if($autor != null && $macrozona == null && $asignador == null && $encargado != null)
                            $data   =   $autor->unionAll($encargado)->get();
                        if($autor != null && $macrozona == null && $asignador == null && $encargado == null)
                            $data   =   $autor->get();
                        if($autor == null && $macrozona != null && $asignador != null && $encargado == null)
                            $data   =   $macrozona->unionAll($asignador)->get();
                        if($autor == null && $macrozona != null && $asignador == null && $encargado == null)
                            $data   =   $macrozona->get();
                    }
                    else if(in_array($tp_correo,[10]) && ($id_estado == 5 || $id_estado == 6)) // Expediente
                    {
                        $tp_aviso   =   10;
                        $asunto     =   'Se Agrega Expediente a la Solicitud - Ticket #' . $nr_ticket;
                        $data       =   User::
                                        join('gsut_encargado_solicitud as es','es.id_encargado','=','users.id')
                                        ->select('users.name','users.email')
                                        ->where('es.id_solicitud','=',$nr_solicitud)
                                        ->where('users.tp_activo','1')
                                        ->get();
                    }
                    else if(in_array($tp_correo,[15]) && $id_estado == 4) // VB Jefatura
                    {
                        $tp_aviso   =   $tp_correo;
                        $asunto     =   'Validar Gestión de Solicitud - Ticket #' . $nr_ticket;
                        $data       =   Roles::
                                        join('users as u','u.id_rol','=','gsut_roles.id')
                                        ->select('u.name','u.email')
                                        ->where('gsut_roles.id','=',23) // Administrador Depto
                                        ->where('u.id_depto','=',$solicitud->id_depto_destino)
                                        ->where('u.tp_activo','=','1')
                                        ->get();
                    }
                    else if(in_array($tp_correo,[16]) && $id_estado == 4) // VB Director
                    {
                        $tp_aviso   =   $tp_correo;
                        $asunto     =   'Validar Gestión de Solicitud - Ticket #' . $nr_ticket;
                        $data       =   Roles::
                                        join('users as u','u.id_rol','=','gsut_roles.id')
                                        ->select('u.name','u.email')
                                        ->where('gsut_roles.id','=',21) // Administrador Director
                                        ->where('u.id_direccion','=',$solicitud->id_direccion_destino)
                                        ->where('u.tp_activo','=','1')
                                        ->get();
                    }
                    else if(in_array($tp_correo,[20,21]) && $id_estado == 4) // Notifica al Director
                    {
                        $tp_aviso   =   $tp_correo;
                        $asunto     =   'Validar Gestión de Solicitud - Ticket #' . $nr_ticket;
                        $data       =   Roles::
                                        join('users as u','u.id_rol','=','gsut_roles.id')
                                        ->select('u.name','u.email')
                                        ->where('gsut_roles.id','=',21) // Director Unidad
                                        ->where('u.id_direccion','=',$solicitud->id_direccion_destino)
                                        ->where('u.tp_activo','1')
                                        ->get();
                    }
                    else if(in_array($tp_correo,[30,31]) && $id_estado == 4) // Notifica al Jefe Depto
                    {
                        $tp_aviso   =   $tp_correo;
                        $asunto     =   'Validar Gestión de Solicitud - Ticket #' . $nr_ticket;
                        $data       =   Roles::
                                        join('users as u','u.id_rol','=','gsut_roles.id')
                                        ->select('u.name','u.email')
                                        ->where('gsut_roles.id','=',23) // Jefe Depto
                                        ->where('u.id_depto','=',$solicitud->id_depto_destino)
                                        ->where('u.tp_activo','1')
                                        ->get();
                    }
                    else if(in_array($tp_correo,[50]) && in_array($id_estado,[1,2,3]))
                    {
                        $tp_aviso   =   $tp_correo;
                        $asunto     =   'Solicitud Ingresada - Ticket #' . $nr_ticket;
                        $data       =   Roles::
                                        join('gsut_user_rol as ur','ur.id_rol','=','gsut_roles.id')
                                        ->join('users as u','u.id','=','ur.id_user')
                                        ->select('u.name','u.email')
                                        ->whereIn('gsut_roles.id',[7]) // Administrador
                                        ->where('u.id_depto','=','5') // Atencino al Vecino
                                        ->where('u.tp_activo','=','1')
                                        ->get();

                        // \Log::debug(__METHOD__ . " Mails Administradores : " . print_r($data->first()->toArray(), true));
                    }
                    else if(in_array($tp_correo,[101,102,103,104,105]))
                    {
                        $tp_aviso   =   $tp_correo;
                        $asunto     =   'Solicitud de Atención Vecino - Ticket #' . $nr_ticket;
                        $data       =   Vecino::
                                        select('nm_vecino as name','nm_mail as email')
                                        ->where('nr_rut','=',$rut_vecino)
                                        ->get();

                        $name   =   $data->first()->name;
                    }
                    /*
                    $arr_data   =   [
                        'nr_solicitud'      =>  $nr_solicitud,
                        'tp_correo'         =>  $tp_correo,
                        'tp_aviso'          =>  $tp_aviso,
                        'id_macrozona'      =>  $solicitud->id_macroterritorio,
                        'id_unidadvecinal'  =>  $solicitud->id_unidadvecinal,
                        'rut_vecino'        =>  $solicitud->nr_rut_vecino,
                        'estado'            =>  $solicitud->id_estado,
                        'arr_info'          =>  $arr_info,
                        'solicitud'         =>  $solicitud->toArray(),
                        'servicio'          =>  $servicio->toArray(),
                        'data'              =>  ($data) ? $data->toArray() : null,
                    ];
                    */
                    // \Log::debug(__METHOD__ . " Se envia notificación para : " . print_r($arr_data, true));

                    try {
                        $tmp    =   $data->unique('email')->pluck('email')->toArray();
                    } catch (Exception $e) {
                        $tmp    =   [];
                    }
                }

                foreach ($tmp as $key) 
                { 
                    if(!in_array($key,$emails))
                        $emails[]  = $key;
                }

                $arr_valida     =  [
                    'emails'            =>  $emails,
                    'asunto'            =>  $asunto,
                    'nr_rut'            =>  $rut_vecino,
                    'name'              =>  $name,
                    'id_territorial'    =>  $id_territorial,
                    'id_direccion'      =>  $id_direccion,
                    'nr_ticket'         =>  $nr_ticket,
                    'tp_notificacion'   =>  $tp_aviso,
                    'arr_info'          =>  $arr_info,
                ];
            } catch (Exception $e) {
                $arr_valida     =  [
                    'emails'            =>  $emails,
                    'asunto'            =>  $asunto,
                    'name'              =>  $name,
                    'id_territorial'    =>  $id_territorial,
                    'id_direccion'      =>  $id_direccion,
                    'nr_ticket'         =>  $nr_ticket,
                    'tp_notificacion'   =>  $tp_aviso,
                    'arr_info'          =>  $arr_info,
                ];
            }
                

            return $arr_valida;
    }

    public static function enviarNotificaciones($tp_correo, $nr_solicitud)
    {
        $arr_error  =   [];
        
        if(env('TP_NOTIFICAR') == 1)
        {
            try {
                $data_tp_correo     =   [];
                $tmp                =   [];
                $emails             =   [];
                $hoy                =   Date("d-m-Y");
                $data_tp_correo     =   self::logicaCorreo($tp_correo, $nr_solicitud);
                $email_sistema      =   env('EMAIL_ENVIO');
                $url_sistema        =   'https://atencionvecino.sanmiguel.cl';
                $from               =   'atencionvecino@sanmiguel.cl';
                $emails             =   $data_tp_correo['emails'];
                $nr_ticket          =   $data_tp_correo['nr_ticket'];
                $asunto             =   $data_tp_correo['asunto'];
                $rut_autor          =   $data_tp_correo['nr_rut'];
                $nm_autor           =   $data_tp_correo['name'];
                $tp_notificacion    =   $data_tp_correo['tp_notificacion'];
                $arr_info           =   $data_tp_correo['arr_info'];

                $arr_envio          =   [
                    'tp_correo'     =>  $tp_correo,
                    'nr_solicitud'  =>  $nr_solicitud,
                    'nr_ticket'     =>  $nr_ticket,
                    'tp_aviso'      =>  $tp_notificacion,
                    'asunto'        =>  $asunto,
                    'from'          =>  $from,
                    'to'            =>  $emails,
                    'rut_persona'   =>  $rut_autor,
                    'nm_persona'    =>  $nm_autor
                ];
                
                \Log::debug(__METHOD__ . " Se envia notificación para : " . print_r($arr_envio, true));

                Mail::send('emails.notificacion',    [
                        'tp_notificacion'   =>  $tp_notificacion,
                        'tp_correo'         =>  $tp_correo,
                        'nm_autor'          =>  $nm_autor,
                        'nr_solicitud'      =>  $nr_solicitud,
                        'nr_ticket'         =>  $nr_ticket,
                        'hoy'               =>  $hoy,
                        'arr_info'          =>  $arr_info,
                    ],function($message) use ($emails,$asunto,$from,$email_sistema,$tp_notificacion) 
                    {
                        $message
                        ->to($emails)
                        ->subject($asunto)     
                        ->from($from,'Sistema Atención al Vecino San Miguel');
                        //->bcc($email_sistema);
                });

                // Se registra notificcion en la tabla
                $notificacion   =   [
                    'nr_solicitud'      =>  $nr_solicitud,
                    'nr_ticket'         =>  $nr_ticket,
                    'desde'             =>  $from,
                    'para'              =>  json_encode($emails),
                    'tp_notificacion'   =>  $tp_notificacion,
                    'str_asunto'        =>  $asunto,
                ];

                Notificacion::create($notificacion);
            } catch (Exception $e) {
                $arr_error  =   [
                                    'exception'=>$e->getMessage(),
                                    'toString'=>$e->__toString(),
                                ];

                if ($e instanceof Swift_TransportException) {
                    // Manejar errores relacionados con la conexión de transporte (como problemas SMTP)
                    \Log::error(__METHOD__ . ' Error de transporte al enviar correo: ' . print_r($arr_error, true));
                    // Otras acciones específicas para Swift_TransportException
                } elseif ($e instanceof Swift_RfcComplianceException) {
                    // Manejar errores relacionados con la conformidad RFC
                    \Log::error(__METHOD__ . ' Error de conformidad RFC al enviar correo: ' . print_r($arr_error, true));
                    // Otras acciones específicas para Swift_RfcComplianceException
                } else {
                    // Manejar cualquier otra excepción general
                    \Log::error(__METHOD__ . ' Error general al enviar correo: ' . print_r($arr_error, true));
                    // Otras acciones para excepciones generales
                }
            }
        }
    }

    public static function enviarNotificacionVecino($tp_correo, $nr_solicitud, $mensaje = '')
    {
        $arr_error  =   [];

        if(env('TP_NOTIFICAR') == 1)
        {
            try {
                $data_info      =   [];
                $emails         =   [];
                $hoy            =   Date("d-m-Y");
                $data_info      =   self::logicaCorreo($tp_correo, $nr_solicitud);
                $email_sistema  =   env('EMAIL_ENVIO');
                $url_sistema    =   'https://atencionvecino.sanmiguelcl';
                $from           =   'atencionvecino@sanmiguel.cl';
                $rut_vecino     =   $data_info['nr_rut'];
                $nm_vecino      =   $data_info['name'];
                $emails         =   $data_info['emails'];
                $nr_ticket      =   $data_info['nr_ticket'];
                $asunto         =   $data_info['asunto'];
                $tp_aviso       =   $data_info['tp_notificacion'];

                $arr_envio          =   [
                    'nr_solicitud'  =>  $nr_solicitud,
                    'nr_ticket'     =>  $nr_ticket,
                    'tp_aviso'      =>  $tp_aviso,
                    'asunto'        =>  $asunto,
                    'from'          =>  $from,
                    'to'            =>  $emails,
                    'rut_persona'   =>  $rut_vecino,
                    'nm_persona'    =>  $nm_vecino
                ];
                \Log::debug(__METHOD__ . " Se envia notificación para : " . print_r($arr_envio, true));

                Mail::send('emails.notificacion', [
                        'tp_notificacion'   => $tp_aviso,
                        'nm_vecino'         => $nm_vecino,
                        'nr_solicitud'      => $nr_solicitud,
                        'nr_ticket'         => $nr_ticket,
                        'mensaje'           => $mensaje,
                        'fc_fecha'          => $hoy,
                    ],function($message) use ($emails,$asunto,$from,$email_sistema) {
                        $message
                        ->to($emails)
                        ->subject($asunto)     
                        ->from($from,'Sistema de Atención al Vecino San Miguel');
                        // ->bcc($email_sistema);
                });

                // Se registra notificcion en la tabla
                $notificacion   =   [
                    'nr_solicitud'      =>  $nr_solicitud,
                    'nr_ticket'         =>  $nr_ticket,
                    'desde'             =>  $from,
                    'para'              =>  json_encode($emails),
                    'tp_notificacion'   =>  $tp_aviso,
                    'str_asunto'        =>  $asunto,
                ];

                Notificacion::create($notificacion);
            } catch (Exception $e) {
                $arr_error  =   [
                                    'exception'=>$e->getMessage(),
                                    'toString'=>$e->__toString(),
                                ];

                if ($e instanceof Swift_TransportException) {
                    // Manejar errores relacionados con la conexión de transporte (como problemas SMTP)
                    \Log::error(__METHOD__ . ' Error de transporte al enviar correo: ' . print_r($arr_error, true));
                    // Otras acciones específicas para Swift_TransportException
                } elseif ($e instanceof Swift_RfcComplianceException) {
                    // Manejar errores relacionados con la conformidad RFC
                    \Log::error(__METHOD__ . ' Error de conformidad RFC al enviar correo: ' . print_r($arr_error, true));
                    // Otras acciones específicas para Swift_RfcComplianceException
                } else {
                    // Manejar cualquier otra excepción general
                    \Log::error(__METHOD__ . ' Error general al enviar correo: ' . print_r($arr_error, true));
                    // Otras acciones para excepciones generales
                }
            }
        }
    }

    public static function testNotificaciones()
    {
        $arr_error          =   [];
        $tp_notificacion    =   101001;
        $nm_asunto          =   'Notificación de Prueba';
        $nm_from            =   'atencionvecino@sanmiguel';
        $arr_mails          =   ['INDICAR_CORREO_PARA_PRUEBAS'];

        try {
            $fc_fecha   =   Date("d-m-Y");

            Mail::send('emails.notificacion',    [
                    'fc_fecha'          =>  $fc_fecha,
                    'tp_notificacion'   =>  $tp_notificacion,
                ],function($message) use ($arr_mails, $nm_asunto, $nm_from) 
                {
                    $message
                    ->to($arr_mails)
                    ->subject($nm_asunto)     
                    ->from($nm_from, 'Sistema Atención al Vecino San Miguel');
                    //->bcc($email_sistema);
            });
        } catch (Exception $e) {
            $arr_error  =   [
                                'exception'=>$e->getMessage(),
                                'toString'=>$e->__toString(),
                            ];

            if ($e instanceof Swift_TransportException) {
                // Manejar errores relacionados con la conexión de transporte (como problemas SMTP)
                \Log::error(__METHOD__ . ' Error de transporte al enviar correo: ' . print_r($arr_error, true));
                // Otras acciones específicas para Swift_TransportException
            } elseif ($e instanceof Swift_RfcComplianceException) {
                // Manejar errores relacionados con la conformidad RFC
                \Log::error(__METHOD__ . ' Error de conformidad RFC al enviar correo: ' . print_r($arr_error, true));
                // Otras acciones específicas para Swift_RfcComplianceException
            } else {
                // Manejar cualquier otra excepción general
                \Log::error(__METHOD__ . ' Error general al enviar correo: ' . print_r($arr_error, true));
                // Otras acciones para excepciones generales
            }
        }
    }
}
