<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Historial;
use App\Despacho;
use App\Encargado;
use App\Solicitud;
use App\Respuesta;

use DB;
use Illuminate\Support\Facades\Auth;

use App\Http\Controllers\UtilController;

class GsutHistoriaController extends Controller
{
    public function index(Request $request)
    {
        $id_solicitud       =   $request->id_solicitud;
        $tp_director        =   Auth::user()->tp_cargo;
        $tp_cargo           =   UtilController::isRolGestor(); // Auth::user()->tp_cargo;


        $data   =   Historial::
                    join('gsut_solicitud as solicitud','solicitud.id','=','gsut_historial.id_solicitud')
                    ->join('users as autor','autor.id','=','gsut_historial.id_autor')
                    ->join('gsut_direccion as dir','dir.id','=','gsut_historial.id_direccion')
                    ->join('gsut_depto as depto','depto.id','=','gsut_historial.id_depto')
                    ->join('gsut_estado as estado','estado.id','=','gsut_historial.id_estado')
                    ->join('gsut_vecino as vecino','vecino.nr_rut','=','solicitud.nr_rut_vecino')
                    ->join('gsut_prioridad as prioridad','prioridad.id','=','solicitud.id_prioridad')
                    ->select('gsut_historial.id',
                        'gsut_historial.id_solicitud',
                        'gsut_historial.nr_historia',
                        'solicitud.id_direccion',
                        'solicitud.id_direccion_destino',
                        'solicitud.id_estado as id_estado_solicitud',
                        'prioridad.id as id_prioridad_solicitud',
                        'prioridad.nm_prioridad as nm_prioridad_solicitud',
                        DB::raw('concat(autor.nombre," ",autor.ap_paterno," ",autor.ap_materno) as nm_autor'),
                        DB::raw('concat(vecino.nm_vecino," ",vecino.ap_paterno," ",vecino.ap_materno) as nm_vecino'),
                        'dir.nm_direccion',
                        'depto.nm_depto',
                        DB::raw('date_format(gsut_historial.fc_inicio, "%d-%m-%Y %H:%i") as fc_inicio'),
                        DB::raw('date_format(gsut_historial.fc_termino, "%d-%m-%Y %H:%i") as fc_termino'),
                        DB::raw('(case when gsut_historial.fc_termino
                                        then timestampdiff(day, gsut_historial.fc_inicio, gsut_historial.fc_termino) 
                                        else timestampdiff(day, gsut_historial.fc_inicio, now()) 
                                        end) as fc_diferencia'),
                        'gsut_historial.str_observacion',
                        'gsut_historial.id_estado',
                        'gsut_historial.id_accion',
                        'solicitud.tp_visado_mt',
                        'solicitud.tp_visado_jt',
                        'solicitud.tp_rechazado',
                        'estado.nm_estado',
                        'gsut_historial.tp_activo')
                    ->where('gsut_historial.tp_activo','=','1')
                    ->where('gsut_historial.id_solicitud','=',$id_solicitud)
                    ->with('visador','gestor','encargado','unidad_destino','observaciones')
                    ->with(['observaciones' => function ($query)
                    {
                        $query->with('archivos');
                    }])
                    ->orderBy('gsut_historial.nr_historia')
                    ->get();

        foreach ($data as $key => $value)
        {
            $value->isDirector              =   ($tp_director == 1) ? 1 : 0;
            $value->isGestor                =   $tp_cargo; // ($tp_cargo == 4) ? 1 : 0;
            $value->solicitud_gestionada    =   $this->getSolicitudGestionada($value->id_solicitud);
            $value->respuestasFaltantes     =   $this->getRespuestasFaltantes($value->id, $value->id_estado);
            $value->esta_asignado           =   $this->getHistoriaAsignada($value->id_solicitud, $value->id);
            $value->debe_responder          =   $this->getDebeResponder($value->id_solicitud, $value->id);
            $value->respuestaRealizada      =   $this->getRespuestaRealizada($value->id, $value->id_estado);
            //if($value->nr_historia == 2)
            //    $value->tiempo_tramitado        =   UtilController::getTiempoTramitacionHistorial($value->fc_inicio, $value->fc_termino);
        }

        return ['arr_historial' => $data];
    }
    //------------------------------------------------------------
    public static function registrarHistoria($id_solicitud, $nr_servicio, $str_observacion, $str_html, $id_estado, $fc_inicio, $fc_termino)
    {
        $id_historia        =   0;
        $nr_historia        =   GsutHistoriaController::getNumeroHistoria($id_solicitud);

        //cerrar fecha historia anterior
        Historial::where('id_solicitud','=',$id_solicitud)
                    ->where('nr_historia','=',($nr_historia-1))
                    ->where('fc_termino','=',Null)
                    ->update(['fc_termino'=> Date("Y-m-d H:i:s")]);

        $id_direccion       =   @Auth::user()->id_direccion?:22; // id => 22, nm_direccion => Externos
        $id_depto           =   @Auth::user()->id_depto?:90; // id => 90, nm_depto => Plataforma Tecnologica
        $id_autor           =   @Auth::user()->id?:1; // id => 1, nr_rut => 69070400-5, name => Sistema
        $tp_activo          =   1;
        $arr_valida         =   [];

        try {
            $arr_valida     =   [
                                    'error'         =>  0,
                                    'tp_icon'       =>  'info',
                                    'title'         =>  'Registrar Historia',
                                    'msj'           =>  'registrando historia de la solicitud',
                                    'id_historia'   =>  $id_historia,
                                ];

            $info_servicio  =   UtilController::getDataServicio($nr_servicio);

            $model                      =   new Historial();
            $model->id_solicitud        =   $id_solicitud;
            $model->nr_historia         =   $nr_historia;
            $model->id_dir_tipo         =   ($info_servicio) ? $info_servicio->id_direccion : 0;
            $model->id_depto_tipo       =   ($info_servicio) ? $info_servicio->id_depto : 0;
            $model->id_tipo             =   $nr_servicio;
            $model->id_direccion        =   $id_direccion;
            $model->id_depto            =   $id_depto;
            $model->id_autor            =   $id_autor;
            $model->fc_inicio           =   $fc_inicio;
            $model->fc_termino          =   $fc_termino;
            $model->str_observacion     =   $str_observacion;
            $model->str_observacion_html=   $str_html;
            $model->id_estado           =   $id_estado;
            $model->save();

            $id_historia                =   $model->id;

            if($id_historia)
            {
                $arr_valida     =   [
                                        'error'         =>  0,
                                        'tp_icon'       =>  'success',
                                        'title'         =>  'Registrar Historia',
                                        'msj'           =>  'se ha registrando una historia',
                                        'id_historia'   =>  $id_historia,
                                    ];  
            }
            else
            {
                $arr_valida     =   [
                                        'error'         =>  1,
                                        'tp_icon'       =>  'warning',
                                        'title'         =>  'Registrar Historia',
                                        'msj'           =>  'No se ha podido registrar una historia',
                                        'id_historia'   =>  $id_historia,
                                    ];
            }
        } catch (Exception $e) {
            $arr_valida     =   [
                                    'error'         =>  1,
                                    'tp_icon'       =>  'error',
                                    'title'         =>  'Registrar Historia',
                                    'msj'           =>  'Ha ocurrido un error al registrar una historia',
                                    'id_historia'   =>  $id_historia,
                                ];
        }

        return $arr_valida;
    }
    //------------------------------------------------------------
    public static function getNumeroHistoria($id_solicitud)
    {
        $nr_historia    =   1;

        try {

            $nr_historia   =   Historial::where('id_solicitud','=',$id_solicitud)->max('nr_historia');
          
        } catch (Exception $e) {
            $nr_historia    =   0;
        }

        return $nr_historia+1;
    }
    //------------------------------------------------------------
    public function getSolicitudGestionada($id_solicitud)
    {
        $tp_gestionar   =   0;

        try {
            $data   =   Encargado::
                        join('gsut_despacho as despacho', function ($join) use ($id_solicitud)
                        {
                            $join->on('despacho.id','=','gsut_encargado.id_despacho')
                                 ->where('despacho.id_solicitud','=',$id_solicitud);
                        })
                        ->select(DB::raw('count(gsut_encargado.id) as tp_gestionar'))                        
                        ->where('gsut_encargado.tp_revisar','=',1)                        
                        ->where(function ($query) 
                        {
                            $query->where('gsut_encargado.tp_responsable','=',1)
                                  ->orWhere('gsut_encargado.tp_participante','=',1);
                        })
                        ->where('gsut_encargado.tp_activo','=',1)
                        ->get();

            if($data->count())
                $tp_gestionar   =   ($data->first()->tp_gestionar) ? 1 : 0;
        } catch (Exception $e) {
            $tp_gestionar   =   0;
        }

        return $tp_gestionar;
    }
    //------------------------------------------------------------
    public function getHistoriaAsignada($id_solicitud, $id_historia)
    {
        $id_usuario     =   Auth::user()->id;
        $tp_asignado    =   0;

        try {
            $data   =   Encargado::
                        join('gsut_despacho as despacho', function ($join) use ($id_solicitud, $id_historia)
                        {
                            $join->on('despacho.id','=','gsut_encargado.id_despacho')
                                 ->where('tp_tabla','=','tb_historial')
                                 ->where('despacho.nr_id','=',$id_historia)
                                 ->where('despacho.id_solicitud','=',$id_solicitud);
                        })
                        ->select(DB::raw('count(gsut_encargado.id) as asignado'))                        
                        ->where('gsut_encargado.tp_revisar','=',1)
                        ->where('gsut_encargado.id_encargado','=',$id_usuario)
                        ->where('gsut_encargado.tp_activo','=',1)
                        ->get();

            if($data->count())
                $tp_asignado    =   $data->first()->asignado;
        } catch (Exception $e) {
            $tp_asignado    =   0;
        }

        return $tp_asignado;
    }
    //------------------------------------------------------------
    public function getEstaAsignado($id_solicitud)
    {
        $id_usuario     =   Auth::user()->id;
        $tp_asignado    =   0;

        try {
            $data   =   Encargado::
                        join('gsut_despacho as despacho', function ($join) use ($id_solicitud)
                        {
                            $join->on('despacho.id','=','gsut_encargado.id_despacho')
                                 ->where('despacho.id_solicitud','=',$id_solicitud);
                        })
                        ->select(DB::raw('count(gsut_encargado.id) as asignado'))                        
                        ->where('gsut_encargado.tp_revisar','=',1)
                        ->where('gsut_encargado.id_encargado','=',$id_usuario)
                        ->where('gsut_encargado.tp_activo','=',1)
                        ->get();

            //dd(['id_solicitud' => $id_solicitud, 'id_usuario' => $id_usuario, 'query' => $data->toArray()]);

            if($data->count())
                $tp_asignado    =   $data->first()->asignado;
        } catch (Exception $e) {
            $tp_asignado    =   0;
        }

        return $tp_asignado;
    }
    //------------------------------------------------------------
    public function getDebeResponder($id_solicitud, $id_historia)
    {
        $id_usuario     =   Auth::user()->id;
        $tp_responder   =   0;

        try {
            $data   =   Encargado::
                        join('gsut_despacho as despacho', function ($join) use ($id_solicitud, $id_historia)
                        {
                            $join->on('despacho.id','=','gsut_encargado.id_despacho')
                                 ->where('tp_tabla','=','tb_historial')
                                 ->where('despacho.nr_id','=',$id_historia)
                                 ->where('despacho.id_solicitud','=',$id_solicitud);
                        })
                        ->select(DB::raw('count(gsut_encargado.id) as responder'))                        
                        ->where('gsut_encargado.tp_revisar','=',1)
                        ->where('gsut_encargado.id_encargado','=',$id_usuario)
                        ->where(function ($query) 
                        {
                            $query->where('gsut_encargado.tp_responsable','=',1)
                                  ->orWhere('gsut_encargado.tp_participante','=',1);
                        })
                        ->where('gsut_encargado.tp_validado','=',0)
                        ->where('gsut_encargado.tp_activo','=',1)
                        ->get();

            if($data->count())
                $tp_responder   =   $data->first()->responder;
        } catch (Exception $e) {
            $tp_responder   =   0;
        }

        return $tp_responder;
    }
    //------------------------------------------------------------
    public function getRespuestasFaltantes($id_historia, $id_estado)
    {
        $nr_faltante    =   0;

        if($id_estado == 8 || $id_estado == 9)
        {
            $data   =   Encargado::
                        join('gsut_despacho as despacho','despacho.id','=','gsut_encargado.id_despacho')
                        ->join('gsut_historial as historial', function ($join) use ($id_historia) {
                            $join->on('historial.id','=','despacho.nr_id')
                                 ->where('despacho.tp_tabla','=','tb_historial')
                                 ->where('despacho.nr_id','=',$id_historia);
                        })
                        ->select(DB::raw('count(gsut_encargado.id) as faltantes'))
                        ->where('gsut_encargado.tp_revisar','=',1)
                        ->where(function ($query) 
                        {
                            $query->where('gsut_encargado.tp_responsable','=',1)
                                  ->orWhere('gsut_encargado.tp_participante','=',1);
                        })
                        ->where('gsut_encargado.tp_validado','=','0')
                        ->where('gsut_encargado.tp_activo','=',1)
                        ->get();

            if($data->count())
                $nr_faltante    =   $data->first()->faltantes;
        }

        return $nr_faltante;
    }
    //------------------------------------------------------------
    public function getRespuestaRealizada($id_historia, $id_estado)
    {
        $id_usuario     =   Auth::user()->id;
        $nr_respondido  =   0;

        if($id_estado == 8 || $id_estado == 9)
        {
            $data   =   Encargado::
                        join('gsut_despacho as despacho','despacho.id','=','gsut_encargado.id_despacho')
                        ->join('gsut_historial as historial', function ($join) use ($id_historia) {
                            $join->on('historial.id','=','despacho.nr_id')
                                 ->where('despacho.tp_tabla','=','tb_historial')
                                 ->where('despacho.nr_id','=',$id_historia);
                        })
                        ->select(DB::raw('count(gsut_encargado.id) as respondido'))
                        ->where('gsut_encargado.id_encargado','=',$id_usuario)
                        ->where('gsut_encargado.tp_validado','=','1')
                        ->where('gsut_encargado.tp_activo','=',1)
                        ->get();

            if($data->count())
                $nr_respondido    =   $data->first()->respondido;
        }

        return $nr_respondido;
    }
    //------------------------------------------------------------
}
