<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\MaestroDirecciones;
use App\MaestroCalles;

class MaestroDireccionesController extends Controller
{
    public function index(Request $request)
    {
        $nm_direccion   =   $request->nm_direccion?:'';
        $nm_direccion   =   trim($nm_direccion);
        $data           =   [];

        if(strlen($nm_direccion) >= 3)
        {
            $data   =   MaestroDirecciones::
                        select('id as value',
                            'nm_direccion as label',
                            'nr_calle',
                            'nm_calle',
                            'str_latitud',
                            'str_longitud',
                            'cod_territorial',
                            'cod_unidadvecinal')
                        ->whereRaw('nm_direccion LIKE ?',[$nm_direccion.'%'])
                        ->orderBy('nr_calle','asc')
                        ->take(500)
                        ->get();
        }            

        return ['result'=> $data];
    }

    public static function indexCalles()
    {
        $data   =   MaestroCalles::
                    select('id as value','nm_calle as label')
                    ->get();

        return $data;
    }
}
