<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;

class RestController extends Controller
{
    //---------------------------------------------------------------------------------
    /*
    *  Consulta servicio externo de Meetcard para validar si el vecino es residente de la comuna 
    *  Si el vecino es residente y se encuentra viegente retorma un valor booleano de acuerdo a la condición (true|false)
    */
    public static function consultaTajertaVecino($nr_rut = '')
    {
        $data       =   [];
        $valida     =   false;
        $method     =   'GET';
        $ruta       =   'https://idfbfafxhk.execute-api.us-west-2.amazonaws.com/webservicelc/validar/v2';
        $atributos  =   [
                            'headers'       =>  [],
                            'form_params'   =>  []                                
                        ];

        try {
            $ruta       =   $ruta . '?apikey='.env('MEETCARD_API_KEY_CONSULTA_VECINO').'&secret='.env('MEETCARD_SECRET_KEY_CONSULTA_VECINO').'&rut='.$nr_rut;
            $client     =   new Client([
                                'exceptions' => false, // Para que no muestre Excepciones
                                'verify' => false, //si no deseas verificar certificado.
                            ]);

            $response   =   $client->request($method, $ruta);
            $response->getStatusCode();

            $data       =   json_decode($response->getBody());

            // dd(['data'  =>  $data]);

            if(isset($data->vecino->estado)) {
                if($tp_opcion == 1)
                    $valida     =   ($data->vecino->estado === 'VIGENTE' && $data->vecino->tipo_vecino === 'Residente') ? $data->vecino : false;
                if($tp_opcion == 2)
                    $valida     =   ($data->vecino->estado === 'VIGENTE') ? $data->vecino : false;
            }
        } catch (Exception $e) {
            $valida     =   false;
        }

        return $valida;
    }
    //---------------------------------------------------------------------------------
    /*
    *  Consulta a servicio externo para obtener información del vecino
    */
    public static function consultaBusDatosVecino($nr_rut = '')
    {
        $data       =   null;
        $arr_error  =   ['error' => 0];
        $method     =   'POST';
        $token      =   env('TOKEN_API');
        $headers    =   [
                            'Authorization'     =>  'Bearer ' . $token,
                            'Accept'            =>  'application/json',
                            'Content-Type'      =>  'application/json'
                        ];
        $atributos  =   [
                            'body'      =>  json_encode((Object) ['rut' => $nr_rut]),
                            'headers'   =>  $headers 
                        ];

        try {
            $client     =   new Client(["base_uri" => env('HOST_BUS')]);
            $response   =   $client->post("/api/maestros/vecinos/get", $atributos);
            $info       =   json_decode($response->getBody());

            if($info->error == 0)
                $data   =   $info->data;
        } catch (RequestException $e) {
            $arr_error  =   [
                                'error'     =>  $e->getMessage(),
                                'request'   =>  $e->getRequest(),
                            ];

            if($e->hasResponse()){
                if ($e->getResponse()->getStatusCode() == '400'){
                    $arr_error  =   array_merge($arr_error, ['response' => $e->getResponse()]);
                }
            }

            \Log::debug(__METHOD__ . " Servicio BusDatos : " . print_r($arr_error, true));
        }catch(Exception $e){
            $arr_error  =   [
                                'msj'       =>  'Se ha producido una exepción, no se ha competado el registro ',
                                'error'     =>  $e->getMessage(),
                                'toString'  =>  $e->__toString(),
                            ];

            \Log::debug(__METHOD__ . " Servicio BusDatos : " . print_r($arr_error, true));
        }

        return $data;
    }
    //---------------------------------------------------------------------------------
    /*
    *  Consulta a servicio externo para obtener listado de los paises y nacionalidad
    */
    public static function getPaises()
    {
        $arr_data       =   [];
        $str_method     =   'GET';
        $str_ruta       =   'https://bus-datos.sanmiguel.cl/api/maestros/paises';
        $arr_attrib     =   [];
        $arr_params     =   [];
        $arr_headers    =   [
                                'verify'    =>  false,
                                'headers'   =>  [
                                                    'Authorization'     =>  'Bearer ' .env('TOKEN_API'),
                                                    'Accept'            =>  'application/json',
                                                    'Content-Type'      =>  'application/json'
                                                ]
                            ];

        try {
            $arr_attrib =   array_merge($arr_attrib, $arr_headers, $arr_params);
            $client     =   new Client([
                                'exceptions'    => false, // Para que no muestre Excepciones
                                'verify'        => false, //si no deseas verificar certificado.
                            ]);

            $response   =   $client->request($str_method, $str_ruta, $arr_attrib);
            $response->getStatusCode();
            $arr_data   =   json_decode($response->getBody()->getContents());
        } catch (RequestException $e) {
            if ($e->getResponse()->getStatusCode() == '400') {
                \Log::debug(__METHOD__ . $e->getMessage());
            }
        }

        return $arr_data;
    }
    //---------------------------------------------------------------------------------
    /*
    *  Consulta a servicio externo para obtener listado de las regiones
    */
    public static function getRegiones()
    {
        $arr_data       =   [];
        $str_method     =   'GET';
        $str_ruta       =   'https://bus-datos.sanmiguel.cl/api/maestros/regiones';
        $arr_attrib     =   [];
        $arr_params     =   [];
        $arr_headers    =   [
                                'verify'    =>  false,
                                'headers'   =>  [
                                                    'Authorization'     =>  'Bearer ' . env('TOKEN_API'),
                                                    'Accept'            =>  'application/json',
                                                    'Content-Type'      =>  'application/json'
                                                ]
                            ];

        try {
            $arr_attrib =   array_merge($arr_attrib, $arr_headers, $arr_params);
            $client     =   new Client([
                                'exceptions'    => false, // Para que no muestre Excepciones
                                'verify'        => false, //si no deseas verificar certificado.
                            ]);

            $response   =   $client->request($str_method, $str_ruta, $arr_attrib);
            $response->getStatusCode();
            $arr_data   =   $response->getBody()->getContents();
        } catch (RequestException $e) {
            if ($e->getResponse()->getStatusCode() == '400') {
                \Log::debug(__METHOD__ . $e->getMessage());
            }
        }

        return $arr_data;
    }
    //---------------------------------------------------------------------------------
    /*
    *  Consulta a servicio externo para obtener listado de las comunas de acuerdo con la región buscada
    */
    public static function getComunas(Request $request)
    {
        $arr_data       =   [];
        $str_method     =   'GET';
        $str_ruta       =   'https://bus-datos.sanmiguel.cl/api/maestros/comunas';
        $arr_attrib     =   [];
        $arr_params     =   [
                                'query'   =>  [
                                    'nr_region' =>  isset($request->nr_region) ? $request->nr_region : 0,
                                ]                                
                            ];
        $arr_headers    =   [
                                'verify'    =>  false,
                                'headers'   =>  [
                                                    'Authorization'     =>  'Bearer ' . env('TOKEN_API'),
                                                    'Accept'            =>  'application/json',
                                                    'Content-Type'      =>  'application/json'
                                                ]
                            ];

        try {
            $arr_attrib =   array_merge($arr_attrib, $arr_headers, $arr_params);
            $client     =   new Client([
                                'exceptions'    => false, // Para que no muestre Excepciones
                                'verify'        => false, //si no deseas verificar certificado.
                            ]);

            $response   =   $client->request($str_method, $str_ruta, $arr_attrib);
            $response->getStatusCode();
            $arr_data   =   $response->getBody()->getContents();
            if($arr_data)
                $arr_data   =   json_decode($arr_data)->data;
        } catch (RequestException $e) {
            if ($e->getResponse()->getStatusCode() == '400') {
                \Log::debug(__METHOD__ . $e->getMessage());
            }
        }

        return $arr_data;
    }
    //---------------------------------------------------------------------------------
    /*
    *  Consulta a servicio externo para obtener listado de ubicaciones de calles y numeración de la comuna
    */
   public static function getApiAwsDirecciones(Request $request)
{
    $nm_direccion   =   $request->nm_direccion;
    $arr_data       =   [];
    
    try {
        if(strlen($nm_direccion) >= 3) {
            $direcciones = \App\MaestroDirecciones::select(
                                'id as value',
                                'nm_direccion as label',
                                'nr_calle',
                                'nm_calle',
                                'str_latitud',
                                'str_longitud',
                                'cod_territorial',
                                'cod_unidadvecinal'
                            )
                            ->whereRaw('nm_direccion LIKE ?', [$nm_direccion.'%'])
                            ->orderBy('nr_calle', 'asc')
                            //->take(25) // Para mantener la misma cantidad que el original (25)
                            ->get();
            
            // Convertir el resultado al formato esperado
            $arr_data = $direcciones->map(function($item) {
                return [
                    'id' => $item->value,
                    'nm_direccion' => $item->label,
                    'nr_calle' => $item->nr_calle,
                    'nm_calle' => $item->nm_calle,
                    'str_latitud' => $item->str_latitud,
                    'str_longitud' => $item->str_longitud,
                    'cod_territorial' => $item->cod_territorial,
                    'cod_unidadvecinal' => $item->cod_unidadvecinal
                ];
            })->toArray();
        }
    } catch (\Exception $e) {
        \Log::error(__METHOD__ . ': ' . $e->getMessage());
    }
    
    return ['direcciones' => $arr_data];
}

// El método searchUbicaciones() se mantiene igual, ya que ya está diseñado
// para trabajar con la estructura de datos que devuelve getApiAwsDirecciones()

public function searchUbicaciones(Request $request)
{
    try {
        $arr_data       =   [];
        $nm_direccion   =   $request->input('nm_direccion');
        
        if (strlen($nm_direccion) < 3) {
            return response()->json([
                'success' => false,
                'message' => 'Mínimo 3 caracteres requeridos',
                'ubicaciones' => []
            ]);
        }

        $info_request   =   new Request(['nm_direccion' => $nm_direccion]);
        $info_response  =   static::getApiAwsDirecciones($info_request);

        // El resto del código se mantiene igual...
        if(isset($info_response['direcciones']) && count($info_response['direcciones'])) {
            foreach ($info_response['direcciones'] as $key => $item) {
                array_push($arr_data, (Object) [
                    'value'     =>  $item['id'],
                    'label'     =>  $item['nm_direccion'],
                    'nr_calle'  =>  $item['nr_calle'],
                    'nm_calle'  =>  $item['nm_calle'],
                    'str_latitud'   =>  $item['str_latitud'],
                    'str_longitud'  =>  $item['str_longitud'],
                    'cod_territorial'   =>  $item['cod_territorial'],
                    'cod_unidadvecinal' =>  $item['cod_unidadvecinal']
                ]);
            }
        }

        return response()->json([
            'success' => true,
            'result' => $arr_data,
            'total' => count($arr_data)
        ]);
    } catch (\Exception $e) {
        \Log::error('Error en búsqueda de ubicaciones: ' . $e->getMessage());
        
        return response()->json([
            'success' => false,
            'message' => 'Error interno del servidor',
            'result' => []
        ], 500);
    }
}
    //---------------------------------------------------------------------------------
}
