<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Collection;
use Illuminate\Pagination\Paginator;
use Illuminate\Pagination\LengthAwarePaginator;
use DB;
use Validator;
use Illuminate\Support\Facades\Auth;
use App\TipoIngreso;
use App\MacroTerritorio;
use App\UnidadVecinal;
use App\Tipo;
use App\Solicitud;
use App\Historial;
use App\User;
use App\DistribucionTerritorio;
use App\UnidadVecinalMacroTerritorio;
use App\Regiones;
use App\Provincias;
use App\Comunas;
use App\Direccion;
use App\Depto;
use App\Roles;
use App\Cargo;
use App\Respuesta;
use App\Vecino;
use App\Satisfaccion;
use App\Archivos;
use App\MaestroDirecciones;
use App\EncuestaPregunta;
use App\EncuestaAlternativa;
use App\EncuestaLlamada;
use App\EncuestaRespuesta;
use App\EncuestaTelefonista;
use App\Http\Controllers\EmailController;
use App\Http\Controllers\GsutTipoController;
use App\Http\Controllers\TerritorialController;

use Illuminate\Support\Facades\Session;
use Barryvdh\DomPDF\Facade as PDF;
use GuzzleHttp\Client;
use Illuminate\Support\Str;
use GuzzleHttp\Exception\RequestException;

class UtilController extends Controller
{
    //---------------------------------------------------------------------------------------------------------
    public function PeticionHttp($bearer_token,$methods= 'POST',$ruta,$form_params= [])
    {

        $headers = ['headers' => 
                [
                    //'Authorization' => 'Bearer ' . $bearer_token,
                    'Content-Type'  => 'application/json',
                    'Accept'        => 'application/json'
                ]
            ];

        $client = new Client($headers);

        $res = $client->request($methods, $ruta,['form_params' =>$form_params])->getBody()->getContents();
        return $res;
    }
    //---------------------------------------------------------------------------------------------------------
    /*
    * Método utilizado para identificar el rut del vecino, donde las app externas envian un token y este es validado a traves del 
    * servicio externo apis.sanmiguel.cl para obtener el rut de la persona de acuerdo con el token recibido
    */
    public static function getDataTokenApp($str_token)
    {
        $data       =   [];
        $atributos  =   [];
        $nr_rut     =   null;

        try {
            $method     =   'POST';
            $ruta       =   'http://apis.sanmiguel.cl/api/valida-token';
            $headers    =   [
                                'headers'       => 
                                [
                                    'Content-Type' => 'application/json',
                                ]                                
                            ];
            $params     =   [
                                'form_params'   =>  [],
                                'json'          =>  ['token'    =>  $str_token],
                            ];
            $atributos  =   array_merge($atributos, $headers, $params);
            $client     =   new Client([
                                'exceptions' => false, // Para que no muestre Excepciones
                                'verify' => false, //si no deseas verificar certificado.
                            ]);
            $response   =   $client->request($method, $ruta, $atributos);
            $response->getStatusCode();
            $data       =   json_decode($response->getBody());

            if(isset($data->data->rut))
                $nr_rut     =   $data->data->rut;
        } catch (Exception $e) {
            \Log::debug(__METHOD__ . $e->getMessage());
        }

        return $nr_rut;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getCantidadSolicitudesPendientes()
    {
        $nr_propias     =   UtilController::ContadorSolicitudes(0);
        $nr_bandeja     =   UtilController::ContadorSolicitudes(1);

        return ['nr_propias' => $nr_propias, 'nr_bandeja' => $nr_bandeja];
    }
    //---------------------------------------------------------------------------------------------------------
    public static function ContadorSolicitudes($opcion)
    {
       $nr_cantidad = 0;

        if($opcion == 0)
            $nr_cantidad        =   self::getCantidadSolicitudesPorEstado(1); // PROPIAS

        if($opcion == 1)
                $nr_cantidad    =  self::getCantidadSolicitudesPorEstado(2); // PENDIENTES

        return $nr_cantidad;        
    }
    //---------------------------------------------------------------------------------------------------------
    public static function setDataSessionVecino($data_vecino)
    {
        $data   =   null;

        if($data_vecino['error'] == 0 && $data['tramites'] == 0)
        {
            $vecino     =   $data_vecino['vecino'];

            foreach ($vecino as $key => $value) {
                $data   =   (Object) [
                                    'tp_sistema'    =>  0,
                                    'nr_rut'        =>  $value->nr_rut,
                                    'nm_vecino'     =>  $value->nm_vecino,
                                    'ap_paterno'    =>  $value->ap_paterno,
                                    'ap_materno'    =>  $value->ap_materno,                                    
                                    'mail_vecino'   =>  $value->nm_mail,
                                    'nr_prefijo'    =>  $value->nr_prefijo,
                                    'nr_prefijo'    =>  $value->nr_prefijo,
                                    'tp_ubicacion'  =>  $value->tp_direccion,
                                    'ubicacion'     =>  (Object) [
                                                            'value'             =>  $value->id_ubicacion,
                                                            'label'             =>  $value->nm_ubicacion,
                                                            'nr_calle'          =>  $value->nr_calle,
                                                            'nm_calle'          =>  $value->nm_calle,
                                                            'str_latitud'       =>  $value->str_latitud,
                                                            'str_longitud'      =>  $value->str_longitud,
                                                            'cod_territorial'   =>  $value->cod_macroterritorio,
                                                            'cod_unidadvecinal' =>  $value->cod_unidadvecinal,
                                                        ],
                                    'region'        =>  (Object) [
                                                            'value'     =>  $value->region->id,
                                                            'label'     =>  $value->region->nm_region,
                                                        ],
                                    'comuna'        =>  (Object) [
                                                            'value'     =>  $value->comuna->id,
                                                            'label'     =>  $value->comuna->nm_comuna,
                                                        ],
                                ];
            }

            Session::put('info_vecino',$data);
        }
        if($data_vecino['error'] == 0 && $data['tramites'] == 1)
        {
            $vecino     =   $data_vecino['vecino'];
            $data       =   (Object) [
                                    'tp_sistema'    =>  1,
                                    'nr_rut'        =>  $value->nr_rut,
                                    'nm_vecino'     =>  $value->nm_vecino,
                                    'ap_paterno'    =>  $value->ap_paterno,
                                    'ap_materno'    =>  $value->ap_materno,                                    
                                    'mail_vecino'   =>  $value->correo,
                                    'nr_prefijo'    =>  $value->nr_prefijo,
                                    'nr_telefono'   =>  $value->nr_telefono,
                            ];

            Session::put('info_vecino',$data);
        }
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getDataSessionVecino()
    {
        $info_vecino    =   Session::get('info_vecino');
        return $info_vecino;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function generarNumeroFolio($nr_anio)
    {
        $nr_folio   =   1;

        try {
            $data   =   Solicitud::
                        select('nr_folio')
                        ->where('nr_anio','=',$nr_anio)
                        ->orderBy('nr_folio','DESC')
                        ->get()->take(1);

            if($data->count())
                $nr_folio   =   $data->first()->nr_folio + 1;
        } catch (Exception $e) {
            $nr_folio   =   1;
        }

        return $nr_folio;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function generarNumeroTicket($nr_anio, $nr_folio)
    {
        $str_zero       =   '0';
        $str_folio      =   str_pad($nr_folio, 4, $str_zero, STR_PAD_LEFT);
        $str_ticket     =   $nr_anio.$str_folio;

        return  $str_ticket;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getDataUser()
    {
        $id_user    =   Auth::user()->id;

        $data       =   User::
                        select('id_municipio',
                            'id_direccion',
                            'id_depto',
                            'rut',
                            'nombre',
                            'ap_paterno',
                            'ap_materno',
                            'name',
                            'movil',
                            'email',
                            'tp_admin',
                            'id_rol',
                            'nr_nivel',
                            'tp_responder',
                            'tp_finalizar',
                            'tp_informar',
                            'tp_derivar',
                            'tp_vb_director',
                            'tp_vb_depto',
                            'tp_activo')
                        ->where('id','=',$id_user)
                        ->get();

        if($data->count())
            return $data->first();

        return $data;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getUsuario($tp_atributo = 'id', $nr_usuario)
    {
        $data       =   User::
                        select('id_municipio',
                            'id_direccion',
                            'id_depto',
                            'rut',
                            'nombre',
                            'ap_paterno',
                            'ap_materno',
                            'name',
                            'movil',
                            'email',
                            'tp_admin',
                            'id_rol',
                            'nr_nivel',
                            'tp_responder',
                            'tp_finalizar',
                            'tp_informar',
                            'tp_derivar',
                            'tp_vb_director',
                            'tp_vb_depto',
                            'tp_activo')
                        ->where($tp_atributo,'=',$nr_usuario)
                        ->get();

        if($data->count())
            return $data->first();

        return $data;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getVecino($nr_rut)
    {
        $data   =   Vecino::
                    select('nr_rut',
                        'nm_vecino',
                        'ap_paterno',
                        'ap_materno')
                    ->where('nr_rut','=',$nr_rut)
                    ->get();

        if($data->count())
            return $data->first();

        return $data;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function existeVecino($nr_rut)
    {
        $tp_existe  =   0;

        try {
            $data   =   Vecino::where('nr_rut',$nr_rut)->get();
            if($data->count())
                $tp_existe  =   1;
        } catch (Exception $e) {
            $tp_existe  =   0;
        }

        return $tp_existe;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getDataSolicitud($nr_id)
    {
        $data   =   Solicitud::where('id','=',$nr_id)->first();
        return $data;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getDataServicio($nr_id)
    {
        $data   =   Tipo::where('id','=',$nr_id)->first();
        return $data;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getDataRespuesta($nr_id)
    {
        $data   =   Respuesta::where('id','=',$nr_id)->first();
        return $data;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getIdUnidadVecinalUser($id_user)
    {
        $nr_id  =   0;
        $data   =   DistribucionTerritorio::select('nr_id')
                                              ->where('id_user','=',$id_user)
                                              ->where('tp_tabla','=','tb_unidadvecinal')
                                              ->get();


        return $data->unique('nr_id')->pluck('nr_id');
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getIdMacroZonaUser($id_user)
    {
        $nr_id  =   0;

        try {
            $data   =   DistribucionTerritorio::select('nr_id')
                                              ->where('id_user','=',$id_user)
                                              ->where('tp_tabla','=','tb_macroterritorio')
                                              ->get();

            if($data->count())
                $nr_id  =   $data->first()->nr_id;
        } catch (Exception $e) {
            $nr_id  =   0;
        }

        return $nr_id;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getTiempoTramitacion($fecha_ingreso, $fecha_terminio, $id_estado)
    {
        $str_diferencia =   '';
        $fc_actual      =   Carbon::now();
        $fc_inicio      =   Carbon::createFromFormat('Y-m-d H:i:s', $fecha_ingreso);
        $fc_termino     =   (in_array($id_estado, [5,6])) ? 
                                Carbon::createFromFormat('Y-m-d H:i:s', $fecha_terminio) : 
                                Carbon::parse($fc_actual)->format('Y-m-d H:i:s');
        $diferencia     =   $fc_inicio->diffForHumans($fc_termino, true, true, 4);
        /*
        dd([
            'diffForHumans1'     =>  $fc_inicio->diffForHumans($fc_termino, true, true, 1),
            'diffForHumans2'     =>  $fc_inicio->diffForHumans($fc_termino, true, true, 2),
            'diffForHumans3'     =>  $fc_inicio->diffForHumans($fc_termino, true, true, 3),
            'diffForHumans4'     =>  $fc_inicio->diffForHumans($fc_termino, true, true, 4),
            'diffForHumans5'     =>  $fc_inicio->diffForHumans($fc_termino, true, true, 5),
            'diffForHumans6'     =>  $fc_inicio->diffForHumans($fc_termino, true, true, 6),
        ]);
        */
        $str_diferencia =   $diferencia;
        // $str_diferencia =   str_replace(['d','h','m',],[' dias',' hrs',' mins'], $diferencia);

        return $str_diferencia;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getTiempoTramitacionTerritorial($fecha_ingreso, $fecha_terminio, $id_estado)
    {
        $str_diferencia =   '';
        $fc_actual      =   Carbon::now();
        $fc_inicio      =   Carbon::createFromFormat('Y-m-d H:i:s', $fecha_ingreso);
        $fc_termino     =   (in_array($id_estado, [2,12,13])) ? 
                                Carbon::createFromFormat('Y-m-d H:i:s', $fecha_terminio) : 
                                Carbon::parse($fc_actual)->format('Y-m-d H:i:s');
        $diferencia     =   $fc_inicio->diffForHumans($fc_termino, true, true, 4);

        // $str_diferencia =   str_replace(['d','h','m',],[' dias',' hrs',' mins'], $diferencia);

        $str_diferencia =   $diferencia;

        return $str_diferencia;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getTiempoTramitacionHistorial($fecha_ingreso, $fecha_terminio)
    {
        dd([
            'fecha_ingreso'     =>  $fecha_ingreso,
            'fecha_termino'     =>  $fecha_terminio,
        ]);

        $str_diferencia =   '';
        $fc_actual      =   Carbon::now();
        $fc_inicio      =   Carbon::createFromFormat('Y-m-d H:i:s', $fecha_ingreso);
        $fc_termino     =   (!isset($fecha_terminio)) ? 
                                Carbon::createFromFormat('Y-m-d H:i:s', $fecha_terminio) : 
                                Carbon::parse($fc_actual)->format('Y-m-d H:i:s');
        $diferencia     =   $fc_inicio->diffForHumans($fc_termino, true, true, 2);
        $str_diferencia =   str_replace(['d','h','m',],[' dias',' hrs',' mins'], $diferencia);

        return $str_diferencia;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getTiempoTramitacionEncuesta($fecha_ingreso, $fecha_terminio)
    {
        $str_diferencia =   '';
        $fc_actual      =   Carbon::now();

        if(!$fecha_ingreso || !$fecha_terminio)
            return $str_diferencia;

        $fc_inicio      =   Carbon::createFromFormat('Y-m-d H:i:s', $fecha_ingreso);
        $fc_termino     =   Carbon::createFromFormat('Y-m-d H:i:s', $fecha_terminio);
        $diferencia     =   $fc_inicio->diffForHumans($fc_termino, true, true, 4);
        /*
        dd([
            'diffForHumans1'     =>  $fc_inicio->diffForHumans($fc_termino, true, true, 1),
            'diffForHumans2'     =>  $fc_inicio->diffForHumans($fc_termino, true, true, 2),
            'diffForHumans3'     =>  $fc_inicio->diffForHumans($fc_termino, true, true, 3),
            'diffForHumans4'     =>  $fc_inicio->diffForHumans($fc_termino, true, true, 4),
            'diffForHumans5'     =>  $fc_inicio->diffForHumans($fc_termino, true, true, 5),
            'diffForHumans6'     =>  $fc_inicio->diffForHumans($fc_termino, true, true, 6),
        ]);
        */
        $str_diferencia =   $diferencia;
        // $str_diferencia =   str_replace(['d','h','m',],[' dias',' hrs',' mins'], $diferencia);

        return $str_diferencia;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function paginateArr($items, $perPage = 50, $page = null, $pageName = 'page', $path = '/', $options = [])
    {
        $items  =   $items instanceof Collection ? $items : Collection::make($items);
        $page   =   $page ?: (Paginator::resolveCurrentPage() ?: 1);
        $opts   =   ['path'=>Paginator::resolveCurrentPath(), 'pageName'=>$pageName];
        
        $data   =   new LengthAwarePaginator($items->forPage($page, $perPage), 
                                            $items->count(), $perPage, $page, $opts);

        return  $data;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getIdMacroTerritorio($cod_macroterritorio)
    {
        $nr_id  =   0;

        try {
            $data   =   MacroTerritorio::
                        select('id')
                        ->where('cod_territorio','=',$cod_macroterritorio)
                        ->get();

            if($data->count())
                $nr_id  =   $data->first()->id;
        } catch (Exception $e) {
            $nr_id  =   0;
        }

        return $nr_id;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getIdUnidadVecinal($cod_unidadvecinal)
    {
        $nr_id  =   0;


        $count  =   UnidadVecinal::where('cod_unidadvecinal','=',$cod_unidadvecinal)->count();

        if($count)
        {
            $data   =   UnidadVecinal::select('id')->where('cod_unidadvecinal','=',$cod_unidadvecinal)->first();
            return $data->id;
        }
        else
            return 0;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function listadoTipoIngreso()
    {
        $data   =   TipoIngreso::
                    select('id as value','nm_ingreso as label')
                    ->get();

        return ['ingresos' => $data];
    }
    //---------------------------------------------------------------------------------------------------------
    public static function listadoCargos()
    {
        $data   =   Cargo::
                    select('id as value','nm_cargo as label')
                    ->where('tp_activo','=',1)
                    ->get();

        return ['cargos' => $data];
    }
    //---------------------------------------------------------------------------------------------------------
    public static function listadoRegiones()
    {
        $data   =   Regiones::
                    select('id as value','nm_region as label')
                    ->where('tp_activo','=',1)
                    ->get();

        return ['regiones' => $data];
    }
    //---------------------------------------------------------------------------------------------------------
    public static function listarNivelSatisfaccion()
    {
        $data   =   Satisfaccion::
                    select('id as value','name as label')
                    ->get();

        return  ['nivel_satisfaccion' => $data];
    }
    //---------------------------------------------------------------------------------------------------------
    public static function listadoProvincias(Request $request)
    {
        $nr_region  =   $request->nr_region;
        $data       =   [];

        $data       =   Provincias::
                        select('id as value','nm_provincia as label')                        
                        ->where('tp_activo','=',1);

        if($nr_region != 0)
            $data   =   $data->where('nr_region','=',$nr_region);

        $data   =   $data->get();

        return ['provincias' => $data];
    }
    //---------------------------------------------------------------------------------------------------------
    public static function listadoComunas(Request $request)
    {
        $nr_region      =   $request->nr_region;
        $nr_provincia   =   $request->nr_provincia;

        $data           =   Comunas::
                            select('id as value','nm_comuna as label')
                            ->where('tp_activo','=',1);

        if($nr_region != 0)
            $data   =   $data->where('nr_region','=',$nr_region);
        if($nr_provincia != 0)
            $data   =   $data->where('nr_provincia','=',$nr_provincia);

        $data   =   $data->get();

        return ['comunas' => $data];
    }    
    //---------------------------------------------------------------------------------------------------------
    public function listadoRoles()
    {
        $data   =   Roles::
                    select('id as value','nombre as label')
                    ->where('condicion','=',1)
                    ->where('tp_cabecera','=',0)
                    ->get();

        return ['roles' => $data];
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getRolActivo($nr_user)
    {
        $data   =   User::
                    join('gsut_roles as roles','roles.id','=','users.id_rol')
                    ->select('users.id_rol',
                        'users.tp_admin',
                        'roles.nombre',
                        'roles.nm_cabecera',
                        'roles.str_sidebar',
                        DB::raw('CONCAT(users.nombre," ",users.ap_paterno) as usuario'))
                    ->where('users.id','=',$nr_user)
                    ->get()->first();

        return $data;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function listarRolesUsuario($nr_user)
    {
        $data   =   Roles::
                    select('gsut_roles.id',
                        'gsut_roles.nombre',
                        'gsut_roles.nm_cabecera',
                        'gsut_roles.tp_agrupacion')
                    ->where('tp_cabecera','=','0')
                    ->where('condicion','=','1');

        if($nr_user != 0)
            $data   =   $data->join('gsut_user_rol as ur','ur.id_rol','=','gsut_roles.id')
                             ->where('ur.id_user','=',$nr_user);

        $data   =   $data->get();

        return $data;
    }
    //---------------------------------------------------------------------------------------------------------
    public function listadoMacrozona()
    {
        $data   =   MacroTerritorio::
                    select('id as value','cod_territorio as label')
                    ->get();

        return ['macrozona' => $data];
    }
    //---------------------------------------------------------------------------------------------------------
    public function listadoUnidadVecinal(Request $request)
    {
        $data           =   [];
        $arr_macrozona  =   $request->arr_macrozona;

        if(count($arr_macrozona))
        {
            $mazrozona  =   collect($arr_macrozona)->pluck('value')->toArray();

            $data       =   UnidadVecinalMacroTerritorio::
                            join('gsut_unidadvecinal as uv','uv.id','=','gsut_unidadvecinal_macroterritorio.id_macroterritorio')
                            ->whereIn('gsut_unidadvecinal_macroterritorio.id_macroterritorio',$mazrozona)
                            ->select('id as value','nm_unidadvecinal as label')
                            ->get();              
        }

        return ['unidadvecinal' => $data];
    }
    //---------------------------------------------------------------------------------------------------------
    public function listadoUnidadVecinalPorMacrozona(Request $request)
    {
        $data           =   [];
        $arr_macrozona  =   $request->arr_macrozona;

        if(count($arr_macrozona))
        {
            $data   =   MacroTerritorio::
                        select('id as id_macrozona','cod_territorio as nm_macrozona','id')
                        ->whereIn('id',$arr_macrozona)
                        ->with('unidadvecinal')
                        ->get();
        }

        return $data;
    }
    //---------------------------------------------------------------------------------------------------------
    public function listadoTicket()
    {
        $data   =   Solicitud::
                    select('nr_ticket as value','nr_ticket as label')
                    ->where('tp_activo','=',1)
                    ->groupBy('nr_ticket')
                    ->get();

        return ['ticket' => $data];
    }
    //---------------------------------------------------------------------------------------------------------
    public function listadoUbicaciones()
    {
        $data   =   Solicitud::
                    select('id_ubicacion as value','nm_ubicacion as label')
                    ->groupBy('id_ubicacion')->get();

        return ['ubicaciones' => $data];
    }
    //---------------------------------------------------------------------------------------------------------
    public function listadoPersonas()
    {
        $data   =   Vecino::
                    select('nr_rut as value','nr_rut as label')
                    ->where('tp_activo','=',1)
                    ->get();

        return ['personas' => $data];
    }
    //---------------------------------------------------------------------------------------------------------
    public function listadoEncuesta(Request $request)
    {
        $nr_mostrar     =   (isset($request->nr_mostrar)) ? $request->nr_mostrar : 0;
        $nr_encuesta    =   (isset($request->nr_encuesta)) ? $request->nr_encuesta : 1;
        $firstQuestion  =   null;

        $data   =   EncuestaPregunta::
                    select('id',
                        'id_encuesta',
                        'tp_categoria',
                        'nr_pregunta',
                        'cod_pregunta',
                        'tp_pregunta',
                        'tp_obligatorio',
                        'str_formdata',
                        'str_pregunta',
                        'str_indicacion',
                        'tp_activo',
                        DB::raw('(case when tp_activo = 1 then "Habilitado" else "Deshabilitado" end) nm_estado')
                    )
                    ->orderBy('tp_categoria')
                    ->orderBy('nr_pregunta','ASC')
                    ->with('logica')
                    ->with(['alternativa' => function ($query) {
                        $query->with('logica');
                    }])
                    ->where('id_encuesta','=',$nr_encuesta);

        if($nr_mostrar == 0)
            $data   =   $data->where('tp_activo','=','1');

        $data   =   $data->get();

        if($data->count())
            $firstQuestion  =   (Object) [
                                            'cod_pregunta'  =>  $data->first()->cod_pregunta,
                                            'str_formdata'  =>  $data->first()->str_formdata,
                                            'str_indicacion'=>  $data->first()->str_indicacion,
                                ];

        return  ['listado' => $data, 'firstQuestion' => $firstQuestion];
    }
    //---------------------------------------------------------------------------------------------------------
    public function listadoTelefonistas()
    {
        $nr_rol =   25; // Encuestador
        $data   =   Roles::
                    join('gsut_user_rol as ur','ur.id_rol','=','gsut_roles.id')
                    ->join('users as telefonista','telefonista.id','=','ur.id_user')
                    ->select('telefonista.id as value',
                        'telefonista.nombre',
                        'telefonista.ap_paterno',
                        'telefonista.ap_materno',
                        'telefonista.name as label')
                    ->where('gsut_roles.tp_cabecera','=','0')
                    ->where('gsut_roles.condicion','=','1')
                    ->where('gsut_roles.id','=',$nr_rol)
                    ->groupBy('telefonista.id')
                    ->get();

        return $data;
    }
    //---------------------------------------------------------------------------------------------------------
    public function getDerivarServicio(Request $request)
    {
        $nr_direccion   =   $request->nr_direccion;
        $nr_depto       =   Auth::user()->nr_depto;
        $tp_derivar     =   Auth::user()->tp_derivar;
        $arr_direccion  =   [];
        $arr_depto      =   [];
        $arr_servicio   =   [];
        $dir_actual     =   [];

        if($tp_derivar == 1)
        {
            $request['nr_direccion']    =   0;
            $arr_direccion  =   $this->getDireccionesMunicipalesConServicios();
            $arr_depto      =   $this->getDeptosMunicipalesConServicios($request);
            $arr_servicio   =   GsutTipoController::listado($request);
        }
        else if($tp_derivar == 2)
        {
            $arr_direccion  =   $this->getDireccionesMunicipalesConServicios($nr_direccion);
            $arr_depto      =   $this->getDeptosMunicipalesConServicios($request);
            $arr_servicio   =   GsutTipoController::listado($request);
            $dir_actual     =   $this->getDireccionMunicipalActual();
        }

        return [
            'arr_direccion'     =>  $arr_direccion,
            'arr_depto'         =>  $arr_depto, 
            'arr_servicio'      =>  $arr_servicio,
            'dir_actual'        =>  $dir_actual,
        ];
    }
    //---------------------------------------------------------------------------------------------------------
    public function listadoDireccionesMunicipales()
    {
        $direcciones    =   $this->getDireccionesMunicipales();
        $conServicio    =   $this->getDireccionesMunicipalesConServicios();
        $sinServicio    =   $this->getDireccionesMunicipalesSinServicio();
        $dir_actual     =   $this->getDireccionMunicipalActual();
        $depto_actual   =   $this->getDeptoMunicipalActual();

        return [
            'listado'       =>  $direcciones,
            'direcciones'   =>  $conServicio, 
            'sinServicio'   =>  $sinServicio,
            'dir_actual'    =>  $dir_actual,
            'depto_actual'  =>  $depto_actual,
        ];
    }
    //---------------------------------------------------------------------------------------------------------
    public function getDireccionMunicipalActual()
    {
        $nr_direccion   =   Auth::user()->id_direccion;

        $data   =   Direccion::
                    select('id as value','nm_direccion as label')
                    ->where('id','=',$nr_direccion)
                    ->get();

        return $data;
    }
    //---------------------------------------------------------------------------------------------------------
    public function getDeptoMunicipalActual()
    {
        $nr_depto       =   Auth::user()->id_depto;

        $data   =   Depto::
                    select('id as value','nm_depto as label')
                    ->where('id','=',$nr_depto)                    
                    ->get();

        return $data;
    }
    //---------------------------------------------------------------------------------------------------------
    private function getDireccionesMunicipales($nr_direccion = 0)
    {
        $data   =   Direccion::
                    select('id as value','nm_direccion as label')
                    ->where('id','!=',1) 
                    ->orderBy('nm_direccion'); //orden alfabético

        if($nr_direccion != 0)
            $data   =   $data->where('id','=',$nr_direccion);

        $data   =   $data->get();

        return $data;
    }
    //---------------------------------------------------------------------------------------------------------
    private function getDireccionesMunicipalesConServicios($nr_direccion = 0)
    {
        //$data   =   Direccion::
        //            select('gsut_direccion.id as value','gsut_direccion.nm_direccion as label')
        //            ->whereExists(function ($query) {
        //                $query->select(DB::raw('1'))                            
        //                    ->from('gsut_tipo')
        //                    ->whereRaw('gsut_tipo.id_direccion = gsut_direccion.id')
        //                    ->whereRaw('gsut_tipo.tp_activo = 1');                            
        //            });
        
        $data   =   Direccion::
                    select('gsut_direccion.id as value', 'gsut_direccion.nm_direccion as label')
                    ->where('gsut_direccion.tp_activo', 1) 
                    ->orderBy('gsut_direccion.nm_direccion', 'asc'); // 👈 orden ascendente

        if ($nr_direccion != 0) {
            $data->where('gsut_direccion.id', $nr_direccion);
        }

        return $data->get();
    }
    //---------------------------------------------------------------------------------------------------------
    private function getDireccionesMunicipalesSinServicio()
    {
        //$data   =   Direccion::
        //            select('gsut_direccion.id as value','gsut_direccion.nm_direccion as label')
        //            ->whereNotExists(function ($query) {
        //                $query->select(DB::raw('1'))                            
        //                    ->from('gsut_tipo')
        //                    ->whereRaw('gsut_tipo.id_direccion = gsut_direccion.id')
        //                    ->whereRaw('gsut_tipo.tp_activo = 1');                            
        //            })
                        
        //            ->where('gsut_direccion.id','!=','1')
        //            ->get();
        
        $data   =   Direccion::
                    select('gsut_direccion.id as value','gsut_direccion.nm_direccion as label')
                    ->whereNotExists(function ($query) {
                        $query->select(DB::raw(1))
                            ->from('gsut_tipo')
                            ->whereColumn('gsut_tipo.id_direccion', 'gsut_direccion.id')
                            ->where('gsut_tipo.tp_activo', 1);
                    })
                    ->orderBy('gsut_direccion.nm_direccion', 'asc'); // 👈 orden ascendente
        
        return $data->get();
    }
    //---------------------------------------------------------------------------------------------------------
    public function listadoDeptosMunicipales(Request $request)
    {
        $deptos         =   $this->getDeptosMunicipales($request);
        $conServicio    =   $this->getDeptosMunicipalesConServicios($request);
        $sinServicio    =   $this->getDeptosMunicipalesSinServicio($request);

        return [
            'listado'       => $deptos,
            'deptos'        => $conServicio, 
            'sinServicio'   => $sinServicio
        ];
    }
    //---------------------------------------------------------------------------------------------------------
    private function getDeptosMunicipales(Request $request)
    {
        $nr_direccion   =   $request->nr_direccion;

        $data   =   Depto::
                    select('id as value','nm_depto as label','nm_ubicacion','id_direccion')
                    ->where('id_municipio','=','2')
                    ->orderBy('nm_depto'); //orden alfabético

        if($nr_direccion != 0)
            $data   =   $data->where('id_direccion','=',$nr_direccion);

        $data   =   $data->get();

        return $data;
    }
    //---------------------------------------------------------------------------------------------------------
    private function getDeptosMunicipalesConServicios(Request $request)
    {
        $nr_direccion   =   $request->nr_direccion;

        //$data   =   Depto::
        //            select('gsut_depto.id as value','gsut_depto.nm_depto as label','nm_ubicacion','gsut_depto.id_direccion')
        //            ->where('gsut_depto.id_municipio','=','2')
        //            ->whereExists(function ($query) {
        //                $query->select(DB::raw('1'))                          
        //                    ->from('gsut_tipo')
        //                    ->whereRaw('gsut_tipo.id_direccion = gsut_depto.id_direccion')
        //                    ->whereRaw('gsut_tipo.id_depto = gsut_depto.id')                           
        //            });
        
        $data   =   Depto::
                    select('gsut_depto.id as value','gsut_depto.nm_depto as label','nm_ubicacion','gsut_depto.id_direccion')
                    ->where('gsut_depto.id_municipio','=','2')
                    ->whereExists(function ($query) {
                        $query->select(DB::raw(1))
                            ->from('gsut_direccion')
                            ->whereColumn('gsut_direccion.id', 'gsut_depto.id_direccion')
                            ->where('gsut_depto.tp_activo', 1);
                    })
                    ->orderBy('gsut_depto.nm_depto', 'asc'); //orden ascendente
        
        if($nr_direccion != 0)
            $data   =   $data->where('gsut_depto.id_direccion','=',$nr_direccion);

        $data   =   $data->get();

        return $data;
    }
    //---------------------------------------------------------------------------------------------------------
    private function getDeptosMunicipalesSinServicio(Request $request)
    {
        $nr_direccion   =   $request->nr_direccion;

        //$data   =   Depto::
        //            select('gsut_depto.id as value','gsut_depto.nm_depto as label','nm_ubicacion','gsut_depto.id_direccion')
        //            ->where('gsut_depto.id_municipio','=','2')
        //            ->whereNotExists(function ($query) {
        //                $query->select(DB::raw('1'))                            
        //                    ->from('gsut_tipo')
        //                    ->whereRaw('gsut_tipo.id_direccion = gsut_depto.id_direccion')
        //                    ->whereRaw('gsut_tipo.id_depto = gsut_depto.id')                           
        //            });
        
        $data   =   Depto::
                    select('gsut_depto.id as value','gsut_depto.nm_depto as label','nm_ubicacion','gsut_depto.id_direccion')
                    ->where('gsut_depto.id_municipio','=','2')
                    ->whereNotExists(function ($query) {
                        $query->select(DB::raw('1'))                                                        
                            ->from('gsut_direccion')                            
                            ->whereRaw('gsut_depto.tp_activo = 1');
                    })
                    ->orderBy('gsut_depto.nm_depto', 'asc'); //orden ascendente        
        

        if($nr_direccion != 0)
            $data   =   $data->where('gsut_depto.id_direccion','=',$nr_direccion);

        $data   =   $data->get();

        return $data;
    }
    //---------------------------------------------------------------------------------------------------------
    public function listadoFuncionarios(Request $request)
    {
        $nr_direccion   =   $request->nr_direccion;
        $nr_depto       =   $request->nr_depto;

        $data   =   User::
                    join('gsut_direccion as dir','dir.id','=','users.id_direccion')
                    ->join('gsut_depto as depto','depto.id','=','users.id_depto')
                    ->select('users.id as value',
                        'dir.nm_direccion',
                        'depto.nm_depto',
                        'users.name',
                        DB::raw('concat(depto.nm_depto," - ",users.nombre," ",users.ap_paterno," ",users.ap_materno) as label'))
                    ->where('users.tp_activo','=','1')
                    ->whereIn('users.id_rol',[5,7,21,23]);

        if(isset($nr_direccion))
            $data   =   $data->where('users.id_direccion','=',$nr_direccion);

        //if(isset($nr_depto))
        //    $data   =   $data->where('users.id_depto','=',$nr_depto);

        $data   =   $data->get();

        return ['funcionarios' => $data];
    }
    //---------------------------------------------------------------------------------------------------------
    public function generarPDFTicket($nr_ticket)
    {
        set_time_limit(300);

        $solicitud      =   Solicitud::
                            select('id',
                                'nr_ticket',
                                DB::raw('DATE_FORMAT(fc_creacion, "%d-%m-%Y %H:%i") as fc_creacion'),
                                'nm_tipo',
                                'nm_ubicacion',
                                'str_observacion',
                                'str_aclaratoria')
                            ->where('token_report','=',$nr_ticket)
                            ->where('token_report_expires_at','>',now())
                            ->get();

        if($solicitud->count())
        {
            $data       =   $solicitud->first();
            $lascondes  =   'Municipalidad de San Miguel';
            $logo       =   (public_path().'/img/logo.png');
            $img_ticket =   (public_path().'/img/icons/ticket.png');
            $img_check  =   (public_path().'/img/icons/check_2.png');
            $img_user   =   (public_path().'/img/icons/user.png');
            $titulo     =   'Atención al vecino';
            $fc_fecha   =   $data->fc_creacion;
            $nr_ticket  =   $data->nr_ticket;
            $nm_tipo    =   $data->nm_tipo;
            $nm_lugar   =   $data->nm_ubicacion;
            $nm_osb     =   $data->str_observacion;
            $nm_aclara  =   $data->str_aclaratoria;

            $data->update(['token_report_used'=>1]);

            /*
            return view('documentos/ticket', ['datos' => (Object) [
                            'lascondes'     =>  $lascondes,
                            'logo'          =>  $logo,
                            'img_ticket'    =>  $img_ticket,
                            'img_check'     =>  $img_check,
                            'img_user'      =>  $img_user,
                            'titulo'        =>  $titulo,
                            'fc_fecha'      =>  $fc_fecha,
                            'nr_ticket'     =>  $nr_ticket,
                            'nm_tipo'       =>  $nm_tipo,
                            'nm_lugar'      =>  $nm_lugar,
                            'nm_osb'        =>  $nm_osb,
                            'nm_aclara'     =>  $nm_aclara,
                        ]]);
            */

            return  PDF::loadView('documentos.ticket', 
                    ['datos' => (Object) 
                        [
                            'lascondes'     =>  $lascondes,
                            'logo'          =>  $logo,
                            'img_ticket'    =>  $img_ticket,
                            'img_check'     =>  $img_check,
                            'img_user'      =>  $img_user,
                            'titulo'        =>  $titulo,
                            'fc_fecha'      =>  $fc_fecha,
                            'nr_ticket'     =>  $nr_ticket,
                            'nm_tipo'       =>  $nm_tipo,
                            'nm_lugar'      =>  $nm_lugar,
                            'nm_osb'        =>  $nm_osb,
                            'nm_aclara'     =>  $nm_aclara,
                        ]
                    ])->stream($nr_ticket.'.pdf');
        }
        else
        {
            abort(403);
        }
    }
    //---------------------------------------------------------------------------------------------------------
    public static function generarPDFInformacionTicket($id_ticket)
    {
        set_time_limit(300);

        $name_document      =   Str::uuid()->toString();
        $data_ticket        =   self::getInformacionTicketToGeneratePDF($id_ticket);
        
        if($data_ticket->count())
        {
            $data_historial     =   self::getHistorialTicketToGeneratePDF($id_ticket);
            $data_respuestas    =   self::getRespuestasTicketToGeneratePDF($id_ticket);

            $info_ticket        =   $data_ticket->first();
            $nm_lascondes       =   'Municipalidad de San Miguel';
            $nm_sistema         =   'Sistema de Atención al vecino';
            $str_logo           =   (public_path().'/logo/logo-sanmiguel-horizontal-white.png');
            $nr_ticket          =   $info_ticket->nr_ticket;
            $nm_estado          =   $info_ticket->nm_estado;
            $id_servicio        =   $info_ticket->id_servicio;
            $info_vecino        =   ($info_ticket->vecino) ? json_decode(json_encode($info_ticket->vecino->toArray())) : null;
            $info_derivado      =   ($info_ticket->derivacion) ? json_decode(json_encode($info_ticket->derivacion->toArray())) : null;
            $info_clonado       =   ($info_ticket->solicitud) ? json_decode(json_encode($info_ticket->solicitud->toArray())) : null;

            $info_historial     =   ($data_historial) ? json_decode(json_encode($data_historial->toArray())) : null;
            $info_respuestas    =   ($data_respuestas) ? json_decode(json_encode($data_respuestas->toArray())) : null;

            /*
            dd([
                'info_ticket'       =>  $info_ticket,
                'info_vecino'       =>  $info_vecino,
                'info_derivado'     =>  $info_derivado,
                'info_clonado'      =>  $info_clonado,
                'info_historial'    =>  $info_historial,
                'info_respuestas'   =>  $info_respuestas,
            ]);
            */            
            
            $pdf = PDF::loadView('documentos.ticket-informacion', [
                'datos' => (Object) [
                    'nm_lascondes'      =>  $nm_lascondes,
                    'nm_sistema'        =>  $nm_sistema,
                    'str_logo'          =>  $str_logo,
                    'nr_ticket'         =>  $nr_ticket, 
                    'nm_estado'         =>  $nm_estado,
                    'info_ticket'       =>  $info_ticket,
                    'info_vecino'       =>  $info_vecino,
                    'info_clonado'      =>  $info_clonado,
                    'info_derivado'     =>  $info_derivado,
                    'data_historial'    =>  $data_historial,
                    'info_respuestas'   =>  $info_respuestas
                ]
            ]);
            
            // Configurar opciones
            $pdf->setOptions([
                'enable_php'                => true,
                'enable_javascript'         => true,
                'isPhpEnabled'              => true,
                'isRemoteEnabled'           => true,
                'defaultFont'               => 'Arial',
                'dpi'                       => 150,
                'chroot'                    => public_path(),
                'defaultMediaType'          => 'print',
                'defaultPaperSize'          => 'a4',
                'isFontSubsettingEnabled'   => true,
                'debugPng'                  => false,
                'debugKeepTemp'             => false
            ]);
            
            // Establecer tamaño del papel
            $pdf->setPaper('a4', 'portrait');
            
            // Generar y retornar el PDF como stream
            return $pdf->stream($name_document.'.pdf');
        }
        else
        {
            abort(403);
        }
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getInformacionTicketToGeneratePDF($id_ticket)
    {
        $info_data  =   Solicitud::
                        join('gsut_prioridad as prioridad','prioridad.id','=','gsut_solicitud.id_prioridad')
                        ->join('gsut_motivo as motivo','motivo.id','=','gsut_solicitud.id_motivo')
                        ->join('gsut_tipo as servicio','servicio.id','=','gsut_solicitud.id_tipo')
                        ->join('gsut_estado as estado','estado.id','=','gsut_solicitud.id_estado')
                        ->join('gsut_tipo_ingreso as ingreso','ingreso.id','=','gsut_solicitud.tp_ingreso')
                        ->join('gsut_direccion as dir_destino','dir_destino.id','=','gsut_solicitud.id_direccion_destino')
                        ->join('gsut_depto as depto_destino','depto_destino.id','=','gsut_solicitud.id_depto_destino')
                        ->leftjoin('gsut_macroterritorio as mt','mt.id','=','gsut_solicitud.id_macroterritorio')
                        ->leftjoin('gsut_unidadvecinal as uv','uv.id','=','gsut_solicitud.id_unidadvecinal')
                        ->select('gsut_solicitud.id',
                            'gsut_solicitud.id_tipo as id_servicio',
                            'gsut_solicitud.nr_ticket',
                            'dir_destino.nm_direccion as nm_direccion_destino',
                            'depto_destino.nm_depto as nm_depto_destino',
                            'gsut_solicitud.nm_tipo',
                            'prioridad.nm_prioridad',
                            'motivo.nm_motivo',
                            'estado.nm_estado',
                            'estado.nm_color',
                            'ingreso.nm_ingreso',
                            'mt.cod_territorio',
                            'uv.cod_unidadvecinal',
                            'uv.nm_unidadvecinal',
                            'gsut_solicitud.tp_direccion',
                            'gsut_solicitud.nr_direccion',
                            'gsut_solicitud.nm_direccion',
                            'gsut_solicitud.nm_ubicacion',
                            'gsut_solicitud.str_aclaratoria',
                            'gsut_solicitud.str_latitud',
                            'gsut_solicitud.str_longitud',
                            'gsut_solicitud.tp_clonado',
                            'gsut_solicitud.str_clonado',
                            'gsut_solicitud.str_clonado_html',
                            'gsut_solicitud.nr_fuente',
                            'gsut_solicitud.nr_rut_vecino',
                            'gsut_solicitud.str_observacion',
                            'gsut_solicitud.str_observacion_html',
                            'gsut_solicitud.tp_activo',                               
                            'gsut_solicitud.fc_publicado',
                            'gsut_solicitud.fc_creacion',
                            DB::raw('date_format(gsut_solicitud.fc_creacion,"%d-%m-%Y %H:%i") as fc_ingreso'),
                            DB::raw('date_format(gsut_solicitud.fc_publicado,"%d-%m-%Y %H:%i") as fc_publicacion'),
                            DB::raw('date_format(gsut_solicitud.updated_at,"%d-%m-%Y %H:%i") as fc_tramitacion'),
                            'gsut_solicitud.created_at',
                            'gsut_solicitud.updated_at')
                        ->where('gsut_solicitud.tp_activo','=',1)
                        ->where('gsut_solicitud.id',$id_ticket)
                        ->with('vecino','archivos','solicitud','derivacion')
                        ->get();

        return  $info_data;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getHistorialTicketToGeneratePDF($id_ticket)
    {
        $info_data  =   Historial::
                        join('gsut_solicitud as solicitud','solicitud.id','=','gsut_historial.id_solicitud')
                        ->join('users as autor','autor.id','=','gsut_historial.id_autor')
                        ->join('gsut_estado as estado','estado.id','=','gsut_historial.id_estado')
                        ->leftjoin('gsut_vecino as vecino','vecino.nr_rut','=','solicitud.nr_rut_vecino')
                        ->join('gsut_prioridad as prioridad','prioridad.id','=','solicitud.id_prioridad')
                        ->join('gsut_tipo as tipo','tipo.id','=','gsut_historial.id_tipo')
                        ->join('gsut_direccion as dir','dir.id','=','tipo.id_direccion')
                        ->join('gsut_depto as depto','depto.id','=','tipo.id_depto')
                        ->select('gsut_historial.id',
                            'tipo.nm_tipo',
                            'gsut_historial.id_solicitud',
                            'gsut_historial.id_tipo',
                            'gsut_historial.nr_historia',
                            'solicitud.id_direccion',
                            'solicitud.nr_ticket',
                            'solicitud.tp_feedback',
                            DB::raw('date_format(solicitud.fc_feedback, "%d-%m-%Y %H:%i") as fc_feedback'),
                            'solicitud.str_feedback',
                            'solicitud.tp_recepcion',
                            'solicitud.tp_satisfaccion',
                            'solicitud.tp_feedback_vecino',
                            DB::raw('date_format(solicitud.fc_feedback_vecino, "%d-%m-%Y %H:%i") as fc_feedback_vecino'),
                            'solicitud.tp_satisfaccion_vecino',
                            'solicitud.str_feedback_vecino',
                            'solicitud.id_direccion_destino',
                            'solicitud.id_estado as id_estado_solicitud',
                            'prioridad.id as id_prioridad_solicitud',
                            'prioridad.nm_prioridad as nm_prioridad_solicitud',
                            DB::raw('concat(autor.nombre," ",autor.ap_paterno," ",autor.ap_materno) as nm_autor'),
                            DB::raw('concat(vecino.nm_vecino," ",vecino.ap_paterno," ",vecino.ap_materno) as nm_vecino'),
                            'dir.nm_direccion',
                            'depto.nm_depto',
                            DB::raw('date_format(gsut_historial.fc_inicio, "%d-%m-%Y %H:%i") as fc_inicio'),
                            DB::raw('date_format(gsut_historial.fc_termino, "%d-%m-%Y %H:%i") as fc_termino'),
                            DB::raw('(case when gsut_historial.fc_termino
                                            then timestampdiff(day, gsut_historial.fc_inicio, gsut_historial.fc_termino) 
                                            else timestampdiff(day, gsut_historial.fc_inicio, now()) 
                                            end) as fc_diferencia'),
                            'gsut_historial.str_observacion',
                            'gsut_historial.str_observacion_html',
                            'solicitud.str_observacion as str_sol_observacion',
                            'solicitud.str_observacion_html as str_solicitud_html',
                            'gsut_historial.id_estado',
                            'gsut_historial.id_accion',
                            'solicitud.tp_visado_mt',
                            'solicitud.tp_rechazado',
                            'estado.nm_estado',
                            'gsut_historial.tp_activo')
                        ->with('servicio')
                        ->where('gsut_historial.tp_activo','=','1')
                        ->where('gsut_historial.id_solicitud','=',$id_ticket)
                        ->orderBy('gsut_historial.nr_historia')
                        ->with('encargado_servicio')
                        ->get();

        return  $info_data;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getRespuestasTicketToGeneratePDF($id_ticket)
    {
        $info_data  =   Respuesta::
                        select('gsut_respuesta.id',
                            'gsut_respuesta.id_solicitud',
                            'gsut_respuesta.id_autor',
                            DB::raw('date_format(gsut_respuesta.fc_ingreso,"%d-%m-%Y %H:%i") as fc_ingreso'),
                            'gsut_respuesta.str_observacion',
                            'gsut_respuesta.str_observacion_html',
                            'gsut_respuesta.id_historia',
                            'gsut_respuesta.str_ruta_adjunto',
                            'depto.nm_depto',
                            'dir.nm_direccion',
                            'gsut_respuesta.tp_validado',
                            'gsut_respuesta.tp_activo',
                            'gsut_respuesta.tp_respuesta')
                        ->selectRaw("(case 
                            when tp_respuesta = 1 then 'Publicación Definitiva' 
                            when tp_respuesta = 2 then 'Publicación Parcial' 
                            when tp_respuesta = 3 then 'Pre-Publicación Definitiva' 
                            when tp_respuesta = 4 then 'Pre-Publicación Parcial' 
                            when tp_respuesta = 5 then 'Pre-Publicación Definitiva Rechazada' 
                            when tp_respuesta = 6 then 'Pre-Publicación Parcial Rechazada' 
                            when tp_respuesta = 7 then 'Expediente' 
                            when tp_respuesta = 8 then 'VB Jefatura' 
                            when tp_respuesta = 9 then 'VB Director' 
                            when tp_respuesta = 10 then 'Rechazo VB Jefatura' 
                            when tp_respuesta = 11 then 'Rechazo VB Director' 
                            when tp_respuesta = 12 then 'Respuesta Automática Enviada' 
                            when tp_respuesta = 13 then 'Respuesta Automática Fallida' 
                            else 'Respuesta Interna' end) as nm_respuesta")
                        ->selectRaw('CONCAT(nombre," ",ap_paterno) as usuario')
                        ->join('users as autor','autor.id','=','gsut_respuesta.id_autor')
                        ->join('gsut_direccion as dir','dir.id','=','autor.id_direccion')
                        ->join('gsut_depto as depto','depto.id','=','autor.id_depto')
                        ->with('archivos')
                        ->where('id_solicitud','=',$id_ticket)
                        ->where('gsut_respuesta.tp_activo','=',1)
                        ->orderBy('gsut_respuesta.created_at','asc')
                        ->get();

        return  $info_data;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getCantidadSolicitudes()
    {
        $nr_cantidad    =   Solicitud::where('tp_activo','=','1')->count();
        return $nr_cantidad;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getCantidadSolicitudesPorEstado($tp_consulta)
    {
        $nr_cantidad    =   0;
        $id_usuario     =   Auth::user()->id;
        $id_rol         =   Auth::user()->id_rol;
        $tp_admin       =   Auth::user()->tp_admin;
        $id_direccion   =   Auth::user()->id_direccion;
        $id_depto       =   Auth::user()->id_depto;
        $nr_nivel       =   Auth::user()->nr_nivel;
        $data           =   null;


        try {
            if($id_rol == 1) // Territorial
            {
                $id_uv  =   UtilController::getIdUnidadVecinalUser($id_usuario);
                $data   =   Solicitud::
                            join('gsut_macroterritorio as mt','mt.id','=','gsut_solicitud.id_macroterritorio')
                            ->join('gsut_unidadvecinal as uv','uv.id','=','gsut_solicitud.id_unidadvecinal')
                            ->select('gsut_solicitud.id')
                            ->where('gsut_solicitud.tp_activo','=',1)
                            ->where('gsut_solicitud.id_estado','=',5);

                if($tp_consulta == 1)
                    $data   =   $data->where('gsut_solicitud.id_autor','=',$id_usuario);

                if($tp_consulta == 2)
                    $data   =   $data->whereIn('gsut_solicitud.id_unidadvecinal',$id_uv)
                                 ->whereNotIn('gsut_solicitud.id_autor',[$id_usuario]);
            }

            if($id_rol == 3) // Macrozona 
            {
                $data   =   Solicitud::                                 
                            join('gsut_macroterritorio as mt','mt.id','=','gsut_solicitud.id_macroterritorio')
                            ->join('gsut_unidadvecinal as uv','uv.id','=','gsut_solicitud.id_unidadvecinal')
                            ->join('gsut_distribucion_territorio as dt', function ($join) use ($id_usuario)
                            {
                                $join->on('dt.nr_id','=','mt.id')
                                     ->where('dt.tp_tabla','=','tb_macroterritorio')
                                     ->where('dt.id_user','=',$id_usuario);
                            })
                            ->select('gsut_solicitud.id')
                            ->where('gsut_solicitud.tp_activo','=',1)
                            ->where('gsut_solicitud.id_estado','=',1);

                if($tp_consulta == 1)
                    $data   =   $data->whereIn('gsut_solicitud.id_autor',[$id_usuario]);

                if($tp_consulta == 2)
                    $data   =   $data->whereNotIn('gsut_solicitud.id_autor',[$id_usuario]);
            }

            if($id_rol == 5) // Funcionario
            {
                $data   =   Solicitud:: 
                            join('gsut_prioridad as prioridad','prioridad.id','=','gsut_solicitud.id_prioridad')
                            ->join('gsut_tipo as tipo','tipo.id','=','gsut_solicitud.id_tipo')
                            ->leftjoin('gsut_macroterritorio as mt','mt.id','=','gsut_solicitud.id_macroterritorio')
                            ->leftjoin('gsut_unidadvecinal as uv','uv.id','=','gsut_solicitud.id_unidadvecinal')
                            ->select('gsut_solicitud.id')
                            ->selectRaw("(case when tp_vecino = 1 then 'SI' else 'NO' end) as tp_vecino")
                            ->where('gsut_solicitud.tp_activo','=',1)
                            ->where('gsut_solicitud.id_estado','=',3);

                if($tp_consulta == 1)
                    $data   =   $data->whereIn('gsut_solicitud.id_autor',[$id_usuario]);

                if($tp_consulta == 2)
                {
                    $data   =   $data->join('gsut_encargado_solicitud as es','es.id_solicitud','=','gsut_solicitud.id')
                                     ->where('es.id_encargado','=',$id_usuario)
                                     ->where('es.tp_activo','=',1)
                                     ->whereNotIn('gsut_solicitud.id_autor',[$id_usuario]);
                }
            }

            if($id_rol == 21) // Director // if($id_rol == 7 && $tp_admin == 2)
            {
                $data   =   Solicitud:: 
                            join('gsut_tipo as tipo','tipo.id','=','gsut_solicitud.id_tipo')
                            ->join('gsut_respuesta as respuesta', function ($join) {
                                $join->on('respuesta.id_solicitud','=','gsut_solicitud.id')
                                     ->whereIn('respuesta.tp_respuesta',[9])
                                     ->where('respuesta.tp_validado','=',0);
                            })
                            ->where('gsut_solicitud.id_direccion_destino','=',$id_direccion)
                            ->whereNotIn('gsut_solicitud.id_estado',[5,6,7,10,11]);
            }

            if($id_rol == 23) // Jefe Depto //if($id_rol == 7 && $tp_admin == 3)
            {
                $data   =   Solicitud:: 
                            join('gsut_tipo as tipo','tipo.id','=','gsut_solicitud.id_tipo')
                            ->join('gsut_respuesta as respuesta', function ($join) {
                                $join->on('respuesta.id_solicitud','=','gsut_solicitud.id')
                                     ->whereIn('respuesta.tp_respuesta',[8])
                                     ->where('respuesta.tp_validado','=',0);
                            })
                            ->where('gsut_solicitud.id_direccion_destino','=',$id_direccion)
                            ->where('gsut_solicitud.id_depto_destino','=',$id_depto)
                            ->whereNotIn('gsut_solicitud.id_estado',[5,6,7,10,11]);
            }

            if($data != null)
            {
                $data   =   $data->get();

                if($data->count())
                    $nr_cantidad    =   $data->count();
            }            
        } catch (Exception $e) {
            $nr_cantidad    =   0;
        }

        return $nr_cantidad;
    }
    //--------------------------------------------------------------------------------------------------------- 
    public static function getCantidadRespuestas($tp_respuesta = 0, $nr_solicitud)
    {
        // 0 => Respuesta Interna | 1 => Publicacion Definitiva | 2 => Publicacion Parcial
        $nr_cantidad    =   Respuesta::
                            where('id_solicitud','=',$nr_solicitud)
                            ->where('tp_respuesta','=',$tp_respuesta)
                            ->get()->count();

        return $nr_cantidad;
    }
    //--------------------------------------------------------------------------------------------------------- 
    public static function getPublicacion($tp_respuesta, $nr_solicitud)
    {
        // 0 => Respuesta Interna | 1 => Publicacion Definitiva | 2 => Publicacion Parcial
        $publicacion    =   null;
        $data           =   Respuesta::
                            where('id_solicitud','=',$nr_solicitud)
                            ->where('tp_respuesta','=',$tp_respuesta)
                            ->orderBy('id','ASC')
                            ->get();

        if($data->count())
            $publicacion    =   $data->first();

        return $publicacion;
    }
    //--------------------------------------------------------------------------------------------------------- 
    public static function getUbicacionDeptoMunicipal($nr_depto)
    {
        $arr_ubicacion  =   null;

        try {
            $depto      =   Depto::where('id','=',$nr_depto)->get();

            if($depto->count())
            {
                $data   =   MaestroDirecciones::
                            select('id as value',
                                'nm_direccion as label',
                                'nr_calle',
                                'nm_calle',
                                'str_latitud',
                                'str_longitud',
                                'cod_territorial',
                                'cod_unidadvecinal')
                            ->whereRaw('nm_direccion LIKE ?',['%'.$depto->first()->nm_ubicacion.'%'])
                            ->get();

                if($data->count())
                    $arr_ubicacion  =   $data->first();
            }
        } catch (Exception $e) {
            $arr_ubicacion  =   null;
        }

        return $arr_ubicacion;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function macrozonaTieneSolicitudPendiente($nr_servicio)
    {
        $arr_valida     =   [];

        $data           =   Tipo::
                            join('gsut_solicitud as s','s.id_tipo','=','gsut_tipo.id')
                            ->where('gsut_tipo.tp_macrozona','=',1)
                            ->where('s.tp_visado_mt','=',0)
                            ->where('gsut_tipo.id','=',$nr_servicio)
                            ->where('s.id_estado','=',1)
                            ->get();

        if($data->count())
            $arr_valida     =   [
                'error'     =>  1,
                'tp_icon'   =>  'warning',
                'title'     =>  'Solicitudes Pendientes',
                'msj'       =>  'No es posible realizar esta acción, quedan "'.$data->count().'" solicitudes pendientes de visación por el macrozona.',
            ];
        else
            $arr_valida     =   [
                'error'     =>  0,
                'tp_icon'   =>  'success',
                'title'     =>  'Solicitudes Pendientes',
                'msj'       =>  'No se encuentran solicitudes pendientes de visación.',
            ];

        return $arr_valida;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function asignadorTieneSolicitudPendiente($nr_servicio)
    {
        $arr_valida     =   [];

        $data           =   Tipo::
                            join('gsut_solicitud as s','s.id_tipo','=','gsut_tipo.id')
                            ->where('gsut_tipo.tp_asignacion','=',1)
                            ->where('s.tp_asignador','=',0)
                            ->where('gsut_tipo.id','=',$nr_servicio)
                            ->where('s.id_estado','=',2)
                            ->get();

        if($data->count())
            $arr_valida     =   [
                'error'     =>  1,
                'tp_icon'   =>  'warning',
                'title'     =>  'Solicitudes Pendientes',
                'msj'       =>  'No es posible realizar esta acción, quedan "'.$data->count().'" solicitudes pendientes de asignación por el "Asignador de Solicitudes".',
            ];
        else
            $arr_valida     =   [
                'error'     =>  0,
                'tp_icon'   =>  'success',
                'title'     =>  'Solicitudes Pendientes',
                'msj'       =>  'No se encuentran solicitudes pendientes de asignación.',
            ];

        return $arr_valida;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function directorTieneSolicitudPendiente($nr_solicitud)
    {
        $arr_valida     =   [];
        $tp_validar     =   0;
        $usuario        =   UtilController::getDataUser();

        if($usuario->id_rol == 7 && in_array($usuario->tp_admin, [2,3])) //if($usuario->id_rol == 7 && in_array($usuario->tp_admin, [2,3]))
            $tp_validar =   1;

        if($tp_validar == 1)
        {
            $data           =   Respuesta::
                                join('users as funcionario','funcionario.id','=','gsut_respuesta.id_autor')
                                ->whereIn('tp_respuesta',[9])
                                ->where('tp_validado','=',0)
                                ->where('id_solicitud','=',$nr_solicitud)
                                ->get();

            if($data->count())
                $arr_valida     =   [
                    'error'     =>  1,
                    'tp_icon'   =>  'warning',
                    'title'     =>  'Validación VB Director',
                    'msj'       =>  'No es posible realizar esta acción, quedan "'.$data->count().'" VB pendientes de validación por el Director.',
                ];
            else
                $arr_valida     =   [
                    'error'     =>  0,
                    'tp_icon'   =>  'success',
                    'title'     =>  'Validación VB Director',
                    'msj'       =>  'No se encuentran publicaciones pendientes de validación.',
                ];
        }
        else
        {
            $arr_valida     =   [
                'error'     =>  0,
                'tp_icon'   =>  'success',
                'title'     =>  'Validación VB Director',
                'msj'       =>  'No se encuentran publicaciones pendientes de validación.',
            ];
        }

        return $arr_valida;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function jefeDeptoTieneSolicitudPendiente($nr_solicitud)
    {
        $arr_valida     =   [];
        $tp_validar     =   0;
        $usuario        =   UtilController::getDataUser();

        if($usuario->id_rol == 7 && in_array($usuario->tp_admin, [2,3]))
            $tp_validar =   1;


        if($tp_validar == 1)
        {
            $data           =   Respuesta::
                                join('users as funcionario','funcionario.id','=','gsut_respuesta.id_autor')
                                ->whereIn('tp_respuesta',[8])
                                ->where('tp_validado','=',0)
                                ->where('id_solicitud','=',$nr_solicitud)
                                ->get();

            if($data->count())
                $arr_valida     =   [
                    'error'     =>  1,
                    'tp_icon'   =>  'warning',
                    'title'     =>  'Validación VB Jefatura',
                    'msj'       =>  'No es posible realizar esta acción, quedan "'.$data->count().'" VB pendientes de validación por la Jefatura.',
                ];
            else
                $arr_valida     =   [
                    'error'     =>  0,
                    'tp_icon'   =>  'success',
                    'title'     =>  'Validación VB Jefatura',
                    'msj'       =>  'No se encuentran VB pendientes de validación.',
                ];
        }
        else
        {
            $arr_valida     =   [
                'error'     =>  0,
                'tp_icon'   =>  'success',
                'title'     =>  'Validación VB Jefatura',
                'msj'       =>  'No se encuentran publicaciones pendientes de validación.',
            ];
        }

        return $arr_valida;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function solicitudTieneGestionesSinValidar($nr_rol, $solicitud, $respuesta) // ($solicitud, $servicio)
    {
        $arr_valida     =   [];
        $nm_encargado   =   'Encargado Unidad';
        $nr_usuario     =   0;
        $encargado      =   null;
        $usuario        =   null;
        $tp_validar     =   0;
        //---------------------------------------------------------------------------------
        // Consulta si hay publicaciones sin validar
        $data   =   Respuesta::
                    whereIn('tp_respuesta',[8,9]) // whereIn('tp_respuesta',[3,4])
                    ->where('tp_validado','=',0)
                    ->where('id_solicitud','=',$solicitud->id)
                    ->get();

        if($data->count())
        {
            $nm_encargado   =   ($data->first()->tp_respuesta == 8) ? 'Jefatura' : 'Director';

            $arr_valida     =   [
                'error'     =>  1,
                'tp_icon'   =>  'warning',
                'title'     =>  'Gestiones Pendientes de Validación',
                'msj'       =>  'No es posible realizar esta acción, hay gestiones pendientes de validación por "'.$nm_encargado.'".',
            ];
        }
        else
            $arr_valida     =   [
                'error'     =>  0,
                'tp_icon'   =>  'success',
                'title'     =>  'Gestiones Pendientes de Validación',
                'msj'       =>  'No se encuentran gestiones pendientes de validación.',
            ];

        return $arr_valida;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function validaPermisos($arr_funcionarios = [])
    {
        $tp_publicar    =   1;
        $tp_parcial     =   0;
        $tp_responder   =   0;
        $arr_valida     =   [
                                'error'     =>  0,
                                'tp_icon'   =>  'info',
                                'title'     =>  'Valida Persmiso de Funcionarios',
                                'msj'       =>  'Validando permisos del funcionario',
                                'encargado' =>  [],
                                'archivo'   =>  [],
                            ];

        if(count($arr_funcionarios))
        {
            $data   =   User::
                        select('id',
                            'tp_finalizar',
                            'tp_responder',
                            'tp_informar',
                            'tp_derivar')
                        ->whereIn('id',$arr_funcionarios)
                        ->where('tp_finalizar','=',$tp_publicar)
                        ->get();

            if($data->count())
                $arr_valida     =   [
                                        'error'     =>  0,
                                        'tp_icon'   =>  'success',
                                        'title'     =>  'Valida Persmiso de Funcionarios',
                                        'msj'       =>  'Se encontraron "'.$data->count().'" funcionarios que tienen permisos para realizar publicaciones',
                                        'encargado' =>  [],
                                        'archivo'   =>  [],
                                    ];
            else
                $arr_valida     =   [
                                        'error'     =>  1,
                                        'tp_icon'   =>  'warning',
                                        'title'     =>  'Valida Persmiso de Funcionarios',
                                        'msj'       =>  'No se enscontraron funcionarios con permisos de "Publicación Definitiva al Vecino", debe haber por lo memos un funcionario con dicho permiso',
                                        'encargado' =>  [],
                                        'archivo'   =>  [],
                                    ];

            return $arr_valida;
        }
    }
    //---------------------------------------------------------------------------------------------------------
    public static function replicarAdjunto($nr_id_old, $nr_id_new, $tp_tabla = 'tb_respuesta')
    {
        $valida     =   0;

        if(self::tieneAdjunto($tp_tabla, $nr_id_old))
        {
            $data   =   self::getArchivos($tp_tabla, $nr_id_old);
            
            foreach ($data as $value) {
                $model  =   new Archivos();
                $model->tp_tabla        =   $tp_tabla;
                $model->nr_id           =   $nr_id_new;
                $model->nm_archivo      =   $value->nm_archivo;
                $model->str_observacion =   $value->str_observacion;
                $model->str_archivo     =   $value->str_archivo;
                $model->ext_archivo     =   $value->ext_archivo;
                $model->tp_activo       =   $value->tp_activo;
                $model->save();
            }
        }        
    }
    //---------------------------------------------------------------------------------------------------------
    public static function tieneAdjunto($tp_tabla, $nr_id)
    {
        $valida =   0;

        try {
            if(isset($nr_id))
            {
                $data   =   Archivos::
                            where('nr_id','=',$nr_id)
                            ->where('tp_tabla','=',$tp_tabla)
                            ->get();

                if($data->count())
                    $valida     =   1;
            }            
        } catch (Exception $e) {
            $valida     =   0;
        }

        return $valida;            
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getArchivos($tp_tabla, $nr_id)
    {
        $data   =   Archivos::
                    where('nr_id','=',$nr_id)
                    ->where('tp_tabla','=',$tp_tabla)
                    ->get();

        return $data;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function isRelacionesPublicas()
    {
        $user_depto =   Auth::user()->id_depto;
        $nr_depto   =   92; // Depto. Relaciones Publicas
        $valida     =   false;

        if($user_depto === $nr_depto)
            $valida     =   true;

        return $valida;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getIngresoCanViewRelaionesPublicas()
    {
        $arr_ingreso     =   [7]; // Redes Sociales
        return $arr_ingreso;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function isUserAdminDirectorExiste($nr_direccion)
    {
        $existe =   0;
        $data   =   User::
                    join('gsut_user_rol as ur','ur.id_user','=','users.id')
                    ->select('users.id',
                        'users.id_direccion',
                        'users.id_depto',
                        'users.id_rol as rol_activo',
                        'users.tp_admin',
                        'ur.id_rol')
                    ->where('users.id_direccion','=',$nr_direccion)
                    ->where('ur.id_rol','=','21')
                    ->get();

        if($data->count())
            $existe     =   1;

        return $existe;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function isUserAdminDeptoExiste($nr_depto)
    {
        $existe =   0;
        $data   =   User::
                    join('gsut_user_rol as ur','ur.id_user','=','users.id')
                    ->select('users.id',
                        'users.id_direccion',
                        'users.id_depto',
                        'users.id_rol as rol_activo',
                        'users.tp_admin',
                        'ur.id_rol')
                    ->where('users.id_depto','=',$nr_depto)
                    ->where('ur.id_rol','=','23')
                    ->get();

        if($data->count())
            $existe     =   1;

        return $existe;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function rutasRoles()
    {
        $nr_rol     =   Auth::user()->id_rol;
        $rutas      =   ['home'];

        switch($nr_rol)
        {
            case 1:     // Territorial
            {
                $rutas  =   [
                    'territorial/inicio',
                    'territorial/ingreso',
                    'territorial/listado',
                    'territorial/bandeja'
                ];
                break;
            }
            case 3:     // Macrozona
            {
                $rutas  =   [
                    'macrozona/inicio',
                    'macrozona/ingreso',
                    'macrozona/listado',
                    'macrozona/bandeja'
                ];
                break;
            }
            case 5:     // Funcionario
            {
                $rutas  =   [
                    'funcionario/inicio',
                    'funcionario/ingreso',
                    'funcionario/listado',
                    'funcionario/bandeja'
                ];
                break;
            }
            case 7:     // Administrador
            {
                $rutas  =   [
                    'administrador/inicio',
                    'administrador/ingreso',
                    'administrador/usuarios',
                    'administrador/servicios',
                    'administrador/solicitud',
                    'administrador/encuestadores',
                    'administrador/estructura_encuesta',
                    'administrador/encuesta',
                    'administrador/llamados',
                    'administrador/estadistica_encuestador',
                    'administrador/visacion',
                    'administrador/exportar'
                ];
                break;
            }
            case 9:     // Asignador
            {
                $rutas  =   [
                    'asignador/inicio',
                    'asignador/servicios'
                ];
                break;
            }
            case 11:    // Concejal
            {
                $rutas  =   [
                    'concejal/inicio',
                    'concejal/solicitud'
                ];
                break;
            }
            case 13:    // Observador
            {
                $rutas  =   [
                    'observador/inicio',
                    'observador/solicitud'
                ];
                break;
            }
            case 15:    // Redes Sociales
            {
                $rutas  =   [
                    'rrss/inicio',
                    'rrss/ingreso',
                    'rrss/consulta',
                    'rrss/dashboard_rrss'
                ];
                break;
            }
            case 17:    // Reuniones Comunitarias
            {
                $rutas  =   [
                    'rrcc/inicio',
                    'rrcc/solicitud'
                ];
                break;
            }
            case 19:    // Supervisor Territorial
            {
                $rutas  =   [
                    'supervisor/inicio',
                    'supervisor/solicitud'
                ];
                break;
            }
            case 21:    // Director
            {
                $rutas  =   [
                    'administrador/inicio',
                    'administrador/solicitud',
                    'administrador/visacion'
                ];
                break;
            }
            case 23:    // Jefatura
            {
                $rutas  =   [
                    'administrador/inicio',
                    'administrador/solicitud',
                    'administrador/visacion'
                ];
                break;
            }
            case 25:    // Encuestador
            {
                $rutas  =   [
                    'encuestador/inicio',
                    'encuestador/solicitud',
                    'encuestador/llamados',
                    'encuestador/agendamientos'
                ];
                break;
            }
            case 27:    // Visualizador (visualiza una direccion)
            {
                $rutas  =   [
                    'visualizador/inicio',
                    'visualizador/solicitud',
                ];
                break;
            }
            case 29:    // Visualizador (visualiza una depto)
            {
                // ------------------------

                break;
            }
            case 31:    // Telefonista
            {
                $rutas  =   [
                    'telefonista/inicio',
                    'telefonista/ingreso',
                    'telefonista/solicitud'
                ];

                break;
            }
            case 33:    // Revisor
            {
                $rutas  =   [
                    'revisor/inicio',
                    'revisor/ingreso',
                    'revisor/solicitud'
                ];

                break;
            }
            case 35:    // IA Atención Vecino
            {
                $rutas  =   [
                    'ia_gpt/inicio',
                    'ia_gpt/base_conocimiento',
                    'ia_gpt/doc_pdfs',
                ];

                break;
            }
            case 35:    // Seguridad Informatica
            {
                $rutas  =   [
                    'seguridadti/inicio',
                ];

                break;
            }
            default:    //  Home
            {
                $rutas  =   ['home'];
                break;
            }
        }

        return $rutas;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getConsultaSolicitud($nr_solicitud)
    {
        $data   =   Solicitud:: 
                    join('gsut_prioridad as prioridad','prioridad.id','=','gsut_solicitud.id_prioridad')
                    ->join('gsut_motivo as motivo','motivo.id','=','gsut_solicitud.id_motivo')
                    ->join('gsut_tipo as tipo','tipo.id','=','gsut_solicitud.id_tipo')
                    ->join('gsut_estado as estado','estado.id','=','gsut_solicitud.id_estado')
                    ->join('gsut_direccion as dir_destino','dir_destino.id','=','gsut_solicitud.id_direccion_destino')
                    ->join('gsut_depto as depto_destino','depto_destino.id','=','gsut_solicitud.id_depto_destino')
                    ->leftjoin('gsut_macroterritorio as mt','mt.id','=','gsut_solicitud.id_macroterritorio')
                    ->leftjoin('gsut_unidadvecinal as uv','uv.id','=','gsut_solicitud.id_unidadvecinal')
                    ->join('gsut_tipo_ingreso as ti','ti.id','=','gsut_solicitud.tp_ingreso')
                    ->select('gsut_solicitud.id',
                        'gsut_solicitud.nr_ticket',
                        'gsut_solicitud.id_municipio',
                        'gsut_solicitud.id_direccion',
                        'gsut_solicitud.id_depto',
                        'gsut_solicitud.id_tipo',
                        'gsut_solicitud.nm_tipo',
                        'gsut_solicitud.id_prioridad',
                        'prioridad.nm_prioridad',
                        'gsut_solicitud.id_motivo',
                        'motivo.nm_motivo',
                        'gsut_solicitud.tp_clonado',
                        'gsut_solicitud.nr_fuente',
                        'gsut_solicitud.id_direccion_destino',
                        'dir_destino.nm_direccion as nm_direccion_destino',
                        'gsut_solicitud.id_depto_destino',
                        'depto_destino.nm_depto as nm_depto_destino',
                        'gsut_solicitud.id_ubicacion',
                        'gsut_solicitud.id_macroterritorio',
                        'mt.cod_territorio',
                        'gsut_solicitud.id_unidadvecinal',
                        'uv.cod_unidadvecinal',
                        'uv.nm_unidadvecinal',
                        'gsut_solicitud.tp_direccion',
                        'gsut_solicitud.nr_direccion',
                        'gsut_solicitud.nm_direccion',
                        'gsut_solicitud.nm_ubicacion',
                        'gsut_solicitud.str_latitud',
                        'gsut_solicitud.str_longitud',
                        'gsut_solicitud.nr_rut_vecino',
                        'gsut_solicitud.str_observacion',
                        'gsut_solicitud.str_observacion_html',
                        'gsut_solicitud.str_aclaratoria',
                        'gsut_solicitud.tp_visado_mt',
                        'gsut_solicitud.tp_rechazado',
                        'gsut_solicitud.id_estado',
                        'estado.nm_estado',
                        'estado.nm_color',
                        'gsut_solicitud.contexto_municipal',
                        'gsut_solicitud.tp_ingreso',
                        'ti.nm_ingreso',
                        'gsut_solicitud.id_autor',
                        'gsut_solicitud.tp_activo',
                        'gsut_solicitud.tp_feedback',
                        'gsut_solicitud.tp_recepcion',
                        'gsut_solicitud.tp_satisfaccion',
                        'gsut_solicitud.str_feedback',
                        'gsut_solicitud.fc_publicado',
                        'gsut_solicitud.created_at as fc_ingreso',
                        'gsut_solicitud.updated_at as fc_tramitacion')
                    ->selectRaw("(case when tp_vecino = 1 then 'SI' else 'NO' end) as tp_vecino")
                    ->with('vecino','archivos','asignados','solicitud','derivacion')
                    ->where('gsut_solicitud.id','=',$nr_solicitud)
                    ->get()->first();

        return $data;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getSolicitudTelefonistas($nr_telefonista = 0)
    {
        $arr_excluir    =   [1,51]; 
        /* Se excluyen los servicios 
            1.      Recepción de Curriculum
            51.     Podas y Arbolado Urbano
        */

        $data   =   Solicitud::
                    select('gsut_solicitud.id',
                        'gsut_solicitud.nr_anio',
                        'gsut_solicitud.nr_mes',
                        'gsut_solicitud.nr_rut_vecino',
                        'gsut_solicitud.nr_ticket',
                        'gsut_solicitud.id_estado',
                        'gsut_solicitud.id_estado_encuesta',
                        'gsut_solicitud.id_telefonista',
                        'gsut_solicitud.tp_activo')
                    ->where('gsut_solicitud.tp_activo','=','1')
                    ->whereNotIn('gsut_solicitud.id_tipo',$arr_excluir)
                    ->whereIn('gsut_solicitud.id_estado',[5,6])
                    ->whereNotIn('gsut_solicitud.id_estado_encuesta',[7])
                    ->whereExists(function ($query) {
                        $query->select(DB::raw('1'))
                            ->from('gsut_vecino')
                            ->whereRaw('gsut_vecino.nr_rut = gsut_solicitud.nr_rut_vecino');
                    })
                    ->whereRaw('(select count(s.id)
                                from     gsut_solicitud as s
                                where    s.tp_activo = 1
                                    and  s.nr_rut_vecino = gsut_solicitud.nr_rut_vecino
                                    and  s.nr_anio = gsut_solicitud.nr_anio
                                    and  s.nr_mes = gsut_solicitud.nr_mes
                                    and  s.id_estado in (5,6)) <= 1');

        if($nr_telefonista != 0) 
            $data   =   $data->where('gsut_solicitud.id_estado_encuesta','=','1')
                            ->where('gsut_solicitud.id_telefonista','=',$nr_telefonista);
        else
            $data   =   $data->whereIn('gsut_solicitud.id_estado_encuesta',[1,2,3,6])
                            ->where('gsut_solicitud.id_telefonista','=','0');

        $data   =   $data->groupBy('gsut_solicitud.nr_anio','gsut_solicitud.nr_mes','gsut_solicitud.nr_rut_vecino');
        $data   =   $data->get();

        if($data->count())
        {
            $arr_ids    =   $data->pluck('id')->toArray();
            $excluidos  =   Solicitud::
                            select('id','nr_anio','nr_mes','nr_rut_vecino','nr_ticket')
                            ->where('tp_activo','=','1')
                            ->whereIn('id_estado',[5,6])
                            ->whereNotIn('id_estado_encuesta',[4,7])
                            ->whereNotIn('id',$arr_ids);

            if($nr_telefonista != 0)
                $excluidos   =   $excluidos->where('id_telefonista','=',$nr_telefonista);
            else
                $excluidos   =   $excluidos->where('id_telefonista','=','0');

            $excluidos   =   $excluidos->get();

            if($excluidos->count())
            {
                $arr_ids    =   $excluidos->pluck('id')->toArray();

                Solicitud::
                whereIn('id',$arr_ids)
                ->update([
                    'id_estado_encuesta'        =>  7,
                    'id_telefonista'            =>  0,
                    'tp_utilizar_encuesta'      =>  0,
                    'tp_utilizar_telefonista'   =>  0
                ]);

            }
        }

        return $data;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getCantidadSolicitudTelefonistasEstado($nr_telefonista = 0, $nr_estado = 1)
    {
        $arr_excluir    =   [1,51]; 
        /* Se excluyen los servicios 
            1.      Recepción de Curriculum
            51.     Podas y Arbolado Urbano
        */
        $id_rol         =   Auth::user()->id_rol;
        $nr_cantidad    =   0;

        $data           =   Solicitud::
                            select('gsut_solicitud.id',
                                'gsut_solicitud.nr_anio',
                                'gsut_solicitud.nr_mes',
                                'gsut_solicitud.nr_rut_vecino',
                                'gsut_solicitud.nr_ticket')
                            ->where('gsut_solicitud.tp_activo','=','1')
                            ->whereNotIn('gsut_solicitud.id_tipo',$arr_excluir)
                            ->whereIn('gsut_solicitud.id_estado',[5,6])
                            ->whereNotIn('gsut_solicitud.id_estado_encuesta',[7])
                            ->whereExists(function ($query) {
                                $query->select(DB::raw('1'))
                                    ->from('gsut_vecino')
                                    ->whereRaw('gsut_vecino.nr_rut = gsut_solicitud.nr_rut_vecino');
                            });
        //-------------------------------------------------------------------------------------
        if($nr_telefonista != 0 && in_array($id_rol,[7,25]))
            $data   =   $data->where('gsut_solicitud.id_telefonista','=',$nr_telefonista);

        if($nr_telefonista == 0 && in_array($id_rol,[7]))
            $data   =   $data->where('gsut_solicitud.id_telefonista','=',$nr_telefonista);

        if($nr_estado != 0)
            $data   =   $data->where('gsut_solicitud.id_estado_encuesta','=',$nr_estado);
        //-------------------------------------------------------------------------------------
        if(in_array($id_rol,[7,25]))
        {
            if(UtilController::getCantidadTelefonistas() <= 1)
            {
                $data   =   $data->whereRaw('(select count(s.id)
                                        from     gsut_solicitud as s
                                        where    s.tp_activo = 1
                                            and  s.nr_rut_vecino = gsut_solicitud.nr_rut_vecino
                                            and  s.nr_anio = gsut_solicitud.nr_anio
                                            and  s.nr_mes = gsut_solicitud.nr_mes
                                            and  s.id_estado in (5,6)) <= 1');
                $data   =   $data->groupBy('gsut_solicitud.nr_anio','gsut_solicitud.nr_mes','gsut_solicitud.nr_rut_vecino');
                $data   =   $data->get();

                if($data->count())
                {
                    $arr_ids    =   $data->pluck('id')->toArray();
                    $excluidos  =   Solicitud::
                                    select('id','nr_anio','nr_mes','nr_rut_vecino','nr_ticket')
                                    ->where('tp_activo','=','1')
                                    ->whereIn('id_estado',[5,6])
                                    ->whereNotIn('id_estado_encuesta',[4,7])
                                    ->whereNotIn('id',$arr_ids);

                    if($nr_telefonista != 0)
                        $excluidos   =   $excluidos->where('id_telefonista','=',$nr_telefonista);
                    else
                        $excluidos   =   $excluidos->where('id_telefonista','=','0');

                    $excluidos   =   $excluidos->get();
                    
                    if($excluidos->count())
                    {
                        $arr_ids    =   $excluidos->pluck('id')->toArray();

                        Solicitud::
                        whereIn('id',$arr_ids)
                        ->update([
                            'id_estado_encuesta'        =>  7,
                            'id_telefonista'            =>  0,
                            'tp_utilizar_encuesta'      =>  0,
                            'tp_utilizar_telefonista'   =>  0
                        ]);
                    }
                }
            }
            else
                $data   =   $data->get();
        }
        else 
            $data   =   $data->get();
        //-------------------------------------------------------------------------------------
        if($data->count())
            $nr_cantidad    =   $data->count();
        //-------------------------------------------------------------------------------------
        return $nr_cantidad;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getCantidadTicketPorTelefonistas()
    {
        $arr_estado =   [1,2,3,6];

        $data       =   EncuestaTelefonista::
                        select('gsut_encuesta_telefonistas.id_telefonista',
                            DB::raw('(select ifnull(count(solicitud.id_telefonista),0) 
                                from gsut_solicitud as solicitud 
                                where solicitud.id_telefonista = gsut_encuesta_telefonistas.id_telefonista 
                                and solicitud.tp_activo = 1 
                                and solicitud.id_estado_encuesta in (1,2,3,6)) as nr_cantidad'))
                        ->groupBy('gsut_encuesta_telefonistas.id_telefonista')
                        ->get()->toArray();

        array_multisort(array_column($data, 'nr_cantidad'), SORT_ASC, $data);

        return  $data;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getCantidadTicketAtendidosPorTelefonista($nr_telefonista = 0)
    {
        $id_rol         =   Auth::user()->id_rol;
        $nr_cantidad    =   0;
        $fc_fecha       =   Date('Y-m-d');

        $data           =   Solicitud::
                            join('gsut_encuesta_llamada as llamada','llamada.id_solicitud','=','gsut_solicitud.id')
                            ->select(DB::raw('count(llamada.id_autor) as cantidad'))
                            ->whereIn('llamada.id_estado',[2,3,4,5])
                            ->where(DB::raw('date_format(llamada.created_at,"Y-m-d")'),'=',DB::raw('date_format(now(),"Y-m-d")'));

        if($nr_telefonista != 0 && in_array($id_rol,[25]))
            $data   =   $data->where('llamada.id_autor','=',$nr_telefonista);

        $data   =   $data->get();

        if($data->count())
            $nr_cantidad    =   $data->first()->cantidad;

        return $nr_cantidad;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getCantidadTicketAgendadosporFecha($fc_fecha)
    {
        $nr_cantidad    =   0;
        
        $data           =   Solicitud:: 
                            select(DB::raw('count(gsut_solicitud.id) as cantidad'))
                            ->where('gsut_solicitud.tp_activo','=',1)
                            ->whereExists(function ($query) use ($fc_fecha) {
                                $query->select(DB::raw('1'))
                                    ->from('gsut_encuesta_llamada as llamada')
                                    ->join('gsut_encuesta_respuestas as respuesta','respuesta.id_llamada','=','llamada.id')
                                    ->join('gsut_encuesta_pregunta as pregunta','pregunta.id','=','respuesta.id_pregunta')
                                    ->whereRaw('llamada.id_estado = 3')
                                    ->whereRaw('gsut_solicitud.id = llamada.id_solicitud')
                                    ->whereRaw('pregunta.tp_pregunta = 4')
                                    ->where(DB::raw('date(respuesta.nm_alternativa)'),'=',$fc_fecha);
                            });

        if($data->count())
            $nr_cantidad    =   $data->first()->cantidad;

        return $nr_cantidad;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getDistribucionTicketTelefonista(Request $request)
    {
        $tp_distribucion    =   intval($request->tp_distribucion);
        $nr_distribucion    =   intval($request->nr_distribucion);
        $nr_telefonista     =   $request->nr_telefonista;
        $str_title          =   'Distribución de Ticket';
        $str_msj            =   '';
        $arr_validar        =   ['error' => 0, 'tp_icon' => 'success', 'title' => $str_title, 'msj' => ''];

        set_time_limit(0);
        ini_set('memory_limit','-1');

        switch($tp_distribucion)
        {
            case 1: // Equidad de carga de Trabajo
            {
                $arr_ticket     =   self::getSolicitudTelefonistas(0);

                if($arr_ticket->count())
                {
                    foreach ($arr_ticket as $key => $value) {
                        $arr_cargatrabajo   =   self::getCantidadTicketPorTelefonistas();

                        if(count($arr_cargatrabajo))
                        {
                            $nr_estado          =   1; // Pendiente
                            $nr_telefonista     =   $arr_cargatrabajo[0]['id_telefonista'];

                            Solicitud::where('id','=',$value->id)
                            ->update([
                                'id_telefonista'        =>  $nr_telefonista,
                                'id_estado_encuesta'    =>  $nr_estado
                            ]);
                        }
                    }
                }

                break;
            }
            case 2: // Igualdad de Carga de Trabajo
            {
                $arr_ticket         =   self::getSolicitudTelefonistas(0);
                $arr_cargatrabajo   =   self::getCantidadTicketPorTelefonistas();
                $nr_total           =   0;

                if(count($arr_cargatrabajo) && $arr_ticket->count())
                {
                    $arr_distribucion   =   [];
                    $arr_solicitud      =   [];
                    $arr_last           =   [];
                    $nr_last            =   0;
                    $nr_total           =   0;
                    $nr_contador        =   0;
                    $nr_cantidad        =   0;
                    $nr_index           =   0;
                    $nr_telefonista     =   0;
                    $nr_estado          =   1; // Pendiente
                    $nr_total           =   $arr_ticket->count();
                    $cant_telefonista   =   count($arr_cargatrabajo);
                    $nr_repartir        =   intval(($nr_total / $cant_telefonista));
                    $nr_resto           =   intval($nr_total - ($nr_repartir * $cant_telefonista));

                    foreach ($arr_ticket as $key => $value) {
                        $nr_contador            =   $nr_contador + 1;
                        $arr_solicitud[$key]    =   $value->id;

                        if($nr_contador == $nr_repartir && ($nr_index < count($arr_cargatrabajo)))
                        {
                            $nr_telefonista     =   $arr_cargatrabajo[$nr_index]['id_telefonista'];
                            $info_data          =   [
                                                        'nr_telefonista'    =>  $nr_telefonista,
                                                        'count'             =>  count($arr_solicitud),
                                                        'last_key'          =>  $key,
                                                        'nr_contador'       =>  $nr_contador,
                                                        'nr_cantidad'       =>  $nr_cantidad,
                                                        'arr_ticket'        =>  $arr_solicitud
                                                    ];
                            $arr_distribucion[$nr_index]   =  $info_data;
                            $nr_cantidad        =   $nr_cantidad + $nr_contador;
                            $nr_last            =   $key;

                            Solicitud::whereIn('id',$arr_solicitud)
                            ->update([
                                'id_telefonista'        =>  $nr_telefonista,
                                'id_estado_encuesta'    =>  $nr_estado
                            ]);

                            $arr_solicitud      =   [];
                            $nr_contador        =   0;
                            $nr_index           =   ($nr_index < count($arr_cargatrabajo)) ? ($nr_index + 1) : $nr_index;
                        }
                        if((($nr_total - $nr_cantidad) === $nr_resto) && ($key > $nr_last))
                        {
                            $nr_telefonista     =   $arr_cargatrabajo[($nr_index - 1)]['id_telefonista'];
                            $info_data          =   [
                                                        'nr_telefonista'    =>  $nr_telefonista,
                                                        'count'             =>  count($arr_solicitud),
                                                        'last_key'          =>  $key,
                                                        'arr_ticket'        =>  $arr_solicitud
                                                    ];
                            $arr_distribucion[$nr_index]   =  $info_data;

                            
                            Solicitud::whereIn('id',$arr_solicitud)
                            ->update([
                                'id_telefonista'        =>  $nr_telefonista,
                                'id_estado_encuesta'    =>  $nr_estado
                            ]);
                        }
                    }                    
                }

                break;
            }
            case 3: // Asignar Cantidad de Ticket
            {
                $arr_ticket     =   self::getSolicitudTelefonistas(0);

                if($arr_ticket->count())
                {
                    $nr_estado      =   1; // Pendiente
                    $arr_solicitud  =   $arr_ticket->take($nr_distribucion);
                    $arr_ids        =   $arr_solicitud->pluck('id')->toArray();

                    Solicitud::whereIn('id',$arr_ids)
                    ->update([
                        'id_telefonista'        =>  $nr_telefonista
                    ]);
                }

                break;
            }
        }

        return $arr_validar;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function verificarContactoVecino($nr_rut_vecino)
    {
        $nr_valida      =   0;
        $data_vecino    =   Vecino::where('nr_rut','=',$nr_rut_vecino)->get();

        if($data_vecino->count())
        {
            $info_vecino    =   $data_vecino->first();

            $data_llamado   =   EncuestaLlamada::
                                where('nr_rut','=',$info_vecino->nr_rut)
                                ->where('nr_telefono','!=',$info_vecino->nr_telefono)
                                ->orderBy('created_at','DESC')
                                ->get()->take(1);

            if($data_llamado->count())
                $nr_valida  =   1;
        }

        return $nr_valida;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function cantidadContactosRealizados($nr_rut_vecino)
    {
        $nr_valida      =   0;
        $data_vecino    =   Vecino::where('nr_rut','=',$nr_rut_vecino)->get();

        if($data_vecino->count())
        {
            $info_vecino    =   $data_vecino->first();

            $data_llamado   =   EncuestaLlamada::
                                where('nr_rut','=',$info_vecino->nr_rut)
                                ->whereNotIn('id_estado',[1,2,6,7])
                                ->whereRaw('created_at >= date_sub(now(), interval 30 day)')
                                ->get();

            if($data_llamado->count())
                $nr_valida  =   $data_llamado->count();
        }

        return $nr_valida;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function cantidadLlamadosRealizados($nr_rut_vecino)
    {
        $nr_valida      =   0;
        $data_vecino    =   Vecino::where('nr_rut','=',$nr_rut_vecino)->get();

        if($data_vecino->count())
        {
            $info_vecino    =   $data_vecino->first();

            $data_llamado   =   EncuestaLlamada::
                                where('nr_rut','=',$info_vecino->nr_rut)
                                ->where('nr_telefono','=',$info_vecino->nr_telefono)
                                ->whereRaw('created_at >= date_sub(now(), interval 30 day)')
                                ->get();

            if($data_llamado->count())
                $nr_valida  =   $data_llamado->count();
        }

        return $nr_valida;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function isTicketTieneObservacionEncuesta($nr_ticket)
    {
        $nr_valida  =   0;

        $data   =   EncuestaLlamada::
                    where('id_solicitud','=',$nr_ticket)
                    ->where('str_observacion','!=','')
                    ->whereNotNull('str_observacion')
                    ->where('tp_activo','=','1')
                    ->get();

        if($data->count())
            $nr_valida  =   1;

        return $nr_valida;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getCantidadTelefonistas()
    {
        $nr_cant    =   0;
        $data       =   EncuestaTelefonista::get();

        if($data->count())
            $nr_cant    =   $data->count();

        return $nr_cant;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getlLlamadosRealizadosTelefonistas($nr_telefonista, $tp_opcion = 0, $obj_atributos)
    {
        $nr_cantidad    =   0;
        /*
            //-----------------------
                Valor de Opcion
                0.-     Global
                1.-     Anual
                2.-     Mensual
                3.-     dia
            //-----------------------
                Valor Atributos
                nr_anio     =>  0,
                nr_mes      =>  0,
                nr_dia      =>  0,
            //-----------------------
        */

        $data   =   EncuestaLlamada::
                    where('id_autor','=',$nr_telefonista)
                    ->whereNotIn('id_estado',[1,2,6,7])
                    ->where('tp_activo','=','1');

        switch($tp_opcion)
        {
            case 1: // Consulta de llamados realizados en el año
            {
                $nr_anio    =   (isset($obj_atributos->nr_anio)) ? $obj_atributos->nr_anio : Date('Y');
                $data       =   $data->whereRaw('year(created_at) = '.$nr_anio);

                break;
            }
            case 2: // consulta de llamados realizados en el mes
            {
                $nr_anio    =   (isset($obj_atributos->nr_anio)) ? $obj_atributos->nr_anio : Date('Y');
                $nr_mes     =   (isset($obj_atributos->nr_mes)) ? $obj_atributos->nr_mes : Date('m');
                $data       =   $data->whereRaw('year(created_at) = '.$nr_anio)
                                    ->whereRaw('month(created_at) = '.$nr_mes);

                break;
            }
            case 3: // consulta de llamados realizados en el dia
            {
                $nr_anio    =   (isset($obj_atributos->nr_anio)) ? $obj_atributos->nr_anio : Date('Y');
                $nr_mes     =   (isset($obj_atributos->nr_mes)) ? $obj_atributos->nr_mes : Date('m');
                $nr_dia     =   (isset($obj_atributos->nr_dia)) ? $obj_atributos->nr_dia : Date('d');

                $data       =   $data->whereRaw('year(created_at) = '.$nr_anio)
                                    ->whereRaw('month(created_at) = '.$nr_mes)
                                    ->whereRaw('day(created_at) = '.$nr_dia);

                break;
            }
        }

        $data   =   $data->get();

        if($data->count())
            $nr_cantidad    =   $data->count();

        return $nr_cantidad;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function getCantidadEncuestasRealizadas($tp_opcion = 0, $nr_telefonista = 0, $obj_atributos)
    {
        $nr_cantidad    =   0;

        $data   =   Solicitud::
                    select('id',
                        'nr_anio',
                        'nr_mes',
                        'nr_dia',
                        'fc_creacion',
                        'nr_ticket',
                        'id_tipo',
                        'id_estado',
                        'id_estado_encuesta',
                        'id_telefonista',
                        'tp_activo')
                    ->where('tp_activo','=','1')
                    ->whereIn('id_estado',[5,6]);
        /* --------------- Filtro de Fecha --------------- */
        //    if($obj_atributos->nr_anio)
        //        $data   =   $data->whereRaw('year(fc_creacion) = '.$obj_atributos->nr_anio);
        //    if($obj_atributos->nr_mes)
        //        $data   =   $data->whereRaw('month(fc_creacion) = '.$obj_atributos->nr_mes);
        //    if($obj_atributos->nr_dia)
        //        $data   =   $data->whereRaw('day(fc_creacion) = '.$obj_atributos->nr_dia);
        /* --------------- Filtro Tipo Encuesta --------------- */
            switch($tp_opcion)
            {
                case 1: { //    Encuestas Pendientes
                    $data   =   $data->whereIn('id_estado_encuesta',[1])
                                ->where('id_telefonista','=',$nr_telefonista);

                    break;
                }
                case 2: { //    Encuestas Parciales 
                    $data   =   $data->whereIn('id_estado_encuesta',[2])
                                ->where('id_telefonista','=',$nr_telefonista);

                    break;
                }
                case 3: { //    Encuestas Reagendadas
                    $data   =   $data->whereIn('id_estado_encuesta',[3])
                                ->where('id_telefonista','=',$nr_telefonista);

                    break;
                }
                case 4: { //    Encuestas Rechazadas
                    $data   =   $data->whereIn('id_estado_encuesta',[4])
                                ->where('id_telefonista','=',$nr_telefonista);

                    break;
                }
                case 5: { //    Encuestas Finalizadas 
                    $data   =   $data->whereIn('id_estado_encuesta',[5])
                                ->where('id_telefonista','=',$nr_telefonista);

                    break;
                }
                case 6: { //    Vecino No Contactado
                    $data   =   $data->whereIn('id_estado_encuesta',[6])
                                ->where('id_telefonista','=',$nr_telefonista);

                    break;
                }
                case 7: { //    No Aplica
                    $data   =   $data->whereIn('id_estado_encuesta',[7])
                                ->where('id_telefonista','=',$nr_telefonista);

                    break;
                }
                case 20: { //   Cantidad de Ticket Atendidos
                    $data   =   $data->whereIn('id_estado_encuesta',[2,3,4,6])
                                ->where('id_telefonista','=',$nr_telefonista);

                    break;
                }
                case 21: { //   Cantidad Total de Ticket
                    $data   =   $data->where('id_estado_encuesta','!=','7')
                                ->where('id_telefonista','=',$nr_telefonista);

                    break;
                }

            }
        /*------------------------------------------------------*/
        if($data->count())
            $nr_cantidad    =   $data->count();

        return $nr_cantidad;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function generarUniqueTokenToTicketReport()
    {
        $str_token  =   Str::random(60);

        $existe     =   Solicitud::where('token_report',$str_token)->exists();

        if ($existe) {
            return generateUniqueToken();
        }

        return $str_token;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function generarToken()
    {
        set_time_limit(0);
        ini_set('memory_limit','-1');

        Solicitud::where('nr_anio',2024)
        ->whereNull('token_report')->each(function ($ticket) {
            $ticket->token_report               =   self::generarUniqueTokenToTicketReport();
            $ticket->token_report_expires_at    =   Carbon::parse($ticket->fc_creacion)->addHours(24);
            $ticket->save();
        });
    }
    //---------------------------------------------------------------------------------------------------------
    public function testSms(Request $request)
    {
        $datos  =   [
            'request'   =>  $request->all(),
        ];

        \Log::debug(__METHOD__ . " Test SMS : " . print_r($datos, true));
    }
    //---------------------------------------------------------------------------------------------------------
    public function testMail()
    {
        $nr_solicitud   =   2330;
        $nr_notificar   =   101;

        // EmailController::enviarNotificaciones($nr_notificar, $nr_solicitud);
        // EmailController::enviarNotificacionVecino($nr_notificar, $nr_solicitud);
        EmailController::testNotificaciones();
    }
    //---------------------------------------------------------------------------------------------------------
    public function testFechas()
    {
        $fc_laravel     =   date('Y-m-d H:i:s');
        $fc_db          =   DB::select('select now() as fecha;');

        return ['fc_laravel' => $fc_laravel, 'fc_db' => $fc_db];
    }
    //---------------------------------------------------------------------------------------------------------
    public function testCiclo()
    {
        $arr_1  =   [1,2,3,4,5,6,7,8,9,10];
        $arr_2  =   [1,2];
        $nr_t   =   count($arr_1);
        $temp   =   [];
        foreach ($arr_2 as $key => $value) {
            $temp   =   array_merge($temp, ['key' => $key, 'value' => $value]);
            foreach ($arr_1 as $key_1 => $value_1) {
                $temp   =   array_merge($temp, ['key_1' => $key_1, 'value_1' => $value_1]);
                if($key_1 == $nr_t)
                    breeak;
            }
        }
        return $temp;
    }
    //---------------------------------------------------------------------------------------------------------
    public static function isJson($string) {
        json_decode($string);
        return (json_last_error() == JSON_ERROR_NONE);
    }
    //---------------------------------------------------------------------------------------------------------
}
