<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBaseConocimiento extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('base_conocimiento', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->text('pregunta')->nullable();
            $table->text('respuesta')->nullable();
            $table->tinyInteger('validacion_creador')->default(0);
            $table->tinyInteger('validacion_redaccion')->default(0);
            $table->tinyInteger('tp_activo')->default(1);
            $table->tinyInteger('tp_obsoleto')->default(0);
            $table->integer('id_direccion')->nullable();
            $table->integer('id_depto')->nullable();
            $table->dateTime('fc_validacion_creador')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('base_conocimiento');
    }
}
