@extends('Template.adminlte')

@section('main-title')
    {{ 'Dashboard' }}
@endsection

@section('main-navigation')
    <li class="">Administración</li>
    <li class="">Inicio</li>
@endsection

@push('styles')
    <style>
        .chart-container {
            height: 600px;
        }

        @media screen and (min-width: 1200px) {
            .chart-container {
              height: 800px;
            }
        }

        .mt-5 {
            margin-top: 2rem;
        }
    </style>
@endpush()

@section('main-content')
    <div class="box" id="app">
        <div class="box-body">
            <div class="x_title">
                <div class="col-md-12 col-sm-12">
                    <span style="float:right;">
                        <button class="btn btn-primary" @click="cargarDatos();">
                            <i class="fas fa-sync"></i> Actualizar
                        </button>
                    </span>
                </div>
            </div>

            <div class="x_content">
                <div class="col-md-12 col-sm-12 mt-3">

                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        var app = new Vue({
            el: '#app',
            data: {
                //-------------------------------------
                modal_principal             :   0,
                modal_mensaje               :   0,
                accion_principal            :   0,
                accion_mensaje              :   0,
                boton_principal             :   0,
                boton_mensaje               :   0,
                titulo_principal            :   '',
                titulo_mensaje              :   '',
                //-------------------------------------
                pagination                  : {
                    'total' : 0,
                    'current_page' : 0,
                    'per_page' : 0,
                    'last_page' : 0,
                    'from' : 0,
                    'to' : 0,
                },
                //-------------------------------------
                offset                      :   3,
                //-------------------------------------
                arr_index                   :   [],
                //-------------------------------------
                //-------------------------------------
            },

            components: {
                //-------------------------------------------------------------------------------------------
                //-------------------------------------------------------------------------------------------
            },

            computed:{
                //-------------------------------------------------------------------------------------------
                isActivedPagination: function()
                {
                    return this.pagination.current_page;
                },
                //-------------------------------------------------------------------------------------------
                pagesNumber: function()
                {
                    if(!this.pagination.to) {
                        return [];
                    }

                    var from = this.pagination.current_page - this.offset;
                    if(from < 1) {
                        from = 1;
                    }

                    var to = from + (this.offset * 2);
                    if(to >= this.pagination.last_page){
                        to = this.pagination.last_page;
                    }

                    var pagesArray = [];
                    while(from <= to) {
                        pagesArray.push(from);
                        from++;
                    }
                    return pagesArray;
                },
                //-------------------------------------------------------------------------------------------
            },

            methods: {
                //-------------------------------------------------------------------------------------------

                //-------------------------------------------------------------------------------------------
            },

            mounted() {
              let me = this;
            }
        });
    </script>
@endsection()


