<?php $__env->startSection('body'); ?>
<div class="page-content">
    <div class="container-fluid" id="app">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18">Estadisticas Encuestadores</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Estadisticas</a></li>
                            <li class="breadcrumb-item active">Encuestadores</li>
                        </ol>
                    </div>
                </div>

                <!-- Filtros Especificos -->
                <div class="row mb-3 not-print">
                    <div class="col-lg-3 col-md-6 col-sm-6" style="text-align:left;">
                        <!-- No se realizaran filtros por estado -->
                    </div>
                    <div class="col-lg-3 col-md-6 col-sm-6" style="text-align: left;">
                        <!-- No se realizaran filtros por rango de fechas -->
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-6" style="text-align:right;">
                        <!-- No se realizaran filtros por orden de campos -->
                    </div>
                    <div class="col-lg-2 col-md-6 col-sm-6" style="text-align:right">
                        <button id="btn_actualizar" class="btn btn-primary btn_activo" @click="refrescarDatos();">
                            <i class="fas fa-sync"></i> Actualizar
                        </button>
                    </div>                        
                </div>

                <!-- Llamadas Realizadas -->
                <div class="col-md-12 col-sm-12">
                    <div class="row">
                        <div class="col-md-12 col-sm-12">
                            <div class="card">
                                <div class="card-header bg-primary m-0 p-1">
                                    <div class="text-center text-white font-weight-bold font-size-18">
                                        Llamadas Realizadas
                                    </div>
                                </div>
                                <div class="card-body m-0 p-2">
                                    <div class="row">
                                        <div class="col-lg-3 col-md-3 col-sm-1"></div>
                                        <div class="col-lg-6 col-md-6 col-sm-10">
                                            <div class="form-group">
                                                <div class="col-md-12 text-center font-size-14">
                                                    <label class="form-control-label font-size-14" for="text-input">
                                                        Fecha Consultada
                                                    </label>
                                                </div>
                                                <div class="col-md-12 text-center">
                                                    <div class="input-group">
                                                        <input type="text" class="form-control text-center font-size-14" v-model="nr_dia" placeholder="Dia" onkeypress="return justNumbers(event);"/>
                                                        <input type="text" class="form-control text-center font-size-14" v-model="nr_mes" placeholder="Mes" onkeypress="return justNumbers(event);"/>
                                                        <input type="text" class="form-control text-center font-size-14" v-model="nr_anio" placeholder="Año" onkeypress="return justNumbers(event);"/>
                                                        <button class="btn btn-sm btn-success pl-2 pr-2" title="Buscar" @click="cargarDatos(pagination.current_page)">Buscar</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-3 col-md-3 col-sm-1"></div>

                                        <!-- Estadisticas de Llamados Realizados -->
                                        <div class="col-md-12 col-sm-12 mt-4">
                                            <div class="row">
                                                <!-- Tabla de Datos -->
                                                <div class="responsive-table">
                                                    <table  class="table table-bordered border-info table-striped table-sm table-hover bl-1">
                                                        <thead class="bg-primary">
                                                            <th colspan="12" >
                                                                <h6 class="text-center font-size-16 mt-2" style="color:white" >
                                                                    Listado de Llamados realizados por Telefonistas
                                                                </h6>
                                                            </th>
                                                        </thead>
                                                        <thead class="bg-primary"  style="color:white">
                                                            <th class="text-center"> # </th>
                                                            <th class="text-center">Nombre</th>
                                                            <th class="text-center">Ap. Paterno</th>
                                                            <th class="text-center">Ap. Materno</th>
                                                            <th class="text-center" style="max-width: 80px;">Llamados x Dia</th>
                                                            <th class="text-center" style="max-width: 80px;">Llamados x Mes</th>
                                                            <th class="text-center" style="max-width: 80px;">Llamados x Año</th>
                                                            <th class="text-center">Estado</th>
                                                        </thead>
                                                        <tbody>
                                                            <template v-if="arr_index.length">
                                                                <tr class="font-size-16" v-for="(datos, index) in arr_index" :key="datos.id">
                                                                    <td style="text-align:center;">
                                                                        {{ (index + 1) }}
                                                                    </td>
                                                                    <td style="text-align:center;">
                                                                        {{ datos.nombre }}
                                                                    </td>
                                                                    <td  style="text-align:left; color: black;">
                                                                        {{ datos.ap_paterno }}
                                                                    </td>
                                                                    <td style="text-align:left;">
                                                                        {{ datos.ap_materno }}
                                                                    </td>
                                                                    <td style="text-align:center;">
                                                                        {{ datos.llamados_realizados_dia }}
                                                                    </td>
                                                                    <td style="text-align:center;">
                                                                        {{ datos.llamados_realizados_mes }}
                                                                    </td>
                                                                    <td style="text-align:center;">
                                                                        {{ datos.llamados_realizados_anio }}
                                                                    </td>
                                                                    <td style="text-align:center;">
                                                                        {{ datos.nm_estado }}
                                                                    </td>
                                                                </tr>
                                                            </template>
                                                            <template v-else>
                                                                <tr>
                                                                    <td colspan="12">
                                                                        <h5 class="text-center">
                                                                            No hay datos para listar
                                                                        </h5>
                                                                    </td>
                                                                </tr>
                                                            </template>
                                                        </tbody>
                                                    </table>
                                                </div>

                                                <!-- Paginacion -->
                                                <div class="col-md-12 col-sm-12">
                                                    <nav>
                                                        <ul class="pagination">
                                                            <li class="page-item" v-if="pagination.current_page > 1">
                                                                <a class="page-link" href="#" @click.prevent="cambiarPagina(1)">Primera</a>
                                                            </li>
                                                            <li class="page-item" v-if="pagination.current_page > 1">
                                                                <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.current_page - 1)">Ant</a>
                                                            </li>
                                                            <li class="page-item" v-for="page in pagesNumber" :key="page" :class="[page == isActivedPagination ? 'active' : '']">
                                                                <a class="page-link" href="#" @click.prevent="cambiarPagina(page, 1)" v-text="page"></a>
                                                            </li>
                                                            <li class="page-item" v-if="pagination.current_page < pagination.last_page">
                                                                <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.current_page + 1)">Sig</a>
                                                            </li>
                                                            <li class="page-item" v-if="pagination.current_page < pagination.last_page">
                                                                <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.last_page)">Ultima</a>
                                                            </li>
                                                        </ul>
                                                    </nav>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal" tabindex="-1" id="modal_estadistica">
            <div class="modal-dialog modal-dialog-scrollable modal-xl">
                <div class="modal-content">
                  <div class="modal-header bg-primary">
                    <h5 class="modal-title text-white" id="title_modal">{{ titulo_modal }}</h5>
                    <button type="button" class="btn-close" @click="cerrarModal('encuesta')" aria-label="Close"></button>
                  </div>
                  <div class="modal-body">
                        <div class="col-md-12 col-sm-12">
                            
                        </div>
                  </div>
                  <div class="modal-footer">
                    <div class="col-md-12 col-sm-12">
                        <button type="button" class="btn btn-md btn-secondary col-lg-2 col-md-3 col-sm-4" style="float: left;" @click="imprimir()">Imprimir</button>
                        <button type="button" class="btn btn-md btn-secondary col-lg-2 col-md-3 col-sm-4" style="float: right;" @click="cerrarModal('encuesta')">Cerrar</button>
                    </div>
                  </div>
                </div>
            </div>
        </div>
    </div>
</div>

    <style type="text/css">
        .bg-color-skyblue {
            background: skyblue;
        }

        .bg-color-khaki {
            background: khaki;
        }

        .bg-color-darkseagreen {
            background: darkseagreen;
        }

        .bg-color-indianred {
            background: indianred;
        }
    </style>

    <script type="text/javascript">
        Vue.component('vue-multiselect', window.VueMultiselect.default);

        var app = new Vue({
            el: '#app',
            data: {
                //-------------------------------------
                tp_modal                    :   0,
                tp_accion                   :   0,
                tp_btn                      :   0,
                titulo_modal                :   '',
                btn_envio                   :   0,
                btn_parcial                 :   0,
                btn_encuesta_next           :   0,
                btn_encuesta_back           :   0,
                btn_encuesta_save           :   0,
                //-------------------------------------
                arr_valida                  :   [],
                arr_error                   :   [],
                arr_form                    :   {},
                str_msj                     :   '',
                //-------------------------------------
                pagination                  : {
                    'total' : 0,
                    'current_page' : 0,
                    'per_page' : 0,
                    'last_page' : 0,
                    'from' : 0,
                    'to' : 0,
                },
                //-------------------------------------
                offset                      :   3,
                //-------------------------------------
                fl_mostrar                  :   0,
                fl_direccion                :   [],
                fl_depto                    :   [],
                fl_servicio                 :   [],
                fl_macrozona                :   [],
                fl_unidadvecinal            :   [],
                fl_ticket                   :   [],
                fl_persona                  :   [],
                fl_motivo                   :   [],
                fl_ubicacion                :   [],
                //-------------------------------------
                nr_anio                     :   0,
                nr_mes                      :   0,
                nr_dia                      :   0,
                //-------------------------------------
                arr_mostrar                 :   [
                    {
                        'value'     :   0,
                        'label'     :   'Todos',
                    },
                    {
                        'value'     :   1,
                        'label'     :   'Pendiente',
                    },
                    {
                        'value'     :   2,
                        'label'     :   'Parcial',
                    },
                    {
                        'value'     :   3,
                        'label'     :   'Reagendar',
                    },
                    {
                        'value'     :   6,
                        'label'     :   'No Contactado',
                    },
                ],
                //-------------------------------------
                tp_criterio                 :   'created_at',
                tp_orden                    :   'ASC',
                //-------------------------------------
                arr_solicitud               :   [],
                arr_historial               :   [],
                arr_respuestas              :   [],
                arr_usuario                 :   [],
                arr_archivo                 :   [],
                //-------------------------------------
                arr_index                   :   [],
                arr_encuestas               :   [],
                //-------------------------------------
            },

            components: {
                Multiselect: window.VueMultiselect.default
            },

            filters:{
                resumir: function (texto, limite=300, final=' ...')
                {
                    let me  = this;
                    var largo = texto.toString().length;
                    if(largo > limite){
                        for (var i = 0; i < largo; i++) {
                            if(texto[i] == ' ' && i >= limite) {
                                texto   =   texto.substring(0,i);
                                texto   =   texto + final;
                                return texto;
                            }
                        }                    
                    }
                    return texto;
                },

                capitalize: function (str_texto) 
                {
                    if (!str_texto) return '';

                    str_texto    = str_texto.toString();
                    var splitStr = str_texto.toLowerCase().split(' ');

                    for (var i = 0; i < splitStr.length; i++) {
                        splitStr[i] = splitStr[i].charAt(0).toUpperCase() + splitStr[i].substring(1);
                    }

                    return splitStr.join(' ');
                },

                formatDate: function (fecha)
                {
                    if(fecha)
                        return moment(String(fecha)).format('DD-MM-YYYY')
                },

                formatDateTime: function (fecha)
                {
                    if(fecha)
                    {
                        return moment(String(fecha)).format('DD-MM-YYYY HH:mm')
                    }
                },
            },

            computed:{
                //-------------------------------------------------------------------------------------------
                isActivedPagination: function()
                {
                    return this.pagination.current_page;
                },
                //-------------------------------------------------------------------------------------------
                pagesNumber: function()
                {
                    if(!this.pagination.to) {
                        return [];
                    }

                    var from = this.pagination.current_page - this.offset;
                    if(from < 1) {
                        from = 1;
                    }

                    var to = from + (this.offset * 2);
                    if(to >= this.pagination.last_page){
                        to = this.pagination.last_page;
                    }

                    var pagesArray = [];
                    while(from <= to) {
                        pagesArray.push(from);
                        from++;
                    }
                    return pagesArray;
                },
                //-------------------------------------------------------------------------------------------
            },

            methods: {
                //-------------------------------------------------------------------------------------------
                isActiveTinyMCE()
                {
                    let me      =   this;
                    var valida  =   0;

                    try{
                        if(tinyMCE.activeEditor != null)
                            valida   =   1;
                    }catch(error) {
                        valida  =   0;
                    }   

                    return valida;
                },
                //-------------------------------------------------------------------------------------------
                imprimir(str_modal = "modal_estadistica")
                {
                    $("#"+str_modal).printThis({
                        debug: false,               // show the iframe for debugging
                        importCSS: true,            // import parent page css
                        importStyle: true,          // import style tags
                        printContainer: false,      // print outer container/$.selector
                        loadCSS: "",                // path to additional css file - use an array [] for multiple
                        pageTitle: "",              // add title to print page
                        removeInline: true,        // remove inline styles from print elements
                        removeInlineSelector: "*",  // custom selectors to filter inline styles. removeInline must be true
                        printDelay: 333,            // variable print delay
                        header: null,               // prefix to html
                        footer: null,               // postfix to html
                        base: 'https://atencionvecino.sanmiguel.cl/',                // preserve the BASE tag or accept a string for the URL
                        formValues: true,           // preserve input/form values
                        canvas: false,              // copy canvas content
                        // doctypeString: '...',       // enter a different doctype for older markup
                        removeScripts: true,        // remove script tags from print content
                        copyTagClasses: false,      // copy classes from the html & body tag
                        beforePrintEvent: null,     // function for printEvent in iframe
                        beforePrint: null,          // function called before iframe is filled
                        afterPrint: null,           // function called before iframe is removed
                    });
                },
                //-------------------------------------------------------------------------------------------
                getCantidadCaracteres(str_contenido = '')
                {
                    var cantidad    =   0;

                    if(!str_contenido)
                        return cantidad;

                    if(str_contenido.trim().length)
                        cantidad    =   str_contenido.trim().length;

                    return cantidad;
                },
                //-------------------------------------------------------------------------------------------
                cambiarPagina(page)
                {
                    let me  =   this;
                    me.pagination.current_page = page;
                    me.cargarDatos(page);
                },
                //-------------------------------------------------------------------------------------------
                refrescarDatos()
                {
                    let me  =   this;
                    me.cargarUsuario();
                    me.cargarDatos(me.pagination.current_page);
                },
                //-------------------------------------------------------------------------------------------
                getLabel(data)
                {
                    var valor   =   '';

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.label;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                getValue(data)
                {
                    var valor   =   0;

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.value;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                strCapitalize(str_texto)
                {
                    if (!str_texto) return '';

                    str_texto    = str_texto.toString();
                    var splitStr = str_texto.toLowerCase().split(' ');

                    for (var i = 0; i < splitStr.length; i++) {
                        splitStr[i] = splitStr[i].charAt(0).toUpperCase() + splitStr[i].substring(1);
                    }

                    return splitStr.join(' ');
                },
                //-------------------------------------------------------------------------------------------
                inArray(needle, haystack) 
                {
                    var length = haystack.length;
                    for(var i = 0; i < length; i++) {
                        if(haystack[i] == needle) return true;
                    }
                    return false;
                },
                //-------------------------------------------------------------------------------------------
                cargarDia()
                {
                    let me  =   this;
                    let fc_format   =   'DD-MM-YYYY';
                    let fc_date     =   moment().locale('es').format(fc_format);
                    let nr_dia      =   '';
                    let nr_mes      =   '';
                    let nr_anio     =   '';
                    //-----------------------------------
                    nr_anio     =   moment().format('YYYY');
                    nr_mes      =   moment().format('M');
                    nr_dia      =   moment().format('D');
                    //-----------------------------------
                    me.nr_dia   =   nr_dia;
                    me.nr_mes   =   nr_mes;
                    me.nr_anio  =   nr_anio;
                    //-----------------------------------
                },
                //-------------------------------------------------------------------------------------------
                cerrarModal(modelo)
                {
                    let me  =   this;

                    switch(modelo)
                    {
                        
                    }
                },
                //-------------------------------------------------------------------------------------------
                cargarUsuario()
                {
                    let me      =   this;
                    var ruta    =   '/info/usuario';
                    me.arr_usuario  =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta     =   response.data;
                        me.arr_usuario    =   respuesta;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarDatos(page = 1)
                {
                    let me          =   this;
                    var ruta        =   '/estadistica/encuestador';

                    axios.post(ruta,{
                        'page'              :   page,
                        'nr_dia'            :   me.nr_dia,
                        'nr_mes'            :   me.nr_mes,
                        'nr_anio'           :   me.nr_anio,
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_index        =   respuesta.info.data;
                        me.pagination       =   respuesta.pagination;
                        me.rows             =   respuesta.info.data;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                filtrarDatos()
                {
                    let me  =   this;
                    me.cargarDatos();
                },
                //-------------------------------------------------------------------------------------------
                limpiarFiltros()
                {
                    let me  =   this;

                    

                    me.cargarDatos();
                },
                //-------------------------------------------------------------------------------------------
                limpiarDatos(modelo)
                {
                    let me  =   this;

                    switch(modelo)
                    {
                        
                    }
                },
                //-------------------------------------------------------------------------------------------
                ensamblarDatos(accion)
                {
                    let me          =   this;
                    var ruta        =   '';
                    var titulo      =   '';
                    var tiempo      =   3000;
                    var error       =   0;
                    var formData    =   new FormData();
                    var fc_format   =   'YYYY-MM-DD HH:mm:ss'; // 'DD-MM-YYYY HH:mm:ss';
                    //----------------------------------------------------------------
                    switch(accion)
                    {
                        case 'solicitud':
                        {
                            titulo  =   'Registrar Solicitud';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                // ruta    =   '/';                            
                                // me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                //formData.append('nm_direccion', me.getLabel(me.nr_direccion));
                                //------------------------------------
                                // me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                    }
                    //----------------------------------------------------------------
                },
                //-------------------------------------------------------------------------------------------
                validarDatos(tp_validacion)
                {
                    let me          =   this;
                    var error       =   0;
                    me.arr_valida   =   [];    
                    me.arr_form     =   {}; 
                    me.str_msj      =   '';

                    switch(tp_validacion)
                    {
                        case 'solicitud':
                        {
                            

                            break;
                        }
                    }

                    if(Object.keys(me.arr_form).length != 0)
                        error   =   1;

                    return error;
                },
                //-------------------------------------------------------------------------------------------
                registrarDatos(ruta, formData)
                {
                    let me              =       this;
                    var tp_icon         =       '';
                    var titulo          =       '';
                    var mensaje         =       '';
                    var error           =       '';

                    axios.post(ruta, formData, {
                        headers: {'Content-Type': 'multipart/form-data'}
                    }).then(function (response) 
                    {
                        var result  =   response.data;                       
                        tp_icon     =   result.tp_icon;
                        titulo      =   result.title;
                        mensaje     =   result.msj;
                        error       =   result.error;

                        me.desplegarVentana(tp_icon, titulo, mensaje);

                        //Limpiar Modelos
                        if(error == 0)
                        {
                            me.limpiarDatos('encuesta');
                            me.refrescarDatos();
                            $('#modal_estadistica').modal('hide');
                            me.cerrarModal('encuesta');
                        }

                        me.btn_envio        =   0;
                        me.btn_parcial      =   0;
                    })
                    .catch(function (error) 
                    {
                        me.btn_envio        =   0;
                        me.btn_parcial      =   0;

                        if (error.response.status == 422)
                            me.validationErrors = error.response.data.errors;
                        /*// Formato de Archivo Incorrecto
                        if (error.response.status == 413)
                        {
                            //------------------------------
                        }
                        */
                    });
                },
                //-------------------------------------------------------------------------------------------
                abrirModal(modelo, accion, data = [])
                {
                    let me      =   this;                    

                    switch(modelo)
                    {
                        case 'solicitud':
                        {
                            switch(accion)
                            {
                                case 'encuesta':
                                {
                                    me.tp_modal                 =   1;
                                    me.tp_accion                =   1;
                                    me.tp_btn                   =   0;
                                    me.btn_envio                =   0;
                                    me.btn_parcial              =   0;
                                    me.titulo_modal             =   'Encuesta de Servicio';
                                    me.limpiarDatos(accion);
                                    $('#modal_estadistica').modal('show');

                                    break;
                                }
                            }

                            break;
                        }
                        case 'archivo':
                        {
                            switch(accion)
                            {
                                case 'anexar':
                                {
                                    me.tp_modal             =   1;
                                    me.tp_accion            =   1;
                                    me.tp_btn               =   1;
                                    me.btn_envio            =   0;
                                    me.titulo_adjunto       =   'Adjuntar Documentos';
                                    me.tp_adjunto           =   'documento';
                                    me.limpiarDatos(modelo);
                                    $('#modal_adjunto').modal('show');

                                    break;
                                }
                                case 'revisar':
                                {
                                    me.tp_modal             =   1;
                                    me.tp_accion            =   1;
                                    me.tp_btn               =   1;
                                    me.btn_envio            =   0;
                                    me.titulo_adjunto       =   'Revisar Documentos';
                                    me.tp_adjunto           =   'archivos';
                                    me.limpiarDatos(modelo);
                                    me.arr_adjuntos         =   data.archivos;
                                    $('#modal_revisar').modal('show');

                                    break;
                                }
                            }

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                zonaDeEspera(titulo, tiempo)
                {
                    Swal.fire({
                        title : '<h5>'+titulo+'</h5>',
                        html: '<strong> </strong>',
                        showConfirmButton: false,
                        timer: tiempo,
                        onBeforOpen: () => {
                            Swal.showLoading()
                        },
                    }).then((result) => {
                        if(result.dismiss == Swal.DismissReason.timer)
                        {
                            //----------------------------------------
                        }
                    });
                },
                //-------------------------------------------------------------------------------------------
                desplegarVentana(tp_icon, titulo, mensaje, tp_btn = 1)
                {
                    Swal.fire({
                        icon: tp_icon,
                        title: titulo,
                        html: mensaje,
                        backdrop:false,
                        showConfirmButton: tp_btn
                    });                       
                },
                //-------------------------------------------------------------------------------------------
                setStyleCalificacion(str_campo)
                {
                    let me  =   this;

                    $(function() {
                        $('#'+str_campo).barrating('show', {
                            theme: 'fontawesome-stars',
                            showValues: false,
                            onSelect: function(value, text, event) {
                                if (typeof(event) !== 'undefined') {
                                    // rating was selected by a user
                                    console.log(event.target);
                                    console.log(value);
                                    console.log(text);
                                } else {
                                    // rating was selected programmatically
                                    // by calling `set` method
                                }
                            }
                        });
                    });
                },
                //-------------------------------------------------------------------------------------------
            },

            mounted() {
                let me = this;
                me.cargarDia();
                me.cargarUsuario();
                me.cargarDatos();
            }
        });
    </script>

    <script type="text/javascript">
        //-----------------------------------------------------------------
        $(document).ready(function(){
            /*----- Inicio - Filtrar -----*/
            $("#btn_filtrar_datos").click(function () {
                $content = $("#filtrar_datos");
                $content.slideToggle(500, function () {
                    // ---------------------------                    
                });
            });

            $("#close_filtrar_datos").click(function () {
                $content = $("#filtrar_datos");
                $content.slideToggle(500, function () {
                    // ---------------------------                    
                });
            });

            /*----- Inicio - Modal -----*/
            $('#modal_estadistica').modal({backdrop: 'static', keyboard: false});
        });
        //-----------------------------------------------------------------
        function justNumbers(e)
        {
            var keynum = window.event ? window.event.keyCode : e.which;
            if (keynum == 8)
                return true;

            return /\d/.test(String.fromCharCode(keynum));
        }
        //-----------------------------------------------------------------
        function Rut(texto)
        { 
            var tmpstr = "";

            for ( i=0; i < texto.length ; i++ )   
                if ( texto.charAt(i) != ' ' && texto.charAt(i) != '.' && texto.charAt(i) != '-' )
                    tmpstr = tmpstr + texto.charAt(i);

            texto = tmpstr; 
            largo = texto.length; 

            if ( largo < 2 ) 
                return false; 

            for (i=0; i < largo ; i++ )    
                if (texto.charAt(i) !="0" && texto.charAt(i) != "1" && texto.charAt(i) !="2" && texto.charAt(i) != "3" && 
                    texto.charAt(i) != "4" && texto.charAt(i) !="5" && texto.charAt(i) != "6" && texto.charAt(i) != "7" && 
                    texto.charAt(i) !="8" && texto.charAt(i) != "9" && texto.charAt(i) !="k" && texto.charAt(i) != "K")   
                    return false;

            var invertido = "";

            for ( i=(largo-1),j=0; i>=0; i--,j++ )    
                invertido = invertido + texto.charAt(i);

            var dtexto = "";  
            dtexto = dtexto + invertido.charAt(0);  
            dtexto = dtexto + '-';  
            cnt = 0;  

            for ( i=1,j=2; i<largo; i++,j++ ) 
            { 
                if ( cnt == 3 )   
                {     
                    dtexto = dtexto + '.';      
                    j++;      
                    dtexto = dtexto + invertido.charAt(i);      
                    cnt = 1;    
                }   
                else    
                {       
                    dtexto = dtexto + invertido.charAt(i);      
                    cnt++;    
                } 
            } 

            invertido = "";

            for ( i=(dtexto.length-1),j=0; i>=0; i--,j++ )    
                invertido = invertido + dtexto.charAt(i);

            if (revisarDigito2(texto))
                return  invertido.toUpperCase();

            return false;
        }
        //-----------------------------------------------------------------
        function formatoMail(valor)
        {
            if (/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test(valor))
                return true;
            else
                return false;
        }
        //-----------------------------------------------------------------
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('template.home', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\atencion_vecino\resources\views/administrador/estadistica_encuestador_administrador.blade.php ENDPATH**/ ?>