<?php $__env->startSection('body'); ?>
<div class="page-content">
    <div class="container-fluid" id="app">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18">Encuesta del Servicio de Atención al Vecino</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Encuesta Servicios</a></li>
                            <li class="breadcrumb-item active">Agendamientos</li>
                        </ol>
                    </div>
                </div>

                <!-- Filtros Especificos -->
                <div class="row mb-3 not-print">
                    <div class="col-lg-3 col-md-6 col-sm-6" style="text-align:left;">
                        <!-- Filtro por Estado -->
                        <div class="row">
                            <div class="col-md-3">
                                <label class="form-control-label">
                                        Filtro por Estado
                                </label>
                            </div>
                            <div class="col-md-8">
                                <select @change="cargarDatos()"  v-model="fl_mostrar" class="form-control estados">
                                    <option v-for="item in arr_mostrar" :value="item.value" v-text="item.label"></option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 col-sm-6" style="text-align: left;">
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-4">
                                    <label class="form-control-label">
                                        Filtro de Fecha
                                    </label>
                                </div>
                                <div class="col-md-8">
                                    <div class="input-group">
                                        <input type="text" class="form-control flatpickr_fecha" name="fc_buscar" id="fc_buscar" placeholder="Fecha" @change="asyncRefrescarDatos()" />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-6" style="text-align:right;">
                        <!-- Filtrar por Orden -->
                        <div class="row">
                            <div class="col-md-2">
                                <label class="form-control-label">
                                    Ordenar Por
                                </label>
                            </div>
                            <div class="col-md-9">
                                <div class="input-group">
                                <select v-model="tp_criterio" @change="cargarDatos()" class="form-control">
                                    <option value="id">Ticket</option>
                                    <option value="id_macroterritorio">Macrozona</option>
                                    <option value="id_unidadvecinal">Unidad Vecinal</option>
                                    <option value="nm_direccion">Dirección Municipal</option>
                                    <option value="nm_depto">Depto. Municipal</option>
                                    <option value="nm_estado">Estado</option>
                                    <option value="created_at">Fecha Ingreso</option>
                                </select>
                                <select v-model="tp_orden" @change="cargarDatos()" class="form-control">
                                    <option value="ASC">Ascendente</option>
                                    <option value="DESC">Descendente</option>
                                </select>
                            </div>
                            </div>                                
                        </div>                            
                    </div>
                    <div class="col-lg-2 col-md-6 col-sm-6" style="text-align:right">
                        <button id="btn_actualizar" class="btn btn-primary btn_activo" @click="refrescarDatos()">
                            <i class="fas fa-sync"></i> Actualizar
                        </button>

                        <button class="btn btn-primary btn_activo" id="btn_filtrar_datos">
                            <i class="fas fa-search"></i> Filtrar Datos
                        </button>
                    </div>                        
                </div>

                <!-- Resumen de Agendados -->
                <div class="card">
                    <div class="card-header bg-primary">
                        <div class="row col-12">
                            <h5 style="color: white; text-align: center;">Resumen de Agendados</h5> 
                            <button class="col-lg-2 col-md-4 col-sm-6 btn btn-primary" @click="mostrar_resumen = (!mostrar_resumen) ? 1 : 0"
                                style="right: 5px;position: absolute;margin: 0px;padding: 0px;background-color: cornflowerblue;color: white;">
                                    Mostrar Resumen
                            </button>
                        </div>
                    </div>
                    <div class="card-body pt-1" v-if="mostrar_resumen === 1">
                        <div class="row">
                            <div class="col-lg-2 col-md-3 col-md-4">
                                <div class="row" v-if="arr_resumen.length">
                                    <div class="col-12 bg-primary resumen-title pt-2">
                                        <h5 style="color: white;">Lista de Años</h5>
                                    </div>
                                    <div class="col-12 resumen-anio anio-toggle" :class="{'activo':datos.nr_anio == nr_anio_visible}" v-for="(datos, index) in arr_resumen" :key="index" @click="asyncResumenAnio(datos);">
                                        {{ datos.nr_anio }}
                                        <span class="badge rounded-pill bg-info float-end">{{ datos.nr_subtotal }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-10 col-md-9 col-sm-8">
                                <div class="row" v-if="arr_resumen_mes.length">
                                    <div class="col-12 bg-primary resumen-title pt-2">
                                        <h5 style="color: white;">Listado de Meses</h5>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-3 col-md-4 col-sm-6 resumen-mes mes-toggle mr-2" :class="{'activo':datos.nr_mes == nr_mes_visible}" v-for="(datos, index) in arr_resumen_mes" :key="index" @click="asyncResumenMes(datos);">
                                            {{ datos.nm_mes }}
                                            <span class="badge rounded-pill bg-info float-end">{{ datos.nr_subtotal }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="row" v-if="arr_resumen_dias.length">
                                    <div class="col-12 bg-primary resumen-title pt-2">
                                        <h5 style="color: white;">Listado de Dias</h5>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-2 col-md-4 col-sm-6 resumen-dia dia-toggle mr-2" :class="{'activo':datos.nr_dia == nr_dia_visible}" v-for="(datos, index) in arr_resumen_dias" :key="" @click="asyncResumenDia(datos)">
                                            {{ datos.fc_calendario }}
                                            <span class="badge rounded-pill bg-info float-end">{{ datos.nr_cantidad }}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Filtro Generales - Tabla de Datos - Paginacion -->
                <div class="row">
                    <!-- Filtro de Datos -->
                    <div class="col-md-12 col-sm-12">
                        <div class="collapse" id="filtrar_datos">
                            <div class="card">
                                <div class="card-header bg-primary">
                                    <div class="col-md-12 col-sm-12 text-center">
                                        <h5 style="color:white;">Filtro de busqueda</h5>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row ml-2 mr-2">
                                        <div class="col-md-12 col-sm-12"> </div>
                                        <!-- Dirección Municipal -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label class="form-control-label">
                                                    Dirección Municipal :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_direccion"
                                                    :options="arr_direccion" 
                                                    @select="asyncDeptos" 
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Dirección Municipal"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                        <!-- Depto Municipal -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label class="form-control-label">
                                                    Depto Municipal :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_depto"
                                                    :options="arr_depto" 
                                                    @select="asyncServicios" 
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Depto Municipal"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                        <!-- Servicio -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label class="form-control-label">
                                                    Servicio :
                                                </label>
                                                <multiselect
                                                    :show-labels="false" 
                                                    :searchable="true" 
                                                    v-model="fl_servicio" 
                                                    :options="arr_servicio" 
                                                    :multiple="false" 
                                                    :showNoOptions="false" 
                                                    placeholder="Servicio" 
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                        <!-- Macrozona -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label class="form-control-label">
                                                    Macrozona :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_macrozona"
                                                    :options="arr_macrozona"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Unidad Vecinal"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                        <!-- Unidad Vecinal -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label class="form-control-label">
                                                    Unidad Vecinal :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_unidadvecinal"
                                                    :options="arr_unidadvecinal"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Unidad Vecinal"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                        <!-- Ticket -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label class="form-control-label">
                                                    N° Ticket :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_ticket"
                                                    :options="arr_ticket"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="N° Ticket"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                        <!-- Solicitante -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label class="form-control-label">
                                                    Solicitante :
                                                </label>
                                                <multiselect
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_persona"
                                                    :options="arr_persona"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Solicitante"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                        <!-- Motivo -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label class="form-control-label">
                                                    Tipo Requerimiento :
                                                </label>
                                                <multiselect
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_motivo"
                                                    :options="arr_motivo"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Tipo Requerimiento"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                        <!-- Ubicación del Problema -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label class="form-control-label">
                                                    Dirección del Requerimiento :
                                                </label>
                                                <multiselect
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_ubicacion"
                                                    :options="arr_ubicaciones"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Dirección del Requerimiento"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div style="float: right;">
                                        <button @click="limpiarFiltros()" type="button" class="btn btn-warning btn-sm btn_activo" style="color: white;">
                                            <i class="fas fa-undo"></i> Quitar Filtros
                                        </button>&nbsp;
                                        <button @click="filtrarDatos()" type="button" class="btn btn-primary btn-sm btn_activo"><i class="fas fa-search"></i>
                                            Filtrar Búsqueda
                                        </button>

                                        <button class="btn btn-secondary btn-sm btn_activo" id="close_filtrar_datos">
                                            Cerrar Filtro
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Tabla de Datos -->
                    <div class="responsive-table">
                        <table  class="table table-bordered border-info table-striped table-sm table-hover bl-1">
                            <thead class="bg-primary">
                                <th colspan="15" >
                                    <h6 class="text-center" style="color:white" >
                                        Listado de Encuestas de Servicio Agendadas
                                    </h6>
                                </th>
                            </thead>
                            <thead class="bg-primary"  style="color:white">
                                <th class="text-center"> # </th>
                                <th class="text-center" style="min-width:130px;">Ticket</th>
                                <th class="text-center" style="min-width:130px;">Estado</th>
                                <th class="text-center" style="min-width:130px;">Agendado</th>
                                <th class="text-center" style="max-width:110px;">Tipo de Requerimiento</th>
                                <th class="text-center" style="max-width:200px;">Dirección Municipal</th>
                                <th class="text-center" style="max-width:250px;">Servicio</th>
                                <th class="text-center" style="max-width:150px;">Vecino</th>
                                <th class="text-center" style="max-width: 80px;">Contactos Realizados</th>
                                <th class="text-center" style="max-width: 80px;">Nuevo Nro. Contacto</th>
                                <th class="text-center" style="max-width: 80px;">Llamados Realizados</th>
                                <th class="text-center" style="max-width: 80px;">Observación Encuesta</th>
                                <th class="text-center">Tiempo Tramitado</th>
                            </thead>
                            <tbody>
                                <template v-if="arr_index.length">
                                    <tr v-for="(datos, index) in arr_index" :key="datos.id">
                                        <td style="text-align:center;">
                                            {{ (index + 1) }}
                                        </td>
                                        <td style="text-align:center; min-width:130px;">
                                            <a href="#" @click="asyncValidaEncuesta(datos)" class="button btn btn-info">
                                                <i class="fas fa-ticket-alt" style="color: white;"></i><span style="padding-left:5px;">{{ datos.nr_ticket }}</span>
                                            </a>
                                        </td>
                                        <td style="text-align:center; max-width:110px;">
                                            {{ datos.nm_estado_encuesta }}
                                        </td>
                                        <td style="text-align:center; max-width:110px;">
                                            <div v-for="agendado in datos.agendados" :key="agendado.id">
                                                {{ agendado.nm_alternativa | formatDateTime }}
                                            </div>
                                        </td>
                                        <td style="text-align:center; max-width:110px;">
                                            {{ datos.nm_motivo }}
                                        </td>
                                        <td  style="text-align:left; color: black; max-width:200px;">
                                            {{ datos.nm_direccion_destino }}
                                        </td>
                                        <td style="text-align:left; max-width:250px;">
                                            {{ datos.nm_tipo }}
                                        </td>
                                        <td style="text-align:left; max-width:150px;">
                                            {{ datos.vecino.nmc_vecino | capitalize }}
                                        </td>
                                        <td style="text-align:center;">
                                            {{ datos.contactos_realizados }}
                                        </td>
                                        <td style="text-align:center;">
                                            {{ datos.verificar_nro_contacto }}
                                        </td>
                                        <td style="text-align:center;">
                                            {{ datos.llamados_realizados }}
                                        </td>
                                        <td style="text-align:center;">
                                            {{ datos.tiene_obs_encuesta }}
                                        </td>
                                        <td style="text-align:center;">
                                            {{ datos.tiempo_tramitado }}
                                        </td>
                                    </tr>
                                </template>
                                <template v-else>
                                    <tr>
                                        <td colspan="15">
                                            <h5 class="text-center">
                                                No hay datos para listar
                                            </h5>
                                        </td>
                                    </tr>
                                </template>
                            </tbody>
                        </table>
                    </div>

                    <!-- Paginacion -->
                    <div class="col-md-12 col-sm-12">
                        <nav>
                            <ul class="pagination">
                                <li class="page-item" v-if="pagination.current_page > 1">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(1)">Primera</a>
                                </li>
                                <li class="page-item" v-if="pagination.current_page > 1">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.current_page - 1)">Ant</a>
                                </li>
                                <li class="page-item" v-for="page in pagesNumber" :key="page" :class="[page == isActivedPagination ? 'active' : '']">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(page, 1)" v-text="page"></a>
                                </li>
                                <li class="page-item" v-if="pagination.current_page < pagination.last_page">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.current_page + 1)">Sig</a>
                                </li>
                                <li class="page-item" v-if="pagination.current_page < pagination.last_page">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.last_page)">Ultima</a>
                                </li>
                            </ul>
                        </nav>
                    </div>                      
                </div>
            </div>
        </div>

        <div class="modal" tabindex="-1" id="modal_encuesta">
            <div class="modal-dialog modal-dialog-scrollable modal-xl">
                <div class="modal-content">
                  <div class="modal-header bg-primary">
                    <h5 class="modal-title text-white" id="title_modal">{{ titulo_modal }}
                        <template v-if="nr_ticket">{{ ' - Ticket #' + nr_ticket }}</template> 
                    </h5>
                    <button type="button" class="btn-close" @click="cerrarModal('encuesta')" aria-label="Close"></button>
                  </div>
                  <div class="modal-body">
                        <div class="col-md-12 col-sm-12">
                            <div class="row">
                                <div class="col-md-6 col-sm-12">
                                    <!-- Datos de la Solicitud -->
                                    <div class="card">
                                        <div class="card-body">
                                            <h5 class="font-weight-bold" style="font-style: unset;">Información del encuestado</h5>
                                            <div class="text-muted mt-1">
                                                <template class="mt-1">
                                                    <ul style="list-style-type: disc;">
                                                        <li><strong>Nombre del Vecino : </strong>
                                                            <template v-if="arr_solicitud.vecino">
                                                                {{ arr_solicitud.vecino.nmc_vecino }}
                                                            </template>
                                                            <template v-else>
                                                                <span class="text-danger">Vecino no encontrado</span>
                                                            </template>
                                                        </li>
                                                        <li><strong>Tipo de Solicitud : </strong>{{ arr_solicitud.nm_motivo }}</li>
                                                        <li><strong>Tipo de Servicio : </strong>{{ arr_solicitud.nm_tipo }}</li>
                                                        <li><strong>Unidad Municipal : </strong>{{ arr_solicitud.nm_direccion_destino }}</li>
                                                        <li><strong>Fecha Ingreso : </strong>{{ arr_solicitud.fc_ingreso | formatDateTime }}</li>
                                                        <li><strong>Fecha Cierre : </strong>{{ arr_solicitud.fc_publicado | formatDateTime }}</li>
                                                        <li><strong>Tiempo Medio de Operación : </strong>{{ arr_solicitud.tiempo_tramitado }}</li>
                                                        <li><strong>Ubicación del Requerimiento : </strong>{{ arr_solicitud.nm_ubicacion }}</li>
                                                        <li><strong>Descripción del Requerimiento : </strong>
                                                            <div class="col-md-12 mb-0 mt-0">
                                                                <template v-if="getCantidadCaracteres(arr_solicitud.str_observacion) < 300">
                                                                    <span class="text-justify" v-html="arr_solicitud.str_observacion_html"></span>
                                                                </template>
                                                                <template v-else>
                                                                    <template v-if="tp_resumir_descripcion == 1">
                                                                        {{ arr_solicitud.str_observacion | resumir }}
                                                                        <div class="col-md-12" style="text-align: right;">
                                                                            <a href="#" class="link-primary" @click="tp_resumir_descripcion = 0"> Leer más</a>    
                                                                        </div>
                                                                    </template>
                                                                    <template v-else>
                                                                        <span class="text-justify" v-html="arr_solicitud.str_observacion_html"></span>
                                                                        <div class="col-md-12" style="text-align: right;">
                                                                            <a href="#" class="link-primary" @click="tp_resumir_descripcion = 1"> Leer menos</a>
                                                                        </div>
                                                                    </template>
                                                                </template>
                                                            </div>
                                                        </li>
                                                        <li><strong>Publicación Definitiva : </strong>
                                                            <div class="col-md-12 mb-0 mt-0">
                                                                <div v-for="(publicacion, index) in arr_solicitud.publicacion" :key="publicacion.id">
                                                                    <template v-if="getCantidadCaracteres(publicacion.str_observacion) < 300">
                                                                        <span class="text-justify" v-html="publicacion.str_observacion_html"></span>
                                                                    </template>
                                                                    <template v-else>
                                                                        <template v-if="tp_resumir_publicacion == 1">
                                                                            {{ publicacion.str_observacion | resumir }}
                                                                            <div class="col-md-12" style="text-align: right;">
                                                                                <a href="#" class="link-primary" @click="tp_resumir_publicacion = 0"> Leer más</a>
                                                                            </div>
                                                                        </template>
                                                                        <template v-else>
                                                                            <span class="text-justify" v-html="publicacion.str_observacion_html"></span>
                                                                            <div class="col-md-12" style="text-align: right;">
                                                                                <a href="#" class="link-primary" @click="tp_resumir_publicacion = 1"> Leer menos</a>
                                                                            </div>
                                                                        </template>
                                                                    </template>
                                                                </div>
                                                            </div>
                                                        </li>
                                                    </ul>
                                                </template>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12">
                                    <!-- Mensaje de Bienvenida -->
                                    <div class="card" style="margin-bottom: 0px;">
                                        <div class="card-body">
                                            <div class="col-md-12 text-justify text-info h5">
                                                <template v-if="tp_iniciar_encuesta == 1">
                                                    <span v-html="str_indicacion"></span>
                                                    <br><br>
                                                    <div class="col-12 text-center">
                                                        <span class="text-primary h5"><strong>Número Contacto : </strong>
                                                            <template v-if="arr_solicitud.vecino">
                                                                {{ arr_solicitud.vecino.nr_prefijo + ' - ' }} 
                                                                {{ arr_solicitud.vecino.nr_telefono | formatPhone }}
                                                            </template>
                                                            <template v-else>
                                                                No encontrado
                                                            </template>
                                                        </span>
                                                    </div>
                                                </template>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Encuesta Telefonista -->
                                    <div class="card" style="margin-bottom: 0px;">
                                        <div class="card-body">
                                            <div class="col-md-12 col-sm-12 text-center" v-if="tp_iniciar_encuesta == 0">
                                                <button class="btn btn-sm btn-md btn-primary" @click="asyncEncuesta()" v-if="tp_utilizar == 0">
                                                    <span class="h4 text-white">Iniciar Encuesta</span>
                                                </button>
                                                <span class="h5 text-danger">{{ tp_utilizar_msj }}</span>
                                            </div>
                                            <div class="col-md-12 col-sm-12" v-else>
                                                <form id="form_encuesta" action="" method="">
                                                    <div class="row" v-if="arr_encuesta.length">
                                                        <div class="col-md-12 col-sm-12" v-for="(pregunta, index) in arr_encuesta" :key="pregunta.id">
                                                            <div class="card encuesta_pregunta" :id="pregunta.cod_pregunta" :class="{'d-block':index == 0,'d-none':index != 0}">
                                                                <div class="card-body">
                                                                    <div class="col-md-12 col-sm-12">
                                                                        <h5 class="font-weight-bold" style="font-style: unset;">{{ pregunta.str_pregunta }}</h5>
                                                                    </div>
                                                                    <div class="col-md-12 col-sm-12 text-left">
                                                                        <template v-if="pregunta.tp_pregunta == 2">
                                                                            <div class="form-check" v-for="alternativa in pregunta.alternativa" :key="alternativa.id">
                                                                                <input class="form-check-input" type="radio" :name="pregunta.str_formdata" 
                                                                                    :id="pregunta.str_formdata+'_'+alternativa.cod_alternativa" 
                                                                                    :value="alternativa.vl_alternativa" @click="asyncPregunta(pregunta, alternativa)">
                                                                                <label class="form-check-label" :for="pregunta.str_formdata">
                                                                                    {{ alternativa.str_alternativa }}
                                                                                </label>
                                                                            </div>
                                                                        </template>
                                                                        <template v-if="pregunta.tp_pregunta == 3">
                                                                            <div class="col-md-6">
                                                                                <select :name="pregunta.str_formdata" :id="pregunta.str_formdata" class="form-control" @click="asyncPregunta(pregunta, null)">
                                                                                    <option value="0">Seleccione una opción</option>
                                                                                    <option v-for="alternativa in pregunta.alternativa" :key="alternativa.id" :value="alternativa.vl_alternativa" v-text="alternativa.str_alternativa"></option>
                                                                                </select>
                                                                            </div>
                                                                        </template>
                                                                        <template v-if="pregunta.tp_pregunta == 4">
                                                                            <div class="col-md-6">
                                                                                <input type="text" class="form-control flatpickr_fecha" :id="pregunta.str_formdata" placeholder="Fecha y Hora" @change="asyncDateChange($event, pregunta)"/>
                                                                            </div>
                                                                        </template>
                                                                        <div class="col-md-12 col-sm-12">
                                                                            <div class="text-center">
                                                                                <button id="btn_encuesta_back" type="button" class="btn btn-sm btn-secondary" @click="showPregunta(2, pregunta)" 
                                                                                    v-if="(btn_encuesta_back == 1 && (index != 0))">Anterior</button>
                                                                                <button id="btn_encuesta_next" type="button" class="btn btn-sm btn-secondary" @click="showPregunta(1, pregunta)" 
                                                                                    v-if="btn_encuesta_next == 1">Siguiente</button>

                                                                                <template v-if="btn_encuesta_save == 1">
                                                                                    <button v-if="btn_envio == 0" type="button" 
                                                                                        class="btn btn-sm btn-success  waves-effect waves-light" @click="ensamblarDatos('encuesta')">
                                                                                        <i class="fas fa-save"></i> Registrar
                                                                                    </button>
                                                                                    <button v-else type="button" class="btn btn-sm btn-success">Registrando <i  class="fas fa-spin fa-spinner"></i></button>
                                                                                </template>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-12 col-sm-12 text-center mt-2">
                                                                        <template v-if="paginationPreguntas.length && btn_encuesta_save == 0">
                                                                            <button v-if="btn_parcial == 0" type="button" 
                                                                                class="btn btn-sm btn-warning waves-effect waves-light" @click="ensamblarDatos('parcial')">
                                                                                <i class="fas fa-save"></i> Registrar encuesta parcial
                                                                            </button>
                                                                            <button v-else type="button" class="btn btn-sm btn-success">Registrando <i  class="fas fa-spin fa-spinner"></i></button>
                                                                        </template>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-12 col-sm-12" >
                                                            <div class="card-body">
                                                                <div class="col-md-12 col-sm-12">
                                                                    <h5 class="font-weight-bold" style="font-style: unset;">Observación de la Encuesta</h5>
                                                                </div>
                                                                <div class="col-md-12 col-sm-12">
                                                                    <textarea maxlength="2000" rows="5" v-model="str_observacion" class="form-control" placeholder="Observación de la Encuesta"></textarea>
                                                                    <small class="form-text text-muted" v-if="str_observacion" v-text="'Disponible '+(2000-str_observacion.trim().length)+' caracteres'"></small>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                  </div>
                  <div class="modal-footer">
                    <div class="col-md-12 col-sm-12">
                        <button type="button" class="btn btn-md btn-secondary col-lg-2 col-md-3 col-sm-4" style="float: left;" @click="imprimir()">Imprimir</button>
                        <button type="button" class="btn btn-md btn-secondary col-lg-2 col-md-3 col-sm-4" style="float: right;" @click="cerrarModal('encuesta')">Cerrar</button>
                    </div>
                  </div>
                </div>
            </div>
        </div>
    </div>
</div>

    <style type="text/css">
        .bg-color-skyblue {
            background: skyblue;
        }

        .bg-color-khaki {
            background: khaki;
        }

        .bg-color-darkseagreen {
            background: darkseagreen;
        }

        .bg-color-indianred {
            background: indianred;
        }

        .resumen-title {
            text-align: center;
            border-radius: 5px;
        }

        .resumen-anio {
            cursor: pointer;
            background-color: #e0e0e0;
            padding: 10px;
            margin: 5px 0;
            text-align: center;
            border-radius: 5px;
        }

        .resumen-mes {
            cursor: pointer;
            background-color: #e0e0e0;
            padding: 10px;
            margin: 5px;
            border-radius: 5px;
            display: block;
        }

        .resumen-dia {
            cursor: pointer;
            background-color: #e0e0e0;
            padding: 10px;
            margin: 5px;
            border-radius: 5px;
        }

        .resumen-cantidad {
            font-weight: bold;
            margin-top: 5px;
            color: #333;
        }

        .resumen-anio.activo {
            background-color: lightsteelblue;
        }

        .resumen-mes.activo {
            background-color: lightsteelblue;
        }

        .resumen-dia.activo {
            background-color: lightsteelblue;
        }
    </style>

    <script type="text/javascript">
        Vue.component('vue-multiselect', window.VueMultiselect.default);

        var app = new Vue({
            el: '#app',
            data: {
                //-------------------------------------
                tp_modal                    :   0,
                tp_accion                   :   0,
                tp_btn                      :   0,
                titulo_modal                :   '',
                btn_envio                   :   0,
                btn_parcial                 :   0,
                btn_encuesta_next           :   0,
                btn_encuesta_back           :   0,
                btn_encuesta_save           :   0,
                //-------------------------------------
                arr_valida                  :   [],
                arr_error                   :   [],
                arr_form                    :   {},
                str_msj                     :   '',
                //-------------------------------------
                pagination                  : {
                    'total' : 0,
                    'current_page' : 0,
                    'per_page' : 0,
                    'last_page' : 0,
                    'from' : 0,
                    'to' : 0,
                },
                //-------------------------------------
                offset                      :   3,
                //-------------------------------------
                fl_mostrar                  :   0,
                fl_direccion                :   [],
                fl_depto                    :   [],
                fl_servicio                 :   [],
                fl_macrozona                :   [],
                fl_unidadvecinal            :   [],
                fl_ticket                   :   [],
                fl_persona                  :   [],
                fl_motivo                   :   [],
                fl_ubicacion                :   [],
                //-------------------------------------
                fc_buscar                   :   '',
                //-------------------------------------
                arr_mostrar                 :   [
                    {
                        'value'     :   0,
                        'label'     :   'Todos',
                    },
                    {
                        'value'     :   1,
                        'label'     :   'Pendiente',
                    },
                    {
                        'value'     :   2,
                        'label'     :   'Parcial',
                    },
                    {
                        'value'     :   3,
                        'label'     :   'Reagendar',
                    },
                    {
                        'value'     :   6,
                        'label'     :   'No Contactado',
                    },
                ],
                //-------------------------------------
                tp_criterio                 :   'created_at',
                tp_orden                    :   'ASC',
                //-------------------------------------
                arr_solicitud               :   [],
                arr_historial               :   [],
                arr_respuestas              :   [],
                arr_usuario                 :   [],
                arr_archivo                 :   [],
                //-------------------------------------
                arr_index                   :   [],
                arr_direccion               :   [],
                arr_depto                   :   [],
                arr_servicio                :   [],
                arr_motivo                  :   [],
                arr_macrozona               :   [],
                arr_unidadvecinal           :   [],
                arr_ticket                  :   [],
                arr_prioridad               :   [],
                arr_persona                 :   [],
                arr_ubicaciones             :   [],
                arr_encuesta                :   [],
                arr_alternativa             :   [],
                //-------------------------------------
                mostrar_resumen             :   1,
                arr_resumen                 :   [],
                arr_resumen_anios           :   [],
                arr_resumen_mes             :   [],
                arr_resumen_dias            :   [],
                nr_anio_visible             :   0,
                nr_mes_visible              :   0,
                nr_dia_visible              :   0,
                //-------------------------------------
                arr_firstQuestion           :   null,
                arr_info                    :   null,
                arr_respuestas              :   null,
                //-------------------------------------
                nr_solicitud                :   0,
                nr_ticket                   :   '',
                nr_rut                      :   '',
                nr_prefijo                  :   '',
                nr_telefono                 :   '',
                nr_direccion                :   [],
                nr_depto                    :   [],
                nr_funcionario              :   [],
                str_observacion             :   '',
                //-------------------------------------
                tp_resumir_descripcion      :   1,
                tp_resumir_publicacion      :   1,
                //-------------------------------------
                nr_pendientes               :   0,
                nr_atendidos                :   0,
                nr_nocontactado             :   0,
                //-------------------------------------
                tp_iniciar_encuesta         :   0,
                nr_estado_encuesta          :   0,
                paginationPreguntas         :   [],
                fc_encuesta                 :   {
                    'fc_inicio' : '',
                    'fc_termino' : '',
                    'fc_inicio_ring' : '',
                    'fc_termino_ring' : '',
                    'fc_inicio_contacto' : '',
                    'fc_termino_contacto' : '',
                    'fc_inicio_servicio' : '',
                    'fc_termino_servicio' : '',
                },
                str_indicacion              :   '',
                tp_utilizar                 :   0,
                tp_utilizar_msj             :   '',
                //-------------------------------------
                timerId                     :   0,
                fc_agenda                   :   '',
                //-------------------------------------
            },

            components: {
                Multiselect: window.VueMultiselect.default
            },

            filters:{
                resumir: function (texto, limite=300, final=' ...')
                {
                    let me  = this;
                    var largo = texto.toString().length;
                    if(largo > limite){
                        for (var i = 0; i < largo; i++) {
                            if(texto[i] == ' ' && i >= limite) {
                                texto   =   texto.substring(0,i);
                                texto   =   texto + final;
                                return texto;
                            }
                        }                    
                    }
                    return texto;
                },

                capitalize: function (str_texto) 
                {
                    if (!str_texto) return '';

                    str_texto    = str_texto.toString();
                    var splitStr = str_texto.toLowerCase().split(' ');

                    for (var i = 0; i < splitStr.length; i++) {
                        splitStr[i] = splitStr[i].charAt(0).toUpperCase() + splitStr[i].substring(1);
                    }

                    return splitStr.join(' ');
                },

                formatDate: function (fecha)
                {
                    if(fecha)
                        return moment(String(fecha)).format('DD-MM-YYYY')
                },

                formatDateTime: function (fecha)
                {
                    if(fecha)
                    {
                        return moment(String(fecha)).format('DD-MM-YYYY HH:mm')
                    }
                },

                formatPhone: function (str_phone)
                {
                    if(!str_phone) return '';
                    let str_regex   =   '/(\d{0,4})(\d{0,4})/';
                    let str_temp    =   str_phone.replace(/(\d{0,4})(\d{0,4})/, function (regex, arg1, arg2) {
                                            return arg1 + '-' + arg2;
                                        });
                    return str_temp;
                },
            },

            computed:{
                //-------------------------------------------------------------------------------------------
                isActivedPagination: function()
                {
                    return this.pagination.current_page;
                },
                //-------------------------------------------------------------------------------------------
                pagesNumber: function()
                {
                    if(!this.pagination.to) {
                        return [];
                    }

                    var from = this.pagination.current_page - this.offset;
                    if(from < 1) {
                        from = 1;
                    }

                    var to = from + (this.offset * 2);
                    if(to >= this.pagination.last_page){
                        to = this.pagination.last_page;
                    }

                    var pagesArray = [];
                    while(from <= to) {
                        pagesArray.push(from);
                        from++;
                    }
                    return pagesArray;
                },                
                //-------------------------------------------------------------------------------------------
            },

            methods: {
                //-------------------------------------------------------------------------------------------
                isActiveTinyMCE()
                {
                    let me      =   this;
                    var valida  =   0;

                    try{
                        if(tinyMCE.activeEditor != null)
                            valida   =   1;
                    }catch(error) {
                        valida  =   0;
                    }   

                    return valida;
                },
                //-------------------------------------------------------------------------------------------
                activeDatetimepicker(tp_accion = 1)
                {
                    let me          =   this;
                    let fc_format1  =   'DD-MM-YYYY';
                    let fc_format2  =   'd-m-Y';
                    let fc_date     =   moment().locale('es').format(fc_format1);
                    let fc_desde    =   '';
                    let fc_hasta    =   '';
                    //-----------------------------------
                    // Configuración base para flatpickr
                    if(tp_accion == 1)
                    {
                        let baseConfig = {
                            dateFormat: fc_format2, // Formato de fecha y hora
                            locale: 'es', // Localización en español 
                            defaultDate: fc_date
                        };

                        flatpickr('#fc_buscar', baseConfig);
                    }
                    if(tp_accion == 2)
                    {
                        let baseConfig = {
                            minDate:"today",
                            enableTime: true, // Si quieres que también se pueda seleccionar la hora
                            dateFormat: fc_format2, // Formato de fecha y hora
                            locale: 'es', // Localización en español 
                            time_24hr: true // Formato de 24 Horas
                            // defaultDate: fc_date,
                        };

                        flatpickr('.flatpickr_fecha', baseConfig);
                    }
                },
                //-------------------------------------------------------------------------------------------
                imprimir()
                {
                    $("#modal_encuesta").printThis({
                        debug: false,               // show the iframe for debugging
                        importCSS: true,            // import parent page css
                        importStyle: true,          // import style tags
                        printContainer: false,      // print outer container/$.selector
                        loadCSS: "",                // path to additional css file - use an array [] for multiple
                        pageTitle: "",              // add title to print page
                        removeInline: true,        // remove inline styles from print elements
                        removeInlineSelector: "*",  // custom selectors to filter inline styles. removeInline must be true
                        printDelay: 333,            // variable print delay
                        header: null,               // prefix to html
                        footer: null,               // postfix to html
                        base: 'https://atencionvecino.lascondes.cl/',                // preserve the BASE tag or accept a string for the URL
                        formValues: true,           // preserve input/form values
                        canvas: false,              // copy canvas content
                        // doctypeString: '...',       // enter a different doctype for older markup
                        removeScripts: true,        // remove script tags from print content
                        copyTagClasses: false,      // copy classes from the html & body tag
                        beforePrintEvent: null,     // function for printEvent in iframe
                        beforePrint: null,          // function called before iframe is filled
                        afterPrint: null,           // function called before iframe is removed
                    });
                },
                //-------------------------------------------------------------------------------------------
                getCantidadCaracteres(str_contenido = '')
                {
                    var cantidad    =   0;

                    if(!str_contenido)
                        return cantidad;

                    if(str_contenido.trim().length)
                        cantidad    =   str_contenido.trim().length;

                    return cantidad;
                },
                //-------------------------------------------------------------------------------------------
                cambiarPagina(page)
                {
                    let me  =   this;
                    me.pagination.current_page = page;
                    me.cargarDatos(page);
                },
                //-------------------------------------------------------------------------------------------
                refrescarDatos()
                {
                    let me  =   this;
                    me.cargarDatos(me.pagination.current_page);
                    me.cargarResumenAgendados();
                },
                //-------------------------------------------------------------------------------------------
                asyncRefrescarDatos()
                {
                    let me          =   this;
                    let fc_fecha    =   document.querySelector('#fc_buscar').value; 
                    let arr_partes  =   fc_fecha.split("-");
                    let arr_anio    =   [];
                    let arr_mes     =   [];
                    let arr_dia     =   [];
                    //-------------------------------------
                    let nr_dia      =   arr_partes[0];
                    let nr_mes      =   arr_partes[1];
                    let nr_anio     =   arr_partes[2];
                    //-------------------------------------
                    me.nr_anio_visible  =   parseInt(nr_anio);
                    me.nr_mes_visible   =   parseInt(nr_mes);
                    me.nr_dia_visible   =   parseInt(nr_dia);
                    //-------------------------------------
                    arr_anio    =   me.arr_resumen.filter((datos) => datos.nr_anio == nr_anio);
                    arr_mes     =   arr_anio.map((datos) => datos.arr_detalle);
                    arr_mes     =   (arr_mes.length === 1) ? arr_mes[0] : arr_mes;
                    arr_dia     =   arr_mes.flatMap((datos) => 
                                        datos.arr_detalle.filter((items) => items.nr_mes == nr_mes)
                                    );
                    //-------------------------------------
                    me.arr_resumen_mes  =   arr_mes;
                    me.arr_resumen_dias =   arr_dia;
                    //-------------------------------------
                    me.cargarDatos();
                },
                //-------------------------------------------------------------------------------------------
                getLabel(data)
                {
                    var valor   =   '';

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.label;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                getValue(data)
                {
                    var valor   =   0;

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.value;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                strCapitalize(str_texto)
                {
                    if (!str_texto) return '';

                    str_texto    = str_texto.toString();
                    var splitStr = str_texto.toLowerCase().split(' ');

                    for (var i = 0; i < splitStr.length; i++) {
                        splitStr[i] = splitStr[i].charAt(0).toUpperCase() + splitStr[i].substring(1);
                    }

                    return splitStr.join(' ');
                },
                //-------------------------------------------------------------------------------------------
                inArray(needle, haystack) 
                {
                    var length = haystack.length;
                    for(var i = 0; i < length; i++) {
                        if(haystack[i] == needle) return true;
                    }
                    return false;
                },
                //-------------------------------------------------------------------------------------------
                cerrarModal(modelo)
                {
                    let me  =   this;

                    switch(modelo)
                    {
                        case 'encuesta':
                        {
                            me.ensamblarDatos('liberar');
                            $('#modal_encuesta').modal('hide');
                            me.limpiarDatos(modelo);
                            if(me.tp_iniciar_encuesta == 1)
                            {
                                document.querySelector('#form_encuesta').reset();
                                $('.encuesta_pregunta').removeClass('d-block').addClass('d-none');
                                $('#'+me.arr_firstQuestion.cod_pregunta).removeClass('d-none').addClass('d-block');
                                me.tp_iniciar_encuesta  =   0;
                                me.nr_estado_encuesta   =   0;
                                me.fc_encuesta          =   {
                                    'fc_inicio' : '',
                                    'fc_termino' : '',
                                    'fc_inicio_contacto' : '',
                                    'fc_termino_contacto' : '',
                                    'fc_inicio_servicio' : '',
                                    'fc_termino_servicio' : '',
                                };
                                me.nr_solicitud     = 0;
                                me.nr_ticket        = '';
                                me.nr_rut           = '';
                            }
                            me.btn_encuesta_next    =   0;
                            me.btn_encuesta_back    =   0;
                            me.btn_encuesta_save    =   0;
                            me.paginationPreguntas  =   [];
                            me.tp_resumir_descripcion   =   1;
                            me.tp_resumir_publicacion   =   1;

                            break;
                        }
                        case 'archivo':
                        {
                            $('#modal_adjunto').modal('hide');
                            me.limpiarDatos(modelo);

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                asyncDatos()
                {
                    let me      =   this;
                    me.timerId  =   window.setInterval(function(){
                                        console.log('Bandeja Telefonista - ejecutado asyncDatos');
                                        me.cargarDatos(me.pagination.current_page);
                                    },300000); // cada 5 min.
                    
                    // clearInterval(timerId); // se detiene la llamada
                },
                //-------------------------------------------------------------------------------------------
                clearTimerInterval()
                {
                    let me  =   this;
                    clearTimerInterval(me.timerId);
                },
                //-------------------------------------------------------------------------------------------
                asyncResumenAnio(data)
                {
                    let me  =   this;
                    me.arr_resumen_mes      =   [];

                    if(data)
                    {
                        if(me.nr_anio_visible != data.nr_anio)
                        {
                            me.nr_anio_visible  =   data.nr_anio;
                            me.arr_resumen_mes  =   data.arr_detalle;
                            me.nr_mes_visible   =   0;
                            me.nr_dia_visible   =   0;
                            me.arr_resumen_dias =   [];
                        }
                        else
                        {
                            me.nr_anio_visible  =   0;
                            me.nr_mes_visible   =   0;
                            me.nr_dia_visible   =   0;
                            me.arr_resumen_mes  =   [];
                            me.arr_resumen_dias =   [];
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                asyncResumenMes(data)
                {
                    let me  =   this;
                    me.arr_resumen_dias         =   [];

                    if(data)
                    {
                        if(me.nr_mes_visible != data.nr_mes)
                        {
                            me.nr_mes_visible   =   data.nr_mes;
                            me.arr_resumen_dias =   data.arr_detalle;
                        }
                        else
                        {
                            me.nr_mes_visible   =   0;
                            me.nr_dia_visible   =   0;
                            me.arr_resumen_dias =   [];
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                asyncResumenDia(data)
                {
                    let me  =   this;
                    let componente_flatpickr    =   document.querySelector("#fc_buscar")._flatpickr;
                    componente_flatpickr.setDate(data.fc_calendario, true);
                    me.nr_dia_visible   =   data.nr_dia;
                    me.cargarDatos();
                },
                //-------------------------------------------------------------------------------------------
                asyncDeptos(item)
                {
                    let me  =   this;

                    if(item)
                    {
                        me.nr_direccion     =   item;
                        me.cargarDeptosMunicipales(0, me.getValue(me.nr_direccion));
                    }
                    else
                        me.arr_depto        =   [];
                },
                //-------------------------------------------------------------------------------------------
                asyncServicios(item)
                {
                    let me  =   this;

                    if(item)
                    {
                        me.fl_depto     =   item;
                        me.cargarServicios(me.getValue(me.fl_direccion), me.getValue(me.fl_depto));
                        me.fl_servicio  =   [];
                    }
                    else
                        me.fl_servicio  =   [];
                },
                //-------------------------------------------------------------------------------------------
                filtrarEncuesta(atributo, valor)
                {
                    let me  =   this;

                    return  me.arr_encuesta.filter((item) => (item[atributo] === valor));
                },
                //-------------------------------------------------------------------------------------------
                asyncDateChange(event, pregunta)
                {
                    let me          =   this;
                    me.fc_agenda    =   event.target.value;
                    me.asyncPregunta(pregunta, null);
                },
                //-------------------------------------------------------------------------------------------
                asyncPregunta(pregunta, alternativa)
                {
                    let me          =   this;
                    let logica      =   [];
                    let valor       =   0;
                    let item        =   null;
                    var fc_format   =   'YYYY-MM-DD HH:mm:ss'; // 'DD-MM-YYYY HH:mm:ss';
                    me.arr_info     =   null;
                    
                    if(pregunta.tp_pregunta == 2)
                    {
                        if(alternativa.logica.length)
                        {
                            logica  =   alternativa.logica;

                            for (var i = 0; i < logica.length; i++) 
                            {
                                if(logica[i].tp_accion == 1)
                                {
                                    me.arr_info             =   logica[i];
                                    me.btn_encuesta_back    =   logica[i].tp_anterior;
                                    me.btn_encuesta_next    =   logica[i].tp_siguiente;
                                    me.btn_encuesta_save    =   logica[i].tp_save;
                                }
                                if(logica[i].tp_accion == 2)
                                {
                                    me.arr_info             =   logica[i];
                                    me.btn_encuesta_back    =   logica[i].tp_anterior;
                                    me.btn_encuesta_next    =   logica[i].tp_siguiente;
                                    me.btn_encuesta_save    =   logica[i].tp_save;
                                }
                                /*------------------------------------  registro de fecha  ------------------------------------*/
                                if(pregunta.tp_categoria === "contacto" && logica[i].tp_evento_fecha == 1 && me.inArray(logica[i].tp_accion,[1,2]))
                                {
                                    me.fc_encuesta.fc_termino_ring      =   moment().locale('es').format(fc_format);
                                    me.fc_encuesta.fc_inicio_contacto   =   moment().locale('es').format(fc_format); // moment().tz("America/Santiago").format();
                                    me.fc_encuesta.fc_inicio_servicio   =   '';
                                }
                                if(pregunta.tp_categoria === "contacto" && logica[i].tp_evento_fecha == 2 && me.inArray(logica[i].tp_accion,[1,2]))
                                {
                                    if(logica[i].tp_evento_estado == 6)
                                        me.fc_encuesta.fc_termino_ring  =   moment().locale('es').format(fc_format);

                                    me.fc_encuesta.fc_termino_contacto  =   moment().locale('es').format(fc_format);
                                    me.fc_encuesta.fc_inicio_servicio   =   '';
                                }
                                if(pregunta.tp_categoria === "contacto" && logica[i].tp_evento_fecha == 3 && me.inArray(logica[i].tp_accion,[1,2]))
                                {
                                    me.fc_encuesta.fc_termino_contacto  =   moment().locale('es').format(fc_format);
                                    me.fc_encuesta.fc_inicio_servicio   =   moment().locale('es').format(fc_format);
                                }
                                if(pregunta.tp_categoria === "servicio" && logica[i].tp_evento_fecha == 2 && me.inArray(logica[i].tp_accion,[1,2]))
                                    me.fc_encuesta.fc_termino_servicio  =   moment().locale('es').format(fc_format);
                                /*------------------------------------  registro de estado  ------------------------------------*/
                                if(alternativa.vl_alternativa == logica[i].nr_valor && me.inArray(logica[i].tp_accion,[1,2]))
                                    me.nr_estado_encuesta   =   logica[i].tp_evento_estado;
                            }
                        }
                    }
                    if(pregunta.tp_pregunta == 3)
                    {
                        valor   =   $('#'+pregunta.str_formdata).val();

                        if(valor)
                        {
                            logica  =   pregunta.logica;

                            if(logica.length)
                            {
                                for (var i = 0; i < logica.length; i++) {
                                    if(valor == logica[i].nr_valor && logica[i].tp_accion == 1)
                                    {
                                        me.arr_info             =   logica[i];
                                        me.btn_encuesta_back    =   logica[i].tp_anterior;
                                        me.btn_encuesta_next    =   logica[i].tp_siguiente;
                                        me.btn_encuesta_save    =   logica[i].tp_save;
                                    }
                                    if(valor == logica[i].nr_valor && logica[i].tp_accion == 2 && logica[i].tp_save == 1)
                                    {
                                        me.arr_info             =   logica[i];
                                        me.btn_encuesta_back    =   logica[i].tp_anterior;
                                        me.btn_encuesta_next    =   logica[i].tp_siguiente;
                                        me.btn_encuesta_save    =   logica[i].tp_save;
                                    }
                                    /*------------------------------------  registro de fecha  ------------------------------------*/
                                    if(pregunta.tp_categoria === "contacto" && logica[i].tp_evento_fecha == 1 && me.inArray(logica[i].tp_accion,[1,2]))
                                    {
                                        me.fc_encuesta.fc_termino_ring      =   moment().locale('es').format(fc_format);
                                        me.fc_encuesta.fc_inicio_contacto   =   moment().locale('es').format(fc_format);
                                        me.fc_encuesta.fc_inicio_servicio   =   '';
                                    }
                                    if(pregunta.tp_categoria === "contacto" && logica[i].tp_evento_fecha == 2 && me.inArray(logica[i].tp_accion,[1,2]))
                                    {
                                        me.fc_encuesta.fc_termino_contacto  =   moment().locale('es').format(fc_format);
                                        me.fc_encuesta.fc_inicio_servicio   =   '';
                                    }
                                    if(pregunta.tp_categoria === "contacto" && logica[i].tp_evento_fecha == 3 && me.inArray(logica[i].tp_accion,[1,2]))
                                    {fc_format
                                        me.fc_encuesta.fc_termino_contacto  =   moment().locale('es').format(fc_format);
                                        me.fc_encuesta.fc_inicio_servicio   =   moment().locale('es').format(fc_format);
                                    }
                                    if(pregunta.tp_categoria === "servicio" && logica[i].tp_evento_fecha == 2 && me.inArray(logica[i].tp_accion,[1,2]))
                                        me.fc_encuesta.fc_termino_servicio  =   moment().locale('es').format(fc_format);
                                    /*------------------------------------  registro de estado  ------------------------------------*/
                                    if(me.inArray(logica[i].tp_accion,[1,2]))
                                        me.nr_estado_encuesta   =   logica[i].tp_evento_estado;
                                }
                            }
                        }
                    }
                    if(pregunta.tp_pregunta == 4)
                    {
                        valor   =   document.querySelector('#'+pregunta.str_formdata).value;

                        let fc_format_input     =   'DD-MM-YYYY HH:mm';     // El formato en el que está la fecha en el input
                        let fc_format_output    =   'YYYY-MM-DD HH:mm:ss';  // El formato en el que deseas la fecha
                        let fechaFormateada     =   moment(valor, fc_format_input).format(fc_format_output);

                        if(valor)
                        {
                            logica  =   pregunta.logica;

                            if(logica.length)
                            {
                                for (var i = 0; i < logica.length; i++) {
                                    if(logica[i].tp_accion == 1)
                                    {
                                        logica[i].str_alternativa   =   fechaFormateada;
                                        logica[i].vl_alternativa    =   fechaFormateada;
                                        me.arr_info             =   logica[i];
                                        me.btn_encuesta_back    =   logica[i].tp_anterior;
                                        me.btn_encuesta_next    =   logica[i].tp_siguiente;
                                        me.btn_encuesta_save    =   logica[i].tp_save;
                                    }
                                    if(logica[i].tp_accion == 2 && logica[i].tp_save == 1)
                                    {
                                        logica[i].str_alternativa   =   fechaFormateada;
                                        logica[i].vl_alternativa    =   fechaFormateada;
                                        me.arr_info             =   logica[i];
                                        me.btn_encuesta_back    =   logica[i].tp_anterior;
                                        me.btn_encuesta_next    =   logica[i].tp_siguiente;
                                        me.btn_encuesta_save    =   logica[i].tp_save;
                                    }
                                    // ------------------------------------  registro de fecha  ------------------------------------
                                    if(pregunta.tp_categoria === "contacto" && logica[i].tp_evento_fecha == 1 && me.inArray(logica[i].tp_accion,[1,2]))
                                    {
                                        me.fc_encuesta.fc_termino_ring      =   moment().locale('es').format(fc_format);
                                        me.fc_encuesta.fc_inicio_contacto   =   moment().locale('es').format(fc_format);
                                        me.fc_encuesta.fc_inicio_servicio   =   '';
                                    }
                                    if(pregunta.tp_categoria === "contacto" && logica[i].tp_evento_fecha == 2 && me.inArray(logica[i].tp_accion,[1,2]))
                                    {
                                        me.fc_encuesta.fc_termino_contacto  =   moment().locale('es').format(fc_format);
                                        me.fc_encuesta.fc_inicio_servicio   =   '';
                                    }
                                    if(pregunta.tp_categoria === "contacto" && logica[i].tp_evento_fecha == 3 && me.inArray(logica[i].tp_accion,[1,2]))
                                    {fc_format
                                        me.fc_encuesta.fc_termino_contacto  =   moment().locale('es').format(fc_format);
                                        me.fc_encuesta.fc_inicio_servicio   =   moment().locale('es').format(fc_format);
                                    }
                                    if(pregunta.tp_categoria === "servicio" && logica[i].tp_evento_fecha == 2 && me.inArray(logica[i].tp_accion,[1,2]))
                                        me.fc_encuesta.fc_termino_servicio  =   moment().locale('es').format(fc_format);
                                    // ------------------------------------  registro de estado  ------------------------------------
                                    if(me.inArray(logica[i].tp_accion,[1,2]))
                                        me.nr_estado_encuesta   =   logica[i].tp_evento_estado;
                                }
                            }
                        }
                    }

                    if(me.arr_info)
                    {
                        if(me.agregarItem(me.arr_info))
                            me.paginationPreguntas.push(me.arr_info);
                        else
                        {
                            for (var i = 0; i < me.paginationPreguntas.length; i++) {
                                if(me.paginationPreguntas[i].actual_cod_pregunta === me.arr_info.actual_cod_pregunta)
                                    me.paginationPreguntas[i]   =   me.arr_info;
                            }
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                asyncEncuesta()
                {
                    let me          =   this;
                    var fc_format   =   'YYYY-MM-DD HH:mm:ss'; // 'DD-MM-YYYY HH:mm:ss';

                    me.tp_iniciar_encuesta      =   1;
                    me.fc_encuesta.fc_inicio    =   moment().locale('es').format(fc_format); // moment().tz("America/Santiago").format();
                    me.fc_encuesta.fc_inicio_ring   =   moment().locale('es').format(fc_format);
                    me.asyncIndicacionPregunta(me.arr_firstQuestion.cod_pregunta, me.arr_firstQuestion.str_indicacion);
                },
                //-------------------------------------------------------------------------------------------
                agregarItem(item)
                {
                    let  me     =   this;
                    let flat    =   0;
                    let found   =   null;

                    found   =   me.paginationPreguntas.some(data => data.actual_cod_pregunta === item.actual_cod_pregunta);

                    if(!found)
                        flat  =   1;

                    return flat;
                },
                //-------------------------------------------------------------------------------------------
                showPregunta(tp_accion = 0, arr_data)
                {
                    let me          =   this;
                    let item        =   null;
                    let str_actual  =   null;
                    let str_next    =   null;
                    let str_back    =   null;

                    switch(tp_accion)
                    {
                        case 1: // siguiente
                        {
                            // ----------------------------------------------------------------------------
                            if(me.arr_info)
                            {
                                console.log(me.arr_info);
                                $('#'+me.arr_info.next_cod_pregunta).removeClass('d-none').addClass('d-block');
                                $('#'+me.arr_info.actual_cod_pregunta).removeClass('d-block').addClass('d-none');
                                me.asyncIndicacionPregunta(me.arr_info.next_cod_pregunta, me.arr_info.next_str_indicacion);
                                me.btn_encuesta_back    =   1;
                                me.btn_encuesta_next    =   0;
                                me.btn_encuesta_save    =   0;

                                if(me.arr_info.next_tp_pregunta === 4)
                                    me.activeDatetimepicker(2);

                                me.arr_info             =   null;
                            }
                            // ----------------------------------------------------------------------------
                            break;
                        }
                        case 2: // anterior
                        {
                            // ----------------------------------------------------------------------------
                            if(arr_data.alternativa)
                            {
                                let alternativa     =   arr_data.alternativa;

                                if(arr_data.tp_pregunta == 2)
                                    for (var i = 0; i < alternativa.length; i++) {
                                            document.querySelector('#'+arr_data.str_formdata+'_'+alternativa[i].cod_alternativa).checked = null;
                                    }
                                if(arr_data.tp_pregunta == 3)
                                    document.querySelector("#"+arr_data.str_formdata).value = 0;
                            }
                            // ----------------------------------------------------------------------------
                            if(me.paginationPreguntas.length)
                            {
                                // ----------------------------------------------------------------------------
                                item    =   me.paginationPreguntas.find(data => data.actual_cod_pregunta === arr_data.cod_pregunta);
                                // ----------------------------------------------------------------------------
                                if(item)
                                {
                                    if(item.next_tp_pregunta == 2)
                                        document.querySelector('input[name="'+item.next_str_formdata+'"]').checked = null;
                                    if(item.next_tp_pregunta == 3)
                                        document.querySelector("#"+item.next_str_formdata).value = 0;

                                    $('#'+item.next_cod_pregunta).removeClass('d-block').addClass('d-none');
                                    $('#'+item.actual_cod_pregunta).removeClass('d-none').addClass('d-block');
                                    me.asyncIndicacionPregunta(item.back_cod_pregunta, item.back_str_indicacion);
                                    me.btn_encuesta_back    =   1;
                                    me.btn_encuesta_next    =   0;
                                    me.btn_encuesta_save    =   0;
                                }
                                // ----------------------------------------------------------------------------
                                else
                                {
                                    item    =   me.paginationPreguntas.find(data => data.next_cod_pregunta === arr_data.cod_pregunta);

                                    if(item)
                                    {
                                        if(item.next_tp_pregunta == 2)
                                            document.querySelector('input[name="'+item.next_str_formdata+'"]').checked = null;
                                        if(item.next_tp_pregunta == 3)
                                            document.querySelector("#"+item.next_str_formdata).value = 0;

                                        $('#'+item.next_cod_pregunta).removeClass('d-block').addClass('d-none');
                                        $('#'+item.actual_cod_pregunta).removeClass('d-none').addClass('d-block');
                                        me.asyncIndicacionPregunta(item.back_cod_pregunta, item.back_str_indicacion);
                                        me.btn_encuesta_back    =   1;
                                        me.btn_encuesta_next    =   0;
                                        me.btn_encuesta_save    =   0;
                                    }
                                }
                                // ----------------------------------------------------------------------------
                                let index_pregunta  =   me.paginationPreguntas.findIndex(info => info.actual_cod_pregunta === arr_data.cod_pregunta);
                                if(index_pregunta >= 0)
                                    me.paginationPreguntas.splice(index_pregunta, 1);
                                // ----------------------------------------------------------------------------
                            }
                            // ----------------------------------------------------------------------------
                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                asyncIndicacionPregunta(cod_pregunta = '', str_texto = '')
                {
                    let me          =   this;
                    let fc_format   =   'H:mm';
                    let fc_date     =   moment().locale('es').format(fc_format);
                    let hr_date     =   moment('12:00',fc_format).format(fc_format);
                    let str_comilla =   '<strong><span style="color: #e03e2d;"> " </span></strong>';

                    if(cod_pregunta === "I02")
                    {
                        //----------------------------------------------------------------------
                        if(me.arr_solicitud.vecino)
                            str_texto   =   str_texto.replace('attr_vecino', me.strCapitalize(me.arr_solicitud.vecino.nmc_vecino));
                        else
                            str_texto   =   str_texto.replace('attr_vecino','');
                        //----------------------------------------------------------------------
                        if(fc_date < hr_date)
                            str_texto   =   str_texto.replace('attr_horario','buenos días');
                        else
                            str_texto   =   str_texto.replace('attr_horario','buenos tardes');
                        //----------------------------------------------------------------------
                        if(me.arr_usuario)
                            str_texto   =   str_texto.replace('attr_telefonista',me.strCapitalize(me.arr_usuario.name));
                        else
                            str_texto   =   str_texto.replace('attr_telefonista','"Indicar su nombre"');
                        //----------------------------------------------------------------------
                        if(me.arr_solicitud.nm_tipo)
                            str_texto   =   str_texto.replace('attr_servicio',me.arr_solicitud.nm_tipo);
                        //----------------------------------------------------------------------
                        me.str_indicacion   =   str_comilla + str_texto + str_comilla;
                        //----------------------------------------------------------------------
                    }
                    else
                        me.str_indicacion   =   str_texto;
                },
                //-------------------------------------------------------------------------------------------
                asyncValidaEncuesta(data)
                {
                    let me          =   this;
                    var formData    =   new FormData();
                    var tp_icon     =   '';
                    var titulo      =   '';
                    var mensaje     =   '';
                    var error       =   '';
                    let ruta        =   '/encuestador/encuesta/valida';
                    //-----------------------------------------------------
                    formData.append('nr_solicitud', data.id);
                    //-----------------------------------------------------
                    axios.post(ruta, formData, {
                        headers: {'Content-Type': 'multipart/form-data'}
                    }).then(function (response) 
                    {
                        var result  =   response.data;                       
                        tp_icon     =   result.tp_icon;
                        titulo      =   result.title;
                        mensaje     =   result.msj;
                        error       =   result.error;

                        if(error == 1)
                        {
                            me.tp_utilizar  =   1;
                            tp_utilizar_msj =   mensaje;
                            me.desplegarVentana(tp_icon, titulo, mensaje);
                        }
                        else
                        {
                            me.tp_utilizar  =   0;
                            tp_utilizar_msj =   '';
                            me.abrirModal('solicitud', 'encuesta', data);
                        }
                    })
                    .catch(function (error) 
                    {
                        me.tp_utilizar      =   0;
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarDireccionesMunicipales(nr_direccion = 0)
                {
                    let me      =   this;
                    var ruta    =   '/listado/direcciones_municipales';
                    me.arr_direccion    =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_direccion    =   respuesta.direcciones;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarDeptosMunicipales(tp_filtro = 0, nr_direccion)
                {
                    let me      =   this;
                    var ruta    =   '/listado/deptos_municipales';
                    me.arr_depto    =   [];

                    axios.post(ruta,{
                        'nr_direccion'      :   nr_direccion,
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;

                        if(tp_filtro == 0)
                            me.arr_depto        =   respuesta.deptos;
                        else
                            me.fl_arr_deptos    =   respuesta.deptos;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarServicios(nr_direccion = 0, nr_depto = 0)
                {
                    let me      =   this;
                    var ruta    =   '/listado/servicios';
                    me.arr_servicio     =   [];

                    axios.post(ruta,{
                        'nr_direccion'      :   nr_direccion,
                        'nr_depto'          :   nr_depto,
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_servicio     =   respuesta;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarMotivo()
                {
                    let me      =   this;
                    var ruta    =   '/motivo/listado';
                    me.arr_motivo   =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta   =   response.data;
                        me.arr_motivo   =   respuesta;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarPrioridad()
                {
                    let me      =   this;
                    var ruta    =   '/prioridad/listado';
                    me.arr_prioridad    =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_prioridad    =   respuesta;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarMacrozona()
                {
                    let me      =   this;
                    var ruta    =   '/listado/macrozona';
                    me.arr_macrozona    =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_macrozona    =   respuesta.macrozona;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarUnidadVecinal()
                {
                    let me      =   this;
                    var ruta    =   '/listar/unidadvecinales';
                    me.arr_unidadvecinal    =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta           =   response.data;
                        me.arr_unidadvecinal    =   respuesta;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarTicket()
                {
                    let me      =   this;
                    var ruta    =   '/listado/ticket';
                    me.arr_ticket    =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta    =   response.data;
                        me.arr_ticket    =   respuesta.ticket;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarUbicaciones()
                {
                    let me      =   this;
                    var ruta    =   '/listado/ubicaciones';
                    me.arr_ubicaciones      =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta           =   response.data;
                        me.arr_ubicaciones      =   respuesta.ubicaciones;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarPersonas()
                {
                    let me      =   this;
                    var ruta    =   '/listado/personas';
                    me.arr_persona      =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_persona      =   respuesta.personas;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarEncuesta()
                {
                    let me      =   this;
                    var ruta    =   '/listado/encuesta';
                    me.arr_encuesta     =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta           =   response.data;
                        me.arr_encuesta         =   respuesta.listado;
                        me.arr_firstQuestion    =   respuesta.firstQuestion;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarUsuario()
                {
                    let me      =   this;
                    var ruta    =   '/info/usuario';
                    me.arr_usuario  =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta     =   response.data;
                        me.arr_usuario    =   respuesta;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarResumenAgendados()
                {
                    let me          =   this;
                    var ruta        =   '/encuesta/resumen/agendados';
                    me.arr_resumen      =   [];
                    me.arr_resumen_mes  =   [];
                    me.arr_resumen_dias =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta           =   response.data;
                        me.arr_resumen          =   respuesta.resumen;
                        me.arr_resumen_mes      =   (respuesta.arr_anio.length) ? respuesta.arr_anio.arr_detalle : [];
                        me.arr_resumen_dias     =   (respuesta.arr_mes.length) ? respuesta.arr_mes.arr_detalle : [];
                        me.nr_anio_visible      =   respuesta.nr_anio;
                        me.nr_mes_visible       =   respuesta.nr_mes;
                        me.nr_dia_visible       =   respuesta.nr_dia;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarDatos(page = 1)
                {
                    let me          =   this;
                    var ruta        =   '/encuestador/agendados';

                    axios.post(ruta,{
                        'page'              :   page,
                        'tp_criterio'       :   me.tp_criterio,
                        'tp_orden'          :   me.tp_orden,
                        'fl_mostrar'        :   me.fl_mostrar,
                        'fc_buscar'         :   document.querySelector('#fc_buscar').value,
                        'fc_desde'          :   '',
                        'fc_hasta'          :   '',
                        'fl_direccion'      :   me.getValue(me.fl_direccion),
                        'fl_depto'          :   me.getValue(me.fl_depto),
                        'fl_servicio'       :   me.getValue(me.fl_servicio),                        
                        'fl_macrozona'      :   me.getValue(me.fl_macrozona),
                        'fl_unidadvecinal'  :   me.getValue(me.fl_unidadvecinal),
                        'fl_ticket'         :   me.getValue(me.fl_ticket),
                        'fl_persona'        :   me.getValue(me.fl_persona),
                        'fl_motivo'         :   me.getValue(me.fl_motivo),
                        'fl_ubicacion'      :   me.getValue(me.fl_ubicacion),
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_index        =   respuesta.info.data ;
                        me.pagination       =   respuesta.pagination;
                        me.rows             =   respuesta.info.data;
                        $('#encuestas_agendadas').html(respuesta.nr_agendados);
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                filtrarDatos()
                {
                    let me  =   this;
                    me.cargarDatos();
                },
                //-------------------------------------------------------------------------------------------
                limpiarFiltros()
                {
                    let me  =   this;

                    me.fl_direccion         =   [];
                    me.fl_depto             =   [];
                    me.fl_servicio          =   [];
                    me.fl_macrozona         =   [];
                    me.fl_unidadvecinal     =   [];
                    me.fl_ticket            =   [];
                    me.arr_depto            =   [];
                    me.arr_servicio         =   [];
                    me.fl_ubicacion         =   [];
                    me.fl_motivo            =   [];
                    me.fl_persona           =   [];

                    me.cargarDatos();
                },
                //-------------------------------------------------------------------------------------------
                limpiarDatos(modelo)
                {
                    let me  =   this;

                    switch(modelo)
                    {
                        case 'encuesta':
                        {
                            me.arr_form         =   {};
                            me.btn_envio        =   0;
                            me.arr_solicitud    =   [];
                            me.str_indicacion   =   '';
                            me.str_observacion  =   '';
                            me.nr_prefijo       =   '';
                            me.nr_telefono      =   '';

                            break;
                        }
                        case 'archivo':
                        {
                            me.str_archivo      =   '';
                            me.arr_error        =   [];
                            me.arr_valida       =   [];
                            me.tp_error         =   0;                            
                            me.descartarAdjunto();

                            break;
                        }
                        case 'revisar':
                        {
                            me.arr_adjuntos     =   [];

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                ensamblarDatos(accion)
                {
                    let me          =   this;
                    var ruta        =   '';
                    var titulo      =   '';
                    var tiempo      =   3000;
                    var error       =   0;
                    var formData    =   new FormData();
                    var fc_format   =   'YYYY-MM-DD HH:mm:ss'; // 'DD-MM-YYYY HH:mm:ss';
                    //----------------------------------------------------------------
                    switch(accion)
                    {
                        case 'solicitud':
                        {
                            titulo  =   'Registrar Solicitud';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                // ruta    =   '/';                            
                                // me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                //formData.append('nm_direccion', me.getLabel(me.nr_direccion));
                                //------------------------------------
                                // me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'encuesta':
                        {
                            titulo  =   'Registrar Datos de Encuesta';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                me.btn_envio    =   1;
                                //------------------------------------
                                ruta    =   '/encuesta/store';
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                me.fc_encuesta.fc_termino   =   moment().locale('es').format(fc_format); // moment().tz("America/Santiago").format();
                                console.log(me.fc_encuesta);
                                //------------------------------------
                                formData.append('tp_parcial', 0);
                                formData.append('nr_solicitud', me.nr_solicitud);
                                formData.append('nr_ticket', me.nr_ticket);
                                formData.append('nr_rut', me.nr_rut);
                                formData.append('nr_prefijo', me.nr_prefijo);
                                formData.append('nr_telefono', me.nr_telefono);
                                formData.append('nr_estado', me.nr_estado_encuesta);
                                formData.append('str_observacion', me.str_observacion);
                                formData.append('arr_encuesta[]', JSON.stringify(me.paginationPreguntas));
                                formData.append('info_fechas[]', JSON.stringify(me.fc_encuesta));
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'parcial':
                        {
                            titulo  =   'Registrar Datos de Encuesta';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                me.btn_parcial    =   1;
                                //------------------------------------
                                ruta    =   '/encuesta/store';
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                me.fc_encuesta.fc_termino   =   moment().locale('es').format(fc_format); // moment().tz("America/Santiago").format();
                                console.log(me.fc_encuesta);
                                //------------------------------------
                                formData.append('tp_parcial', 1);
                                formData.append('nr_solicitud', me.nr_solicitud);
                                formData.append('nr_ticket', me.nr_ticket);
                                formData.append('nr_rut', me.nr_rut);
                                formData.append('nr_prefijo', me.nr_prefijo);
                                formData.append('nr_telefono', me.nr_telefono);
                                formData.append('nr_estado', me.nr_estado_encuesta);
                                formData.append('str_observacion', me.str_observacion);
                                formData.append('arr_encuesta[]', JSON.stringify(me.paginationPreguntas));
                                formData.append('info_fechas[]', JSON.stringify(me.fc_encuesta));
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'capturar':
                        {
                            titulo  =   'Encuesta de Servicio de Atención Vecino';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                ruta    =   '/encuestador/encuesta/capturar';
                                //------------------------------------
                                formData.append('nr_solicitud', me.nr_solicitud);
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'liberar':
                        {
                            titulo  =   'Encuesta de Servicio de Atención Vecino';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                ruta    =   '/encuestador/encuesta/liberar';
                                //------------------------------------
                                formData.append('nr_solicitud', me.nr_solicitud);
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'validar':
                        {
                            titulo  =   'Encuesta de Servicio de Atención Vecino';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                ruta    =   '/encuestador/encuesta/valida';
                                //------------------------------------
                                formData.append('nr_solicitud', me.nr_solicitud);
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                    }
                    //----------------------------------------------------------------
                },
                //-------------------------------------------------------------------------------------------
                validarDatos(tp_validacion)
                {
                    let me          =   this;
                    var error       =   0;
                    me.arr_valida   =   [];    
                    me.arr_form     =   {}; 
                    me.str_msj      =   '';

                    switch(tp_validacion)
                    {
                        case 'capturar':
                        case 'liberar':
                        case 'validar':
                        {
                            if(me.nr_solicitud == 0)
                                me.arr_form.nr_solicitud    =   'No se encuentra el Id de la Solicitud';

                            break;
                        }
                        case 'encuesta':
                        {
                            if(me.nr_solicitud == 0)
                                me.arr_form.nr_solicitud    =   'No se encuentra el Id de la Solicitud';

                            break;
                        }
                    }

                    if(Object.keys(me.arr_form).length != 0)
                        error   =   1;

                    return error;
                },
                //-------------------------------------------------------------------------------------------
                registrarDatos(ruta, formData)
                {
                    let me              =       this;
                    var tp_icon         =       '';
                    var titulo          =       '';
                    var mensaje         =       '';
                    var error           =       '';

                    axios.post(ruta, formData, {
                        headers: {'Content-Type': 'multipart/form-data'}
                    }).then(function (response) 
                    {
                        var result  =   response.data;                       
                        tp_icon     =   result.tp_icon;
                        titulo      =   result.title;
                        mensaje     =   result.msj;
                        error       =   result.error;

                        if(error != 2)
                        {
                            me.desplegarVentana(tp_icon, titulo, mensaje);

                            //Limpiar Modelos
                            if(error == 0)
                            {
                                me.limpiarDatos('encuesta');
                                me.refrescarDatos();
                                $('#modal_encuesta').modal('hide');
                                me.cerrarModal('encuesta');
                            }
                        }
                            
                        me.btn_envio        =   0;
                        me.btn_parcial      =   0;
                        me.tp_utilizar      =   0;
                    })
                    .catch(function (error) 
                    {
                        me.btn_envio        =   0;
                        me.btn_parcial      =   0;
                        me.tp_utilizar      =   0;

                        if (error.response.status == 422)
                            me.validationErrors = error.response.data.errors;
                        /*// Formato de Archivo Incorrecto
                        if (error.response.status == 413)
                        {
                            //------------------------------
                        }
                        */
                    });
                },
                //-------------------------------------------------------------------------------------------
                abrirModal(modelo, accion, data = [])
                {
                    let me      =   this;                    

                    switch(modelo)
                    {
                        case 'solicitud':
                        {
                            switch(accion)
                            {
                                case 'encuesta':
                                {
                                    me.tp_modal                 =   1;
                                    me.tp_accion                =   1;
                                    me.tp_btn                   =   0;
                                    me.btn_envio                =   0;
                                    me.btn_parcial              =   0;
                                    me.titulo_modal             =   'Encuesta de Servicio';
                                    me.limpiarDatos(accion);
                                    me.arr_solicitud            =   data;
                                    me.nr_solicitud             =   data.id;
                                    me.nr_ticket                =   data.nr_ticket;
                                    me.nr_rut                   =   data.nr_rut_vecino;
                                    if(data.vecino)
                                    {
                                        me.nr_prefijo           =   data.vecino.nr_prefijo;
                                        me.nr_telefono          =   data.vecino.nr_telefono;
                                    }
                                    me.ensamblarDatos('capturar');
                                    $('#modal_encuesta').modal('show');

                                    break;
                                }
                            }

                            break;
                        }
                        case 'archivo':
                        {
                            switch(accion)
                            {
                                case 'anexar':
                                {
                                    me.tp_modal             =   1;
                                    me.tp_accion            =   1;
                                    me.tp_btn               =   1;
                                    me.btn_envio            =   0;
                                    me.titulo_adjunto       =   'Adjuntar Documentos';
                                    me.tp_adjunto           =   'documento';
                                    me.limpiarDatos(modelo);
                                    $('#modal_adjunto').modal('show');

                                    break;
                                }
                                case 'revisar':
                                {
                                    me.tp_modal             =   1;
                                    me.tp_accion            =   1;
                                    me.tp_btn               =   1;
                                    me.btn_envio            =   0;
                                    me.titulo_adjunto       =   'Revisar Documentos';
                                    me.tp_adjunto           =   'archivos';
                                    me.limpiarDatos(modelo);
                                    me.arr_adjuntos         =   data.archivos;
                                    $('#modal_revisar').modal('show');

                                    break;
                                }
                            }

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                zonaDeEspera(titulo, tiempo)
                {
                    Swal.fire({
                        title : '<h5>'+titulo+'</h5>',
                        html: '<strong> </strong>',
                        showConfirmButton: false,
                        timer: tiempo,
                        onBeforOpen: () => {
                            Swal.showLoading()
                        },
                    }).then((result) => {
                        if(result.dismiss == Swal.DismissReason.timer)
                        {
                            //----------------------------------------
                        }
                    });
                },
                //-------------------------------------------------------------------------------------------
                desplegarVentana(tp_icon, titulo, mensaje, tp_btn = 1)
                {
                    Swal.fire({
                        icon: tp_icon,
                        title: titulo,
                        html: mensaje,
                        backdrop:false,
                        showConfirmButton: tp_btn
                    });                       
                },
                //-------------------------------------------------------------------------------------------
                setStyleCalificacion(str_campo)
                {
                    let me  =   this;

                    $(function() {
                        $('#'+str_campo).barrating('show', {
                            theme: 'fontawesome-stars',
                            showValues: false,
                            onSelect: function(value, text, event) {
                                if (typeof(event) !== 'undefined') {
                                    // rating was selected by a user
                                    console.log(event.target);
                                    console.log(value);
                                    console.log(text);
                                } else {
                                    // rating was selected programmatically
                                    // by calling `set` method
                                }
                            }
                        });
                    });
                },
                //-------------------------------------------------------------------------------------------
            },

            mounted() {
                let me = this;
                me.activeDatetimepicker();
                me.cargarResumenAgendados();
                me.cargarUsuario();
                me.cargarDatos();
                me.cargarDireccionesMunicipales();
                me.cargarPrioridad();
                me.cargarMotivo();
                me.cargarMacrozona();
                me.cargarUnidadVecinal();
                me.cargarTicket();
                me.cargarUbicaciones();
                me.cargarPersonas();
                me.cargarEncuesta();
                me.asyncDatos();
                me.cargarServicios(0,0);
            }
        });
    </script>

    <script type="text/javascript">
        //-----------------------------------------------------------------
        $(document).ready(function(){
            /*----- Inicio - Filtrar Datos-----*/
            $("#btn_filtrar_datos").click(function () {
                $content = $("#filtrar_datos");
                $content.slideToggle(500, function () {
                    // ---------------------------                    
                });
            });
            $("#close_filtrar_datos").click(function () {
                $content = $("#filtrar_datos");
                $content.slideToggle(500, function () {
                    // ---------------------------                    
                });
            });

            /*----- Inicio - Resumen - Año-Mes -----*/
            $(".anio-toggle").click(function() {
                $(this).next('.mes-container').slideToggle(500);
            });

            /*----- Inicio - Resumen - Mes-Dia -----*/
            $(".mes-toggle").click(function() {
                $(this).next('.dia-container').slideToggle(500);
            });

            /*----- Inicio - Modal -----*/
            $('#modal_encuesta').modal({backdrop: 'static', keyboard: false});
        });
        //-----------------------------------------------------------------
        function justNumbers(e)
        {
            var keynum = window.event ? window.event.keyCode : e.which;
            if (keynum == 8)
                return true;

            return /\d/.test(String.fromCharCode(keynum));
        }
        //-----------------------------------------------------------------
        function Rut(texto)
        { 
            var tmpstr = "";

            for ( i=0; i < texto.length ; i++ )   
                if ( texto.charAt(i) != ' ' && texto.charAt(i) != '.' && texto.charAt(i) != '-' )
                    tmpstr = tmpstr + texto.charAt(i);

            texto = tmpstr; 
            largo = texto.length; 

            if ( largo < 2 ) 
                return false; 

            for (i=0; i < largo ; i++ )    
                if (texto.charAt(i) !="0" && texto.charAt(i) != "1" && texto.charAt(i) !="2" && texto.charAt(i) != "3" && 
                    texto.charAt(i) != "4" && texto.charAt(i) !="5" && texto.charAt(i) != "6" && texto.charAt(i) != "7" && 
                    texto.charAt(i) !="8" && texto.charAt(i) != "9" && texto.charAt(i) !="k" && texto.charAt(i) != "K")   
                    return false;

            var invertido = "";

            for ( i=(largo-1),j=0; i>=0; i--,j++ )    
                invertido = invertido + texto.charAt(i);

            var dtexto = "";  
            dtexto = dtexto + invertido.charAt(0);  
            dtexto = dtexto + '-';  
            cnt = 0;  

            for ( i=1,j=2; i<largo; i++,j++ ) 
            { 
                if ( cnt == 3 )   
                {     
                    dtexto = dtexto + '.';      
                    j++;      
                    dtexto = dtexto + invertido.charAt(i);      
                    cnt = 1;    
                }   
                else    
                {       
                    dtexto = dtexto + invertido.charAt(i);      
                    cnt++;    
                } 
            } 

            invertido = "";

            for ( i=(dtexto.length-1),j=0; i>=0; i--,j++ )    
                invertido = invertido + dtexto.charAt(i);

            if (revisarDigito2(texto))
                return  invertido.toUpperCase();

            return false;
        }
        //-----------------------------------------------------------------
        function formatoMail(valor)
        {
            if (/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test(valor))
                return true;
            else
                return false;
        }
        //-----------------------------------------------------------------
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('template.home', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\repositorio\atencion_vecino\resources\views/encuestador/bandeja_agendados.blade.php ENDPATH**/ ?>