<?php $__env->startSection('body'); ?>
<div class="page-content">
    <div class="container-fluid" id="app">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18">Gestión de Servicios</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Gestión de Servicios</a></li>
                            <li class="breadcrumb-item active">Servicios</li>
                        </ol>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-12 col-sm-12" style="text-align:right">
                        <button id="btn_actualizar" class="btn btn-success btn_activo" @click="abrirModal('servicio', 'registrar')">
                            <i class="fas fa-sync"></i> Crear Servicio
                        </button>

                        <button id="btn_actualizar" class="btn btn-primary btn_activo" @click="refrescarDatos();">
                            <i class="fas fa-sync"></i> Actualizar
                        </button>

                        <button class="btn btn-primary btn_activo" id="btn_filtrar_datos">
                            <i class="fas fa-search"></i> Filtrar Datos
                        </button>
                    </div>
                </div>

                <div class="row">
                    <!-- Filtro de Datos -->
                    <div class="col-md-12 col-sm-12">
                        <div class="collapse" id="filtrar_datos">
                            <div class="card">
                                <div class="card-header bg-primary">
                                    <div class="col-md-12 col-sm-12 text-center">
                                        <h5 style="color: white;">Filtro de busqueda</h5>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row ml-2 mr-2">
                                        <div class="col-md-12 col-sm-12"> </div>
                                        <!-- Dirección Municipal -->
                                        <div class="col-md-4 col-sm-6">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Dirección Municipal :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_direccion"
                                                    :options="arr_direccion" 
                                                    @select="filtro_asyncDeptos" 
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Dirección Municipal"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                        <!-- Depto Municipal -->
                                        <div class="col-md-4 col-sm-6">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Depto Municipal :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_depto"
                                                    :options="fl_arr_deptos"
                                                    @select="asyncServicios" 
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Depto Municipal"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                        <!-- Tipo -->
                                        <div class="col-md-4 col-sm-6">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Tipo Solicitud :
                                                </label>
                                                <multiselect
                                                    :show-labels="false" 
                                                    :searchable="true" 
                                                    v-model="fl_servicio" 
                                                    :options="arr_servicio" 
                                                    :multiple="false" 
                                                    :showNoOptions="false" 
                                                    placeholder="Tipo Solicitud" 
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div style="float: right;">
                                        <button @click="limpiarFiltros()" type="button" class="btn btn-warning btn-sm btn_activo" style="color: white;">
                                            <i class="fas fa-undo"></i> Quitar Filtros
                                        </button>&nbsp;
                                        <button @click="filtrarDatos()" type="button" class="btn btn-primary btn-sm btn_activo"><i class="fas fa-search"></i>
                                            Filtrar Búsqueda
                                        </button>

                                        <button class="btn btn-secondary btn-sm btn_activo" id="close_filtrar_datos">
                                            Cerrar Filtro
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Tabla de Datos -->
                    <div class="responsive-table">
                        <table  class="table table-bordered border-info table-striped table-sm table-hover bl-1">
                            <thead class="bg-primary">
                                <th colspan="8" >
                                    <h6 class="text-center" style="color:white" >
                                        Listado de Servicios
                                    </h6>
                                </th>
                            </thead>
                            <thead class="bg-primary"  style="color:white">
                                <th class="text-center"> # </th>
                                <th class="text-center">Opciones</th>
                                <th class="text-center">Dirección Municipal</th>
                                <th class="text-center">Departamento</th>
                                <th class="text-center">Servicio</th>
                                <th class="text-center">Macrozona</th>
                                <th class="text-center">Asignador</th>
                                <th class="text-center">Estado</th>
                            </thead>
                            <tbody>
                                <template v-if="arr_index.length">
                                    <tr v-for="(datos, index) in arr_index" :key="datos.id">
                                        <td style="text-align:center;">
                                            {{ (index + 1) }}
                                        </td>
                                        <td style="text-align:center;">
                                            <div class="dropdown">
                                                <button class="btn btn-secondary" type="button" id="menu_opcion" data-bs-toggle="dropdown" aria-expanded="false">
                                                    Opción <i class="mdi mdi-chevron-down"></i>
                                                </button>
                                                <div class="dropdown-menu" aria-labelledby="menu_opcion">
                                                    <!-- Actualizar Usuario -->
                                                    <a href="#" class="dropdown-item" 
                                                        @click="abrirModal('servicio', 'actualizar', datos)">
                                                            <i class="fas fa-edit" style="color: blue;"></i>
                                                            Actualizar Servicio
                                                    </a>

                                                    <!-- Inhabilitar Usuario -->
                                                    <a href="#" class="dropdown-item" v-if="datos.tp_activo == 1" 
                                                        @click="abrirModal('servicio', 'inhabilitar', datos)">
                                                            <i class="far fa-minus-square" style="color: red;"></i>
                                                            Inhabilitar Servicio
                                                    </a>
                                                    
                                                    <!-- Habilitar Usuario -->
                                                    <a href="#" class="dropdown-item" v-if="datos.tp_activo == 0" 
                                                        @click="abrirModal('servicio', 'habilitar', datos)">
                                                            <i class="far fa-plus-square" style="color: green;"></i>
                                                            Habilitar Servicio
                                                    </a>
                                                </div>
                                            </div>
                                        </td>
                                         <td style="text-align:left;">
                                            {{ datos.nm_direccion }}
                                        </td>
                                        <td  style="text-align:left; color: black;">
                                            {{ datos.nm_depto }}
                                        </td>                                        
                                        <td style="text-align:left; max-width: 350px;">
                                            {{ datos.nm_tipo }}
                                        </td>
                                        <td style="text-align:center;">
                                            <template v-if="datos.tp_macrozona == 1">SI</template>
                                            <template v-else>NO</template>
                                        </td>
                                        <td style="text-align:center;">
                                            <template v-if="datos.tp_asignacion == 1">SI</template>
                                            <template v-else>NO</template>
                                        </td>
                                        <td style="text-align:center;">
                                            <template v-if="datos.tp_activo == 1">Habilitado</template>
                                            <template v-else>Inhabilitado</template>
                                        </td>
                                    </tr>
                                </template>
                                <template v-else>
                                    <tr>
                                        <td colspan="8">
                                            <h5 class="text-center">
                                                No hay datos para listar
                                            </h5>
                                        </td>
                                    </tr>
                                </template>
                            </tbody>
                        </table>
                    </div>

                    <!-- Paginacion -->
                    <div class="col-md-12 col-sm-12">
                        <nav>
                            <ul class="pagination">
                                <li class="page-item" v-if="pagination.current_page > 1">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.current_page - 1)">Ant</a>
                                </li>
                                <li class="page-item" v-for="page in pagesNumber" :key="page" :class="[page == isActivedPagination ? 'active' : '']">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(page, 1)" v-text="page"></a>
                                </li>
                                <li class="page-item" v-if="pagination.current_page < pagination.last_page">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.current_page + 1)">Sig</a>
                                </li>
                            </ul>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal" tabindex="-1" id="modal_servicios">
            <div class="modal-dialog modal-dialog-scrollable modal-xl">
                <div class="modal-content">
                    <div class="modal-header bg-primary">
                        <h5 class="modal-title text-white">{{ titulo_modal }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="col-md-12 col-sm-12 mt-2">
                            <div class="row-flow">
                                <!-- Información del Servicio -->
                                <div class="card mt-2 border-info">
                                    <div class="card-header bg-primary border-info">
                                        <div class="form-check form-check-inline">
                                            <h5 class="form-check-label text-white">Información del Servicio</h5>
                                        </div>
                                    </div>

                                    <div class="card-body">
                                        <div class="row" >
                                            <!-- Direccion Municipal -->
                                            <div class="col-md-6 col-sm-12 mt-2">
                                                <div class="form-group">
                                                    <label>Dirección Municipal</label>
                                                    <multiselect 
                                                        :show-labels="false"
                                                        :searchable="true"
                                                        v-model="nr_direccion"
                                                        :options="arr_direccion"
                                                        :multiple="false"
                                                        :showNoOptions ="false" 
                                                        @select="asyncDeptos" 
                                                        placeholder="Seleccionar Dirección Municipal"
                                                        label="label"                                                                 
                                                        track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                    </multiselect>
                                                    <small class="text-error text-danger" v-if="arr_valida.nr_direccion" v-text="arr_valida.nr_direccion[0]"></small>
                                                    <small class="text-error text-danger" v-if="arr_form.nr_direccion"  v-text="arr_form.nr_direccion"></small>
                                                </div>
                                            </div>
                                            
                                            <!-- Depto Municipal -->
                                            <div class="col-md-6 col-sm-12 mt-2">
                                                <div class="form-group">
                                                    <label>Depto Municipal</label>
                                                    <multiselect 
                                                        :disabled="(getValue(nr_direccion) == 0)"
                                                        :show-labels="false"
                                                        :searchable="true"
                                                        v-model="nr_depto"
                                                        :options="arr_depto"
                                                        :multiple="false"
                                                        :showNoOptions ="false" 
                                                        @select="asyncFuncionarios"
                                                        placeholder="Seleccionar Depto Municipal"
                                                        label="label"                                                                 
                                                        track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                    </multiselect>
                                                    <small class="text-error text-danger" v-if="arr_valida.nr_depto" v-text="arr_valida.nr_depto[0]"></small>
                                                    <small class="text-error text-danger" v-if="arr_form.nr_depto"  v-text="arr_form.nr_depto"></small>
                                                </div>
                                            </div>
                                            <!-- Servicio -->
                                            <div class="col-md-12 col-sm-12 mt-2">
                                                <div class="form-group">
                                                    <label>Servicio</label>
                                                    <input type="text" maxlength="500" class="form-control" v-model="nm_servicio" :disabled="(getValue(nr_depto) == 0)">
                                                    <small class="text-error text-danger" v-if="arr_valida.nm_servicio" v-text="arr_valida.nm_servicio[0]"></small>
                                                    <small class="text-error text-danger" v-if="arr_form.nm_servicio"  v-text="arr_form.nm_servicio"></small>
                                                </div>
                                            </div>
                                            <!-- Requiere Ubicación -->
                                            <div class="col-md-3 col-sm-3 mt-4">
                                                <div class="row justify-content-center">
                                                    <label class="text-small text-center col-12">Requiere Ubicación</label>
                                                    <label class="switch">
                                                        <input type="checkbox" id="tp_ubicacion" v-model="tp_ubicacion">
                                                        <span class="slider round"></span>
                                                    </label>
                                                </div>
                                            </div>
                                            <!-- Requiere Validacion de Macrozona -->
                                            <div class="col-md-3 col-sm-3 mt-4">
                                                <div class="row justify-content-center">
                                                    <label class="text-small text-center col-12">Requiere Macrozona</label>
                                                    <label class="switch">
                                                        <input type="checkbox" id="tp_macrozona" v-model="tp_macrozona">
                                                        <span class="slider round"></span>
                                                    </label>
                                                </div>
                                            </div>
                                            <!-- Requiere Asignación -->
                                            <div class="col-md-3 col-sm-3 mt-4">
                                                <div class="row justify-content-center">
                                                    <label class="text-small text-center col-12">Requiere Asignación</label>
                                                    <label class="switch">
                                                        <input type="checkbox" id="tp_asignacion" v-model="tp_asignacion">
                                                        <span class="slider round"></span>
                                                    </label>
                                                </div>
                                            </div>
                                            <!-- Trabaja con Respuesta -->
                                            <div class="col-md-3 col-sm-3 mt-4">
                                                <div class="row justify-content-center">
                                                    <label class="text-small text-center col-12">Respuesta Automatica</label>
                                                    <label class="switch">
                                                        <input type="checkbox" id="tp_respuesta" v-model="tp_respuesta">
                                                        <span class="slider round"></span>
                                                    </label>
                                                </div>
                                            </div>
                                            <!-- Requiere Visto Bueno Director -->
                                            <!--
                                            <div class="col-md-3 col-sm-6 mt-2">
                                                <div class="row justify-content-center">
                                                    <label class="text-small text-center col-12">Requiere V.B. Director</label>
                                                    <label class="switch">
                                                        <input type="checkbox" id="tp_director" v-model="tp_director">
                                                        <span class="slider round"></span>
                                                    </label>
                                                </div>
                                            </div>
                                            -->
                                            <!-- Requiere Visto Bueno Jefe -->
                                            <!--
                                            <div class="col-md-3 col-sm-6 mt-2">
                                                <div class="row justify-content-center">
                                                    <label class="text-small text-center col-12">Requiere V.B. Jefe Depto</label>
                                                    <label class="switch">
                                                        <input type="checkbox" id="tp_depto" v-model="tp_depto">
                                                        <span class="slider round"></span>
                                                    </label>
                                                </div>
                                            </div>
                                            -->
                                            <!-- Explicación Servicio -->
                                            <div class="col-md-12 col-sm-12 mt-2">
                                                <div class="form-group">
                                                    <label>Explicación del Servicio</label>
                                                    <div id="txt_servicio"></div>
                                                    <small class="form-text text-muted">
                                                        <span>Cantidad maxima de caracteres a utilizar 1000</span>
                                                    </small> 
                                                    <small class="text-error text-danger" v-if="arr_form.str_servicio"  v-text="arr_form.str_servicio"></small>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Funcionarios Asignados al Servicio -->
                                <div class="card mt-4">
                                    <div class="card-header bg-primary" style="color:white">
                                        <div class="form-check form-check-inline">
                                            <h5 class="form-check-label text-white">Asignación de Funcionarios al Servicio</h5>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <!-- Registro de Asignación de usuarios -->
                                            <div class="col-lg-12 col-md-12 col-sm-12">
                                                <!-- funcionarios -->
                                                <div class="row">
                                                    <div class="col-md-10 col-sm-12 mt-2">
                                                        <div class="form-group">
                                                            <label>Funcionarios</label>
                                                            <multiselect 
                                                                :show-labels="false"
                                                                :searchable="true"
                                                                v-model="nr_funcionario"
                                                                :options="arr_personal"
                                                                :multiple="true"
                                                                :showNoOptions ="false" 
                                                                placeholder="Seleccionar Funcionario"
                                                                label="label"                                                                 
                                                                track-by="label">
                                                                <span slot="noResult">No se han encontrado resultados</span>
                                                            </multiselect>
                                                            <small class="text-error text-danger" v-if="arr_valida.nr_funcionario" v-text="arr_valida.nr_funcionario[0]"></small>
                                                            <small class="text-error text-danger" v-if="arr_form.nr_funcionario"  v-text="arr_form.nr_funcionario"></small>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2 col-sm-12 mt-2 pt-4">
                                                        <button type="button" class="btn btn-success waves-effect waves-light col-12" 
                                                            @click="agregarFuncionario()">
                                                            <i class="fas fa-portrait"></i> Asignar
                                                        </button>
                                                    </div>
                                                </div>

                                                <div class="col-lg-12 col-md-12 col-sm-12 table-responsive mt-2">
                                                    <table class="table table-bordered table-striped table-sm">
                                                        <thead>
                                                            <tr class="bg-primary">
                                                                <th colspan="5" class="text-center" style="color: white;">Lista de Funcionarios</th>
                                                            </tr>
                                                            <tr>
                                                                <th style="min-width:100px; text-align:center;">#</th>
                                                                <th style="min-width:100px; text-align:center;">Opción</th>
                                                                <th style="min-width:150px; text-align:center;">Dirección</th>
                                                                <th style="min-width:200px; text-align:center;">Departamento</th>
                                                                <th style="min-width:100px; text-align:center;">Nombre</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <template v-if="arr_seleccionados.length">
                                                                <tr v-for="(seleccionado, index) in arr_seleccionados" :key="seleccionado.value">
                                                                    <td class="text-center">{{ (index + 1) }}</td>
                                                                    <td class="text-center">
                                                                        <button type="button" class="btn btn-success  waves-effect waves-light" title="Desasignar" 
                                                                            @click="quitarFuncionario(1, index)">
                                                                            <i class="fas fa-user-times"></i>
                                                                        </button>
                                                                    </td>
                                                                    <td class="text-center">{{ seleccionado.nm_direccion }}</td>
                                                                    <td class="text-center">{{ seleccionado.nm_depto }}</td>
                                                                    <td class="text-center">{{ seleccionado.name }}</td>
                                                                </tr>
                                                            </template>
                                                            <template v-if="arr_asignados.length">
                                                                <tr v-for="(asignado, index) in arr_asignados" :key="asignado.id">
                                                                    <td class="text-center">{{ (index + 1) }}</td>
                                                                    <td class="text-center">
                                                                        <button type="button" class="btn btn-danger waves-effect waves-light" title="Desasignar" 
                                                                            @click="abrirModal('servicio','desasignar',asignado)">
                                                                            <i class="fas fa-portrait"></i>
                                                                        </button>
                                                                    </td>
                                                                    <td class="text-center">{{ asignado.nm_direccion }}</td>
                                                                    <td class="text-center">{{ asignado.nm_depto }}</td>
                                                                    <td class="text-center">{{ asignado.name }}</td>
                                                                </tr>
                                                            </template>
                                                            <template v-else>
                                                                <td colspan="5">
                                                                    <div class="empty" empty-text="No hay datos para listar"></div>
                                                                </td>
                                                            </template>
                                                        </tbody>
                                                    </table>
                                                </div>

                                                 <small class="text-error text-danger" v-if="arr_form.arr_seleccionados"  v-text="arr_form.arr_seleccionados"></small>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Respuestas Automatica del servicio -->
                                <div class="card mt-2 border-info" v-if="tp_servicio === 1">
                                    <div class="card-header bg-primary border-info">
                                        <div class="form-check form-check-inline">
                                            <h5 class="form-check-label text-white">Respuestas Automaticas : Publicaciones Parciales del Servicio</h5>
                                        </div>
                                    </div>

                                    <div class="card-body">
                                        <div class="row" >
                                            <div class="col-md-12 col-sm-12">
                                                <div class="row mb-2">
                                                    <div class="col-md-12 col-sm-12 text-center">
                                                        <button class="btn btn-success btn_activo" @click="abrirModal('respuesta', 'modal_respuesta')">
                                                            <i class="fas fa-edit"></i> Crear Respuesta
                                                        </button>
                                                    </div>
                                                </div>

                                                <div class="col-lg-12 col-md-12 col-sm-12 table-responsive mt-2">
                                                    <table class="table table-bordered border-info table-striped table-sm table-hover bl-1">
                                                        <thead>
                                                            <tr class="bg-primary">
                                                                <th colspan="5" class="text-center" style="color: white;">Lista de Respuestas</th>
                                                            </tr>
                                                            <tr>
                                                                <th class="text-center" style="min-width:100px;">#</th>
                                                                <th class="text-center" style="min-width:150px;">Opción</th>
                                                                <th class="text-center" style="min-width:150px;">Respuesta</th>
                                                                <th class="text-center" style="min-width:100px;">Tiempo</th>
                                                                <th class="text-center" style="min-width:100px;">Estado</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <template v-if="arr_respuestas.length">
                                                                <tr v-for="(datos, index) in arr_respuestas" :key="datos.value">
                                                                    <td class="text-center">{{ (index + 1) }}</td>
                                                                    <td style="text-align:center;">
                                                                        <div class="dropdown">
                                                                            <button class="btn btn-secondary" type="button" id="menu_respuesta" data-bs-toggle="dropdown" aria-expanded="false">
                                                                                Opción <i class="mdi mdi-chevron-down"></i>
                                                                            </button>
                                                                            <div class="dropdown-menu" aria-labelledby="menu_respuesta">
                                                                                <!-- Revisar respuesta -->
                                                                                <a href="#" class="dropdown-item" 
                                                                                    @click="abrirModal('respuesta', 'actualizar_respuesta', datos)">
                                                                                        <i class="fas fa-history" style="color: blue;"></i>
                                                                                        Revisar respuesta
                                                                                </a>
                                                                                <!-- Deshabilitar Respuesta -->
                                                                                <a href="#" class="dropdown-item" v-if="datos.tp_activo == 1" 
                                                                                    @click="abrirModal('respuesta', 'deshabilitar_respuesta', datos)">
                                                                                        <i class="far fa-minus-square" style="color: red;"></i>
                                                                                        Deshabilitar Respuesta
                                                                                </a>
                                                                                <!-- Habilitar Respuesta -->
                                                                                <a href="#" class="dropdown-item" v-if="datos.tp_activo == 0" 
                                                                                    @click="abrirModal('respuesta', 'habilitar_respuesta', datos)">
                                                                                        <i class="far fa-plus-square" style="color: green;"></i>
                                                                                        Habilitar Respuesta
                                                                                </a>
                                                                            </div>
                                                                        </div>
                                                                    </td>
                                                                    <td class="text-left">
                                                                        <template v-if="getCantidadCaracteres(datos.str_respuesta) < 300">
                                                                            <span class="text-justify" v-html="datos.str_respuesta_html"></span>
                                                                        </template>
                                                                        <template v-else>
                                                                            <template v-if="tp_resumir_respuesta == 1">
                                                                                {{ datos.str_respuesta | resumir }}
                                                                                <div class="col-md-12" style="text-align: right;">
                                                                                    <a href="#" class="link-primary" @click="tp_resumir_respuesta = 0"> Leer más</a>
                                                                                </div>
                                                                            </template>
                                                                            <template v-else>
                                                                                <span class="text-justify" v-html="datos.str_respuesta_html"></span>
                                                                                <div class="col-md-12" style="text-align: right;">
                                                                                    <a href="#" class="link-primary" @click="tp_resumir_respuesta = 1"> Leer menos</a>
                                                                                </div>
                                                                            </template>
                                                                        </template>
                                                                    </td>
                                                                    <td class="text-center">{{ datos.str_tiempo }}</td>
                                                                    <td class="text-center">{{ datos.nm_estado }}</td>
                                                                </tr>
                                                            </template>
                                                            <template v-else>
                                                                <td colspan="5">
                                                                    <div class="empty" empty-text="No hay datos para listar"></div>
                                                                </td>
                                                            </template>
                                                        </tbody>
                                                    </table>

                                                    <!-- Paginacion -->
                                                    <div class="col-md-12 col-sm-12">
                                                        <nav>
                                                            <ul class="pagination">
                                                                <li class="page-item" v-if="paginationRespuestas.current_page > 1">
                                                                    <a class="page-link" href="#" @click.prevent="cambiarPaginaRespuestas(paginationRespuestas.current_page - 1)">Ant</a>
                                                                </li>
                                                                <li class="page-item" v-for="page in pagesNumberRespuestas" :key="page" :class="[page == isActivedPaginationRespuestas ? 'active' : '']">
                                                                    <a class="page-link" href="#" @click.prevent="cambiarPaginaRespuestas(page, 1)" v-text="page"></a>
                                                                </li>
                                                                <li class="page-item" v-if="paginationRespuestas.current_page < paginationRespuestas.last_page">
                                                                    <a class="page-link" href="#" @click.prevent="cambiarPaginaRespuestas(paginationRespuestas.current_page + 1)">Sig</a>
                                                                </li>
                                                            </ul>
                                                        </nav>
                                                    </div>
                                                </div>

                                                    
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>                        
                    </div>
                    <div class="modal-footer">
                        <div class="col-lg-12 col-md-12 col-sm-12" style="text-align: center;">
                            <template v-if="tp_accion == 1">
                                <button v-if="btn_envio == 0" type="button" class="btn btn-success col-md-8 waves-effect waves-light" @click="ensamblarDatos('registrar')">
                                    <i class="fas fa-save"></i> Registrar
                                </button>
                                <button v-else type="button"  class="btn btn-success">Registrando <i class="fas fa-spin fa-spinner"></i></button>
                            </template>
                            <template v-else>
                                <button v-if="btn_envio == 0" type="button" class="btn btn-success col-md-8 waves-effect waves-light" @click="ensamblarDatos('actualizar')">
                                    <i class="fas fa-edit"></i> Actualizar
                                </button>
                                <button v-else type="button"  class="btn btn-success">Actualizando <i class="fas fa-spin fa-spinner"></i></button>
                            </template>
                            <button type="button" class="btn btn-secondary" style="float: right;" @click="cerrarModal('servicio')">Cerrar</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal" tabindex="-1" id="modal_respuesta" role="dialog">
            <div class="modal-dialog modal-dialog-scrollable modal-lg mt-5">
                <div class="modal-content" style="border: 2px solid #a79fcd;">
                  <div class="modal-header bg-primary">
                    <h5 class="modal-title text-white">{{ titulo_modal_respuesta }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                  </div>
                  <div class="modal-body">
                        <div class="col-md-12 col-sm-12 mt-2">
                            <div class="row">
                                <!-- Tiempo de Ejecución -->
                                <div class="col-md-6 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>Tiempo de Activación</label>
                                        <multiselect 
                                            :show-labels="false"
                                            :searchable="true"
                                            v-model="nr_tiempo"
                                            :options="arr_tiempo"
                                            :multiple="false"
                                            :showNoOptions ="false" 
                                            placeholder="Seleccionar Tiempo de Activación"
                                            label="label"                                                                 
                                            track-by="label">
                                            <span slot="noResult">No se han encontrado resultados</span>
                                        </multiselect>
                                        <small class="text-error text-danger" v-if="arr_valida.nr_tiempo" v-text="arr_valida.nr_tiempo[0]"></small>
                                        <small class="text-error text-danger" v-if="arr_form.nr_tiempo"  v-text="arr_form.nr_tiempo"></small>
                                    </div>
                                </div>
                                <!-- Descripcion Solicitud -->
                                <div class="col-md-12 mt-2">
                                    <div class="form-group">
                                        <label>Descripción de la Respuesta</label> <br>
                                        <div id="txt_respuesta"></div>
                                        <small class="form-text text-muted">
                                            <span>Cantidad maxima de caracteres a utilizar 2000</span>
                                        </small> 
                                        <small class="text-error text-danger" v-if="arr_form.str_respuesta"  v-text="arr_form.str_respuesta"></small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <div class="col-lg-12 col-md-12 col-sm-12" style="text-align: center;">
                            <template v-if="tp_accion_respuesta == 1">
                                <button v-if="btn_respuesta == 0 " type="button" class="btn btn-success  waves-effect waves-light col-8" @click="ensamblarDatos('registrar_respuesta')">
                                    <i class="fas fa-save"></i> Registrar 
                                </button>
                                <button v-else type="button"  class="btn btn-success">Registrando <i  class="fas fa-spin fa-spinner col-8"></i></button>
                            </template>
                            <template v-if="tp_accion_respuesta == 2">
                                <button v-if="btn_respuesta == 0 " type="button" class="btn btn-success  waves-effect waves-light col-8" @click="ensamblarDatos('actualizar_respuesta')">
                                    <i class="fas fa-save"></i> Actualizar 
                                </button>
                                <button v-else type="button"  class="btn btn-success">Actualizando <i  class="fas fa-spin fa-spinner col-8"></i></button>
                            </template>
                            <button type="button" class="btn btn-secondary" style="float: right;" data-bs-dismiss="modal">Cerrar</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    <style type="text/css">
        .switch {
            position: relative;
            display: inline-block;
            width: 60px;
            height: 34px;
        }

        .switch input { 
            opacity: 0;
            width: 0;
            height: 0;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            -webkit-transition: .4s;
            transition: .4s;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 26px;
            width: 26px;
            left: 4px;
            bottom: 4px;
            background-color: white;
            -webkit-transition: .4s;
            transition: .4s;
        }

        input:checked + .slider {
            background-color: #2196F3;
        }

        input:focus + .slider {
            box-shadow: 0 0 1px #2196F3;
        }

        input:checked + .slider:before {
            -webkit-transform: translateX(26px);
            -ms-transform: translateX(26px);
            transform: translateX(26px);
        }

        /* Rounded sliders */
        .slider.round {
            border-radius: 34px;
        }

        .slider.round:before {
            border-radius: 50%;
        }
    </style>

    <script type="text/javascript">
        Vue.component('vue-multiselect', window.VueMultiselect.default);

        var app = new Vue({
            el: '#app',
            data: {
                //-------------------------------------
                tp_modal                    :   0,
                tp_accion                   :   0,
                tp_btn                      :   0,
                titulo_modal                :   '',
                titulo_modal_respuesta      :   '',
                //-------------------------------------
                btn_envio                   :   0,
                btn_respuesta               :   0,
                //-------------------------------------
                tp_accion_respuesta         :   0,
                //-------------------------------------
                arr_valida                  :   [],
                arr_error                   :   [],
                arr_form                    :   {},
                str_msj                     :   '',
                //-------------------------------------
                pagination                  : {
                    'total' : 0,
                    'current_page' : 0,
                    'per_page' : 0,
                    'last_page' : 0,
                    'from' : 0,
                    'to' : 0,
                },
                //-------------------------------------
                paginationRespuestas        : {
                    'total' : 0,
                    'current_page' : 0,
                    'per_page' : 0,
                    'last_page' : 0,
                    'from' : 0,
                    'to' : 0,
                },
                //-------------------------------------
                offset                      :   3,
                //-------------------------------------
                tp_tinymce                  :   0,
                //-------------------------------------
                fl_direccion                :   [],
                fl_depto                    :   [],
                fl_servicio                 :   [],
                fl_arr_deptos               :   [],
                //-------------------------------------
                arr_index                   :   [],
                arr_direccion               :   [],
                arr_depto                   :   [],
                arr_servicio                :   [],
                arr_funcionario             :   [],
                arr_personal                :   [],
                arr_seleccionados           :   [],
                arr_asignados               :   [],
                arr_respuestas              :   [],
                arr_info                    :   null,
                //-------------------------------------
                nr_servicio                 :   0,
                nr_direccion                :   [],
                nr_depto                    :   [],
                nr_funcionario              :   [],
                nr_usuario                  :   0,
                nm_usuario                  :   '',
                nm_servicio                 :   '',
                str_servicio                :   '',
                tp_ubicacion                :   true,
                tp_macrozona                :   false,
                tp_asignacion               :   false,
                tp_respuesta                :   false,
                tp_director                 :   false,
                tp_depto                    :   false,
                tp_activo                   :   0,
                //-------------------------------------
                tp_servicio                 :   0,
                nr_respuesta                :   0,
                tp_publicacion              :   2,
                //-------------------------------------
                nr_nivel                    :   {
                    value : 1,
                    label : 'Solo Nivel 1',
                },
                arr_nivel                   :   [
                    {
                        value : 1,
                        label : 'Solo Nivel 1',
                    },
                    {
                        value : 2,
                        label : 'Hasta Nivel 2',
                    },
                    {
                        value : 3,
                        label : 'Hasta Nivel 3',
                    },
                ],
                //-------------------------------------
                nr_tiempo                   :   {
                    value : 24,
                    label : '24 Hrs',
                },
                arr_tiempo                  :   [
                    {
                        value : 12,
                        label : '12 Hrs',
                    },
                    {
                        value : 24,
                        label : '24 Hrs',
                    },
                    {
                        value : 36,
                        label : '36 Hrs',
                    },
                    {
                        value : 48,
                        label : '48 Hrs',
                    },
                ],
                //-------------------------------------
                tp_resumir_respuesta        :   1,
                //-------------------------------------
            },

            components: {
                Multiselect: window.VueMultiselect.default
            },

            filters:{
                resumir: function (texto, limite=300, final=' ...')
                {
                    let me  = this;
                    var largo = texto.toString().length;
                    if(largo > limite){
                        for (var i = 0; i < largo; i++) {
                            if(texto[i] == ' ' && i >= limite) {
                                texto   =   texto.substring(0,i);
                                texto   =   texto + final;
                                return texto;
                            }
                        }                    
                    }
                    return texto;
                },

                formatDate: function (fecha)
                {
                    if(fecha)
                        return moment(String(fecha)).format('DD-MM-YYYY')
                },

                formatDateTime: function (fecha)
                {
                    if(fecha)
                    {
                        return moment(String(fecha)).format('DD-MM-YYYY HH:mm')
                    }
                },
            },

            computed:{
                //-------------------------------------------------------------------------------------------
                isActivedPagination: function()
                {
                    return this.pagination.current_page;
                },
                //-------------------------------------------------------------------------------------------
                isActivedPaginationRespuestas: function()
                {
                    return this.paginationRespuestas.current_page;
                },
                //-------------------------------------------------------------------------------------------
                pagesNumber: function()
                {
                    if(!this.pagination.to) {
                        return [];
                    }

                    var from = this.pagination.current_page - this.offset;
                    if(from < 1) {
                        from = 1;
                    }

                    var to = from + (this.offset * 2);
                    if(to >= this.pagination.last_page){
                        to = this.pagination.last_page;
                    }

                    var pagesArray = [];
                    while(from <= to) {
                        pagesArray.push(from);
                        from++;
                    }
                    return pagesArray;
                }, 
                //-------------------------------------------------------------------------------------------
                pagesNumberRespuestas: function()
                {
                    if(!this.paginationRespuestas.to) {
                        return [];
                    }

                    var from = this.paginationRespuestas.current_page - this.offset;
                    if(from < 1) {
                        from = 1;
                    }

                    var to = from + (this.offset * 2);
                    if(to >= this.paginationRespuestas.last_page){
                        to = this.paginationRespuestas.last_page;
                    }

                    var pagesArray = [];
                    while(from <= to) {
                        pagesArray.push(from);
                        from++;
                    }
                    return pagesArray;
                }, 
                //-------------------------------------------------------------------------------------------
            },

            methods: {
                //-------------------------------------------------------------------------------------------
                getCantidadCaracteres(str_contenido = '')
                {
                    var cantidad    =   0;

                    if(!str_contenido)
                        return cantidad;

                    if(str_contenido.trim().length)
                        cantidad    =   str_contenido.trim().length;

                    return cantidad;
                },
                //-------------------------------------------------------------------------------------------
                existeTextArea(tp_accion = 1)
                {
                    let me  =   this;

                    switch(tp_accion)
                    {
                        case 1:
                        {
                            if($('#str_servicio'))
                            {
                                console.log('Existe textArea : #str_servicio');

                                activeTextArea();
                            }
                            else
                            {
                                console.log('NO existe textArea : #str_servicio');
                            }

                            break;
                        }
                        case 2:
                        {
                            if($('#str_respuesta'))
                            {
                                console.log('Existe textArea : #str_respuesta');

                                activeTextArea();
                            }
                            else
                            {
                                console.log('NO existe textArea : #str_respuesta');
                            }

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                cargarTextArea(tp_accion = 1)
                {
                   $("#txt_servicio").html('<textarea class="form-control tinymce" maxlength="500" rows="2" id="str_servicio" disabled="true"></textarea>');
                   $("#txt_respuesta").html('<textarea class="form-control tinymce" maxlength="2000" rows="2" id="str_respuesta" disabled="true"></textarea>');
                },
                //-------------------------------------------------------------------------------------------
                setScrollTo(tag_id)
                {
                    // var container   =   $('.modal #historia_solicitud'); // $('html, body, .main-content');
                    // var scrollTo    =   $('#' + tag_id);

                    $("#" + tag_id).animate({
                        scrollTop: $(document).height()
                    }, 500);

                    // container.animate({scrollTop : $('#' + tag_id).offset().top +1000 }, 'slow');
                },
                //-------------------------------------------------------------------------------------------
                cambiarPagina(page)
                {
                    let me  =   this;
                    me.pagination.current_page = page;
                    me.cargarDatos(page);
                },
                //-------------------------------------------------------------------------------------------
                cambiarPaginaRespuestas(page)
                {
                    let me  =   this;
                    me.paginationRespuestas.current_page = page;
                    me.cargarRespuestas(page);
                },
                //-------------------------------------------------------------------------------------------
                refrescarDatos()
                {
                    let me  =   this;
                    me.cargarDireccionesMunicipales();
                    me.cargarDatos();
                    me.cargarRespuestas();
                    me.cargarPendientes();
                },
                //-------------------------------------------------------------------------------------------
                getLabel(data)
                {
                    var valor   =   '';

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.label;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                getValue(data)
                {
                    var valor   =   0;

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.value;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                cerrarModal(modelo)
                {
                    let me  =   this;

                    switch(modelo)
                    {
                        case 'servicio':
                        {
                            // tinymce.remove('#str_servicio');
                            // $('str_servicio').remove();
                            $('#modal_servicios').modal('hide');

                            break;
                        }
                        case 'respuestas':
                        {
                            $('#modal_respuesta').modal('hide');

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                agregarFuncionario()
                {
                    let me      =   this;
                    var temp    =   [];

                    if(me.nr_funcionario.length)
                    {
                        if(me.arr_asignados.length)
                        {
                            me.arr_seleccionados    =   me.arr_seleccionados.concat(me.nr_funcionario);
                            temp                    =   temp.concat(me.arr_asignados, me.nr_funcionario);

                            me.nr_funcionario       =   [];
                            me.arr_personal         =   me.arr_funcionario.filter(
                                                            (funcionario) => !temp.find(
                                                                ({ value }) => funcionario.value === value
                                                            )
                                                        );
                        }
                        else
                        {
                            me.arr_seleccionados    =   me.arr_seleccionados.concat(me.nr_funcionario);
                            me.nr_funcionario       =   [];
                            me.arr_personal         =   me.arr_funcionario.filter(
                                                            (funcionario) => !me.arr_seleccionados.find(
                                                                ({ value }) => funcionario.value === value
                                                            )
                                                        );
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                quitarFuncionario(tp_accion, index)
                {
                    let me      =   this;
                    var temp    =   [];

                    me.arr_seleccionados.splice(index, 1);

                    if(me.arr_asignados.length)
                    {
                        temp    =   temp.concat(me.arr_asignados, me.arr_seleccionados);

                        me.arr_personal     =   me.arr_funcionario.filter(
                                                    (funcionario) => !temp.find(
                                                        ({ value }) => funcionario.value === value
                                                    )
                                                );
                    }
                    else
                    {
                        me.arr_personal     =   me.arr_funcionario.filter(
                                                    (funcionario) => !me.arr_seleccionados.find(
                                                        ({ value }) => funcionario.value === value
                                                    )
                                                );
                    }
                },
                //-------------------------------------------------------------------------------------------
                sincronizarFuncionarios()
                {
                    let me  =   this;
                    me.arr_personal     =   [];
                    me.arr_personal     =   me.arr_funcionario.filter(
                                                (funcionario) => !me.arr_asignados.find(
                                                    ({ value }) => funcionario.value === value
                                                )
                                            );
                },
                //-------------------------------------------------------------------------------------------
                cargarPendientes()
                {
                    let me          = this;
                    var ruta        = '/contador/solicitudes/pendientes';

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta           =   response.data;                        
                        $('#pendientes_validacion').html(respuesta.nr_bandeja);
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                asyncDeptos(item)
                {
                    let me  =   this;

                    if(item)
                    {
                        me.nr_direccion     =   item;
                        me.cargarDeptosMunicipales(0, me.getValue(me.nr_direccion));
                    }
                    else
                    {
                        me.nr_depto         =   [];
                        me.arr_depto        =   [];
                    }
                },
                //-------------------------------------------------------------------------------------------
                filtro_asyncDeptos(item)
                {
                    let me  =   this;

                    if(item)
                    {
                        me.fl_direccion     =   item;
                        me.cargarDeptosMunicipales(1, me.getValue(me.fl_direccion));
                        me.fl_servicio      =   [];
                    }
                    else
                    {
                        me.fl_depto         =   [];
                        me.fl_servicio      =   [];
                    }
                },
                //-------------------------------------------------------------------------------------------
                asyncServicios(item)
                {
                    let me  =   this;

                    if(item)
                    {
                        me.fl_depto     =   item;
                        me.cargarServicios(me.getValue(me.fl_direccion), me.getValue(me.fl_depto));
                        me.fl_servicio  =   [];
                    }
                    else
                        me.fl_servicio  =   [];
                },
                //-------------------------------------------------------------------------------------------
                asyncFuncionarios(item)
                {
                    let me  =   this;

                    if(item)
                    {
                        me.nr_depto         =   item;
                        me.cargarFuncionarios(me.getValue(me.nr_direccion), me.getValue(me.nr_depto));
                        me.nr_funcionario   =   [];
                    }
                    else
                        me.nr_funcionario   =   [];
                },
                //-------------------------------------------------------------------------------------------
                cargarDireccionesMunicipales()
                {
                    let me      =   this;
                    var ruta    =   '/listado/direcciones_municipales';
                    me.arr_direccion    =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_direccion    =   respuesta.direcciones;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarDeptosMunicipales(tp_filtro = 0, nr_direccion)
                {
                    let me      =   this;
                    var ruta    =   '/listado/deptos_municipales';
                    me.arr_depto    =   [];

                    axios.post(ruta,{
                        'nr_direccion'      :   nr_direccion,
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;

                        if(tp_filtro == 0)
                            me.arr_depto        =   respuesta.deptos;
                        else
                            me.fl_arr_deptos    =   respuesta.deptos;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarServicios(nr_direccion = 0, nr_depto = 0)
                {
                    let me      =   this;
                    var ruta    =   '/listado/servicios';
                    me.arr_servicio     =   [];

                    axios.post(ruta,{
                        'nr_direccion'      :   nr_direccion,
                        'nr_depto'          :   nr_depto,
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_servicio     =   respuesta;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarFuncionarios(nr_direccion = 0, nr_depto = 0)
                {
                    let me      =   this;
                    var ruta    =   '/listado/funcionario';
                    me.arr_funcionario  =   [];

                    axios.post(ruta,{
                        'nr_direccion'      :   nr_direccion,
                        'nr_depto'          :   nr_depto,
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_funcionario  =   respuesta.funcionarios;
                        me.arr_personal     =   respuesta.funcionarios;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },                
                //-------------------------------------------------------------------------------------------
                cargarFuncionariosAsignados(nr_servicio = 0)
                {
                    let me      =   this;
                    var ruta    =   '/listado/asignados';
                    me.arr_asignados  =   [];

                    axios.post(ruta,{
                        'nr_servicio'       :   nr_servicio,
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_asignados    =   respuesta.funcionarios;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarDatos(page = 1)
                {
                    let me          =   this;
                    var ruta        =   '/gestion/servicios';

                    axios.post(ruta,{
                        'page'              :   page,
                        'fl_direccion'      :   me.getValue(me.fl_direccion),
                        'fl_depto'          :   me.getValue(me.fl_depto),
                        'fl_servicio'       :   me.getValue(me.fl_servicio),
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_index        =   respuesta.info.data ;
                        me.pagination       =   respuesta.pagination;
                        me.rows             =   respuesta.info.data;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarRespuestas(page = 1)
                {
                    let me          =   this;
                    var ruta        =   '/gestion/servicios/respuestas/index';

                    axios.post(ruta,{
                        'page'              :   page,
                        'nr_servicio'       :   me.nr_servicio,
                    }).then(function (response)
                    {
                        var respuesta           =   response.data;
                        me.arr_respuestas       =   respuesta.info.data ;
                        me.paginationRespuestas =   respuesta.pagination;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                filtrarDatos()
                {
                    let me  =   this;
                    me.cargarDatos();
                },
                //-------------------------------------------------------------------------------------------
                limpiarFiltros()
                {
                    let me  =   this;

                    me.fl_direccion     =   [];
                    me.fl_depto         =   [];
                    me.fl_servicio      =   [];
                    me.fl_arr_deptos    =   [];
                    me.arr_servicio     =   [];

                    me.cargarDatos();
                },
                //-------------------------------------------------------------------------------------------
                limpiarDatos(modelo)
                {
                    let me  =   this;

                    switch(modelo)
                    {
                        case 'registrar':
                        {
                            me.nr_servicio          =   0;
                            me.nr_direccion         =   [];
                            me.nr_depto             =   [];
                            me.arr_depto            =   [];
                            me.arr_seleccionados    =   [];
                            me.arr_asignados        =   [];
                            me.arr_personal         =   [];
                            me.nm_servicio          =   '';
                            me.str_servicio         =   '';
                            me.tp_activo            =   0;
                            me.tp_ubicacion         =   false;
                            me.tp_macrozona         =   false;
                            me.tp_asignacion        =   false;
                            me.tp_director          =   false;
                            me.tp_depto             =   false;
                            me.nr_nivel             =   {
                                value : 1,
                                label : 'Solo Nivel 1',
                            };

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                ensamblarDatos(accion)
                {
                    let me              =   this;
                    var ruta            =   '';
                    var titulo          =   '';
                    var tiempo          =   3000;
                    var error           =   0;                    
                    var formData        =   new FormData();
                    var fc_format       =   'YYYY-MM-DD';                                   
                    //----------------------------------------------------------------
                    switch(accion)
                    {
                        case 'registrar':
                        {
                            titulo  =   'Registrar Servicio';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                ruta    =   '/gestion/servicios/store';                            
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nm_direccion', me.getLabel(me.nr_direccion));
                                formData.append('id_direccion', me.getValue(me.nr_direccion));
                                formData.append('nm_depto', me.getLabel(me.nr_depto));
                                formData.append('id_depto', me.getValue(me.nr_depto));
                                formData.append('nm_servicio', me.nm_servicio);
                                formData.append('str_servicio', tinymce.get("str_servicio").getContent({format: "text"}));
                                formData.append('str_servicio_html', tinymce.get("str_servicio").getContent({format: "html"}));
                                formData.append('tp_ubicacion', me.tp_ubicacion);
                                formData.append('tp_macrozona', me.tp_macrozona);
                                formData.append('tp_asignacion', me.tp_asignacion);
                                formData.append('tp_respuesta', me.tp_respuesta);
                                // formData.append('tp_director', me.tp_director);
                                // formData.append('tp_depto', me.tp_depto);
                                formData.append('nr_nivel', me.getValue(me.nr_nivel));
                                //------------------------------------
                                for (var i = 0; i < me.arr_seleccionados.length; i++) {
                                    formData.append('arr_funcionarios['+i+']', me.getValue(me.arr_seleccionados[i]));
                                }
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'actualizar':
                        {
                            titulo  =   'Actualizar Servicio';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                ruta    =   '/gestion/servicios/update';
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_servicio', me.nr_servicio);
                                formData.append('nm_direccion', me.getLabel(me.nr_direccion));
                                formData.append('id_direccion', me.getValue(me.nr_direccion));
                                formData.append('nm_depto', me.getLabel(me.nr_depto));
                                formData.append('id_depto', me.getValue(me.nr_depto));
                                formData.append('nm_servicio', me.nm_servicio);
                                formData.append('str_servicio', tinymce.get("str_servicio").getContent({format: "text"}));
                                formData.append('str_servicio_html', tinymce.get("str_servicio").getContent({format: "html"}));
                                formData.append('tp_ubicacion', me.tp_ubicacion);
                                formData.append('tp_macrozona', me.tp_macrozona);
                                formData.append('tp_asignacion', me.tp_asignacion);
                                formData.append('tp_respuesta', me.tp_respuesta);
                                // formData.append('tp_director', me.tp_director);
                                // formData.append('tp_depto', me.tp_depto);
                                formData.append('nr_nivel', me.getValue(me.nr_nivel));
                                //------------------------------------
                                for (var i = 0; i < me.arr_seleccionados.length; i++) {
                                    formData.append('arr_funcionarios['+i+']', me.getValue(me.arr_seleccionados[i]));
                                }
                                //------------------------------------
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'estado':
                        {
                            titulo  =   (me.tp_activo == 1) ? 'Habilitar Servicio': 'Inhabilitar Servicio';
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'No es posible realizar la accion : "'+titulo+'"');
                            else
                            {
                                //------------------------------------
                                ruta    =   '/gestion/servicios/state';
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_servicio', me.nr_servicio);
                                formData.append('nm_servicio', me.nm_servicio);
                                formData.append('tp_activo', me.tp_activo);
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'desasignar':
                        {
                            titulo  =   'Desasignar Funcionario';
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'No es posible realizar la accion : "'+titulo+'"');
                            else
                            {
                                //------------------------------------
                                ruta    =   '/gestion/servicios/del/funcionario';
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('id_direccion', me.getValue(me.nr_direccion));
                                formData.append('nr_servicio', me.nr_servicio);
                                formData.append('nm_servicio', me.nm_servicio);
                                formData.append('nr_funcionario', me.nr_usuario);
                                formData.append('nm_funcionario', me.nm_usuario);
                                formData.append('tp_activo', me.tp_activo);
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'registrar_respuesta':
                        {
                            titulo  =   'Respuesta Automatica del Servicio';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                ruta    =   '/gestion/servicios/respuestas/store';
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_direccion', me.getValue(me.nr_direccion));
                                formData.append('nr_depto', me.getValue(me.nr_depto));
                                formData.append('nr_servicio', me.nr_servicio);
                                formData.append('nm_servicio', me.nm_servicio);
                                formData.append('tp_publicacion', me.tp_publicacion);
                                formData.append('nr_tiempo', me.getValue(me.nr_tiempo));
                                formData.append('str_respuesta', tinymce.get("str_respuesta").getContent({format: "text"}));
                                formData.append('str_respuesta_html', tinymce.get("str_respuesta").getContent({format: "html"}));
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'actualizar_respuesta':
                        {
                            titulo  =   'Respuesta Automatica del Servicio';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                ruta    =   '/gestion/servicios/respuestas/update';
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_respuesta', me.nr_respuesta);
                                formData.append('nr_direccion', me.getValue(me.nr_direccion));
                                formData.append('nr_depto', me.getValue(me.nr_depto));
                                formData.append('nr_servicio', me.nr_servicio);
                                formData.append('nm_servicio', me.nm_servicio);
                                formData.append('tp_publicacion', me.tp_publicacion);
                                formData.append('nr_tiempo', me.getValue(me.nr_tiempo));
                                formData.append('str_respuesta', tinymce.get("str_respuesta").getContent({format: "text"}));
                                formData.append('str_respuesta_html', tinymce.get("str_respuesta").getContent({format: "html"}));
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'habilitar_respuesta':
                        case 'deshabilitar_respuesta':
                        {
                            titulo  =   'Respuesta Automatica del Servicio';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                ruta    =   '/gestion/servicios/respuestas/state';
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_respuesta',me.nr_respuesta);
                                formData.append('nr_servicio', me.nr_servicio);
                                formData.append('nm_servicio', me.nm_servicio);
                                formData.append('tp_activo', me.tp_activo);
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                    }
                    //----------------------------------------------------------------
                },
                //-------------------------------------------------------------------------------------------
                validarDatos(tp_validacion)
                {
                    let me          =   this;
                    var error       =   0;
                    me.arr_valida   =   [];    
                    me.arr_form     =   {}; 
                    me.str_msj      =   '';

                    switch(tp_validacion)
                    {
                        case 'registrar':
                        {
                            if(me.nm_servicio.trim().length < 5)
                                me.arr_form.nm_servicio     =   'El nombre del servicio debe tener minimo 5 caracteres';

                            if(tinymce.get("str_servicio").plugins.wordcount.body.getCharacterCount() >  1000)
                                me.arr_form.str_servicio    =   'La Explicación del Servicio debe tener maximo 1000 caracteres';
                            
                            if(me.getValue(me.nr_direccion) == 0)
                                me.arr_form.nr_direccion    =   'Debe seleccionar la dirección municipal';

                            if(me.getValue(me.nr_depto) == 0)
                                me.arr_form.nr_depto        =   'Debe seleccionar el depto. municipal';

                            if(me.arr_seleccionados.length == 0)
                                me.arr_form.arr_seleccionados   =   'Debe asignar funcionarios al servicio';
                            
                            if(Object.keys(me.arr_form).length != 0)
                                error   =   1;

                            break;
                        }
                        case 'actualizar':
                        {
                            var cant_caracteres     =   tinymce.get("str_servicio").plugins.wordcount.body.getCharacterCount();

                            console.log('cantidad caracteres : ' + cant_caracteres);

                            if(me.nm_servicio.trim().length < 5)
                                me.arr_form.nm_servicio     =   'El nombre del servicio debe tener minimo 5 caracteres';

                            if(tinymce.get("str_servicio").plugins.wordcount.body.getCharacterCount() >  1000)
                                me.arr_form.str_servicio    =   'La Explicación del Servicio debe tener maximo 1000 caracteres';
                            
                            if(me.getValue(me.nr_direccion) == 0)
                                me.arr_form.nr_direccion    =   'Debe seleccionar la dirección municipal';

                            if(me.getValue(me.nr_depto) == 0)
                                me.arr_form.nr_depto        =   'Debe seleccionar el depto. municipal';
                            
                            if(Object.keys(me.arr_form).length != 0)
                                error   =   1;


                            console.log(me.arr_form);
                            break;
                        }
                        case 'estado':
                        {
                            if(me.nr_servicio == 0)
                                me.str_msj  =   'No es posible encontrar el id del servicio';

                            if((typeof me.nm_servicio === "") || (me.nm_servicio === null))
                                me.str_msj  =   '<br>No se encuentra el nombre del servicio';

                            if(me.str_msj.trim().length != 0)
                                error   =   1;

                            break;
                        }
                        case 'desasignar':
                        {
                            if(me.getValue(me.nr_direccion) == 0)
                                me.arr_form.nr_direccion    =   'Debe seleccionar la dirección municipal';

                            if(me.nr_servicio == 0)
                                me.str_msj  =   'No es posible encontrar el id del servicio';

                            if(me.nr_usuario == 0)
                                me.str_msj  =   'No es posible encontrar el id del funcionario';

                            if(me.str_msj.trim().length != 0)
                                error   =   1;

                            break;
                        }
                    }                    

                    return error;
                },
                //-------------------------------------------------------------------------------------------
                registrarDatos(ruta, formData)
                {
                    let me              =       this;
                    var tp_icon         =       '';
                    var titulo          =       '';
                    var mensaje         =       '';
                    var error           =       '';
                    me.btn_envio        =        1;

                    axios.post(ruta, formData, {
                        headers: {'Content-Type': 'multipart/form-data'}
                    }).then(function (response) 
                    {
                        var result  =   response.data;                       
                        tp_icon     =   result.tp_icon;
                        titulo      =   result.title;
                        mensaje     =   result.msj;
                        error       =   result.error;

                        me.desplegarVentana(tp_icon, titulo, mensaje);

                        //Limpiar Modelos
                        if(error == 0)
                        {
                            me.btn_envio        =   0;
                            me.btn_respuesta    =   0;

                            if(me.tp_accion_respuesta == 0)
                            {
                                if(me.tp_accion == 1 || me.tp_accion == 2 || me.tp_accion == 3)
                                {
                                    me.cargarFuncionariosAsignados(me.nr_servicio);
                                    me.cargarFuncionarios(me.getValue(me.nr_direccion), me.getValue(me.nr_depto));
                                    setTimeout(function(){
                                        me.sincronizarFuncionarios();
                                    }, 1000);
                                }
                                
                                if(me.tp_accion == 1 || me.tp_accion == 2)
                                    me.cerrarModal('servicio');
                            }
                            else
                            {
                                me.cerrarModal('respuestas');
                            }

                            me.refrescarDatos();
                        }

                        me.btn_envio            =   0;
                        me.btn_respuesta        =   0;
                        me.tp_accion_respuesta  =   0;
                    })
                    .catch(function (error) 
                    {
                        me.btn_envio        =   0;
                        me.btn_respuesta    =   0;

                        if (error.response.status == 422)
                            me.validationErrors = error.response.data.errors;
                        /*// Formato de Archivo Incorrecto
                        if (error.response.status == 413)
                        {
                            //------------------------------
                        }
                        */
                    });
                },
                //-------------------------------------------------------------------------------------------
                abrirModal(modelo, accion, data = [])
                {
                    let me      =       this;

                    switch(modelo)
                    {
                        case 'servicio':
                        {
                            switch(accion)
                            {
                                case 'registrar':
                                {
                                    me.tp_modal                 =   1;
                                    me.tp_accion                =   1;
                                    me.tp_btn                   =   1;
                                    me.btn_envio                =   0;
                                    me.tp_servicio              =   0;
                                    me.titulo_modal             =   'Registrar Servicio';
                                    me.limpiarDatos(accion);
                                    me.cargarTextArea(1);
                                    me.existeTextArea(1)
                                    $('#modal_servicios').modal('show');

                                    break;
                                }
                                case 'actualizar':
                                {
                                    me.nr_funcionario           =   [];
                                    me.tp_modal                 =   1;
                                    me.tp_accion                =   2;
                                    me.tp_accion_respuesta      =   0;
                                    me.tp_btn                   =   2;
                                    me.btn_envio                =   0;
                                    me.tp_servicio              =   1;
                                    me.titulo_modal             =   'Actualizar Servicio';
                                    //---------------------------------------------------
                                    if(me.tp_tinymce == 0)
                                    {
                                        me.cargarTextArea(1);
                                        me.existeTextArea(1);
                                    }
                                    //---------------------------------------------------
                                    me.arr_seleccionados        =   [];
                                    me.arr_info                 =   data;
                                    me.nr_servicio              =   data.id;
                                    me.nm_servicio              =   data.nm_tipo;                                    
                                    me.tp_ubicacion             =   (data.tp_ubicacion == 1) ? true : false;
                                    me.tp_macrozona             =   (data.tp_macrozona == 1) ? true : false;
                                    me.tp_asignacion            =   (data.tp_asignacion == 1) ? true : false;
                                    me.tp_respuesta             =   (data.tp_respuesta == 1) ? true : false;
                                    // me.tp_director              =   (data.tp_director == 1) ? true : false;
                                    // me.tp_depto                 =   (data.tp_depto == 1) ? true : false;
                                    //---------------------------------------------------
                                    me.nr_direccion             =   {
                                        'value' : data.id_direccion,
                                        'label' : data.nm_direccion,
                                    };
                                    me.nr_depto                 =   {
                                        'value' : data.id_depto,
                                        'label' : data.nm_depto,
                                    };
                                    me.nr_nivel                 =   me.arr_nivel.filter(
                                        event   =>  event.value === data.nr_nivel
                                    );
                                    //---------------------------------------------------
                                    me.arr_asignados            =   data.funcionarios;
                                    me.cargarFuncionarios(me.getValue(me.nr_direccion), me.getValue(me.nr_depto));
                                    setTimeout(function(){
                                             me.sincronizarFuncionarios();
                                    }, 1000);
                                    me.cargarRespuestas();
                                    //---------------------------------------------------
                                    $('#modal_servicios').modal('show');
                                    //---------------------------------------------------
                                    if(me.tp_tinymce == 0)
                                    {
                                        setTimeout(function(){
                                            if($('#str_servicio') && tinymce.activeEditor)
                                                tinymce.get("str_servicio").setContent(data.str_tipo_html);
                                        }, 2500);

                                        me.tp_tinymce   =   1;
                                    }
                                    else
                                    {
                                        if($('#str_servicio') && tinymce.activeEditor)
                                            tinymce.get("str_servicio").setContent(data.str_tipo_html);
                                    }
                                    //---------------------------------------------------

                                    break;
                                }
                                case 'inhabilitar':
                                {
                                    me.nr_servicio          =   data.id;
                                    me.nm_servicio          =   data.nm_tipo;
                                    me.tp_activo            =   0;

                                    me.ensamblarDatos('estado');

                                    break;
                                }
                                case 'habilitar':
                                {
                                    me.nr_servicio          =   data.id;
                                    me.nm_servicio          =   data.nm_tipo;
                                    me.tp_activo            =   1;
                                    me.ensamblarDatos('estado');

                                    break;
                                }
                                case 'desasignar':
                                {
                                    me.tp_modal             =   1;
                                    me.tp_accion            =   3;
                                    me.nr_usuario           =   data.value;
                                    me.nm_usuario           =   data.name;
                                    me.tp_activo            =   0;
                                    me.ensamblarDatos('desasignar');

                                    break;
                                }
                            }

                            break;
                        }
                        case 'respuesta':
                        {
                            switch(accion)
                            {
                                case 'modal_respuesta':
                                {
                                    me.tp_accion_respuesta      =   1;
                                    me.btn_respuesta            =   0;
                                    me.titulo_modal_respuesta   =   'Respuesta Automaticas del Servicio';
                                    me.limpiarDatos(accion);
                                    // me.cargarTextArea(2);
                                    // me.existeTextArea(2);
                                    if($('#str_respuesta') && tinymce.activeEditor)
                                        tinymce.get("str_respuesta").setContent('');
                                    $('#modal_respuesta').modal('show');

                                    break;
                                }
                                case 'actualizar_respuesta':
                                {
                                    me.tp_accion_respuesta      =   2;
                                    me.btn_respuesta            =   0;
                                    me.titulo_modal_respuesta   =   'Respuesta Automaticas del Servicio';
                                    me.limpiarDatos(accion);
                                    // me.cargarTextArea(2);
                                    // me.existeTextArea(2);
                                    me.nr_respuesta             =   data.id;
                                    if($('#str_respuesta') && tinymce.activeEditor)
                                            tinymce.get("str_respuesta").setContent(data.str_respuesta_html);
                                    $('#modal_respuesta').modal('show');

                                    break;
                                }
                                case 'habilitar_respuesta':
                                {
                                    me.tp_accion_respuesta      =   3;
                                    me.nr_respuesta             =   data.id;
                                    me.tp_activo                =   1;
                                    me.ensamblarDatos(accion);

                                    break;
                                }
                                case 'deshabilitar_respuesta':
                                {
                                    me.tp_accion_respuesta      =   3;
                                    me.nr_respuesta             =   data.id;
                                    me.tp_activo                =   0;
                                    me.ensamblarDatos(accion);

                                    break;
                                }
                            }

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                zonaDeEspera(titulo, tiempo)
                {
                    Swal.fire({
                        title : '<h5>'+titulo+'</h5>',
                        html: '<strong> </strong>',
                        showConfirmButton: false,
                        timer: tiempo,
                        onBeforOpen: () => {
                            Swal.showLoading()
                        },
                    }).then((result) => {
                        if(result.dismiss == Swal.DismissReason.timer)
                        {
                            //----------------------------------------
                        }
                    });
                },
                //-------------------------------------------------------------------------------------------
                desplegarVentana(tp_icon, titulo, mensaje, tp_btn = 1)
                {
                    Swal.fire({
                        icon: tp_icon,
                        title: titulo,
                        html: mensaje,
                        backdrop:false,
                        showConfirmButton: tp_btn
                    });                       
                },
                //-------------------------------------------------------------------------------------------
            },

            mounted() {
                let me = this;
                me.cargarDatos();
                me.cargarDireccionesMunicipales();
                me.cargarPendientes();
            }
        });
    </script>


    <script src="<?php echo e(asset('/lib/tinymce/tinymce.min.js')); ?>"></script>

    <script type="text/javascript">
        //-----------------------------------------------------------------
        $(document).ready(function(){
            /*----- Inicio - Filtrar -----*/
            $("#btn_filtrar_datos").click(function () {
                $content = $("#filtrar_datos");
                $content.slideToggle(500, function () {
                    // ---------------------------                    
                });
            });

            $("#close_filtrar_datos").click(function () {
                $content = $("#filtrar_datos");
                $content.slideToggle(500, function () {
                    // ---------------------------                    
                });
            });
            /*----- Inicio - Modal -----*/

            $('#modal_servicios').modal({backdrop: 'static', keyboard: false});
        });
        //-----------------------------------------------------------------
        function justNumbers(e)
        {
            var keynum = window.event ? window.event.keyCode : e.which;
            if (keynum == 8)
                return true;

            return /\d/.test(String.fromCharCode(keynum));
        }
        //-----------------------------------------------------------------
        function Rut(texto)
        { 
            var tmpstr = "";

            for ( i=0; i < texto.length ; i++ )   
                if ( texto.charAt(i) != ' ' && texto.charAt(i) != '.' && texto.charAt(i) != '-' )
                    tmpstr = tmpstr + texto.charAt(i);

            texto = tmpstr; 
            largo = texto.length; 

            if ( largo < 2 ) 
                return false; 

            for (i=0; i < largo ; i++ )    
                if (texto.charAt(i) !="0" && texto.charAt(i) != "1" && texto.charAt(i) !="2" && texto.charAt(i) != "3" && 
                    texto.charAt(i) != "4" && texto.charAt(i) !="5" && texto.charAt(i) != "6" && texto.charAt(i) != "7" && 
                    texto.charAt(i) !="8" && texto.charAt(i) != "9" && texto.charAt(i) !="k" && texto.charAt(i) != "K")   
                    return false;

            var invertido = "";

            for ( i=(largo-1),j=0; i>=0; i--,j++ )    
                invertido = invertido + texto.charAt(i);

            var dtexto = "";  
            dtexto = dtexto + invertido.charAt(0);  
            dtexto = dtexto + '-';  
            cnt = 0;  

            for ( i=1,j=2; i<largo; i++,j++ ) 
            { 
                if ( cnt == 3 )   
                {     
                    dtexto = dtexto + '.';      
                    j++;      
                    dtexto = dtexto + invertido.charAt(i);      
                    cnt = 1;    
                }   
                else    
                {       
                    dtexto = dtexto + invertido.charAt(i);      
                    cnt++;    
                } 
            } 

            invertido = "";

            for ( i=(dtexto.length-1),j=0; i>=0; i--,j++ )    
                invertido = invertido + dtexto.charAt(i);

            if (revisarDigito2(texto))
                return  invertido.toUpperCase();

            return false;
        }
        //-----------------------------------------------------------------
        function formatoMail(valor)
        {
            if (/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test(valor))
                return true;
            else
                return false;
        }
        //-----------------------------------------------------------------
    </script>

<?php $__env->stopSection(); ?>



<?php echo $__env->make('template.home', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\atencion_vecino\resources\views/administrador/gestion_servicios_administrador.blade.php ENDPATH**/ ?>