<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use DB;

class Historial extends Model
{
    protected $table        =   'gsut_historial';
    protected $primaryKey   =   'id';
    protected $fillable     =   [
                                    'id_solicitud',
                                    'nr_historia',
                                    'id_dir_tipo',
                                    'id_depto_tipo',
                                    'id_tipo',
                                    'id_direccion',
                                    'id_depto',
                                    'id_autor',
                                    'fc_inicio',
                                    'fc_termino',
                                    'str_observacion',
                                    'str_observacion_html',
                                    'id_estado',
                                    'id_accion',
                                    'tp_activo'
                                ];

    public $timestamps = true;
    //-----------------------------------------------------------
    public function unidad_destino()
    {
        return $this->hasManyThrough('App\Direccion','App\Despacho','nr_id','id','id','id_direccion_destino')
                    ->select(['gsut_direccion.id','gsut_direccion.nm_direccion','gsut_direccion.tp_activo']);
    }
    //-----------------------------------------------------------
    public function servicio()
    {
        return  $this->belongsTo('App\Tipo','id_tipo','id')
                    ->join('gsut_direccion as dir','dir.id','=','gsut_tipo.id_direccion')
                    ->join('gsut_depto as depto','depto.id','=','gsut_tipo.id_depto')
                    ->select(['gsut_tipo.id',
                        'gsut_tipo.id_direccion',
                        'gsut_tipo.id_depto',
                        'gsut_tipo.nm_tipo',
                        'dir.nm_direccion',
                        'depto.nm_depto']);
    }
    //-----------------------------------------------------------
    public function encargado_servicio()
    {
        return  $this->hasMany('App\ServicioTieneUsuarios','id_servicio','id_tipo')
                ->join('users as funcionario','funcionario.id','=','gsut_servicio_tiene_usuario.id_usuario')
                ->join('gsut_direccion as dir','dir.id','=','funcionario.id_direccion')
                ->join('gsut_depto as depto','depto.id','=','funcionario.id_depto')
                ->select([
                    'gsut_servicio_tiene_usuario.id_servicio',
                    'funcionario.id as id_funcionario',
                    DB::raw('concat(funcionario.nombre," ",funcionario.ap_paterno," ",funcionario.ap_materno) as nm_funcionario'),
                    'dir.id as id_direccion',
                    'depto.id as id_depto',
                    'dir.nm_direccion',
                    'depto.nm_depto'
                ])
                ->where('funcionario.tp_activo','1')
                ->where('gsut_servicio_tiene_usuario.tp_activo','1');
    }
    //-----------------------------------------------------------
}
