<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Vecino;
use App\Solicitud;
use App\Historial;
use App\Respuesta;
use App\Satisfaccion;
use App\SolicitudTerritorial;

use App\Http\Controllers\UtilController;
use App\Http\Controllers\GsutVecinoController;
use App\Http\Controllers\ArchivosController;

use DB;
use Validator;
use GuzzleHttp\Client;
use Freshwork\ChileanBundle\Rut;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class AppMovilController extends Controller
{
    //------------------------------------------------------------
    public function setSession(Request $request)
    {
        $token      =   $request->header('app-token', null);
        $nr_rut     =   '';
        $data       =   null;

        Session::forget('info_vecino');
        Session::forget('nr_rut');

        if(isset($token))
        {
            $nr_rut     =   UtilController::getDataTokenApp($token);

            if(Rut::parse($nr_rut)->quiet()->validate())
            {
                $data       =   (new GsutVecinoController)->getVecino($nr_rut);
                Session::put('nr_rut', $nr_rut);
                Session::put('info_vecino', $data);
                Session::put('app-token', $token);
            } 
        }

        \Log::debug(__METHOD__ . " Token : " . $token);
        \Log::debug(__METHOD__ . " nr_rut : " . $nr_rut);
    }
    //------------------------------------------------------------
    public function pageIngreso(Request $request)
    {
        $this->setSession($request);

        return view('app_movil.ingreso_app');
    }
    //------------------------------------------------------------
    public function pageConsulta(Request $request)
    {
        $this->setSession($request);
        return view('app_movil.consulta_vecino');
    }
    //------------------------------------------------------------
    public function storeSolicitud(Request $request)
    {
        // dd([
        //     'request'   =>  $request->all(),
        // ]);
        //-------------------------------------------------------------------------
        $server     =   $request->root();
        $id_rol     =   0;
        //-------------------------------------------------------------------------
        /*----- Datos de Vecino -----*/
        $rut_vecino         =   Rut::parse($request->rut_vecino)->format(Rut::FORMAT_WITH_DASH);
        $nm_vecino          =   strtoupper(trim($request->nm_vecino));
        $ap_paterno         =   strtoupper(trim($request->ap_paterno));
        $ap_materno         =   strtoupper(trim($request->ap_materno));
        $str_vecino         =   strtoupper(trim($request->str_vecino));
        $nm_mail            =   strtoupper(trim($request->nm_mail));
        //-------------------------------------------------------------------------
        /*----- Datos de la Solicitud -----*/
        $nr_motivo          =   $request->nr_motivo;
        $nr_tipo            =   $request->nr_tipo;
        $nm_tipo            =   $request->nm_tipo;
        $nr_dir_destino     =   $request->nr_dir_municipal;
        $nr_depto_destino   =   $request->nr_depto;
        $tp_ubicacion       =   $request->tp_ubicacion;
        $arr_dir_solicitud  =   null;
        $str_solicitud      =   $request->str_aclaratoria_solicitud;
        $str_descripcion    =   $request->str_observacion;
        $str_html           =   $request->str_observacion_html;
        $rut_vecino         =   Rut::parse($request->rut_vecino)->format(Rut::FORMAT_WITH_DASH);
        //-------------------------------------------------------------------------
        /*----- Datos Complementarios -----*/
        $nr_anio            =   Date('Y');
        $nr_mes             =   Date('m');
        $nr_dia             =   Date('d');
        $fc_actual          =   Date("Y-m-d H:i:s");
        $nr_folio           =   1;
        $nr_ticket          =   '';
        $id_autor           =   0; // 69070400-5 - Municipalidad de Las Condes
        $id_municipio       =   2; // Las Condes
        $id_direccion       =   22; // Externo
        $id_depto           =   90; // Plataforma Tecnologica
        $tp_vecino          =   1; 
        $tp_direccion       =   1; // frente
        $tp_municipal       =   1; // Contexto Municipal
        $nr_prioridad       =   2; // 1. SI | 2. NO
        $tp_ingreso         =   $request->tp_ingreso; // 1. formulario | 6. Audiencias | 7. Redes Sociales
        $id_estado          =   1; // 1. Ingresada | 2. Revision
        $tp_visado_jmt      =   0;
        $tp_rechazado       =   0;
        $tp_activo          =   1; // 1. Activo | 0. Inactivo
        //-------------------------------------------------------------------------
        $valida             =   [];
        $nr_id              =   0;
        $obj_dir_solicitud  =   null;
        $msj                =   '';
        $nr_folio           =   $this->generarNumeroFolio($nr_anio);
        $nr_ticket          =   $this->generarNumeroTicket($nr_anio, $nr_folio);
        $arr_archivo        =   $request->arr_archivo;
        $arr_observacion    =   $request->arr_observacion;            
        //-------------------------------------------------------------------------
        \Log::debug(__METHOD__ . " Ingreso Solicitud App Movil : " . print_r($request->all(), true));
        //-------------------------------------------------------------------------
        try {
            if($tp_ubicacion  == 1)
            {
                $arr_dir_solicitud  =   json_decode($request->arr_direccion_solicitud[0]);

                $obj_dir_solicitud  =   [
                    'value'                 =>  $arr_dir_solicitud->value,
                    'label'                 =>  $arr_dir_solicitud->label,
                    'nr_calle'              =>  $arr_dir_solicitud->nr_calle,
                    'nm_calle'              =>  $arr_dir_solicitud->nm_calle,
                    'str_latitud'           =>  $arr_dir_solicitud->str_latitud,
                    'str_longitud'          =>  $arr_dir_solicitud->str_longitud,
                    'cod_territorial'       =>  $arr_dir_solicitud->cod_territorial,
                    'id_macroterritorio'    =>  UtilController::getIdMacroTerritorio($arr_dir_solicitud->cod_territorial),
                    'cod_unidadvecinal'     =>  $arr_dir_solicitud->cod_unidadvecinal,
                    'id_unidadvecinal'      =>  UtilController::getIdUnidadVecinal($arr_dir_solicitud->cod_unidadvecinal),
                ];
            }
            else 
            {
                $arr_dir_solicitud  =   UtilController::getUbicacionDeptoMunicipal($nr_depto_destino);

                $obj_dir_solicitud  =   [
                    'value'                 =>  $arr_dir_solicitud->value,
                    'label'                 =>  $arr_dir_solicitud->label,
                    'nr_calle'              =>  $arr_dir_solicitud->nr_calle,
                    'nm_calle'              =>  $arr_dir_solicitud->nm_calle,
                    'str_latitud'           =>  $arr_dir_solicitud->str_latitud,
                    'str_longitud'          =>  $arr_dir_solicitud->str_longitud,
                    'cod_territorial'       =>  $arr_dir_solicitud->cod_territorial,
                    'id_macroterritorio'    =>  UtilController::getIdMacroTerritorio($arr_dir_solicitud->cod_territorial),
                    'cod_unidadvecinal'     =>  $arr_dir_solicitud->cod_unidadvecinal,
                    'id_unidadvecinal'      =>  UtilController::getIdUnidadVecinal($arr_dir_solicitud->cod_unidadvecinal),
                ];
            }                
            //-------------------------------------------------------------------------
            $info   =   [
                'nr_anio'               =>  $nr_anio,
                'nr_mes'                =>  $nr_mes,
                'nr_dia'                =>  $nr_dia,
                'nr_folio'              =>  $nr_folio,
                'nr_ticket'             =>  $nr_ticket,
                'id_municipio'          =>  $id_municipio,                                      // interno
                'id_direccion'          =>  $id_direccion,                                      // interno
                'id_depto'              =>  $id_depto,                                          // interno
                'id_motivo'             =>  $nr_motivo,                                         // form
                'id_tipo'               =>  $nr_tipo,                                           // form 
                'nm_tipo'               =>  $nm_tipo,                                           // form
                'id_prioridad'          =>  $nr_prioridad,                                      // form
                'id_direccion_destino'  =>  $nr_dir_destino,                                    // form 
                'id_depto_destino'      =>  $nr_depto_destino,                                  // form 
                'id_ubicacion'          =>  $obj_dir_solicitud['value'],                        // form 
                'id_macroterritorio'    =>  $obj_dir_solicitud['id_macroterritorio'],           // form 
                'id_unidadvecinal'      =>  $obj_dir_solicitud['id_unidadvecinal'],             // form                         
                'nr_direccion'          =>  $obj_dir_solicitud['nr_calle'],                     // form 
                'nm_direccion'          =>  strtoupper(trim($obj_dir_solicitud['nm_calle'])),   // form 
                'nm_ubicacion'          =>  strtoupper(trim($obj_dir_solicitud['label'])),      // form 
                'str_latitud'           =>  $obj_dir_solicitud['str_latitud'],                  // form 
                'str_longitud'          =>  $obj_dir_solicitud['str_longitud'],                 // form 
                'tp_direccion'          =>  $tp_direccion,                                      // form 
                'nr_rut_vecino'         =>  $rut_vecino,                                        // form 
                'str_observacion'       =>  strtoupper(trim($str_descripcion)),                 // form 
                'str_observacion_html'  =>  strtoupper(trim($str_html)),                        // form 
                'str_aclaratoria'       =>  strtoupper(trim($str_solicitud)),                   // form 
                'fc_creacion'           =>  $fc_actual,                                         // interno
                'tp_visado_mt'          =>  $tp_visado_jmt,                                     // interno
                'tp_rechazado'          =>  $tp_rechazado,                                      // interno
                'id_estado'             =>  $id_estado,                                         // interno
                'contexto_municipal'    =>  $tp_municipal,                                      // form 
                'tp_ingreso'            =>  $tp_ingreso,                                        // interno
                'id_autor'              =>  $id_autor,                                          // interno
                'id_rol'                =>  $id_rol,                                            // interno
                'tp_activo'             =>  $tp_activo,                                         // Interno
                'tp_vecino'             =>  $tp_vecino,                                         // Interno
            ];
            //-------------------------------------------------------------------------
            $model  =   Solicitud::create($info);
            $nr_id  =   $model->id;
            $msj    =   'Se ha registrado la solicitud correctamente con el número de ticket <strong>#'.$nr_ticket .'</strong>'.
                        '<br> <center><i>Favor tomar nota del numero de ticket</i></center>';

            if($nr_id)
            {
                GsutVecinoController::setRegistrarVecino($request);

                // Proceso Ingreso Flujo
                GsutFlujoController::ingresoSolicitud($nr_id,$nr_tipo,$tp_ingreso);

                // Proceso de Almacenamiento de Archivos
                ArchivosController::registrarArchivo('tb_solicitud', $nr_id, $arr_archivo, $arr_observacion);

                $valida     =   [
                                    'error'     =>  0,
                                    'existe'    =>  1,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  'Registro de Solicitud',
                                    'msj'       =>  $msj . '<br> Para descargar el Ticket de Ateción favor haga clic en el link de descarga 
                                                            <a target="_blank" href="'.$server.'/atencion_vecino/ticket/'.$nr_ticket.'" class="btn btn-sm btn-danger">Descargar</a>',
                                ];
                                
                EmailController::enviarNotificacionVecino(101, $nr_id, ''); // 101. Notificación de ingreso solicitud al vecino
                EmailController::enviarNotificaciones(50, $nr_id); // 50. Notificación de ingreso de solicitud a administrador de Atención al Vecino
            }
            else
            {
                $msj        =   'No se ha podido registrar la solicitud, favor intente nuevamente.';

                $valida     =   [
                                    'error'     =>  1,
                                    'existe'    =>  0,
                                    'tp_icon'   =>  'warning',
                                    'title'     =>  'Registro de Solicitud',
                                    'msj'       =>  $msj,
                                ];
            }   
        } catch (Exception $e) {
             $valida     =   [
                                'error'     =>  1,
                                'existe'    =>  0,
                                'tp_icon'   =>  'error',
                                'title'     =>  'Registro de Solicitud',
                                'msj'       =>  'Se ha producido un problema al registrar la solicitud',
                            ];
        }

        return $valida;       
    }
    //------------------------------------------------------------
    public function generarNumeroFolio($nr_anio)
    {
        $nr_folio   =   1;

        try {
            $data   =   Solicitud::
                        select('nr_folio')
                        ->where('nr_anio','=',$nr_anio)
                        ->orderBy('nr_folio','DESC')
                        ->get()->take(1);

            if($data->count())
                $nr_folio   =   $data->first()->nr_folio + 1;
        } catch (Exception $e) {
            $nr_folio   =   1;
        }

        return $nr_folio;
    }
    //------------------------------------------------------------
    public function generarNumeroTicket($nr_anio, $nr_folio)
    {
        $str_zero       =   '0';
        $str_folio      =   str_pad($nr_folio, 4, $str_zero, STR_PAD_LEFT);
        $str_ticket     =   $nr_anio.$str_folio;

        return  $str_ticket;
    }
    //------------------------------------------------------------
    public function searchSolicitud(Request $request)
    {
        $str_buscar     =   Session::get('nr_rut');
        $fl_mostrar     =   $request->fl_mostrar;
        $page           =   $request->page;

        \Log::debug(__METHOD__ . " Consulta de Solicitud App Movil - Rut : " . $str_buscar);

        $data           =   Solicitud:: 
                            join('gsut_prioridad as prioridad','prioridad.id','=','gsut_solicitud.id_prioridad')
                            ->join('gsut_tipo as tipo','tipo.id','=','gsut_solicitud.id_tipo')
                            ->join('gsut_estado as estado','estado.id','=','gsut_solicitud.id_estado')
                            ->join('gsut_direccion as dir_destino','dir_destino.id','=','gsut_solicitud.id_direccion_destino')
                            ->select('gsut_solicitud.id',
                                'gsut_solicitud.nr_ticket',
                                'gsut_solicitud.id_municipio',
                                'gsut_solicitud.id_direccion',
                                'gsut_solicitud.id_depto',
                                'gsut_solicitud.id_tipo',
                                'gsut_solicitud.nm_tipo',
                                'gsut_solicitud.id_prioridad',
                                'gsut_solicitud.id_direccion_destino',
                                'gsut_solicitud.id_ubicacion',
                                'gsut_solicitud.id_macroterritorio',
                                'gsut_solicitud.id_unidadvecinal',
                                'gsut_solicitud.tp_direccion',
                                'gsut_solicitud.nr_direccion',
                                'gsut_solicitud.nm_direccion',
                                'gsut_solicitud.nm_ubicacion',
                                'gsut_solicitud.str_latitud',
                                'gsut_solicitud.str_longitud',
                                'gsut_solicitud.nr_rut_vecino',
                                'gsut_solicitud.str_observacion',
                                'gsut_solicitud.str_observacion_html as str_solicitud_html',
                                'gsut_solicitud.tp_visado_mt',
                                'gsut_solicitud.tp_rechazado',
                                'gsut_solicitud.id_estado',
                                'gsut_solicitud.contexto_municipal',
                                'gsut_solicitud.tp_ingreso',
                                'gsut_solicitud.id_autor',
                                'gsut_solicitud.tp_activo',
                                'gsut_solicitud.tp_feedback',
                                'gsut_solicitud.tp_recepcion',
                                'gsut_solicitud.tp_satisfaccion',
                                'gsut_solicitud.str_feedback',
                                'gsut_solicitud.tp_feedback_vecino',
                                'gsut_solicitud.fc_feedback_vecino',
                                'gsut_solicitud.tp_satisfaccion_vecino',
                                'gsut_solicitud.str_feedback_vecino',
                                'gsut_solicitud.fc_publicado',
                                'gsut_solicitud.fc_creacion as fc_ingreso',
                                'gsut_solicitud.created_at',
                                'gsut_solicitud.updated_at as fc_tramitacion')
                            ->selectRaw("(case 
                                            when estado.id = 1 then 'Ingresada'
                                            when estado.id = 2 then 'En Revisión'
                                            when estado.id = 3 then 'En Revisión'
                                            when estado.id = 4 then 'En Revisión'
                                            when (estado.id = 5 && gsut_solicitud.tp_feedback_vecino = 0) then 'Cerrado sin Calificación'
                                            when (estado.id = 5 && gsut_solicitud.tp_feedback_vecino = 1) then 'Cerrado con Calificación'
                                            when (estado.id = 6 && gsut_solicitud.tp_feedback_vecino = 0) then 'Cerrado sin Calificación'
                                            when (estado.id = 6 && gsut_solicitud.tp_feedback_vecino = 1) then 'Cerrado con Calificación'
                                            when estado.id = 7 then 'Anulada'
                                            when estado.id = 8 then 'Derivado'
                                            when estado.id = 9 then 'Derivado'
                                            when estado.id = 10 then 'Derivado'
                                            end) as nm_estado") 
                            ->where('gsut_solicitud.nr_rut_vecino','=',$str_buscar)
                            ->where('gsut_solicitud.tp_activo','=',1)
                            ->orderBy('gsut_solicitud.created_at','DESC');

        /*---------- Inicio - Filtro ----------*/
            if($fl_mostrar != 0)
            {
                if($fl_mostrar == 3)
                    $data   =   $data->whereIn('gsut_solicitud.id_estado',[1,2,3,4]);                
                if($fl_mostrar == 5)
                    $data   =   $data->whereIn('gsut_solicitud.id_estado',[5,6]);
                if($fl_mostrar != 3 && $fl_mostrar != 5)
                    $data   =   $data->where('gsut_solicitud.id_estado','=',$fl_mostrar);
            }
        /*---------- Termino - Filtro ----------*/

        $data   =   $data->groupBy('gsut_solicitud.id')->paginate(10);

        $data->getCollection()->transform(function ($value) {
            $value->tiempo_tramitado    =   UtilController::getTiempoTramitacion($value->fc_ingreso, $value->fc_publicado, $value->id_estado);
            return $value;
        });

        return [
            'pagination' => [
                'total'        => $data->total(),
                'current_page' => $data->currentPage(),
                'per_page'     => $data->perPage(),
                'last_page'    => $data->lastPage(),
                'from'         => $data->firstItem(),
                'to'           => $data->lastItem(),
            ],
            'info'          =>  $data,
            'rut_vecino'    =>  $str_buscar,
        ];
    }
    //------------------------------------------------------------
}
