<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Encuesta;
use App\EncuestaPregunta;
use App\EncuestaPreguntaTemp;
use App\EncuestaAlternativa;
use App\EncuestaLogica;

use DB;
use Validator;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Str;

class EstructuraEncuestaController extends Controller
{
    //------------------------------------------------------------
    public function index(Request $request)
    {
        $fl_encuesta    =   $request->fl_encuesta;
        $fl_activo      =   $request->fl_activo;
        $tp_criterio    =   $request->tp_criterio;
        $tp_orden       =   $request->tp_orden;
        $page           =   $request->page;

        $data   =   Encuesta::
                    select('id',
                        'nm_encuesta',
                        'str_descripcion',
                        'tp_encuesta',
                        'tp_activo',
                        DB::raw('ifnull((select count(*) from gsut_encuesta_pregunta as ep where ep.id_encuesta = gsut_encuesta.id), 0) as nr_cantidad_preguntas'),
                        DB::raw('(case when tp_activo = 1 then "Habilitado" else "Deshabilitado" end) as nm_estado'));

        /* ----- Inicio - Filtro ----- */
            if(isset($fl_activo))
                $data   =   $data->whereIn('tp_activo',$fl_activo);

            if(isset($fl_encuesta))
                $data   =   $data->where('id','=',$fl_encuesta);
        /* ----- Termino - Filtro ----- */

        /*----- Inicio - Orden por Campos -----*/
            if(in_array($tp_criterio, ['id','nm_encuesta','created_at']))
                $data   =   $data->orderBy('gsut_encuesta.'.$tp_criterio, $tp_orden);

            if($tp_criterio === 'tp_activo')
                $data   =   $data->orderBy('gsut_encuesta.tp_activo',$tp_orden);
        /*----- Termino - Orden por Campos -----*/

        $data   =   $data->paginate(20);

        return [
            'pagination' => [
                'total'         =>  $data->total(),
                'current_page'  =>  $data->currentPage(),
                'per_page'      =>  $data->perPage(),
                'last_page'     =>  $data->lastPage(),
                'from'          =>  $data->firstItem(),
                'to'            =>  $data->lastItem(),
            ],
            'info' => $data,
        ];
    }
    //------------------------------------------------------------
    public function store(Request $request)
    {
        $tp_valida  =   $this->existeEncuesta($request);

        if($tp_valida == 0)
             return $this->registrarEncuesta($request);
        else
            return [
                'error'     =>  1,
                'existe'    =>  0,
                'tp_icon'   =>  'warning',
                'title'     =>  'Registrar Encuesta de Atención al Vecino',
                'msj'       =>  'Ya existe una Encuesta con el mismo nombre'
            ];
    }
    //------------------------------------------------------------
    public function update(Request $request)
    {
        $tp_existe  =   $this->existeRegistro($request);

        if($tp_existe == 1)
            return $this->actualizarEncuesta($request);
        else
            return [
                'error'     =>  1,
                'existe'    =>  0,
                'tp_icon'   =>  'warning',
                'title'     =>  'Actualizar Encuesta de Atención al Vecino',
                'msj'       =>  'No es posible actualizar la encuesta, no se encuentra ID'
            ];
    }
    //------------------------------------------------------------
    public function state(Request $request)
    {
        $tp_activo      =   $request->tp_activo;
        $str_title      =   ($tp_activo == 1) ? 'Habilitar Encuesta de Atención al Vecino' : 
                                                'Deshabilitar Encuesta de Atención al Vecino';

        $tp_existe  =   $this->existeRegistro($request);

        if($tp_existe == 1)
            return $this->estadoEncuesta($request);
        else
            return [
                'error'     =>  1,
                'existe'    =>  0,
                'tp_icon'   =>  'warning',
                'title'     =>  $str_title,
                'msj'       =>  'No es posible actualizar la encuesta, no se encuentra ID'
            ];
    }
    //------------------------------------------------------------
    public function registrarEncuesta(Request $request)
    {
        $nm_encuesta        =   $request->nm_encuesta;
        $str_descripcion    =   $request->str_descripcion;
        $str_title          =   'Registrar Encuesta de Atención al Vecino';
        $str_msj            =   '';
        $arr_valida         =   [
                                    'error'     =>  0,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];

        try {
            $model  =   new Encuesta();
            $model->nm_encuesta         =   $nm_encuesta;
            $model->str_descripcion     =   $str_descripcion;
            $model->save();

            if(isset($model->id))
            {
                $str_msj        =   'Se ha registrado la encuesta: <strong>"'.$nm_encuesta.'"</strong>';
                $arr_valida     =   [
                                        'error'     =>  0,
                                        'tp_icon'   =>  'success',
                                        'title'     =>  $str_title,
                                        'msj'       =>  $str_msj,
                                    ];
            }
        } catch (Exception $e) {
            $str_msj        =   'Ha ocurrido un problema al registrar la encuesta: <strong>"'.$nm_encuesta.'"</strong>';
            $arr_valida     =   [
                                    'error'     =>  1,
                                    'tp_icon'   =>  'warning',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];
        }
        
        return $arr_valida;
    }
    //------------------------------------------------------------
    public function actualizarEncuesta(Request $request)
    {
        $nr_encuesta        =   $request->nr_encuesta;
        $new_encuesta       =   $request->nm_encuesta;
        $old_encuesta       =   $request->old_encuesta;
        $str_descripcion    =   $request->str_descripcion;
        $str_title          =   'Actualizar Encuesta de Atención al Vecino';
        $str_msj            =   '';
        $arr_valida         =   [
                                    'error'     =>  0,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];

        try {
            $str_msj    =   ($new_encuesta != $old_encuesta) ?  'Se ha actualizado la encuesta "'.$old_encuesta.'" a "'.$new_encuesta.'"' : 
                                                                'Se ha actualizado la encuesta "'.$old_encuesta.'"';
            $str_msj    =   (isset($str_descripcion)) ? $str_msj . ', <br>con la siguiente descripción : "'.$str_descripcion.'"' : $str_msj;

            Encuesta::where('id','=',$nr_encuesta)
            ->update([
                'nm_encuesta'       =>  $new_encuesta,
                'str_descripcion'   =>  $str_descripcion
            ]);

            $arr_valida     =   [
                                    'error'     =>  0,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];
        } catch (Exception $e) {
            $str_msj        =   'Ha ocurrido un problema al actualizar la encuesta';
            $arr_valida     =   [
                                    'error'     =>  1,
                                    'tp_icon'   =>  'warning',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];
        }
        
        return $arr_valida;
    }
    //------------------------------------------------------------
    public function estadoEncuesta(Request $request)
    {
        $nr_encuesta    =   $request->nr_encuesta;
        $nm_encuesta    =   $request->nm_encuesta;
        $tp_activo      =   $request->tp_activo;
        $str_title      =   ($tp_activo == 1) ? 'Habilitar Encuesta de Atención al Vecino' : 
                                                'Deshabilitar Encuesta de Atención al Vecino';
        $str_msj        =   ($tp_activo == 1) ? 'Se ha Habilitado la encuesta "'.$nm_encuesta.'"' : 
                                                'Se ha Deshabilitado la encuesta "'.$nm_encuesta.'"';
        $arr_valida     =   [
                                'error'     =>  0,
                                'tp_icon'   =>  'success',
                                'title'     =>  $str_title,
                                'msj'       =>  $str_msj,
                            ];

        try {
            Encuesta::where('id','=',$nr_encuesta)
            ->update([
                'tp_activo'     =>  $tp_activo
            ]);

            $arr_valida     =   [
                                    'error'     =>  0,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];
        } catch (Exception $e) {
            $arr_valida     =   [
                                    'error'     =>  1,
                                    'tp_icon'   =>  'warning',
                                    'title'     =>  $str_title,
                                    'msj'       =>  'Ha ocurrido un problema al realizar la operación "'.$str_title.'"',
                                ];
        }

        return $arr_valida;
    }
    //------------------------------------------------------------
    public function existeEncuesta(Request $request)
    {
        $nm_encuesta    =   trim($request->nm_encuesta);
        $tp_valida      =   0;

        try {
            $data       =   Encuesta::
                            whereRaw('nm_encuesta LIKE ? ',[$nm_encuesta])
                            ->get();

            if($data->count())
                $tp_valida  =   1;
        } catch (Exception $e) {
            $tp_valida  =   0;
        }

        return $tp_valida;
    }
    //------------------------------------------------------------
    public function existeRegistro(Request $request)
    {
        $nr_encuesta    =   trim($request->nr_encuesta);
        $tp_valida      =   0;

        try {
            $data       =   Encuesta::
                            where('id','=',$nr_encuesta)
                            ->get();

            if($data->count())
                $tp_valida  =   1;
        } catch (Exception $e) {
            $tp_valida  =   0;
        }

        return $tp_valida;
    }
    //------------------------------------------------------------
    public function updatePregunta(Request $request)
    {
        $tp_valida  =   $this->existeRegistroPregunta($request);

        if($tp_valida == 1)
            return  $this->actualizarPregunta($request);
        else
            return [
                'error'     =>  1,
                'existe'    =>  0,
                'tp_icon'   =>  'warning',
                'title'     =>  'Actualizar Pregunta',
                'msj'       =>  'No se ha encontrado la pregunta a actualizar'
            ];
    }
    //------------------------------------------------------------
    public function statePregunta(Request $request)
    {
        $tp_valida  =   $this->existeRegistroPregunta($request);

        if($tp_valida == 1)
            return  $this->estadoPregunta($request);
        else
            return [
                'error'     =>  1,
                'existe'    =>  0,
                'tp_icon'   =>  'warning',
                'title'     =>  'Habilitar/Deshabilitar Pregunta',
                'msj'       =>  'No se ha encontrado la pregunta a actualizar'
            ];
    }
    //------------------------------------------------------------
    public function deletePregunta(Request $request)
    {
        $tp_valida  =   $this->existeRegistroPregunta($request);

        if($tp_valida == 1)
            return  $this->eliminarPregunta($request);
        else
            return [
                'error'     =>  1,
                'existe'    =>  0,
                'tp_icon'   =>  'warning',
                'title'     =>  'Eliminar Pregunta',
                'msj'       =>  'No se ha encontrado la pregunta a eliminar'
            ];
    }
    //------------------------------------------------------------
    public function updateAlternativa(Request $request)
    {
        $tp_valida  =   $this->existeRegistroAlternativa($request);

        if($tp_valida == 1)
            return  $this->actualizarAlternativa($request);
        else
            return [
                'error'     =>  1,
                'existe'    =>  0,
                'tp_icon'   =>  'warning',
                'title'     =>  'Actualizar Alternativa',
                'msj'       =>  'No se ha encontrado la alternativa a actualizar'
            ];
    }
    //------------------------------------------------------------
    public function stateAlternativa(Request $request)
    {
        $tp_activo  =   $request->tp_activo;
        $tp_valida  =   $this->existeRegistroAlternativa($request);

        if($tp_valida == 1)
            return  $this->estadoAlternativa($request);
        else
            return [
                'error'     =>  1,
                'existe'    =>  0,
                'tp_icon'   =>  'warning',
                'title'     =>  ($tp_activo == 1) ? 'Habilitar Alternativa' : 'Deshabilitar',
                'msj'       =>  'No se ha encontrado la alternativa a '. (($tp_activo == 1) ? 'habilitar' : 'deshabilitar')
            ];
    }
    //------------------------------------------------------------
    public function deleteAlternativa(Request $request)
    {
        $tp_valida  =   $this->existeRegistroAlternativa($request);

        if($tp_valida == 1)
            return  $this->eliminarAlternativa($request);
        else
            return [
                'error'     =>  1,
                'existe'    =>  0,
                'tp_icon'   =>  'warning',
                'title'     =>  'Eliminar Alternativa',
                'msj'       =>  'No se ha encontrado la alternativa a eliminar'
            ];
    }
    //------------------------------------------------------------
    public function generarPregunta(Request $request)
    {
        $nr_encuesta        =   $request->nr_encuesta;
        $tp_pregunta        =   $request->tp_pregunta;
        $tp_categoria       =   'encuesta';
        $tp_obligatorio     =   1;
        $arr_pregunta       =   [];
        $str_title          =   'Registrar Pregunta de Encuesta de Atención Vecino';
        $str_msj            =   '';
        $arr_valida         =   ['error' => 0, 'tp_icon' => 'success', 'title' => $str_title, 'msj' => $str_msj];

        switch($tp_pregunta)
        {
            case 2: // Opción Multiple
            {
                try {
                    DB::beginTransaction();
                    $str_fecha      =   Date('YmdHis');
                    $str_formdata   =   Str::random(10);
                    $nr_pregunta    =   $this->generarNumeroPregunta($nr_encuesta);
                    $cod_pregunta   =   'E0'.$nr_encuesta.'P0'.$nr_pregunta.'#'.$str_formdata;
                    $arr_pregunta   =   [
                                            'id_encuesta'       =>  $nr_encuesta,
                                            'tp_categoria'      =>  $tp_categoria,
                                            'nr_pregunta'       =>  $nr_pregunta,
                                            'cod_pregunta'      =>  $cod_pregunta,
                                            'tp_pregunta'       =>  $tp_pregunta,
                                            'tp_obligatorio'    =>  $tp_obligatorio,
                                            'str_formdata'      =>  $str_formdata,
                                            'str_pregunta'      =>  'Nueva Pregunta',
                                            'str_indicacion'    =>  '',
                                            'tp_activo'         =>  1,
                                        ];

                    DB::commit();
                    $pregunta   =   EncuestaPregunta::create($arr_pregunta);

                    if($pregunta->id)
                    {
                        $nr_alternativa     =   $this->generarNumeroAlternativa($pregunta->id);
                        $vl_alternativa     =   $this->generarValorAlternativa($pregunta->id);
                        $str_formdata       =   Str::random(10);
                        $cod_alternativa    =   'P0'.$nr_pregunta.'A0'.$nr_alternativa.'#'.$str_formdata;
                        $arr_alternativa    =   [
                                                    'id_pregunta'       =>  $pregunta->id,
                                                    'nr_alternativa'    =>  $nr_alternativa,
                                                    'cod_alternativa'   =>  $cod_alternativa,
                                                    'tp_alternativa'    =>  $tp_pregunta,
                                                    'str_alternativa'   =>  'Nueva Alternativa',
                                                    'vl_alternativa'    =>  $vl_alternativa,
                                                    'tp_activo'         =>  1,
                                                ];

                        $alternativa    =   EncuestaAlternativa::create($arr_alternativa);

                        $str_msj        =   'Se ha registrado una nueva pregunta a la encuesta';
                        $arr_valida     =   [
                                                'error'     =>  0,
                                                'tp_icon'   =>  'success',
                                                'title'     =>  $str_title,
                                                'msj'       =>  $str_msj,
                                            ];
                    }
                    else
                    {
                        DB::rollback();
                        $arr_valida     =   [
                                                'error'     =>  0,
                                                'tp_icon'   =>  'success',
                                                'title'     =>  $str_title,
                                                'msj'       =>  'No se ha podido registrar la nueva pregunta en la encuesta',
                                            ];
                    }
                } catch (Exception $e) {
                    DB::rollback();
                    $arr_valida     =   [
                                            'error'     =>  1,
                                            'tp_icon'   =>  'warning',
                                            'title'     =>  $str_title,
                                            'msj'       =>  'Ha ocurrido un problema al registrar la nueva pregunta en la encuesta',
                                        ];
                }

                break;
            }
            case 3: // Opción Lista
            {
                try {
                    DB::beginTransaction();
                    $str_fecha      =   Date('YmdHis');
                    $str_formdata   =   Str::random(10);
                    $nr_pregunta    =   $this->generarNumeroPregunta($nr_encuesta);
                    $cod_pregunta   =   'E0'.$nr_encuesta.'P0'.$nr_pregunta.'#'.$str_formdata;
                    $arr_pregunta   =   [
                                            'id_encuesta'       =>  $nr_encuesta,
                                            'tp_categoria'      =>  $tp_categoria,
                                            'nr_pregunta'       =>  $nr_pregunta,
                                            'cod_pregunta'      =>  $cod_pregunta,
                                            'tp_pregunta'       =>  $tp_pregunta,
                                            'tp_obligatorio'    =>  $tp_obligatorio,
                                            'str_formdata'      =>  $str_formdata,
                                            'str_pregunta'      =>  'Nueva Pregunta',
                                            'str_indicacion'    =>  '',
                                            'tp_activo'         =>  1,
                                        ];

                    DB::commit();
                    $pregunta   =   EncuestaPregunta::create($arr_pregunta);

                    if($pregunta->id)
                    {
                        $nr_alternativa     =   $this->generarNumeroAlternativa($pregunta->id);
                        $vl_alternativa     =   $this->generarValorAlternativa($pregunta->id);
                        $str_formdata       =   Str::random(10);
                        $cod_alternativa    =   'P0'.$nr_pregunta.'A0'.$nr_alternativa.'#'.$str_formdata;
                        $arr_alternativa    =   [
                                                    'id_pregunta'       =>  $pregunta->id,
                                                    'nr_alternativa'    =>  $nr_alternativa,
                                                    'cod_alternativa'   =>  $cod_alternativa,
                                                    'tp_alternativa'    =>  $tp_pregunta,
                                                    'str_alternativa'   =>  'Nueva Alternativa',
                                                    'vl_alternativa'    =>  $vl_alternativa,
                                                    'tp_activo'         =>  1,
                                                ];

                        $alternativa    =   EncuestaAlternativa::create($arr_alternativa);

                        $str_msj        =   'Se ha registrado una nueva pregunta a la encuesta';
                        $arr_valida     =   [
                                                'error'     =>  0,
                                                'tp_icon'   =>  'success',
                                                'title'     =>  $str_title,
                                                'msj'       =>  $str_msj,
                                            ];
                    }
                    else
                    {
                        DB::rollback();
                        $arr_valida     =   [
                                                'error'     =>  0,
                                                'tp_icon'   =>  'success',
                                                'title'     =>  $str_title,
                                                'msj'       =>  'No se ha podido registrar la nueva pregunta en la encuesta',
                                            ];
                    }
                } catch (Exception $e) {
                    DB::rollback();
                    $arr_valida     =   [
                                            'error'     =>  1,
                                            'tp_icon'   =>  'warning',
                                            'title'     =>  $str_title,
                                            'msj'       =>  'Ha ocurrido un problema al registrar la nueva pregunta en la encuesta',
                                        ];
                }

                break;
            }
        }

        return $arr_valida;
    }
    //------------------------------------------------------------
    public function generarAlternativa(Request $request)
    {
        $nr_pregunta        =   $request->nr_pregunta;
        $tp_pregunta        =   $request->tp_pregunta;
        $str_pregunta       =   '';
        $str_title          =   'Registrar Alternativa en la Pregunta de Encuesta de Atención al Vecino';
        $str_msj            =   '';
        $arr_valida         =   [
                                    'error'     =>  0,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];

        try {
            $model  =   null;

            switch($tp_pregunta)
            {
                case 2: // Opción Multiple
                {
                    try {
                        DB::beginTransaction();

                        $pregunta   =   $this->getPregunta($nr_pregunta);

                        if($pregunta)
                        {
                            $str_pregunta       =   $pregunta->str_pregunta;
                            $nr_alternativa     =   $this->generarNumeroAlternativa($nr_pregunta);
                            $vl_alternativa     =   $this->generarValorAlternativa($nr_pregunta);
                            $str_formdata       =   Str::random(10);
                            $cod_alternativa    =   'P0'.$nr_pregunta.'A0'.$nr_alternativa.'#'.$str_formdata;
                            $arr_alternativa    =   [
                                                        'id_pregunta'       =>  $nr_pregunta,
                                                        'nr_alternativa'    =>  $nr_alternativa,
                                                        'cod_alternativa'   =>  $cod_alternativa,
                                                        'tp_alternativa'    =>  $tp_pregunta,
                                                        'str_alternativa'   =>  'Nueva Alternativa #' . $nr_alternativa,
                                                        'vl_alternativa'    =>  $vl_alternativa,
                                                        'tp_activo'         =>  1,
                                                    ];

                            DB::commit();
                            $model              =   EncuestaAlternativa::create($arr_alternativa);
                        }
                    } catch (Exception $e) {
                        DB::rollback();
                    }

                    break;
                }
                case 3: // Opción Lista
                {
                    try {
                        DB::beginTransaction();

                        $pregunta   =   $this->getPregunta($nr_pregunta);

                        if($pregunta)
                        {
                            $str_pregunta       =   $pregunta->str_pregunta;
                            $nr_alternativa     =   $this->generarNumeroAlternativa($nr_pregunta);
                            $vl_alternativa     =   $this->generarValorAlternativa($nr_pregunta);
                            $str_formdata       =   Str::random(10);
                            $cod_alternativa    =   'P0'.$nr_pregunta.'A0'.$nr_alternativa.'#'.$str_formdata;
                            $arr_alternativa    =   [
                                                        'id_pregunta'       =>  $nr_pregunta,
                                                        'nr_alternativa'    =>  $nr_alternativa,
                                                        'cod_alternativa'   =>  $cod_alternativa,
                                                        'tp_alternativa'    =>  $tp_pregunta,
                                                        'str_alternativa'   =>  'Nueva Alternativa #' . $nr_alternativa,
                                                        'vl_alternativa'    =>  $vl_alternativa,
                                                        'tp_activo'         =>  1,
                                                    ];

                            DB::commit();
                            $model              =   EncuestaAlternativa::create($arr_alternativa);
                        }
                    } catch (Exception $e) {
                        DB::rollback();
                    }

                    break;
                }
            }  


            if(isset($model->id))
            {
                $str_msj        =   'Se ha registrado una nueva alternativa para la pregunta <strong>"'.$str_pregunta.'"</strong> en la Encuesta de Atención al Vecino';
                $arr_valida     =   [
                                        'error'     =>  0,
                                        'tp_icon'   =>  'success',
                                        'title'     =>  $str_title,
                                        'msj'       =>  $str_msj,
                                    ];
            }
            else
            {
                $str_msj        =   'No se ha podido registrar la nueva alternativa para la pregunta <strong>"'.$str_pregunta.'"</strong> en la Encuesta de Atención al Vecino';
                $arr_valida     =   [
                                        'error'     =>  1,
                                        'tp_icon'   =>  'warning',
                                        'title'     =>  $str_title,
                                        'msj'       =>  $str_msj,
                                    ];
            }
        } catch (Exception $e) {
            $str_msj        =   'Ha ocurrido un problema al registrar la nueva alternativa para la pregunta <strong>"'.$str_pregunta.'"</strong> en la Encuesta de Atención al Vecino';
            $arr_valida     =   [
                                    'error'     =>  1,
                                    'tp_icon'   =>  'warning',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];
        }
        
        return $arr_valida;
    }
    //------------------------------------------------------------
    public function actualizarPregunta(Request $request)
    {
        $nr_pregunta        =   $request->nr_pregunta;
        $new_pregunta       =   $request->nm_pregunta;
        $old_pregunta       =   $request->old_pregunta;
        $str_title          =   'Actualizar Pregunta';
        $str_msj            =   '';
        $arr_valida         =   [
                                    'error'     =>  0,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];

        try {
            $str_msj    =   ($new_pregunta != $old_pregunta) ?  'Se ha actualizado la pregunta "'.$old_pregunta.'" a "'.$new_pregunta.'"' : 
                                                                'Se ha actualizado la pregunta "'.$old_pregunta.'"';

            EncuestaPregunta::
            where('id','=',$nr_pregunta)
            ->update([
                'str_pregunta'       =>  $new_pregunta
            ]);

            $arr_valida     =   [
                                    'error'     =>  0,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];
        } catch (Exception $e) {
            $str_msj        =   'Ha ocurrido un problema al actualizar la pregunta';
            $arr_valida     =   [
                                    'error'     =>  1,
                                    'tp_icon'   =>  'warning',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];
        }
        
        return $arr_valida;
    }
    //------------------------------------------------------------
    public function estadoPregunta(Request $request)
    {
        $nr_pregunta        =   $request->nr_pregunta;
        $nm_pregunta        =   $request->nm_pregunta;
        $tp_activo          =   $request->tp_activo;
        $str_title          =   ($tp_activo == 1) ? 'Habilitar Pregunta' : 'Deshabilitar Pregunta';
        $str_msj            =   '';
        $arr_valida         =   [
                                    'error'     =>  0,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];

        try {
            $str_msj    =   ($tp_activo == 1) ? 'Se ha habilitado la pregunta "'.$nm_pregunta.'" de la encuesta' : 
                                                'Se ha deshabilitado la pregunta "'.$nm_pregunta.'" de la encuesta';

            // Se actualiza tp_activo
            EncuestaPregunta::where('id','=',$nr_pregunta)->update(['tp_activo' => $tp_activo]);

            $arr_valida     =   [
                                    'error'     =>  0,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];
        } catch (Exception $e) {
            $str_msj        =   ($tp_activo == 1) ? 'Ha ocurrido un problema al Habilitar la pregunta' : 
                                                    'Ha ocurrido un problema al Deshabilitar la pregunta';
            $arr_valida     =   [
                                    'error'     =>  1,
                                    'tp_icon'   =>  'warning',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];
        }
        
        return $arr_valida;
    }
    //------------------------------------------------------------
    public function eliminarPregunta(Request $request)
    {
        $nr_pregunta        =   $request->nr_pregunta;
        $nm_pregunta        =   $request->nm_pregunta;
        $str_title          =   'Eliminar Pregunta';
        $str_msj            =   '';
        $arr_valida         =   [
                                    'error'     =>  0,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];

        try {
            $str_msj    =   'Se ha eliminado la pregunta "'.$nm_pregunta.'" de la encuesta"';

            // Se eliminan las alternativas y preguntas
            EncuestaAlternativa::where('id_pregunta','=',$nr_pregunta)->delete();
            EncuestaPregunta::where('id','=',$nr_pregunta)->delete();

            $arr_valida     =   [
                                    'error'     =>  0,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];
        } catch (Exception $e) {
            $str_msj        =   'Ha ocurrido un problema al eliminar la pregunta';
            $arr_valida     =   [
                                    'error'     =>  1,
                                    'tp_icon'   =>  'warning',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];
        }
        
        return $arr_valida;
    }
    //------------------------------------------------------------
    public function actualizarAlternativa(Request $request)
    {
        $nr_alternativa     =   $request->nr_alternativa;
        $new_alternativa    =   $request->nm_alternativa;
        $old_alternativa    =   $request->old_alternativa;
        $str_title          =   'Actualizar Alternativa';
        $str_msj            =   '';
        $arr_valida         =   [
                                    'error'     =>  0,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];

        try {
            $str_msj    =   ($new_alternativa != $old_alternativa) ?    'Se ha actualizado la pregunta "'.$old_alternativa.'" a "'.$new_alternativa.'"' : 
                                                                        'Se ha actualizado la pregunta "'.$old_alternativa.'"';

            EncuestaAlternativa::
            where('id','=',$nr_alternativa)
            ->update([
                'str_alternativa'   =>  $new_alternativa
            ]);

            $arr_valida     =   [
                                    'error'     =>  0,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];
        } catch (Exception $e) {
            $str_msj        =   'Ha ocurrido un problema al actualizar la alternativa';
            $arr_valida     =   [
                                    'error'     =>  1,
                                    'tp_icon'   =>  'warning',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];
        }
        
        return $arr_valida;
    }
    //------------------------------------------------------------
    public function estadoAlternativa(Request $request)
    {
        $nr_alternativa     =   $request->nr_alternativa;
        $nm_alternativa     =   $request->nm_alternativa;
        $tp_activo          =   $request->tp_activo;
        $str_title          =   ($tp_activo == 1) ? 'Habilitar Alternativa' : 'Deshabilitar Alternativa';
        $str_msj            =   '';
        $arr_valida         =   [
                                    'error'     =>  0,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];

        try {
            $str_msj    =   ($tp_activo == 1) ? 'Se ha habilitado la alternativa "'.$nm_alternativa.'" de la pregunta' : 
                                                'Se ha deshabilitado la alternativa "'.$nm_alternativa.'" de la pregunta';

            // Se actualiza tp_activo
            EncuestaAlternativa::where('id','=',$nr_alternativa)->update(['tp_activo' => $tp_activo]);

            $arr_valida     =   [
                                    'error'     =>  0,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];
        } catch (Exception $e) {
            $str_msj        =   ($tp_activo == 1) ? 'Ha ocurrido un problema al Habilitar la alternativa' : 
                                                    'Ha ocurrido un problema al Deshabilitar la alternativa';
            $arr_valida     =   [
                                    'error'     =>  1,
                                    'tp_icon'   =>  'warning',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];
        }
        
        return $arr_valida;
    }
    //------------------------------------------------------------
    public function eliminarAlternativa(Request $request)
    {
        $nr_alternativa     =   $request->nr_alternativa;
        $nm_alternativa     =   $request->nm_alternativa;
        $str_title          =   'Eliminar Alternativa';
        $str_msj            =   '';
        $arr_valida         =   [
                                    'error'     =>  0,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];

        try {
            $str_msj    =   'Se ha eliminado la alternativa "'.$nm_alternativa.'" de la pregunta"';

            // Se elimina la alternativa
            EncuestaAlternativa::where('id','=',$nr_alternativa)->delete();

            $arr_valida     =   [
                                    'error'     =>  0,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];
        } catch (Exception $e) {
            $str_msj        =   'Ha ocurrido un problema al eliminar la alternativa';
            $arr_valida     =   [
                                    'error'     =>  1,
                                    'tp_icon'   =>  'warning',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];
        }
        
        return $arr_valida;
    }
    //------------------------------------------------------------
    public function generarNumeroPregunta($nr_registro)
    {
        $nr_valor   =   1;

        try {
            $data   =   EncuestaPregunta::
                        select('nr_pregunta')
                        ->where('id_encuesta','=',$nr_registro)
                        ->orderby('nr_pregunta','desc')
                        ->get()->take(1);

            if($data->count())
                $nr_valor    =   $data->first()->nr_pregunta + 1;
        } catch (Exception $e) {
            $nr_valor    =   1;
        }

        return $nr_valor;
    }
    //------------------------------------------------------------
    public function generarNumeroAlternativa($nr_registro)
    {
        $nr_valor   =   1;

        try {
            $data   =   EncuestaAlternativa::
                        select('nr_alternativa')
                        ->where('id_pregunta','=',$nr_registro)
                        ->orderBy('nr_alternativa','desc')
                        ->get()->take(1);

            if($data->count())
                $nr_valor    =   $data->first()->nr_alternativa + 1;
        } catch (Exception $e) {
            $nr_valor   =   1;
        }

        return $nr_valor;
    }
    //------------------------------------------------------------
    public function generarValorAlternativa($nr_registro)
    {
        $nr_valor   =   1;

        try {
            $data   =   EncuestaAlternativa::
                        select('vl_alternativa')
                        ->where('id_pregunta','=',$nr_registro)
                        ->orderBy('vl_alternativa','desc')
                        ->get()->take(1);

            if($data->count())
                $nr_valor   =   $data->first()->vl_alternativa + 1;
        } catch (Exception $e) {
            $nr_valor   =   1;
        }

        return $nr_valor;
    }
    //------------------------------------------------------------
    public function existeRegistroPregunta(Request $request)
    {
        $nr_pregunta    =   $request->nr_pregunta;
        $tp_valida      =   0;

        try {
            $data       =   EncuestaPregunta::
                            where('id','=',$nr_pregunta)
                            ->get();

            if($data->count())
                $tp_valida  =   1;
        } catch (Exception $e) {
            $tp_valida  =   0;
        }

        return $tp_valida;
    }
    //------------------------------------------------------------
    public function existeAlternativa(Request $request)
    {
        $nr_pregunta        =   $request->nr_pregunta;
        $nr_pregunta        =   $request->nr_alternativa;
        $str_alternativa    =   trim($request->str_alternativa);
        $tp_valida          =   0;

        try {
            $data   =   EncuestaAlternativa::
                        whereRaw('str_alternativa LIKE ?',[$str_alternativa])
                        ->where('id_pregunta','=',$nr_pregunta)
                        ->get();            

            if($data->count())
                $tp_valida  =   1;
        } catch (Exception $e) {
            $tp_valida  =   0;
        }

        return $tp_valida;
    }
    //------------------------------------------------------------
    public function existeRegistroAlternativa(Request $request)
    {
        $nr_alternativa =   $request->nr_alternativa;
        $tp_valida      =   0;

        try {
            $data       =   EncuestaAlternativa::
                            where('id','=',$nr_alternativa)
                            ->get();

            if($data->count())
                $tp_valida  =   1;
        } catch (Exception $e) {
            $tp_valida  =   0;
        }

        return $tp_valida;
    }
    //------------------------------------------------------------
    public function getPregunta($nr_registro)
    {
        $data   =   null;

        try {
            $info   =   EncuestaPregunta::
                        where('id','=',$nr_registro)
                        ->get();

            if($info->count())
                $data   =   $info->first();
        } catch (Exception $e) {
            $data   =   null;
        }

        return $data;
    }
    //------------------------------------------------------------
}
