<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Tipo;
use App\Solicitud;

//Controladores
use App\Http\Controllers\GsutHistoriaController;
use App\Http\Controllers\AsignadorController;
use App\Http\Controllers\EmailController;

use DB;

class GsutFlujoController extends Controller
{
    public static function ingresoSolicitud($nr_id,$nr_tipo,$tp_ingreso) 
    {
        $fc_inicio          =   Date("Y-m-d H:i:s");
        $fc_termino         =   Date("Y-m-d H:i:s");
        $id_unidad          =   0;
        $id_depto           =   0;
        $nr_nivel           =   0;
        $tp_macrozona       =   0;
        $tp_asignacion      =   0;
        $nr_estado          =   1;
        $data_tipo          =   Tipo::where('id','=',$nr_tipo)->first();
        $id_unidad          =   $data_tipo->id_direccion;
        $id_depto           =   $data_tipo->id_depto;
        $nr_nivel           =   $data_tipo->nr_nivel;
        $tp_macrozona       =   $data_tipo->tp_macrozona;
        $tp_asignacion      =   $data_tipo->tp_asignacion;

        if(!$data_tipo)
            return  [
                        'error' =>  1,
                        'msj'   =>  'Tipo de Servicio inexistente'
                    ];
        
        $arr_data   =   [
                            'tipo_ingreso'      =>  $tp_ingreso,
                            'nr_solicitud'      =>  $nr_id,
                            'nr_servicio'       =>  $nr_tipo,
                            'servicio'          =>  $data_tipo->toArray(),
                        ];
        // \Log::debug(__METHOD__ . " Datos ingresados : " . print_r($arr_data, true));

        //  1. formulario | 2. territorial | 3. funcionario | 5. administrador | 4. macrozona | 6. Reuniones Comunitarias | 7. Redes Sociales | 8. Concejales | 9. App Movil | 10. Telefonista 
        if(in_array($tp_ingreso, [1,2,3,4,5,6,7,8,9,10]))
        {
            $nr_estado  =   1; // Ingresada

            // Registra hito de ingreso de solicitud
            GsutHistoriaController::registrarHistoria($nr_id, $nr_tipo, '', '', $nr_estado, $fc_inicio, $fc_termino);
                    
            // Si el servicio NO requiere macrozona y SI requiere Asigandor 
            if(($tp_ingreso == 4 && ($data_tipo->tp_macrozona == 0 || $data_tipo->tp_macrozona == 1) && $tp_asignacion == 1) || 
                ($data_tipo->tp_macrozona == 0 && $data_tipo->tp_asignacion == 1))
            {
                $nr_estado  =   2; // Por Asignar
                GsutHistoriaController::registrarHistoria($nr_id, $nr_tipo, '', '', $nr_estado, $fc_inicio, NULL);
            }
            // Si el servicio NO requiere macrozona y NO requiere Asigandor 
            if($data_tipo->tp_macrozona == 0 && $data_tipo->tp_asignacion == 0)
            {
                $nr_estado  =   3; // En Gestion
                AsignadorController::setAsignarSolicitud($nr_tipo, $nr_id);
                GsutHistoriaController::registrarHistoria($nr_id, $nr_tipo, '', '', $nr_estado, $fc_inicio, NULL);
            }

            //actualizacion nuevo estado
            Solicitud::where('id','=',$nr_id)->update(['id_estado'=>$nr_estado]);
        }

        EmailController::enviarNotificaciones($tp_ingreso, $nr_id); // Notificación via mail

        return $data_tipo;
    }

    public static function derivarSolicitud($nr_solicitud, $nr_servicio, $tp_ingreso, $str_derivar, $str_html)
    {
        $fc_inicio          =   Date("Y-m-d H:i:s");
        $fc_termino         =   Date("Y-m-d H:i:s");
        $data_servicio      =   Tipo::where('id','=',$nr_servicio)->get()->first();
        $id_unidad          =   0;
        $id_depto           =   0;
        $nr_nivel           =   0;
        $tp_macrozona       =   0;
        $tp_asignacion      =   0;        

        if(!$data_servicio)
            return ['error'=>1, 'msj'=>'Tipo de Servicio inexistente'];

        //  1. formulario | 2. territorial | 3. funcionario | 4. macrozona | 5. Administrador
        if($tp_ingreso == 3 || $tp_ingreso == 4 || $tp_ingreso == 5) 
        {
            $id_unidad      =   $data_servicio->id_direccion;
            $id_depto       =   $data_servicio->id_depto;
            $nr_nivel       =   $data_servicio->nr_nivel;
            $tp_macrozona   =   $data_servicio->tp_macrozona;

            // Si el servicio SI requiere revision macrozona
            if($tp_macrozona == 1 && $tp_ingreso != 4)
            {
                $nr_estado  =   1; // Ingresado, en espera de visacion
                $tp_estado  =   9; // Derivado a Macrozona

                AsignadorController::setQuitarAsignacion($nr_solicitud);
                GsutHistoriaController::registrarHistoria($nr_solicitud, $nr_servicio, $str_derivar, $str_html, $tp_estado, $fc_inicio, NULL);

                Solicitud::
                where('id','=',$nr_solicitud)
                ->update([
                    'fc_visado_mt'  =>  null,
                    'tp_visado_mt'  =>  0,
                    'tp_asignador'  =>  0,
                    'fc_asignador'  =>  null,
                    'fc_derivado'   =>  $fc_inicio,
                    'id_estado'     =>  $nr_estado
                ]);
            }
            // Si el servicio NO requiere revision macrozona y SI requiere asignacion
            if(($tp_macrozona == 0 || $tp_ingreso == 4) && $tp_asignacion == 1)
            {
                $nr_estado  =   2; // visado, en espera de asignacion
                $tp_estado  =   10; // Derivado a Asignador
                $fc_visado  =   ($tp_ingreso == 4) ? $fc_inicio: null;
                $tp_visado  =   ($tp_ingreso == 4) ? 1: 0;

                AsignadorController::setQuitarAsignacion($nr_solicitud);
                GsutHistoriaController::registrarHistoria($nr_solicitud, $nr_servicio, $str_derivar, $str_html, $tp_estado, $fc_inicio, NULL);

                Solicitud::
                where('id','=',$nr_solicitud)
                ->update([
                    'fc_derivado'   =>  $fc_inicio,
                    'id_estado'     =>  $nr_estado,
                    'fc_visado_mt'  =>  $fc_visado,
                    'tp_visado_mt'  =>  $tp_visado,
                    'tp_asignador'  =>  0,
                    'fc_asignador'  =>  null
                ]);
            }
            // Si el servicio NO requiere revision macrozona y NO requiere asignacion
            if($tp_macrozona == 0 && $tp_asignacion == 0)
            {
                $nr_estado  =   3; // En Gestion
                $tp_estado  =   8; // Derivado a Funcionario

                AsignadorController::setQuitarAsignacion($nr_solicitud);
                AsignadorController::setAsignarSolicitud($nr_servicio, $nr_solicitud);
                GsutHistoriaController::registrarHistoria($nr_solicitud, $nr_servicio, $str_derivar, $str_html, $tp_estado, $fc_inicio, NULL);

                Solicitud::
                where('id','=',$nr_solicitud)
                ->update([
                    'fc_visado_mt'  =>  null,
                    'tp_visado_mt'  =>  0,
                    'tp_asignador'  =>  0,
                    'fc_asignador'  =>  null,
                    'fc_derivado'   =>  $fc_inicio,
                    'id_estado'     =>  $nr_estado
                ]);
            }

            EmailController::enviarNotificaciones($tp_ingreso, $nr_solicitud);
        }
    }

    public function regularizarSolicitudesSinFlujo()
    {
        $nr_cantidad    =   0;
        $fc_inicio      =   Date("Y-m-d H:i:s");
        $fc_termino     =   Date("Y-m-d H:i:s");

        $data           =   Solicitud::
                            where(function ($query) {
                                $query->where('id_estado','=','1')
                                    ->where('tp_activo','=','1');
                            })
                            ->whereNotExists(function ($query) {
                                $query->select(DB::raw('1'))
                                    ->from('gsut_historial')
                                    ->whereRaw('gsut_historial.id_solicitud = gsut_solicitud.id');
                            })
                            ->get();

        foreach ($data as $key => $value) {
            $nr_estado      =   1;
            // Obtiene informacion del servicio
            $info_servicio      =   Tipo::where('id','=',$value->id_tipo)->first();

            // Registra hito de ingreso de solicitud
            GsutHistoriaController::registrarHistoria($value->id, $value->id_tipo, '', '', $nr_estado, $fc_inicio, $fc_termino);

            // Si el servicio NO requiere macrozona y SI requiere Asigandor 
            if(($value->tp_ingreso == 4 && ($info_servicio->tp_macrozona == 0 || $info_servicio->tp_macrozona == 1) && $info_servicio->tp_asignacion == 1) || 
                ($info_servicio->tp_macrozona == 0 && $info_servicio->tp_asignacion == 1))
            {
                $nr_estado  =   2; // Por Asignar
                GsutHistoriaController::registrarHistoria($value->id, $Value->id_tipo, '', '', $nr_estado, $fc_inicio, NULL);
            }
            // Si el servicio NO requiere macrozona y NO requiere Asigandor 
            if($info_servicio->tp_macrozona == 0 && $info_servicio->tp_asignacion == 0)
            {
                $nr_estado  =   3; // En Gestion
                AsignadorController::setAsignarSolicitud($value->id_tipo, $value->id);
                GsutHistoriaController::registrarHistoria($value->id, $value->id_tipo, '', '', $nr_estado, $fc_inicio, NULL);
            }

            //actualizacion nuevo estado
            Solicitud::where('id','=',$value->id)->update(['id_estado'=>$nr_estado]);
        }

        return ['cantidad' => $data->count()];
    }
}
