<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class MailRespuestaServicio extends Mailable
{
    use Queueable, SerializesModels;

    private $nm_vecino;
    private $nr_ticket;
    private $str_mensaje;
    private $str_asunto;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($str_asunto, $str_mensaje, $nm_vecino, $info_ticket)
    {
        $this->nm_vecino    =   $nm_vecino;
        $this->info_ticket  =   $info_ticket;
        $this->str_mensaje  =   $str_mensaje;
        $this->str_asunto   =   $str_asunto;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->from('atencionvecino@lascondes.cl','Sistema Atención al Vecino Las Condes')
                    ->subject($this->str_asunto)
                    ->view('emails.notificacion_servicio')
                    ->with([
                        'nm_vecino'     =>  $this->nm_vecino,
                        'str_mensaje'   =>  $this->str_mensaje,
                    ]);
    }
}
