<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_municipio')->unsigned();
            $table->integer('id_direccion')->unsigned();
            $table->integer('id_depto')->unsigned();
            $table->string('rut', 20)->unique();
            $table->string('nombre', 50)->default('');
            $table->string('ap_paterno', 50)->default('');
            $table->string('ap_materno', 50)->default('');
            $table->string('name', 180)->default('');
            $table->string('movil', 20)->default('');
            $table->string('email');//->unique();//podrian existir correos repetidos para distintos usuarios
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');            
            $table->integer('id_rol')->default(1);
            $table->integer('tp_admin')->default(1);
            $table->integer('condicion')->default(1);
            $table->integer('tp_activo')->default(1);
            $table->string('api_token', 60)->unique()->nullable();
            $table->tinyInteger('has_reset_passwd')->default(0);

            // permisos usuario
            $table->integer('nr_nivel')->default(1);
            $table->integer('tp_informar')->default(1);
            $table->integer('tp_responder')->default(1);
            $table->integer('tp_finalizar')->default(1);
            $table->integer('tp_derivar')->default(1);

            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
