@extends('template.home')

@section('body')
<div class="page-content">
    <div class="container-fluid" id="app">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18">Estructura Encuesta</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Estructura Encuesta</a></li>
                            <li class="breadcrumb-item active">Encuestas</li>
                        </ol>
                    </div>
                </div>

                <!-- Filtros Especificos -->
                <div class="row mb-3 not-print">
                    <div class="col-lg-3 col-md-6 col-sm-6" style="text-align:left;">
                        <!-- No se realizan filtro por estado -->
                    </div>
                    <div class="col-lg-3 col-md-6 col-sm-6" style="text-align: left;">
                        <!-- No se realizaran filtros por rango de fechas -->
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-6" style="text-align:right;">
                        <!-- No se realizan filtrar por orden -->                           
                    </div>
                    <div class="col-lg-2 col-md-6 col-sm-6" style="text-align:right">
                        <button id="btn_actualizar" class="btn btn-success btn_activo" @click="abrirModal('encuesta', 'crear_encuesta')">
                            <i class="fas fa-sync"></i> Crear Encuesta
                        </button>
                        <button id="btn_actualizar" class="btn btn-primary btn_activo" @click="cargarDatos(pagination.current_page);">
                            <i class="fas fa-sync"></i> Actualizar
                        </button>
                        <!--
                        <button class="btn btn-primary btn_activo" id="btn_filtrar_datos">
                            <i class="fas fa-search"></i> Filtrar Datos
                        </button>
                        -->
                    </div>                        
                </div>

                <!-- Filtro Generales - Tabla de Datos - Paginacion -->
                <div class="row">
                    <!-- Filtro de Datos -->
                    <div class="col-md-12 col-sm-12">
                        <div class="collapse" id="filtrar_datos">
                            <div class="card">
                                <div class="card-header bg-primary">
                                    <div class="col-md-12 col-sm-12 text-center">
                                        <h5 style="color:white;">Filtro de busqueda</h5>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row ml-2 mr-2">
                                        <div class="col-md-12 col-sm-12"> </div>
                                        <!-- Dirección Municipal -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Dirección Municipal :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_direccion"
                                                    :options="arr_direccion" 
                                                    @select="asyncDeptos" 
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Dirección Municipal"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                        <!-- Depto Municipal -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Depto Municipal :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_depto"
                                                    :options="arr_depto" 
                                                    @select="asyncServicios" 
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Depto Municipal"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                        <!-- Servicio -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Servicio :
                                                </label>
                                                <multiselect
                                                    :show-labels="false" 
                                                    :searchable="true" 
                                                    v-model="fl_servicio" 
                                                    :options="arr_servicio" 
                                                    :multiple="false" 
                                                    :showNoOptions="false" 
                                                    placeholder="Servicio" 
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                        <!-- Macrozona -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Macrozona :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_macrozona"
                                                    :options="arr_macrozona"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Unidad Vecinal"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                        <!-- Unidad Vecinal -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Unidad Vecinal :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_unidadvecinal"
                                                    :options="arr_unidadvecinal"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Unidad Vecinal"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                        <!-- Ticket -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    N° Ticket :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_ticket"
                                                    :options="arr_ticket"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="N° Ticket"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                        <!-- Solicitante -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Solicitante :
                                                </label>
                                                <multiselect
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_persona"
                                                    :options="arr_persona"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Solicitante"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                        <!-- Motivo -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Tipo Requerimiento :
                                                </label>
                                                <multiselect
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_motivo"
                                                    :options="arr_motivo"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Tipo Requerimiento"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                        <!-- Ubicación del Problema -->
                                        <div class="col-md-4 col-sm-6 mt-2">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Dirección del Requerimiento :
                                                </label>
                                                <multiselect
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_ubicacion"
                                                    :options="arr_ubicaciones"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Dirección del Requerimiento"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div style="float: right;">
                                        <button @click="limpiarFiltros()" type="button" class="btn btn-warning btn-sm btn_activo" style="color: white;">
                                            <i class="fas fa-undo"></i> Quitar Filtros
                                        </button>&nbsp;
                                        <button @click="filtrarDatos()" type="button" class="btn btn-primary btn-sm btn_activo"><i class="fas fa-search"></i>
                                            Filtrar Búsqueda
                                        </button>

                                        <button class="btn btn-secondary btn-sm btn_activo" id="close_filtrar_datos">
                                            Cerrar Filtro
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Tabla de Datos -->
                    <div class="responsive-table">
                        <table  class="table table-bordered border-info table-striped table-sm table-hover bl-1">
                            <thead class="bg-primary">
                                <th colspan="12" >
                                    <h6 class="text-center" style="color:white" >
                                        Listado de Encuestas
                                    </h6>
                                </th>
                            </thead>
                            <thead class="bg-primary"  style="color:white">
                                <th class="text-center"> # </th>
                                <th class="text-center" style="min-width:100px;">Opción</th>
                                <th class="text-center" style="min-width:100px;">Encuesta</th>
                                <th class="text-center" style="min-width:100px;">Cantidad Preguntas</th>
                                <th class="text-center" style="min-width:400px;">Descripción</th>
                                <th class="text-center" style="min-width:100px;">Estado</th>
                            </thead>
                            <tbody>
                                <template v-if="arr_index.length">
                                    <tr v-for="(datos, index) in arr_index" :key="datos.id">
                                        <td style="text-align:center;">
                                            @{{ (index + 1) }}
                                        </td>
                                        <td style="text-align:center;">
                                            <div class="dropdown">
                                                <button class="btn btn-secondary" type="button" id="menu_opcion" data-bs-toggle="dropdown" aria-expanded="false">
                                                    Opción <i class="mdi mdi-chevron-down"></i>
                                                </button>
                                                <div class="dropdown-menu" aria-labelledby="menu_opcion">
                                                    <!-- Actualizar Encuesta -->
                                                    <a href="#" class="dropdown-item" 
                                                         @click="abrirModal('encuesta', 'editar_encuesta', datos)">
                                                            <i class="fas fa-clipboard" style="color:lightskyblue; margin-right: 15px;"></i> 
                                                            Actualizar Encuesta
                                                    </a>
                                                    <!-- Revisar Estructura -->
                                                    <a href="#" class="dropdown-item" 
                                                         @click="abrirModal('encuesta', 'estructura', datos)">
                                                            <i class="fas fa-clipboard" style="color:lightskyblue; margin-right: 15px;"></i> 
                                                            Revisar Estructura
                                                    </a>
                                                    <!-- Habilitar Encuesta -->
                                                    <a href="#" class="dropdown-item" v-if="datos.tp_activo == 0" 
                                                        @click="abrirModal('encuesta', 'habilitar_encuesta', datos)">
                                                            <i class="far fa-plus-square" style="color:lightskyblue; margin-right: 15px;"></i>
                                                            Habilitar Encuesta
                                                    </a>

                                                    <!-- Deshabilitar Encuesta -->
                                                    <a href="#" class="dropdown-item" v-if="datos.tp_activo == 1"
                                                        @click="abrirModal('encuesta', 'deshabilitar_encuesta', datos)">
                                                            <i class="far fa-minus-square" style="color:lightskyblue; margin-right: 15px;"></i>
                                                            Deshabilitar Encuesta
                                                    </a>
                                                </div>
                                            </div>
                                        </td>
                                        <td style="text-align:center;">
                                            @{{ datos.nm_encuesta }}
                                        </td>
                                        <td style="text-align:center;">
                                            @{{ datos.nr_cantidad_preguntas }}
                                        </td>
                                        <td  style="text-align:left; color: black;">
                                            @{{ datos.str_descripcion }}
                                        </td>
                                        <td style="text-align:left;">
                                            @{{ datos.nm_estado }}
                                        </td>
                                    </tr>
                                </template>
                                <template v-else>
                                    <tr>
                                        <td colspan="12">
                                            <h5 class="text-center">
                                                No hay datos para listar
                                            </h5>
                                        </td>
                                    </tr>
                                </template>
                            </tbody>
                        </table>
                    </div>

                    <!-- Paginacion -->
                    <div class="col-md-12 col-sm-12">
                        <nav>
                            <ul class="pagination">
                                <li class="page-item" v-if="pagination.current_page > 1">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(1)">Primera</a>
                                </li>
                                <li class="page-item" v-if="pagination.current_page > 1">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.current_page - 1)">Ant</a>
                                </li>
                                <li class="page-item" v-for="page in pagesNumber" :key="page" :class="[page == isActivedPagination ? 'active' : '']">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(page, 1)" v-text="page"></a>
                                </li>
                                <li class="page-item" v-if="pagination.current_page < pagination.last_page">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.current_page + 1)">Sig</a>
                                </li>
                                <li class="page-item" v-if="pagination.current_page < pagination.last_page">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.last_page)">Ultima</a>
                                </li>
                            </ul>
                        </nav>
                    </div>                      
                </div>
            </div>
        </div>

        <div class="modal" tabindex="-1" id="modal_estructura">
            <div class="modal-dialog modal-dialog-scrollable modal-xxl">
                <div class="modal-content">
                    <div class="modal-header bg-primary">
                        <h5 class="modal-title text-white" id="title_modal">@{{ titulo_modal }}</h5>
                        <button type="button" class="btn-close" @click="cerrarModal('estructura')" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="col-md-12 col-sm-12 mt-2">
                            <div class="row-flow">
                                <!-- Información de la Encuesta -->
                                <div class="card mt-2 border-info" v-if="info_encuesta">
                                    <div class="card-header bg-primary border-info text-center">
                                        <div class="form-check form-check-inline">
                                            <h5 class="form-check-label text-white">Información de la Encuesta</h5>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="row" >
                                            <div class="col-md-12 col-sm-12">
                                                <div class="row">
                                                    <div class="col-lg-2 col-md-3 col-sm-12">
                                                        <label class="form-control">
                                                            <span class="font-size-14 text-secundary font-weight-bolder" style="font-weight: 500;">Nombre Encuesta</span>
                                                        </label>
                                                    </div>
                                                    <div class="col-lg-10 col-md-9 col-sm-12">
                                                        <label class="form-control text-justify">
                                                            @{{ info_encuesta.nm_encuesta }}
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-12 col-sm-12">
                                                <div class="row">
                                                    <div class="col-lg-2 col-md-3 col-sm-12">
                                                        <label class="form-control">
                                                            <span class="font-size-14 text-secundary font-weight-bolder" style="font-weight: 500;">Descripción</span>
                                                        </label>
                                                    </div>
                                                    <div class="col-lg-12 col-md-12 col-sm-12">
                                                        <label class="form-control text-justify">
                                                            @{{ info_encuesta.str_descripcion }}
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Estructura Encuesta -->
                                <div class="card mt-2 border-info">
                                    <div class="card-header bg-primary border-info text-center">
                                        <div class="form-check form-check-inline">
                                            <h5 class="form-check-label text-white">Estructura de la Encuesta</h5>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="col-lg-12 col-md-12 col-sm-12">
                                            <div class="row" v-if="arr_encuesta.length">
                                                <div class="col-md-6 col-sm-12" v-for="(pregunta, index) in arr_encuesta" :key="index">
                                                    <div class="card" :id="'E0'+nr_encuesta+'_'+pregunta.cod_pregunta">
                                                        <div class="card-body">
                                                            <div class="col-md-12 col-sm-12">
                                                                <div class="row">
                                                                    <div class="col-md-8 col-sm-8 ">
                                                                        <h5 class="font-weight-bold" style="font-style: unset;">
                                                                            <template v-if="pregunta.nr_pregunta">@{{ (index+1) + '.- ' }}</template>
                                                                            @{{ pregunta.str_pregunta }}
                                                                        </h5>
                                                                    </div>
                                                                    <div class="col-md-4 col-sm-4 text-right" style="text-align: right;">
                                                                        <div class="form-group">
                                                                            <i class="btn fas fa-plus text-success fa-lg ml-2" title="Agregar Alternativa" @click="asyncEstructura(2,pregunta)"></i>
                                                                            <i class="btn fas fa-pen text-warning fa-lg ml-2" title="Editar Pregunta" @click="abrirModal('pregunta','editar_pregunta',pregunta)"></i>
                                                                            <i class="btn fas fa-trash text-danger fa-lg ml-2" title="Quitar Pregunta" @click="abrirModal('pregunta','quitar_pregunta',pregunta)"></i>
                                                                            <i class="btn fas fa-check text-success fa-lg ml-2" title="Habilitar Pregunta" 
                                                                                @click="abrirModal('pregunta','habilitar_pregunta',pregunta)" v-if="pregunta.tp_activo == 0"></i>
                                                                            <i class="btn fas fa-ban text-danger fa-lg ml-2" title="Deshabilitar Pregunta" 
                                                                                @click="abrirModal('pregunta','deshabilitar_pregunta',pregunta)" v-else></i>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-12 col-sm-12">
                                                                <template v-if="pregunta.tp_pregunta == 1">
                                                                    <input type="text" class="form-control" style="width: 60%;" :id="'E0'+nr_encuesta+'_'+pregunta.str_formdata">
                                                                </template>
                                                                <template v-if="pregunta.tp_pregunta == 2">
                                                                    <div class="form-check border-bottom border-primary mt-2" v-for="alternativa in pregunta.alternativa" :key="alternativa.id">
                                                                        <div class="row">
                                                                            <div class="col-md-9 col-sm-8">
                                                                                <input class="form-check-input" type="radio" :name="pregunta.str_formdata" 
                                                                                    :id="'E0'+nr_encuesta+'_'+pregunta.str_formdata+'_'+alternativa.cod_alternativa" 
                                                                                    :value="alternativa.vl_alternativa">
                                                                                <label class="form-check-label" :for="pregunta.str_formdata">
                                                                                    @{{ alternativa.str_alternativa }}
                                                                                </label>
                                                                            </div>
                                                                            <div class="col-md-3 col-sm-4" style="text-align: right;">
                                                                                <div class="form-group">
                                                                                    <i class="btn fas fa-pen text-warning ml-2" title="Editar Alternativa" @click="abrirModal('alternativa','editar_alternativa',alternativa)"></i>
                                                                                    <i class="btn fas fa-trash text-danger ml-2" title="Quitar Alternativa" @click="abrirModal('alternativa','quitar_alternativa',alternativa)"></i>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </template>
                                                                <template v-if="pregunta.tp_pregunta == 3">
                                                                    <div class="col-md-6 col-sm-12">
                                                                        <select :name="pregunta.str_formdata" :id="'E0'+nr_encuesta+'_'+pregunta.str_formdata" class="form-control">
                                                                            <option value="0">Seleccione una opción</option>
                                                                            <option v-for="alternativa in pregunta.alternativa" :key="alternativa.id" 
                                                                                :value="alternativa.vl_alternativa" v-text="alternativa.str_alternativa"></option>
                                                                        </select>

                                                                        <div class="col-md-12 col-sm-12" style="width: 650px; height: 200px; overflow-y: scroll; overflow-x: hidden;">
                                                                            <div class="border-bottom border-primary mt-2" v-for="alternativa in pregunta.alternativa" :key="alternativa.id">
                                                                                <div class="row">
                                                                                    <div class="col-md-9 col-sm-8 pl-3">
                                                                                        <label class="form-control-label" :for="pregunta.str_formdata">
                                                                                            @{{ 'Opción - ' + alternativa.str_alternativa }}
                                                                                        </label>
                                                                                    </div>
                                                                                    <div class="col-md-3 col-sm-4" style="text-align: right;">
                                                                                        <div class="form-group">
                                                                                            <i class="btn fas fa-pen text-warning ml-2" title="Editar Alternativa" @click="abrirModal('alternativa','editar_alternativa',alternativa)"></i>
                                                                                            <i class="btn fas fa-trash text-danger ml-2" title="Quitar Alternativa" @click="abrirModal('alternativa','quitar_alternativa',alternativa)"></i>
                                                                                            <i class="btn fas fa-check text-success fa-lg ml-2" title="Habilitar Alternativa" 
                                                                                                @click="abrirModal('alternativa','habilitar_alternativa',alternativa)" v-if="pregunta.tp_activo == 0"></i>
                                                                                            <i class="btn fas fa-ban text-danger fa-lg ml-2" title="Deshabilitar Alternativa" 
                                                                                                @click="abrirModal('alternativa','deshabilitar_alternativa',alternativa)" v-else></i>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </template>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 col-md-12 col-sm-12 text-center">
                                            <div class="dropdown">
                                                <button class="btn btn-secondary" type="button" id="menu_tipo" data-bs-toggle="dropdown" aria-expanded="false">
                                                    Agregar Pregunta <i class="mdi mdi-chevron-down"></i>
                                                </button>
                                                <div class="dropdown-menu" aria-labelledby="menu_tipo">
                                                    <a href="#" class="dropdown-item" v-for="(formato, index) in arr_formato" :key="index"  @click="asyncEstructura(1, formato)">
                                                        <i class="fas fa-clipboard" style="color:lightskyblue; margin-right: 15px;"></i> 
                                                        @{{ formato.label }} 
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <div class="col-md-12 col-sm-12">
                            <button type="button" class="btn btn-md btn-secondary col-lg-2 col-md-3 col-sm-4" style="float: right;" @click="cerrarModal('estructura')">Cerrar</button>
                            <button type="button" class="btn btn-md btn-secondary col-lg-2 col-md-3 col-sm-4 mr-2" style="float: right; margin-right: inherit;" @click="abrirModal('encuesta','modelo')">Test Encuesta</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal" tabindex="-1" id="modal_encuesta">
            <div class="modal-dialog modal-dialog-scrollable">
                <div class="modal-content">
                    <div class="modal-header bg-primary">
                        <h5 class="modal-title text-white" id="title_modal">@{{ titulo_modal }}</h5>
                        <button type="button" class="btn-close" @click="cerrarModal('crear_encuesta')" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="col-md-12 col-sm-12 mt-2">
                            <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    <label class="form-control-label">Nombre de la Encuesta</label>
                                    <div class="form-group">                                        
                                        <input type="text" class="form-control" v-model="nm_encuesta" placeholder="Nombre de la Encuesta" maxlength="250">
                                    </div>
                                </div>
                                <div class="col-md-12 col-sm-12 mt-2">
                                    <label class="form-control-label">Descripción de la Encuesta</label>
                                    <div class="form-group">                                        
                                        <textarea rows="3" class="form-control" v-model="str_descripcion" placeholder="Descripción de la Encuesta"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <div class="col-md-12 col-sm-12">
                            <button type="button" class="btn btn-md btn-secondary col-lg-2 col-md-3 col-sm-12" style="float: right; margin-left: inherit;" @click="cerrarModal('crear_encuesta')">Cerrar</button>
                            <template v-if="tp_accion == 2">
                                <button type="button" class="btn btn-md btn-primary col-lg-3 col-md-4 col-sm-12" style="float: right;" @click="ensamblarDatos('crear_encuesta')" v-if="btn_envio == 0">
                                    <i class="fas fa-save"></i> Registrar
                                </button>
                                <button v-else type="button" class="btn btn-success col-lg-3 col-md-4 col-sm-12" style="float: right; margin-left: inherit;">Registrando <i class="fas fa-spin fa-spinner"></i></button>
                            </template>
                            <template v-if="tp_accion == 3">
                                <button type="button" class="btn btn-md btn-primary col-lg-3 col-md-4 col-sm-12" style="float: right;" @click="ensamblarDatos('editar_encuesta')" v-if="btn_envio == 0">
                                    <i class="fas fa-save"></i> Actualizar
                                </button>
                                <button v-else type="button" class="btn btn-success col-lg-3 col-md-4 col-sm-12" style="float: right; margin-left: inherit;">Actualizando <i class="fas fa-spin fa-spinner"></i></button>
                            </template>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal" tabindex="-1" id="modal_pregunta">
            <div class="modal-dialog modal-dialog-scrollable mt-5 pt-5">
                <div class="modal-content">
                    <div class="modal-header bg-primary">
                        <h5 class="modal-title text-white" id="title_modal">Actualizar Pregunta</h5>
                        <button type="button" class="btn-close" @click="cerrarModal('modal_pregunta')" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="col-md-12 col-sm-12 mt-2">
                            <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    <label class="form-control-label">Nombre de la Pregunta</label>
                                    <div class="form-group">                                        
                                        <input type="text" class="form-control" v-model="nm_pregunta" placeholder="Nombre de la Pregunta" maxlength="250">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <div class="col-md-12 col-sm-12">
                            <button type="button" class="btn btn-md btn-secondary col-lg-2 col-md-3 col-sm-12" style="float: right; margin-left: inherit;" @click="cerrarModal('modal_pregunta')">Cerrar</button>
                            <button type="button" class="btn btn-md btn-primary col-lg-3 col-md-4 col-sm-12" style="float: right;" @click="ensamblarDatos('editar_pregunta')" v-if="btn_envio == 0">
                                <i class="fas fa-save"></i> Actualizar
                            </button>
                            <button v-else type="button" class="btn btn-success col-lg-3 col-md-4 col-sm-12" style="float: right; margin-left: inherit;">Actualizando <i class="fas fa-spin fa-spinner"></i></button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal" tabindex="-1" id="modal_alternativa">
            <div class="modal-dialog modal-dialog-scrollable mt-5 pt-5">
                <div class="modal-content">
                    <div class="modal-header bg-primary">
                        <h5 class="modal-title text-white" id="title_modal">Actualizar Alternativa</h5>
                        <button type="button" class="btn-close" @click="cerrarModal('modal_alternativa')" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="col-md-12 col-sm-12 mt-2">
                            <div class="row">
                                <div class="col-md-12 col-sm-12">
                                    <label class="form-control-label">Nombre de la Alternativa</label>
                                    <div class="form-group">                                        
                                        <input type="text" class="form-control" v-model="nm_alternativa" placeholder="Nombre de la Alternativa" maxlength="250">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <div class="col-md-12 col-sm-12">
                            <button type="button" class="btn btn-md btn-secondary col-lg-2 col-md-3 col-sm-12" style="float: right; margin-left: inherit;" @click="cerrarModal('modal_alternativa')">Cerrar</button>
                            <button type="button" class="btn btn-md btn-primary col-lg-3 col-md-4 col-sm-12" style="float: right;" @click="ensamblarDatos('editar_alternativa')" v-if="btn_envio == 0">
                                <i class="fas fa-save"></i> Actualizar
                            </button>
                            <button v-else type="button" class="btn btn-success col-lg-3 col-md-4 col-sm-12" style="float: right; margin-left: inherit;">Actualizando <i class="fas fa-spin fa-spinner"></i></button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal" tabindex="-1" id="modal_modelo">
            <div class="modal-dialog modal-dialog-scrollable modal-lg mt-5 pt-5">
                <div class="modal-content">
                  <div class="modal-header bg-primary">
                    <h5 class="modal-title text-white" id="title_modal">@{{ titulo_modal }}
                        <template v-if="nr_ticket">@{{ ' - Ticket #' + nr_ticket }}</template> 
                    </h5>
                    <button type="button" class="btn-close" @click="cerrarModal('modelo')" aria-label="Close"></button>
                  </div>
                  <div class="modal-body">
                        <div class="col-md-12 col-sm-12">
                            <div class="row">
                                <div class="col-md-12 col-sm-12" v-if="tp_encuesta == 1">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="col-md-12 col-sm-12 text-center" v-if="tp_iniciar_encuesta == 0">
                                                <button class="btn btn-sm btn-md btn-primary" @click="asyncEncuesta()" v-if="tp_utilizar == 0">
                                                    <span class="h4 text-white">Iniciar Encuesta</span>
                                                </button>
                                                <span class="h5 text-danger">@{{ tp_utilizar_msj }}</span>
                                            </div>
                                            <div class="col-md-12 col-sm-12" v-else>
                                                <form id="form_encuesta" action="" method="">
                                                    <div class="row" v-if="arr_estructura.length">
                                                        <div class="col-md-12 col-sm-12" v-for="(pregunta, index) in arr_estructura" :key="pregunta.id">
                                                            <div class="card" :id="pregunta.cod_pregunta">
                                                                <div class="card-body">
                                                                    <div class="col-md-12 col-sm-12">
                                                                        <h5 class="font-weight-bold" style="font-style: unset;">@{{ pregunta.str_pregunta }}</h5>
                                                                    </div>
                                                                    <div class="col-md-12 col-sm-12 text-left">
                                                                        <template v-if="pregunta.tp_pregunta == 2">
                                                                            <div class="form-check" v-for="alternativa in pregunta.alternativa" :key="alternativa.id">
                                                                                <input class="form-check-input" type="radio" :name="pregunta.str_formdata" 
                                                                                    :id="pregunta.str_formdata+'_'+alternativa.cod_alternativa" 
                                                                                    :value="alternativa.vl_alternativa">
                                                                                <label class="form-check-label" :for="pregunta.str_formdata">
                                                                                    @{{ alternativa.str_alternativa }}
                                                                                </label>
                                                                            </div>
                                                                        </template>
                                                                        <template v-if="pregunta.tp_pregunta == 3">
                                                                            <div class="col-md-6">
                                                                                <select :name="pregunta.str_formdata" :id="pregunta.str_formdata" class="form-control">
                                                                                    <option value="0">Seleccione una opción</option>
                                                                                    <option v-for="alternativa in pregunta.alternativa" :key="alternativa.id" :value="alternativa.vl_alternativa" v-text="alternativa.str_alternativa"></option>
                                                                                </select>
                                                                            </div>
                                                                        </template>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12 col-sm-12" v-if="tp_encuesta == 2">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="col-md-12 col-sm-12 text-center" v-if="tp_iniciar_encuesta == 0">
                                                <button class="btn btn-sm btn-md btn-primary" @click="asyncEncuesta()" v-if="tp_utilizar == 0">
                                                    <span class="h4 text-white">Iniciar Encuesta</span>
                                                </button>
                                                <span class="h5 text-danger">@{{ tp_utilizar_msj }}</span>
                                            </div>
                                            <div class="col-md-12 col-sm-12" v-else>
                                                <form id="form_encuesta" action="" method="">
                                                    <div class="row" v-if="arr_estructura.length">
                                                        <div class="col-md-12 col-sm-12" v-for="(pregunta, index) in arr_estructura" :key="pregunta.id">
                                                            <div class="card encuesta_pregunta" :id="pregunta.cod_pregunta" :class="{'d-block':index == 0,'d-none':index != 0}">
                                                                <div class="card-body">
                                                                    <div class="col-md-12 col-sm-12">
                                                                        <h5 class="font-weight-bold" style="font-style: unset;">@{{ pregunta.str_pregunta }}</h5>
                                                                    </div>
                                                                    <div class="col-md-12 col-sm-12 text-left">
                                                                        <template v-if="pregunta.tp_pregunta == 2">
                                                                            <div class="form-check" v-for="alternativa in pregunta.alternativa" :key="alternativa.id">
                                                                                <input class="form-check-input" type="radio" :name="pregunta.str_formdata" 
                                                                                    :id="pregunta.str_formdata+'_'+alternativa.cod_alternativa" 
                                                                                    :value="alternativa.vl_alternativa" @click="asyncPregunta(pregunta, alternativa)">
                                                                                <label class="form-check-label" :for="pregunta.str_formdata">
                                                                                    @{{ alternativa.str_alternativa }}
                                                                                </label>
                                                                            </div>
                                                                        </template>
                                                                        <template v-if="pregunta.tp_pregunta == 3">
                                                                            <div class="col-md-6">
                                                                                <select :name="pregunta.str_formdata" :id="pregunta.str_formdata" class="form-control" @click="asyncPregunta(pregunta, null)">
                                                                                    <option value="0">Seleccione una opción</option>
                                                                                    <option v-for="alternativa in pregunta.alternativa" :key="alternativa.id" :value="alternativa.vl_alternativa" v-text="alternativa.str_alternativa"></option>
                                                                                </select>
                                                                            </div>
                                                                        </template>
                                                                        <div class="col-md-12 col-sm-12">
                                                                            <div class="text-center">
                                                                                <button id="btn_encuesta_back" type="button" class="btn btn-sm btn-secondary" @click="showPregunta(2, pregunta)" 
                                                                                    v-if="(btn_encuesta_back == 1 && (index != 0))">Anterior</button>
                                                                                <button id="btn_encuesta_next" type="button" class="btn btn-sm btn-secondary" @click="showPregunta(1, pregunta)" 
                                                                                    v-if="btn_encuesta_next == 1">Siguiente</button>

                                                                                <template v-if="btn_encuesta_save == 1">
                                                                                    <button v-if="btn_envio == 0" type="button" 
                                                                                        class="btn btn-sm btn-success  waves-effect waves-light" 
                                                                                            @click="desplegarVentana('warning', 'Test de Encuesta de Atención Vecino','Esta acción no se encuestra disponible')">
                                                                                        <i class="fas fa-save"></i> Registrar
                                                                                    </button>
                                                                                </template>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-12 col-sm-12 text-center mt-2">
                                                                        <template v-if="paginationPreguntas.length && btn_encuesta_save == 0">
                                                                            <button v-if="btn_parcial == 0" type="button" 
                                                                                class="btn btn-sm btn-warning waves-effect waves-light" 
                                                                                    @click="desplegarVentana('warning', 'Test de Encuesta de Atención Vecino','Esta acción no se encuestra disponible')">
                                                                                <i class="fas fa-save"></i> Registrar encuesta parcial
                                                                            </button>
                                                                        </template>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                  </div>
                  <div class="modal-footer">
                    <div class="col-md-12 col-sm-12">
                        <button type="button" class="btn btn-md btn-secondary col-lg-2 col-md-3 col-sm-4" style="float: right;" @click="cerrarModal('modelo')">Cerrar</button>
                    </div>
                  </div>
                </div>
            </div>
        </div>
    </div>
</div>

    <style type="text/css">
        .bg-color-skyblue {
            background: skyblue;
        }

        .bg-color-khaki {
            background: khaki;
        }

        .bg-color-darkseagreen {
            background: darkseagreen;
        }

        .bg-color-indianred {
            background: indianred;
        }
    </style>

    <script type="text/javascript">
        Vue.component('vue-multiselect', window.VueMultiselect.default);

        var app = new Vue({
            el: '#app',
            data: {
                //-------------------------------------
                tp_modal                    :   0,
                tp_accion                   :   0,
                tp_btn                      :   0,
                titulo_modal                :   '',
                btn_envio                   :   0,
                btn_parcial                 :   0,
                btn_encuesta_next           :   0,
                btn_encuesta_back           :   0,
                btn_encuesta_save           :   0,
                btn_agregar                 :   0,
                btn_editar                  :   0,
                //-------------------------------------
                msj_titulo                  :   '',
                //-------------------------------------
                arr_valida                  :   [],
                arr_error                   :   [],
                arr_form                    :   {},
                str_msj                     :   '',
                //-------------------------------------
                pagination                  : {
                    'total' : 0,
                    'current_page' : 0,
                    'per_page' : 0,
                    'last_page' : 0,
                    'from' : 0,
                    'to' : 0,
                },
                //-------------------------------------
                offset                      :   3,
                //-------------------------------------
                fl_mostrar                  :   0,
                fl_direccion                :   [],
                fl_depto                    :   [],
                fl_servicio                 :   [],
                fl_macrozona                :   [],
                fl_unidadvecinal            :   [],
                fl_ticket                   :   [],
                fl_persona                  :   [],
                fl_motivo                   :   [],
                fl_ubicacion                :   [],
                //-------------------------------------
                arr_mostrar                 :   [
                    {
                        'value'     :   0,
                        'label'     :   'Todos',
                    },
                    {
                        'value'     :   1,
                        'label'     :   'Pendiente',
                    },
                    {
                        'value'     :   2,
                        'label'     :   'Parcial',
                    },
                    {
                        'value'     :   3,
                        'label'     :   'Reagendar',
                    },
                    {
                        'value'     :   6,
                        'label'     :   'No Contactado',
                    },
                ],
                //-------------------------------------
                tp_criterio                 :   'created_at',
                tp_orden                    :   'ASC',
                //-------------------------------------
                arr_solicitud               :   [],
                arr_historial               :   [],
                arr_respuestas              :   [],
                arr_usuario                 :   [],
                arr_archivo                 :   [],
                //-------------------------------------
                arr_index                   :   [],
                arr_direccion               :   [],
                arr_depto                   :   [],
                arr_servicio                :   [],
                arr_motivo                  :   [],
                arr_macrozona               :   [],
                arr_unidadvecinal           :   [],
                arr_ticket                  :   [],
                arr_prioridad               :   [],
                arr_persona                 :   [],
                arr_ubicaciones             :   [],
                arr_encuesta                :   [],
                arr_alternativa             :   [],
                arr_estructura              :   [],
                //-------------------------------------
                arr_formato                 :   [
                    // {
                    //     'value' : 1,
                    //     'label' : 'Respuesta Corta'
                    // },
                    {
                        'value' : 2,
                        'label' : 'Opción Multiple'
                    },
                    {
                        'value' : 3,
                        'label' : 'Lista Desplegable'
                    },
                    // {
                    //     'value' : 4,
                    //     'label' : 'Casilla de Verificación'
                    // },
                    // {
                    //     'value' : 5,
                    //     'label' : 'Párrafo'
                    // },
                ],
                nr_formato                  :   null,
                //-------------------------------------
                arr_firstQuestion           :   null,
                arr_info                    :   null,
                arr_respuestas              :   null,
                info_encuesta               :   null,
                //-------------------------------------
                nr_solicitud                :   0,
                nr_ticket                   :   '',
                nr_rut                      :   '',
                nr_prefijo                  :   '',
                nr_telefono                 :   '',
                nr_direccion                :   [],
                nr_depto                    :   [],
                nr_funcionario              :   [],
                str_observacion             :   '',
                nr_estado                   :   0,
                nr_encuesta                 :   0,
                nm_encuesta                 :   '',
                tp_encuesta                 :   0,
                nm_old_encuesta             :   '',
                str_descripcion             :   '',
                nr_pregunta                 :   0,
                nr_alternativa              :   0,
                nm_pregunta                 :   '',
                nm_old_pregunta             :   '',
                nm_alternativa              :   '',
                nm_old_alternativa          :   '',
                info_pregunta               :   null,
                info_alternativa            :   null,
                //-------------------------------------
                tp_resumir_descripcion      :   1,
                tp_resumir_publicacion      :   1,
                //-------------------------------------
                nr_pendientes               :   0,
                nr_atendidos                :   0,
                nr_nocontactado             :   0,
                //-------------------------------------
                tp_iniciar_encuesta         :   0,
                nr_estado_encuesta          :   0,
                paginationPreguntas         :   [],
                fc_encuesta                 :   {
                    'fc_inicio' : '',
                    'fc_termino' : '',
                    'fc_inicio_ring' : '',
                    'fc_termino_ring' : '',
                    'fc_inicio_contacto' : '',
                    'fc_termino_contacto' : '',
                    'fc_inicio_servicio' : '',
                    'fc_termino_servicio' : '',
                },
                str_indicacion              :   '',
                tp_utilizar                 :   0,
                tp_utilizar_msj             :   '',
                //-------------------------------------
                timerId                     :   0,
                //-------------------------------------
            },

            components: {
                Multiselect: window.VueMultiselect.default
            },

            filters:{
                resumir: function (texto, limite=300, final=' ...')
                {
                    let me  = this;
                    var largo = texto.toString().length;
                    if(largo > limite){
                        for (var i = 0; i < largo; i++) {
                            if(texto[i] == ' ' && i >= limite) {
                                texto   =   texto.substring(0,i);
                                texto   =   texto + final;
                                return texto;
                            }
                        }                    
                    }
                    return texto;
                },

                capitalize: function (str_texto) 
                {
                    if (!str_texto) return '';

                    str_texto    = str_texto.toString();
                    var splitStr = str_texto.toLowerCase().split(' ');

                    for (var i = 0; i < splitStr.length; i++) {
                        splitStr[i] = splitStr[i].charAt(0).toUpperCase() + splitStr[i].substring(1);
                    }

                    return splitStr.join(' ');
                },

                formatDate: function (fecha)
                {
                    if(fecha)
                        return moment(String(fecha)).format('DD-MM-YYYY')
                },

                formatDateTime: function (fecha)
                {
                    if(fecha)
                    {
                        return moment(String(fecha)).format('DD-MM-YYYY HH:mm')
                    }
                },

                formatPhone: function (str_phone)
                {
                    if(!str_phone) return '';
                    let str_regex   =   '/(\d{0,4})(\d{0,4})/';
                    let str_temp    =   str_phone.replace(/(\d{0,4})(\d{0,4})/, function (regex, arg1, arg2) {
                                            return arg1 + '-' + arg2;
                                        });
                    return str_temp;
                },
            },

            computed:{
                //-------------------------------------------------------------------------------------------
                isActivedPagination: function()
                {
                    return this.pagination.current_page;
                },
                //-------------------------------------------------------------------------------------------
                pagesNumber: function()
                {
                    if(!this.pagination.to) {
                        return [];
                    }

                    var from = this.pagination.current_page - this.offset;
                    if(from < 1) {
                        from = 1;
                    }

                    var to = from + (this.offset * 2);
                    if(to >= this.pagination.last_page){
                        to = this.pagination.last_page;
                    }

                    var pagesArray = [];
                    while(from <= to) {
                        pagesArray.push(from);
                        from++;
                    }
                    return pagesArray;
                },                
                //-------------------------------------------------------------------------------------------
            },

            methods: {
                //-------------------------------------------------------------------------------------------
                isActiveTinyMCE()
                {
                    let me      =   this;
                    var valida  =   0;

                    try{
                        if(tinyMCE.activeEditor != null)
                            valida   =   1;
                    }catch(error) {
                        valida  =   0;
                    }   

                    return valida;
                },
                //-------------------------------------------------------------------------------------------
                imprimir(str_div = 'modal_estructura')
                {
                    $("#"+str_div).printThis({
                        debug: false,               // show the iframe for debugging
                        importCSS: true,            // import parent page css
                        importStyle: true,          // import style tags
                        printContainer: false,      // print outer container/$.selector
                        loadCSS: "",                // path to additional css file - use an array [] for multiple
                        pageTitle: "",              // add title to print page
                        removeInline: true,        // remove inline styles from print elements
                        removeInlineSelector: "*",  // custom selectors to filter inline styles. removeInline must be true
                        printDelay: 333,            // variable print delay
                        header: null,               // prefix to html
                        footer: null,               // postfix to html
                        base: 'https://atencionvecino.sanmiguel.cl/',                // preserve the BASE tag or accept a string for the URL
                        formValues: true,           // preserve input/form values
                        canvas: false,              // copy canvas content
                        // doctypeString: '...',       // enter a different doctype for older markup
                        removeScripts: true,        // remove script tags from print content
                        copyTagClasses: false,      // copy classes from the html & body tag
                        beforePrintEvent: null,     // function for printEvent in iframe
                        beforePrint: null,          // function called before iframe is filled
                        afterPrint: null,           // function called before iframe is removed
                    });
                },
                //-------------------------------------------------------------------------------------------
                getCantidadCaracteres(str_contenido = '')
                {
                    var cantidad    =   0;

                    if(!str_contenido)
                        return cantidad;

                    if(str_contenido.trim().length)
                        cantidad    =   str_contenido.trim().length;

                    return cantidad;
                },
                //-------------------------------------------------------------------------------------------
                cambiarPagina(page)
                {
                    let me  =   this;
                    me.pagination.current_page = page;
                    me.cargarDatos(page);
                },
                //-------------------------------------------------------------------------------------------
                refrescarDatos()
                {
                    let me  =   this;
                    me.cargarDireccionesMunicipales();
                    me.cargarDatos();
                    me.cargarUsuario();
                },
                //-------------------------------------------------------------------------------------------
                getLabel(data)
                {
                    var valor   =   '';

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.label;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                getValue(data)
                {
                    var valor   =   0;

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.value;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                strCapitalize(str_texto)
                {
                    if (!str_texto) return '';

                    str_texto    = str_texto.toString();
                    var splitStr = str_texto.toLowerCase().split(' ');

                    for (var i = 0; i < splitStr.length; i++) {
                        splitStr[i] = splitStr[i].charAt(0).toUpperCase() + splitStr[i].substring(1);
                    }

                    return splitStr.join(' ');
                },
                //-------------------------------------------------------------------------------------------
                inArray(needle, haystack) 
                {
                    var length = haystack.length;
                    for(var i = 0; i < length; i++) {
                        if(haystack[i] == needle) return true;
                    }
                    return false;
                },
                //-------------------------------------------------------------------------------------------
                asyncDatos()
                {
                    let me      =   this;
                    me.timerId  =   window.setInterval(function(){
                                        console.log('Bandeja Telefonista - ejecutado asyncDatos');
                                        me.cargarDatos(me.pagination.current_page)
                                    },300000); // cada 5 min.
                    
                    // clearInterval(timerId); // se detiene la llamada
                },
                //-------------------------------------------------------------------------------------------
                clearTimerInterval()
                {
                    let me  =   this;
                    clearTimerInterval(me.timerId);
                },
                //-------------------------------------------------------------------------------------------
                asyncDeptos(item)
                {
                    let me  =   this;

                    if(item)
                    {
                        me.nr_direccion     =   item;
                        me.cargarDeptosMunicipales(0, me.getValue(me.nr_direccion));
                    }
                    else
                        me.arr_depto        =   [];
                },
                //-------------------------------------------------------------------------------------------
                asyncServicios(item)
                {
                    let me  =   this;

                    if(item)
                    {
                        me.fl_depto     =   item;
                        me.cargarServicios(me.getValue(me.fl_direccion), me.getValue(me.fl_depto));
                        me.fl_servicio  =   [];
                    }
                    else
                        me.fl_servicio  =   [];
                },
                //-------------------------------------------------------------------------------------------
                filtrarEncuesta(atributo, valor)
                {
                    let me  =   this;

                    return  me.arr_encuesta.filter((item) => (item[atributo] === valor));
                },
                //-------------------------------------------------------------------------------------------
                asyncEstructura(tp_categoria = 0, item)
                {
                    let me          =   this;
                    let arr         =   null;
                    var ruta        =   '';
                    var titulo      =   '';
                    var tiempo      =   3000;
                    var error       =   0;
                    var formData    =   new FormData();
                    me.tp_accion    =   1;

                    if(!me.info_encuesta)
                        return me.desplegarVentana('warning', 
                            'Encuesta de Atención al Vecino', 
                            'No se encuestra la información de la encuesta');

                    if(item)
                    {
                        switch(tp_categoria)
                        {
                            case 1: // Generar Pregunta
                            {
                                //------------------------------------
                                ruta    =   '/estructura/encuesta/pregunta/generar';
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_encuesta', me.nr_encuesta);
                                formData.append('tp_pregunta', item.value);
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------

                                break;
                            }
                            case 2: // Generar Alternativa
                            {
                                //------------------------------------
                                ruta    =   '/estructura/encuesta/alternativa/generar';
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_pregunta', item.id);
                                formData.append('tp_pregunta', item.tp_pregunta);
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------

                                break;
                            }
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                asyncPregunta(pregunta, alternativa)
                {
                    let me          =   this;
                    let logica      =   [];
                    let valor       =   0;
                    let item        =   null;
                    var fc_format   =   'YYYY-MM-DD HH:mm:ss'; // 'DD-MM-YYYY HH:mm:ss';
                    me.arr_info     =   null;

                    if(pregunta.tp_pregunta == 2)
                    {
                        if(alternativa.logica.length)
                        {
                            logica  =   alternativa.logica;

                            for (var i = 0; i < logica.length; i++) 
                            {
                                if(logica[i].tp_accion == 1)
                                {
                                    me.arr_info             =   logica[i];
                                    me.btn_encuesta_back    =   logica[i].tp_anterior;
                                    me.btn_encuesta_next    =   logica[i].tp_siguiente;
                                    me.btn_encuesta_save    =   logica[i].tp_save;
                                }
                                if(logica[i].tp_accion == 2)
                                {
                                    me.arr_info             =   logica[i];
                                    me.btn_encuesta_back    =   logica[i].tp_anterior;
                                    me.btn_encuesta_next    =   logica[i].tp_siguiente;
                                    me.btn_encuesta_save    =   logica[i].tp_save;
                                }
                                /*------------------------------------  registro de fecha  ------------------------------------*/
                                if(pregunta.tp_categoria === "contacto" && logica[i].tp_evento_fecha == 1 && me.inArray(logica[i].tp_accion,[1,2]))
                                {
                                    me.fc_encuesta.fc_termino_ring      =   moment().locale('es').format(fc_format);
                                    me.fc_encuesta.fc_inicio_contacto   =   moment().locale('es').format(fc_format); // moment().tz("America/Santiago").format();
                                    me.fc_encuesta.fc_inicio_servicio   =   '';
                                }
                                if(pregunta.tp_categoria === "contacto" && logica[i].tp_evento_fecha == 2 && me.inArray(logica[i].tp_accion,[1,2]))
                                {
                                    if(logica[i].tp_evento_estado == 6)
                                        me.fc_encuesta.fc_termino_ring  =   moment().locale('es').format(fc_format);

                                    me.fc_encuesta.fc_termino_contacto  =   moment().locale('es').format(fc_format);
                                    me.fc_encuesta.fc_inicio_servicio   =   '';
                                }
                                if(pregunta.tp_categoria === "contacto" && logica[i].tp_evento_fecha == 3 && me.inArray(logica[i].tp_accion,[1,2]))
                                {
                                    me.fc_encuesta.fc_termino_contacto  =   moment().locale('es').format(fc_format);
                                    me.fc_encuesta.fc_inicio_servicio   =   moment().locale('es').format(fc_format);
                                }
                                if(pregunta.tp_categoria === "servicio" && logica[i].tp_evento_fecha == 2 && me.inArray(logica[i].tp_accion,[1,2]))
                                    me.fc_encuesta.fc_termino_servicio  =   moment().locale('es').format(fc_format);
                                /*------------------------------------  registro de estado  ------------------------------------*/
                                if(alternativa.vl_alternativa == logica[i].nr_valor && me.inArray(logica[i].tp_accion,[1,2]))
                                    me.nr_estado_encuesta   =   logica[i].tp_evento_estado;
                            }
                        }
                    }
                    if(pregunta.tp_pregunta == 3)
                    {
                        valor   =   $('#'+pregunta.str_formdata).val();

                        if(valor)
                        {
                            logica  =   pregunta.logica;

                            if(logica.length)
                            {
                                for (var i = 0; i < logica.length; i++) {
                                    if(valor == logica[i].nr_valor && logica[i].tp_accion == 1)
                                    {
                                        me.arr_info             =   logica[i];
                                        me.btn_encuesta_back    =   logica[i].tp_anterior;
                                        me.btn_encuesta_next    =   logica[i].tp_siguiente;
                                        me.btn_encuesta_save    =   logica[i].tp_save;
                                    }
                                    if(valor == logica[i].nr_valor && logica[i].tp_accion == 2 && logica[i].tp_save == 1)
                                    {
                                        me.arr_info             =   logica[i];
                                        me.btn_encuesta_back    =   logica[i].tp_anterior;
                                        me.btn_encuesta_next    =   logica[i].tp_siguiente;
                                        me.btn_encuesta_save    =   logica[i].tp_save;
                                    }
                                    /*------------------------------------  registro de fecha  ------------------------------------*/
                                    if(pregunta.tp_categoria === "contacto" && logica[i].tp_evento_fecha == 1 && me.inArray(logica[i].tp_accion,[1,2]))
                                    {
                                        me.fc_encuesta.fc_termino_ring      =   moment().locale('es').format(fc_format);
                                        me.fc_encuesta.fc_inicio_contacto   =   moment().locale('es').format(fc_format);
                                        me.fc_encuesta.fc_inicio_servicio   =   '';
                                    }
                                    if(pregunta.tp_categoria === "contacto" && logica[i].tp_evento_fecha == 2 && me.inArray(logica[i].tp_accion,[1,2]))
                                    {
                                        me.fc_encuesta.fc_termino_contacto  =   moment().locale('es').format(fc_format);
                                        me.fc_encuesta.fc_inicio_servicio   =   '';
                                    }
                                    if(pregunta.tp_categoria === "contacto" && logica[i].tp_evento_fecha == 3 && me.inArray(logica[i].tp_accion,[1,2]))
                                    {fc_format
                                        me.fc_encuesta.fc_termino_contacto  =   moment().locale('es').format(fc_format);
                                        me.fc_encuesta.fc_inicio_servicio   =   moment().locale('es').format(fc_format);
                                    }
                                    if(pregunta.tp_categoria === "servicio" && logica[i].tp_evento_fecha == 2 && me.inArray(logica[i].tp_accion,[1,2]))
                                        me.fc_encuesta.fc_termino_servicio  =   moment().locale('es').format(fc_format);
                                    /*------------------------------------  registro de estado  ------------------------------------*/
                                    if(me.inArray(logica[i].tp_accion,[1,2]))
                                        me.nr_estado_encuesta   =   logica[i].tp_evento_estado;
                                }
                            }
                        }
                    }

                    if(me.arr_info)
                    {
                        if(me.agregarItem(me.arr_info))
                            me.paginationPreguntas.push(me.arr_info);
                        else
                        {
                            for (var i = 0; i < me.paginationPreguntas.length; i++) {
                                if(me.paginationPreguntas[i].actual_cod_pregunta === me.arr_info.actual_cod_pregunta)
                                    me.paginationPreguntas[i]   =   me.arr_info;
                            }
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                asyncEncuesta()
                {
                    let me          =   this;
                    var fc_format   =   'YYYY-MM-DD HH:mm:ss'; // 'DD-MM-YYYY HH:mm:ss';

                    me.tp_iniciar_encuesta      =   1;
                    me.fc_encuesta.fc_inicio    =   moment().locale('es').format(fc_format); // moment().tz("America/Santiago").format();
                    me.fc_encuesta.fc_inicio_ring   =   moment().locale('es').format(fc_format);
                    // me.asyncIndicacionPregunta(me.arr_firstQuestion.cod_pregunta, me.arr_firstQuestion.str_indicacion);
                    // console.log(me.fc_encuesta);
                },
                //-------------------------------------------------------------------------------------------
                agregarItem(item)
                {
                    let  me     =   this;
                    let flat    =   0;
                    let found   =   null;

                    found   =   me.paginationPreguntas.some(data => data.actual_cod_pregunta === item.actual_cod_pregunta);

                    if(!found)
                        flat  =   1;

                    return flat;
                },
                //-------------------------------------------------------------------------------------------
                showPregunta(tp_accion = 0, arr_data)
                {
                    let me          =   this;
                    let item        =   null;
                    let str_actual  =   null;
                    let str_next    =   null;
                    let str_back    =   null;

                    switch(tp_accion)
                    {
                        case 1: // siguiente
                        {
                            // ----------------------------------------------------------------------------
                            if(me.arr_info)
                            {
                                $('#'+me.arr_info.next_cod_pregunta).removeClass('d-none').addClass('d-block');
                                $('#'+me.arr_info.actual_cod_pregunta).removeClass('d-block').addClass('d-none');
                                // me.asyncIndicacionPregunta(me.arr_info.next_cod_pregunta, me.arr_info.next_str_indicacion);
                                me.btn_encuesta_back    =   1;
                                me.btn_encuesta_next    =   0;
                                me.btn_encuesta_save    =   0;
                                me.arr_info             =   null;
                            }
                            // ----------------------------------------------------------------------------
                            break;
                        }
                        case 2: // anterior
                        {
                            // ----------------------------------------------------------------------------
                            if(arr_data.alternativa)
                            {
                                let alternativa     =   arr_data.alternativa;

                                if(arr_data.tp_pregunta == 2)
                                    for (var i = 0; i < alternativa.length; i++) {
                                            document.querySelector('#'+arr_data.str_formdata+'_'+alternativa[i].cod_alternativa).checked = null;
                                    }
                                if(arr_data.tp_pregunta == 3)
                                    document.querySelector("#"+arr_data.str_formdata).value = 0;
                            }
                            // ----------------------------------------------------------------------------
                            if(me.paginationPreguntas.length)
                            {
                                // ----------------------------------------------------------------------------
                                item    =   me.paginationPreguntas.find(data => data.actual_cod_pregunta === arr_data.cod_pregunta);
                                // ----------------------------------------------------------------------------
                                if(item)
                                {
                                    if(item.next_tp_pregunta == 2)
                                        document.querySelector('input[name="'+item.next_str_formdata+'"]').checked = null;
                                    if(item.next_tp_pregunta == 3)
                                        document.querySelector("#"+item.next_str_formdata).value = 0;

                                    $('#'+item.next_cod_pregunta).removeClass('d-block').addClass('d-none');
                                    $('#'+item.actual_cod_pregunta).removeClass('d-none').addClass('d-block');
                                    // me.asyncIndicacionPregunta(me.arr_info.back_cod_pregunta, me.arr_info.back_str_indicacion);
                                    me.btn_encuesta_back    =   1;
                                    me.btn_encuesta_next    =   0;
                                    me.btn_encuesta_save    =   0;
                                }
                                // ----------------------------------------------------------------------------
                                else
                                {
                                    item    =   me.paginationPreguntas.find(data => data.next_cod_pregunta === arr_data.cod_pregunta);

                                    if(item)
                                    {
                                        if(item.next_tp_pregunta == 2)
                                            document.querySelector('input[name="'+item.next_str_formdata+'"]').checked = null;
                                        if(item.next_tp_pregunta == 3)
                                            document.querySelector("#"+item.next_str_formdata).value = 0;

                                        $('#'+item.next_cod_pregunta).removeClass('d-block').addClass('d-none');
                                        $('#'+item.actual_cod_pregunta).removeClass('d-none').addClass('d-block');
                                        // me.asyncIndicacionPregunta(me.arr_info.back_cod_pregunta, me.arr_info.back_str_indicacion);
                                        me.btn_encuesta_back    =   1;
                                        me.btn_encuesta_next    =   0;
                                        me.btn_encuesta_save    =   0;
                                    }
                                }
                                // ----------------------------------------------------------------------------
                                let index_pregunta  =   me.paginationPreguntas.findIndex(info => info.actual_cod_pregunta === arr_data.cod_pregunta);
                                if(index_pregunta >= 0)
                                    me.paginationPreguntas.splice(index_pregunta, 1);
                                // ----------------------------------------------------------------------------
                            }
                            // ----------------------------------------------------------------------------
                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                asyncIndicacionPregunta(cod_pregunta = '', str_texto = '')
                {
                    let me          =   this;
                    let fc_format   =   'H:mm';
                    let fc_date     =   moment().locale('es').format(fc_format);
                    let hr_date     =   moment('12:00',fc_format).format(fc_format);
                    let str_comilla =   '<strong><span style="color: #e03e2d;"> " </span></strong>';

                    if(cod_pregunta === "I02")
                    {
                        //----------------------------------------------------------------------
                        if(me.arr_solicitud.vecino)
                            str_texto   =   str_texto.replace('attr_vecino', me.strCapitalize(me.arr_solicitud.vecino.nmc_vecino));
                        else
                            str_texto   =   str_texto.replace('attr_vecino','');
                        //----------------------------------------------------------------------
                        if(fc_date < hr_date)
                            str_texto   =   str_texto.replace('attr_horario','buenos días');
                        else
                            str_texto   =   str_texto.replace('attr_horario','buenos tardes');
                        //----------------------------------------------------------------------
                        if(me.arr_usuario)
                            str_texto   =   str_texto.replace('attr_telefonista',me.strCapitalize(me.arr_usuario.name));
                        else
                            str_texto   =   str_texto.replace('attr_telefonista','"Indicar su nombre"');
                        //----------------------------------------------------------------------
                        if(me.arr_solicitud.nm_tipo)
                            str_texto   =   str_texto.replace('attr_servicio',me.arr_solicitud.nm_tipo);
                        //----------------------------------------------------------------------
                        me.str_indicacion   =   str_comilla + str_texto + str_comilla;
                        //----------------------------------------------------------------------
                    }
                    else
                        me.str_indicacion   =   str_texto;
                },
                //-------------------------------------------------------------------------------------------
                asyncValidaEncuesta(data)
                {
                    let me          =   this;
                    var formData    =   new FormData();
                    var tp_icon     =   '';
                    var titulo      =   '';
                    var mensaje     =   '';
                    var error       =   '';
                    let ruta        =   '/encuestador/encuesta/valida';
                    //-----------------------------------------------------
                    formData.append('nr_solicitud', data.id);
                    //-----------------------------------------------------
                    axios.post(ruta, formData, {
                        headers: {'Content-Type': 'multipart/form-data'}
                    }).then(function (response) 
                    {
                        var result  =   response.data;                       
                        tp_icon     =   result.tp_icon;
                        titulo      =   result.title;
                        mensaje     =   result.msj;
                        error       =   result.error;

                        if(error == 1)
                        {
                            console.log('paso por if');
                            me.tp_utilizar  =   1;
                            tp_utilizar_msj =   mensaje;
                            me.desplegarVentana(tp_icon, titulo, mensaje);
                        }
                        else
                        {
                            console.log('paso por else');
                            me.tp_utilizar  =   0;
                            tp_utilizar_msj =   '';
                            me.abrirModal('solicitud', 'encuesta', data);
                        }
                    })
                    .catch(function (error) 
                    {
                        me.tp_utilizar      =   0;
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarDireccionesMunicipales(nr_direccion = 0)
                {
                    let me      =   this;
                    var ruta    =   '/listado/direcciones_municipales';
                    me.arr_direccion    =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_direccion    =   respuesta.direcciones;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarDeptosMunicipales(tp_filtro = 0, nr_direccion)
                {
                    let me      =   this;
                    var ruta    =   '/listado/deptos_municipales';
                    me.arr_depto    =   [];

                    axios.post(ruta,{
                        'nr_direccion'      :   nr_direccion,
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;

                        if(tp_filtro == 0)
                            me.arr_depto        =   respuesta.deptos;
                        else
                            me.fl_arr_deptos    =   respuesta.deptos;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarServicios(nr_direccion = 0, nr_depto = 0)
                {
                    let me      =   this;
                    var ruta    =   '/listado/servicios';
                    me.arr_servicio     =   [];

                    axios.post(ruta,{
                        'nr_direccion'      :   nr_direccion,
                        'nr_depto'          :   nr_depto,
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_servicio     =   respuesta;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarMotivo()
                {
                    let me      =   this;
                    var ruta    =   '/motivo/listado';
                    me.arr_motivo   =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta   =   response.data;
                        me.arr_motivo   =   respuesta;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarPrioridad()
                {
                    let me      =   this;
                    var ruta    =   '/prioridad/listado';
                    me.arr_prioridad    =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_prioridad    =   respuesta;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarMacrozona()
                {
                    let me      =   this;
                    var ruta    =   '/listado/macrozona';
                    me.arr_macrozona    =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_macrozona    =   respuesta.macrozona;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarUnidadVecinal()
                {
                    let me      =   this;
                    var ruta    =   '/listar/unidadvecinales';
                    me.arr_unidadvecinal    =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta           =   response.data;
                        me.arr_unidadvecinal    =   respuesta;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarTicket()
                {
                    let me      =   this;
                    var ruta    =   '/listado/ticket';
                    me.arr_ticket    =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta    =   response.data;
                        me.arr_ticket    =   respuesta.ticket;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarUbicaciones()
                {
                    let me      =   this;
                    var ruta    =   '/listado/ubicaciones';
                    me.arr_ubicaciones      =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta           =   response.data;
                        me.arr_ubicaciones      =   respuesta.ubicaciones;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarPersonas()
                {
                    let me      =   this;
                    var ruta    =   '/listado/personas';
                    me.arr_persona      =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_persona      =   respuesta.personas;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarEncuesta(nr_encuesta = 1)
                {
                    let me      =   this;
                    var ruta    =   '/listado/encuesta?nr_encuesta='+nr_encuesta+'&nr_mostrar=1';
                    me.arr_encuesta     =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta           =   response.data;
                        me.arr_encuesta         =   respuesta.listado;
                        me.arr_firstQuestion    =   respuesta.firstQuestion;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarUsuario()
                {
                    let me      =   this;
                    var ruta    =   '/info/usuario';
                    me.arr_usuario  =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta     =   response.data;
                        me.arr_usuario    =   respuesta;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarDatos(page = 1)
                {
                    let me          =   this;
                    var ruta        =   '/estructura/encuesta/index';

                    axios.post(ruta,{
                        'page'              :   page,
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_index        =   respuesta.info.data ;
                        me.pagination       =   respuesta.pagination;
                        me.rows             =   respuesta.info.data;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },                
                //-------------------------------------------------------------------------------------------
                filtrarDatos()
                {
                    let me  =   this;
                    me.cargarDatos();
                },
                //-------------------------------------------------------------------------------------------
                limpiarFiltros()
                {
                    let me  =   this;

                    me.fl_direccion         =   [];
                    me.fl_depto             =   [];
                    me.fl_servicio          =   [];
                    me.fl_macrozona         =   [];
                    me.fl_unidadvecinal     =   [];
                    me.fl_ticket            =   [];
                    me.arr_depto            =   [];
                    me.arr_servicio         =   [];
                    me.fl_ubicacion         =   [];
                    me.fl_motivo            =   [];
                    me.fl_persona           =   [];

                    me.cargarDatos();
                },
                //-------------------------------------------------------------------------------------------
                limpiarDatos(modelo)
                {
                    let me  =   this;

                    switch(modelo)
                    {
                        case 'estructura':
                        {
                            me.arr_form         =   {};
                            me.btn_envio        =   0;
                            me.info_encuesta    =   null;

                            break;
                        }
                        case 'crear_encuesta':
                        {
                            me.nr_encuesta      =   0;
                            me.nm_encuesta      =   '';
                            me.str_descripcion  =   '';

                            break;
                        }
                        case 'encuesta':
                        {
                            me.arr_form         =   {};
                            me.btn_envio        =   0;
                            me.arr_solicitud    =   [];
                            me.str_indicacion   =   '';
                            me.nr_prefijo       =   '';
                            me.nr_telefono      =   '';

                            break;
                        }
                        case 'deshabilitar':
                        {
                            me.nr_solicitud     =   0;
                            me.nr_ticket        =   '';
                            me.nr_rut           =   '';
                            me.nr_estado        =   0;
                            me.str_observacion  =   '';

                            break;
                        }
                        case 'archivo':
                        {
                            me.str_archivo      =   '';
                            me.arr_error        =   [];
                            me.arr_valida       =   [];
                            me.tp_error         =   0;                            
                            me.descartarAdjunto();

                            break;
                        }
                        case 'revisar':
                        {
                            me.arr_adjuntos     =   [];

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                ensamblarDatos(accion)
                {
                    let me          =   this;
                    var ruta        =   '';
                    var titulo      =   '';
                    var tiempo      =   3000;
                    var error       =   0;
                    var formData    =   new FormData();
                    var fc_format   =   'YYYY-MM-DD HH:mm:ss'; // 'DD-MM-YYYY HH:mm:ss';
                    //----------------------------------------------------------------
                    switch(accion)
                    {
                        case 'solicitud':
                        {
                            titulo  =   'Registrar Solicitud';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                // ruta    =   '/';                            
                                // me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                //formData.append('nm_direccion', me.getLabel(me.nr_direccion));
                                //------------------------------------
                                // me.fc_encuesta.fc_termino   =   moment().locale('es').format(fc_format); // moment().tz("America/Santiago").format();
                                // formData.append('arr_encuesta[]', JSON.stringify(me.paginationPreguntas));
                                // console.log(me.fc_encuesta);
                                //------------------------------------
                                // me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'crear_encuesta':
                        {
                            titulo  =   'Registrar Encuesta de Atención al Vecino';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                me.btn_envio    =   1;
                                //------------------------------------
                                ruta    =   '/estructura/encuesta/store';
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_encuesta', me.nr_encuesta);
                                formData.append('nm_encuesta', me.nm_encuesta);
                                formData.append('str_descripcion', me.str_descripcion);
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'editar_encuesta':
                        {
                            titulo  =   'Actualizar Encuesta de Atención al Vecino';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                me.btn_envio    =   1;
                                //------------------------------------
                                ruta    =   '/estructura/encuesta/update';
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_encuesta', me.nr_encuesta);
                                formData.append('nm_encuesta', me.nm_encuesta);
                                formData.append('old_encuesta', me.nm_old_encuesta);
                                formData.append('str_descripcion', me.str_descripcion);
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'estado_encuesta':
                        {
                            titulo  =   me.msj_titulo;
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                me.btn_envio    =   1;
                                //------------------------------------
                                ruta    =   '/estructura/encuesta/state';
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_encuesta', me.nr_encuesta);
                                formData.append('nm_encuesta', me.nm_encuesta);
                                formData.append('tp_activo', me.nr_estado);
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'editar_pregunta':
                        {
                            titulo  =   'Actualizar Pregunta';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                me.btn_envio    =   1;
                                //------------------------------------
                                ruta    =   '/estructura/encuesta/pregunta/update';
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_pregunta', me.nr_pregunta);
                                formData.append('nm_pregunta', me.nm_pregunta);
                                formData.append('old_pregunta', me.nm_old_pregunta);
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'habilitar_pregunta':
                        case 'deshabilitar_pregunta':
                        {
                            titulo  =   (me.nr_estado == 1) ? 'Habilitar Pregunta' : 'Deshabilitar Pregunta';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                me.btn_envio    =   1;
                                //------------------------------------
                                ruta    =   '/estructura/encuesta/pregunta/state';
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_pregunta', me.nr_pregunta);
                                formData.append('nm_pregunta', me.nm_pregunta);
                                formData.append('tp_activo', me.nr_estado);
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'quitar_pregunta':
                        {
                            titulo  =   'Eliminar Pregunta';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                me.btn_envio    =   1;
                                //------------------------------------
                                ruta    =   '/estructura/encuesta/pregunta/delete';
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_pregunta', me.nr_pregunta);
                                formData.append('nm_pregunta', me.nm_pregunta);
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'editar_alternativa':
                        {
                            titulo  =   'Actualizar Alternativa';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                me.btn_envio    =   1;
                                //------------------------------------
                                ruta    =   '/estructura/encuesta/alternativa/update';
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_alternativa', me.nr_alternativa);
                                formData.append('nm_alternativa', me.nm_alternativa);
                                formData.append('old_alternativa', me.nm_old_alternativa);
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'habilitar_alternativa':
                        case 'deshabilitar_alternativa':
                        {
                            titulo  =   (me.nr_estado == 1) ? 'Habilitar Alternativa' : 'Deshabilitar Alternativa';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                me.btn_envio    =   1;
                                //------------------------------------
                                ruta    =   '/estructura/encuesta/alternativa/state';
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_alternativa', me.nr_alternativa);
                                formData.append('nm_alternativa', me.nm_alternativa);
                                formData.append('tp_activo', me.nr_estado);
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'quitar_alternativa':
                        {
                            titulo  =   'Eliminar Alternativa';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                me.btn_envio    =   1;
                                //------------------------------------
                                ruta    =   '/estructura/encuesta/alternativa/delete';
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_alternativa', me.nr_alternativa);
                                formData.append('nm_alternativa', me.nm_alternativa);
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                    }
                    //----------------------------------------------------------------
                },
                //-------------------------------------------------------------------------------------------
                validarDatos(tp_validacion)
                {
                    let me          =   this;
                    var error       =   0;
                    me.arr_valida   =   [];    
                    me.arr_form     =   {}; 
                    me.str_msj      =   '';

                    switch(tp_validacion)
                    {
                        case 'solicitud':
                        {
                            

                            break;
                        }
                        case 'crear_encuesta':
                        {
                            if(me.nm_encuesta == '')
                                me.arr_form.nm_encuesta     =   'Debe Ingresar un nombre para la Encuesta';
                            else
                            {
                                if(me.nm_encuesta.trim().length < 5)
                                    me.arr_form.nm_encuesta =   'La encuesta debe tener mínimo 5 caracteres';
                            }

                            break;
                        }
                        case 'editar_encuesta':
                        {
                            if(me.nr_encuesta == 0)
                                me.arr_form.nr_encuesta     =   'No se encuentra el ID de la Encuesta';

                            if(me.nm_encuesta == '')
                                me.arr_form.nm_encuesta     =   'Debe Ingresar un nombre para la Encuesta';
                            else
                            {
                                if(me.nm_encuesta.trim().length < 5)
                                    me.arr_form.nm_encuesta =   'La encuesta debe tener mínimo 5 caracteres';
                            }

                            break;
                        }
                        case 'estado_encuesta':
                        {
                            if(me.nr_encuesta == 0)
                                me.arr_form.nr_encuesta     =   'No se encuentra el ID de la Encuesta';

                            if(me.nm_encuesta == '')
                                me.arr_form.nm_encuesta     =   'Debe Ingresar un nombre para la Encuesta';
                            else
                            {
                                if(me.nm_encuesta.trim().length < 5)
                                    me.arr_form.nm_encuesta =   'La encuesta debe tener mínimo 5 caracteres';
                            }

                            break;
                        }
                        case 'editar_pregunta':
                        {
                            if(me.nr_pregunta == 0)
                                me.arr_form.nr_pregunta     =   'No se encuentra el ID de la Pregunta';

                            if(me.nm_pregunta == '')
                                me.arr_form.nm_pregunta     =   'Debe Ingresar un nombre para la Pregunta';
                            else
                            {
                                if(me.nm_pregunta.trim().length < 5)
                                    me.arr_form.nm_pregunta =   'La pregunta debe tener mínimo 5 caracteres';
                            }

                            break;
                        }
                        case 'habilitar_pregunta':
                        case 'deshabilitar_pregunta':
                        case 'quitar_pregunta':
                        {
                            if(me.nr_pregunta == 0)
                                me.arr_form.nr_pregunta     =   'No se encuentra el ID de la Pregunta';

                            if(me.nm_pregunta == '')
                                me.arr_form.nm_pregunta     =   'No se encuesta el nombre de la Pregunta';

                            break;
                        }
                        case 'editar_altenativa':
                        {
                            if(me.nr_alternativa == 0)
                                me.arr_form.nr_alternativa      =   'No se encuentra el ID de la Alternativa';

                            if(me.nm_alternativa == '')
                                me.arr_form.nm_alternativa      =   'Debe Ingresar un nombre para la Alternativa';
                            else
                            {
                                if(me.nm_alternativa.trim().length < 5)
                                    me.arr_form.nm_alternativa  =   'La pregunta debe tener mínimo 5 caracteres';
                            }

                            break;
                        }
                        case 'habilitar_alterantiva':
                        case 'deshabilitar_alterantiva':
                        case 'quitar_alterantiva':
                        {
                            if(me.nr_alternativa == 0)
                                me.arr_form.nr_alternativa      =   'No se encuentra el ID de la Alternativa';

                            if(me.nm_alternativa == '')
                                me.arr_form.nm_alternativa      =   'No se encuesta el nombre de la Alternativa';

                            break;
                        }
                    }

                    if(Object.keys(me.arr_form).length != 0)
                        error   =   1;

                    return error;
                },
                //-------------------------------------------------------------------------------------------
                registrarDatos(ruta, formData)
                {
                    let me              =       this;
                    var tp_icon         =       '';
                    var titulo          =       '';
                    var mensaje         =       '';
                    var error           =       '';

                    axios.post(ruta, formData, {
                        headers: {'Content-Type': 'multipart/form-data'}
                    }).then(function (response) 
                    {
                        var result  =   response.data;                       
                        tp_icon     =   result.tp_icon;
                        titulo      =   result.title;
                        mensaje     =   result.msj;
                        error       =   result.error;

                        if(error != 2)
                        {
                            me.desplegarVentana(tp_icon, titulo, mensaje);

                            //Limpiar Modelos
                            if(error == 0)
                            {
                                me.refrescarDatos();

                                if(me.tp_accion == 1)
                                    me.cargarEncuesta(me.nr_encuesta);
                                if(me.tp_accion == 2)
                                    me.cerrarModal('crear_encuesta');
                                if(me.inArray(me.tp_accion, [7,8,9]))
                                {
                                    me.cargarEncuesta(me.nr_encuesta);
                                    me.cerrarModal('modal_pregunta');
                                }
                                if(me.inArray(me.tp_accion, [10,11,12]))
                                {
                                    me.cargarEncuesta(me.nr_encuesta);
                                    me.cerrarModal('modal_alternativa');
                                }
                            }
                        }

                        me.btn_envio        =   0;
                    })
                    .catch(function (error) 
                    {
                        me.btn_envio        =   0;

                        if (error.response.status == 422)
                            me.validationErrors = error.response.data.errors;
                        /*// Formato de Archivo Incorrecto
                        if (error.response.status == 413)
                        {
                            //------------------------------
                        }
                        */
                    });
                },
                //-------------------------------------------------------------------------------------------
                abrirModal(modelo, accion, data = [])
                {
                    let me      =   this;                    

                    switch(modelo)
                    {
                        case 'encuesta':
                        {
                            switch(accion)
                            {
                                case 'estructura':
                                {
                                    me.tp_modal                 =   1;
                                    me.tp_accion                =   1;
                                    me.tp_btn                   =   0;
                                    me.btn_envio                =   0;
                                    me.arr_estructura           =   [];
                                    me.titulo_modal             =   'Encuesta de Atención al Vecino';
                                    me.limpiarDatos(accion);
                                    me.info_encuesta            =   data;
                                    me.nr_encuesta              =   data.id;
                                    me.nm_encuesta              =   data.nm_encuesta;
                                    me.tp_encuesta              =   data.tp_encuesta;
                                    me.cargarEncuesta(data.id);
                                    $('#modal_estructura').modal('show');

                                    break;
                                }
                                case 'crear_encuesta':
                                {
                                    me.tp_modal                 =   1;
                                    me.tp_accion                =   2;
                                    me.tp_btn                   =   0;
                                    me.btn_envio                =   0;
                                    me.titulo_modal             =   'Registrar Encuesta de Atención al Vecino';
                                    me.limpiarDatos(accion);
                                    $('#modal_encuesta').modal('show');

                                    break;
                                }
                                case 'editar_encuesta':
                                {
                                    me.tp_modal                 =   1;
                                    me.tp_accion                =   3;
                                    me.tp_btn                   =   0;
                                    me.btn_envio                =   0;
                                    me.titulo_modal             =   'Actualizar Encuesta de Atención al Vecino';
                                    me.limpiarDatos(accion);
                                    me.nr_encuesta              =   data.id;
                                    me.nm_encuesta              =   data.nm_encuesta;
                                    me.nm_old_encuesta          =   data.nm_encuesta;
                                    me.str_descripcion          =   data.str_descripcion;
                                    $('#modal_encuesta').modal('show');

                                    break;
                                }
                                case 'habilitar_encuesta':
                                {
                                    me.btn_envio                =   0;
                                    me.tp_accion                =   4;
                                    me.msj_titulo               =   'Habilitar Encuesta de Atención al Vecino';
                                    me.limpiarDatos(accion);
                                    me.nr_encuesta              =   data.id;
                                    me.nm_encuesta              =   data.nm_encuesta;
                                    me.str_descripcion          =   data.str_descripcion;
                                    me.nr_estado                =   1;
                                    me.ensamblarDatos('estado_encuesta')

                                    break;
                                }
                                case 'deshabilitar_encuesta':
                                {
                                    me.btn_envio                =   0;
                                    me.tp_accion                =   4;
                                    me.msj_titulo               =   'Deshabilitar Encuesta de Atención al Vecino';
                                    me.limpiarDatos(accion);
                                    me.nr_encuesta              =   data.id;
                                    me.nm_encuesta              =   data.nm_encuesta;
                                    me.str_descripcion          =   data.str_descripcion;
                                    me.nr_estado                =   0;
                                    me.ensamblarDatos('estado_encuesta')

                                    break;
                                }
                                case 'modelo':
                                {
                                    me.tp_modal                 =   1;
                                    me.tp_accion                =   5;
                                    me.tp_btn                   =   0;
                                    me.btn_envio                =   0;
                                    me.btn_envio                =   0;
                                    me.btn_parcial              =   0;
                                    me.arr_estructura           =   me.arr_encuesta.filter((item) => item.tp_activo == 1);
                                    $('#modal_modelo').modal('show');

                                    break;
                                }
                            }

                            break;
                        }
                        case 'pregunta':
                        {
                            switch(accion)
                            {
                                case 'editar_pregunta':
                                {
                                    me.tp_accion                =   7;
                                    me.nr_pregunta              =   data.id;
                                    me.nm_pregunta              =   data.str_pregunta;
                                    me.nm_old_pregunta          =   data.str_pregunta;
                                    me.info_pregunta            =   data;
                                    $('#modal_pregunta').modal('show');

                                    break;
                                }
                                case 'habilitar_pregunta':
                                {
                                    me.tp_accion                =   8;
                                    me.nr_pregunta              =   data.id;
                                    me.nm_pregunta              =   data.str_pregunta;
                                    me.nr_estado                =   1;
                                    me.info_pregunta            =   data;
                                    me.ensamblarDatos(accion);

                                    break;
                                }
                                case 'deshabilitar_pregunta':
                                {
                                    me.tp_accion                =   8;
                                    me.nr_pregunta              =   data.id;
                                    me.nm_pregunta              =   data.str_pregunta;
                                    me.nr_estado                =   0;
                                    me.info_pregunta            =   data;
                                    me.ensamblarDatos(accion);

                                    break;
                                }
                                case 'quitar_pregunta':
                                {
                                    me.tp_accion                =   9;
                                    me.nr_pregunta              =   data.id;
                                    me.nm_pregunta              =   data.str_pregunta;
                                    me.info_pregunta            =   data;
                                    me.ventanaConfirmarEliminar('¿Esta seguro de Eliminar la pregunta "'+data.str_pregunta+'" de la encuensta?', accion);
                                    // me.ensamblarDatos(accion);

                                    break;
                                }
                            }

                            break;
                        }
                        case 'alternativa':
                        {
                            switch(accion)
                            {
                                case 'editar_alternativa':
                                {
                                    me.tp_accion                =   10;
                                    me.nr_alternativa           =   data.id;
                                    me.nm_alternativa           =   data.str_alternativa;
                                    me.nm_old_alternativa       =   data.str_alternativa;
                                    me.info_alternativa         =   data;
                                    $('#modal_alternativa').modal('show');

                                    break;
                                }
                                case 'habilitar_alternativa':
                                {
                                    me.tp_accion                =   11;
                                    me.nr_alternativa           =   data.id;
                                    me.nm_alternativa           =   data.str_alternativa;
                                    me.nr_estado                =   1;
                                    me.info_alternativa         =   data;
                                    me.ensamblarDatos(accion);

                                    break;
                                }
                                case 'deshabilitar_alternativa':
                                {
                                    me.tp_accion                =   11;
                                    me.nr_alternativa           =   data.id;
                                    me.nm_alternativa           =   data.str_alternativa;
                                    me.nr_estado                =   0;
                                    me.info_alternativa         =   data;
                                    me.ensamblarDatos(accion);

                                    break;
                                }
                                case 'quitar_alternativa':
                                {
                                    me.tp_accion                =   12;
                                    me.nr_alternativa           =   data.id;
                                    me.nm_alternativa           =   data.str_alternativa;
                                    me.info_alternativa         =   data;
                                    me.ventanaConfirmarEliminar('¿Esta seguro de Eliminar la alternativa "'+data.str_alternativa+'" de la pregunta?', accion);
                                    // me.ensamblarDatos(accion);

                                    break;
                                }
                            }

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                cerrarModal(modelo)
                {
                    let me  =   this;

                    switch(modelo)
                    {
                        case 'estructura':
                        {
                            $('#modal_estructura').modal('hide');

                            break;
                        }
                        case 'crear_encuesta':
                        case 'editar_encuesta':
                        {
                            $('#modal_encuesta').modal('hide');

                            break;
                        }
                        case 'modelo':
                        {
                            $('#modal_modelo').modal('hide');
                            if(me.tp_iniciar_encuesta == 1)
                            {
                                document.querySelector('#form_encuesta').reset();
                                $('.encuesta_pregunta').removeClass('d-block').addClass('d-none');
                                $('#'+me.arr_firstQuestion.cod_pregunta).removeClass('d-none').addClass('d-block');
                                me.tp_iniciar_encuesta  =   0;
                                me.nr_estado_encuesta   =   0;
                                me.fc_encuesta          =   {
                                    'fc_inicio' : '',
                                    'fc_termino' : '',
                                    'fc_inicio_contacto' : '',
                                    'fc_termino_contacto' : '',
                                    'fc_inicio_servicio' : '',
                                    'fc_termino_servicio' : '',
                                };
                                me.nr_solicitud     = 0;
                                me.nr_ticket        = '';
                                me.nr_rut           = '';
                            }
                            me.btn_encuesta_next    =   0;
                            me.btn_encuesta_back    =   0;
                            me.btn_encuesta_save    =   0;
                            me.paginationPreguntas  =   [];
                            me.tp_resumir_descripcion   =   1;
                            me.tp_resumir_publicacion   =   1;

                            break;
                        }
                        case 'archivo':
                        {
                            $('#modal_adjunto').modal('hide');
                            me.limpiarDatos(modelo);

                            break;
                        }
                        case 'modal_pregunta':
                        {
                            me.info_pregunta        =   null;
                            me.nm_pregunta          =   '';
                            me.nm_old_pregunta      =   '';
                            $('#modal_pregunta').modal('hide');

                            break;
                        }
                        case 'modal_alternativa':
                        {
                            me.info_alternativa     =   null;
                            me.nm_alternativa       =   '';
                            me.nm_old_alternativa   =   '';
                            $('#modal_alternativa').modal('hide');

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                zonaDeEspera(titulo, tiempo)
                {
                    Swal.fire({
                        title : '<h5>'+titulo+'</h5>',
                        html: '<strong> </strong>',
                        showConfirmButton: false,
                        timer: tiempo,
                        onBeforOpen: () => {
                            Swal.showLoading()
                        },
                    }).then((result) => {
                        if(result.dismiss == Swal.DismissReason.timer)
                        {
                            //----------------------------------------
                        }
                    });
                },
                //-------------------------------------------------------------------------------------------
                desplegarVentana(tp_icon, titulo, mensaje, tp_btn = 1)
                {
                    Swal.fire({
                        icon: tp_icon,
                        title: titulo,
                        html: mensaje,
                        backdrop:false,
                        showConfirmButton: tp_btn
                    });                       
                },
                //-------------------------------------------------------------------------------------------
                ventanaConfirmarEliminar(str_title, tp_accion)
                {
                    let me  =   this;

                    Swal.fire({
                        title : str_title,
                        type  : 'warning',
                        showCancelButton : true,
                        confirmButtonColor : '#3085d6',
                        cancelButtonColor : '$d33',
                        cancelButtonText : 'Cancelar',
                        confirmButtonText : 'Eliminar',
                        backdrop: false, 
                        allowOutsideClick: false
                    }).then((result) => {
                        console.log(result);
                        if(result.value === true) {
                            console.log(result.value);
                            me.ensamblarDatos(tp_accion);
                        }
                    });
                },
                //-------------------------------------------------------------------------------------------
                setStyleCalificacion(str_campo)
                {
                    let me  =   this;

                    $(function() {
                        $('#'+str_campo).barrating('show', {
                            theme: 'fontawesome-stars',
                            showValues: false,
                            onSelect: function(value, text, event) {
                                if (typeof(event) !== 'undefined') {
                                    // rating was selected by a user
                                    console.log(event.target);
                                    console.log(value);
                                    console.log(text);
                                } else {
                                    // rating was selected programmatically
                                    // by calling `set` method
                                }
                            }
                        });
                    });
                },
                //-------------------------------------------------------------------------------------------
            },
            mounted() {
                let me = this;
                me.cargarUsuario();
                me.cargarDatos();
            }
        });
    </script>

    <script type="text/javascript">
        //-----------------------------------------------------------------
        $(document).ready(function(){
            /*----- Inicio - Filtrar -----*/
            $("#btn_filtrar_datos").click(function () {
                $content = $("#filtrar_datos");
                $content.slideToggle(500, function () {
                    // ---------------------------                    
                });
            });

            $("#close_filtrar_datos").click(function () {
                $content = $("#filtrar_datos");
                $content.slideToggle(500, function () {
                    // ---------------------------                    
                });
            });

            /*----- Inicio - Modal -----*/
            $('#modal_estructura').modal({backdrop: 'static', keyboard: false});
        });
        //-----------------------------------------------------------------
        function justNumbers(e)
        {
            var keynum = window.event ? window.event.keyCode : e.which;
            if (keynum == 8)
                return true;

            return /\d/.test(String.fromCharCode(keynum));
        }
        //-----------------------------------------------------------------
        function Rut(texto)
        { 
            var tmpstr = "";

            for ( i=0; i < texto.length ; i++ )   
                if ( texto.charAt(i) != ' ' && texto.charAt(i) != '.' && texto.charAt(i) != '-' )
                    tmpstr = tmpstr + texto.charAt(i);

            texto = tmpstr; 
            largo = texto.length; 

            if ( largo < 2 ) 
                return false; 

            for (i=0; i < largo ; i++ )    
                if (texto.charAt(i) !="0" && texto.charAt(i) != "1" && texto.charAt(i) !="2" && texto.charAt(i) != "3" && 
                    texto.charAt(i) != "4" && texto.charAt(i) !="5" && texto.charAt(i) != "6" && texto.charAt(i) != "7" && 
                    texto.charAt(i) !="8" && texto.charAt(i) != "9" && texto.charAt(i) !="k" && texto.charAt(i) != "K")   
                    return false;

            var invertido = "";

            for ( i=(largo-1),j=0; i>=0; i--,j++ )    
                invertido = invertido + texto.charAt(i);

            var dtexto = "";  
            dtexto = dtexto + invertido.charAt(0);  
            dtexto = dtexto + '-';  
            cnt = 0;  

            for ( i=1,j=2; i<largo; i++,j++ ) 
            { 
                if ( cnt == 3 )   
                {     
                    dtexto = dtexto + '.';      
                    j++;      
                    dtexto = dtexto + invertido.charAt(i);      
                    cnt = 1;    
                }   
                else    
                {       
                    dtexto = dtexto + invertido.charAt(i);      
                    cnt++;    
                } 
            } 

            invertido = "";

            for ( i=(dtexto.length-1),j=0; i>=0; i--,j++ )    
                invertido = invertido + dtexto.charAt(i);

            if (revisarDigito2(texto))
                return  invertido.toUpperCase();

            return false;
        }
        //-----------------------------------------------------------------
        function formatoMail(valor)
        {
            if (/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test(valor))
                return true;
            else
                return false;
        }
        //-----------------------------------------------------------------
    </script>
@endsection()
