@extends('template.template_gpt')
@section('body')

<div class="page-content">
    <div class="container-fluid" id="app" >
        
        <div class="row" id="chat_scroll">

            <div class="col-sm-12 col-md-3  mt-2">
                <div class="form-group">
                    <select v-model="id_file"  @change="selectPDF()" name="" id="" class="form-control">
                        <option value="0">Seleccionar Archivo</option>
                        <option v-for="(item,index) in pdfs"  :value="item.id">@{{ item.nombre_real }}</option>
                    </select>
                </div>
            </div>

            <div class="col-sm-12 col-md-3  mt-2">
                <div class="form-group">
                    <div class="form-file">
                        <input @change="uploadPdf()" @click="id_file = 0"  type="file" accept=".pdf"  class="form-control" id="file_pdf" placeholder="hola">
                    </div>
                </div>
            </div>

            <div class="col-sm-12 mt-2  d-block d-sm-none"  v-if="id_file != 0" >
                <div class="form-group">
                    <div class="form-file">
                        <label class="" for="customFile">Opciones</label>
                        <select @change="OptionPDF()" v-model="tp_sm" class="form-control">
                            <option value="0">Seleccionar Opción</option>
                            <option value="1">Eliminar</option>
                            <option value="2">Visualizar</option>
                        </select>
                    </div>
                </div>
            </div>

            <div class="col-sm-3"  v-if="tp_cargando == 1">

                <div class="form-group">
                    <div class="form-file">
                        <label style="visibility: hidden;" class="" for="customFile">x</label>
                        <button  class="btn btn-sm btn-block btn-warning">
                            Cargando &nbsp;  <em class="icon ni ni-loader"></em>
                        </button>
                        
                    </div>
                </div>
                
            </div>

            <div class="col-sm-3 d-none d-sm-block" v-if="id_file != 0">

                <div class="form-group">
                    <div class="form-file">
                        <label style="visibility: hidden;" class="" for="customFile">x</label>
                        <button  @click="deletePdf()" class="btn btn-block btn-danger">
                            Eliminar
                        </button>
                        
                        
                    </div>
                </div>

            </div>

            <div class="col-sm-3 d-none d-sm-block">

                <div class="form-group">
                    <div class="form-file">
                        <label style="visibility: hidden;" class="" for="customFile">x</label>
                        
                        <button v-if="id_file != 0" @click="showPdf()" class="btn btn-block btn-success d-block d-sm-none">
                            Visualizar PDF
                        </button>
                    </div>
                </div>

            </div> 

        </div>

        <div class=" row mt-2" style="width:100%" v-if="id_file !=0">

            <div  class="col-md-6" >
                <iframe class="d-none d-sm-block" style="width: 100%;height:80vh"  v-if="current_index" :src="'/get/preview?ruta='+str_archivo" ></iframe>
            </div>

            <div class="col-sm-12 col-md-6"  style="overflow:visible" >

                <div style="height:65vh;overflow-y:auto" id="scroll_chat">
                    <div  v-for="(item,index) in info" :key="index" :id ="'nodo_'+index" style="">

                        <div class="" style="float:right;padding-top: 0px;padding-right: 5%;padding-bottom: 1em;" v-if="item.role == 'user'">
                            <div class="nk-reply-header">
                                <div class="user-card">

                                    <!--<div :class="{'sm spinner-grow spinner-grow-sm  ml-2':escribiendo && item.last == 1}" class="user-avatar " style="color:white;background-color: #19C37D;width: 2em;height: 2em;"><span>@{{name_user}}</span></div> -->
                                    <strong class="user-name text-black">Tú</strong>
                                </div>
                            </div>
                            <div class="nk-reply-body">
                                <div  class="nk-reply-entry entry text-black" v-html="formatLinks(item.content[0])">
                                </div>
                            </div>
                        </div>


                        <div class="" style="padding-top: 0px;padding-left: 0px;" v-if="item.role == 'assistant'">
                            <div class="nk-reply-header">
                                <div class="user-card">
                                    <div class="user-avatar sm" style="width: 2em;height: 2em;">
                                    </div>
                                    <div class="user-name">
                                        <strong class="text-black">Q&A Documentos</strong>
                                    </div>
                                </div>
                            </div>

                            <div class="nk-reply-body">
                                <div :id="'text_'+index" class="nk-reply-entry entry  text-black" v-html="formatLinks(item.content[0])">
                                </div>
                                
                                <em v-if="show_copy != 'text_'+index" @click="copiarAlPortapapeles('text_'+index)" class="icon ni ni-copy" style="font-size: 1.3em;cursor: pointer;"></em>
                                <em v-if="show_copy == 'text_'+index" class="icon ni ni-copy-fill"  style="font-size: 1.3em;cursor: pointer;"></em>
                            </div>
                        </div>

                    </div>
                </div>

                <div class="nk-chat-editor">
                    
                    <div class="card-body">

                        <div class="hstack gap-3">
                            <input :disabled="escribiendo == 1" v-on:keyup.enter="add_question()" v-model="query" class="form-control me-auto" type="text" placeholder="Ingrese su consulta..." aria-label="Ingrese su consulta...">
                            <button :disabled="escribiendo == 1"  type="button" @click="add_question()" class="btn btn-success">Enviar</button>
                            <div class="vr"></div>
                            <button  @click="deletePdf()" :disabled="escribiendo == 1"  type="button" class="btn btn-outline-danger">Eliminar</button>
                        </div>

                    </div>
                </div>


            </div>
        </div>



        </div>
        
        
    </div>

</div>

<script type="text/javascript">
        
        Vue.component('QuillEditor', VueQuill.QuillEditor);
        var app = new Vue({
                el: '#app',
                data: {
                    pdfs            : [],
                    name_user       : '',
                    isXS            : false,
                    info            : [],
                    current_index   : [],
                    str_archivo     : '',
                    id_file         : 0,
                    tp_cargando     : 0,
                    pdfs            : [],
                    tp_sm           : 1,
                    query           : '',
                    escribiendo     : 0,
                    show_copy       : '',
                    tp_asistente    : 'ASIST_FILES',
                    current_doc     : [],
                    nombre_real     : '',
                    nombre_guardado : '',
                },
                components: {},
                filters:{},
                computed:{},
                methods: {
                deletePdf()
                {
                    console.log(this.id_file)
                    if(this.id_file == 0)
                        return
                    // busca en pdfs el id_file igual a item.id y retornarlo
                    this.current_doc        = this.pdfs.find(item => item.id == this.id_file)
                    this.str_archivo        = this.current_doc.ruta
                    this.current_index      = this.current_doc.index_qdrant
                    this.nombre_real        = this.current_doc.nombre_real
                    this.nombre_guardado    = this.current_doc.nombre_guardado

                    axios.post('/delete/pdf',
                    {  
                        value_key       :this.nombre_real,
                        nombre_guardado :this.nombre_guardado,
                        nombre_real     :this.nombre_real,
                        key             :'pdf_name',
                        ruta            :this.str_archivo,
                        tp_categoria    :this.current_doc.tp_categoria,
                        contexto        :this.id_file,
                        asistente_id    :this.tp_asistente
                    })
                    .then(res => {
                        let resp = res.data
                        this.modalSweetAlert({title:resp.title,text:resp.msj,icon:resp.color})
                        this.get_pdfs()
                        this.current_index  = ''
                        this.nombre_real    = ''

                        this.get_chats()
                        this.id_file        = 0
                    })
                    .catch(err => {
                        console.log(err)
                    })
                },
                formatLinks(text) 
                {
                    if (typeof text !== 'string') 
                    {
                        console.warn('formatLinks: el argumento proporcionado no es una cadena', text);
                        return text;
                    }
                
                    // Interpretar tablas Markdown
                    const tableRegex = /((?:.*\|)+)(\n|\r\n?)((?:[- :|]+)+)(\n|\r\n?)((?:.*\|[\r\n?])+)/g;
                    let textWithTables = text.replace(tableRegex, function(match, p1, p2, p3, p4, p5) {
                        let headers = p1.split('|').filter(cell => cell.trim());
                        let rows = p5.split(/\r?\n/).filter(line => line.trim());
                
                        let tableHtml = '<table><thead><tr>';
                        headers.forEach(header => {
                            tableHtml += `<th>${header.trim()}</th>`;
                        });
                        tableHtml += '</tr></thead><tbody>';
                
                        rows.forEach(row => {
                            let cells = row.split('|').filter(cell => cell.trim());
                            tableHtml += '<tr>';
                            cells.forEach(cell => {
                                tableHtml += `<td>${cell.trim()}</td>`;
                            });
                            tableHtml += '</tr>';
                        });
                
                        return tableHtml + '</tbody></table>';
                    });
                
                    // Resto de las conversiones
                    const linkRegex = /\[(.*?)\]\((.*?)\)/g;
                    const replacedText = textWithTables.replace(linkRegex, '<a target="_blank" href="$2">Enlace</a>');
                    const boldRegex = /\*\*(.*?)\*\*/g;
                    const textWithBold = replacedText.replace(boldRegex, '<strong>$1</strong>');
                    const h2Regex = /^##\s+(.*)$/gm;
                    const textWithH2 = textWithBold.replace(h2Regex, '<h3>$1</h3>');
                    const h1Regex = /^#\s+(.*)$/gm;
                    const textWithH1 = textWithH2.replace(h1Regex, '<h2>$1</h2>');
                    const textWithLineBreaks = textWithH1.replace(/\n/g, '<br>');
                
                    return textWithLineBreaks;
                },
                get_hilo(run_id)
                {
                    let me          = this;
                    let tmp_query   = me.query
                    me.query        = ''

                    axios.post('/consulta/pdf',
                    {'run_id':run_id,'question':tmp_query,'contexto':me.id_file,'asistente' : me.tp_asistente})
                    .then(response => {
                        
                        me.info        = response.data.response.messages
                        me.info.sort(function(a, b) {return a.created_at - b.created_at;});

                        this.$nextTick(() => 
                        {
                            this.scrollDown('#scroll_chat')
                        })


                        me.escribiendo  = 0
                    })
                        .catch(error => {
                            me.escribiendo  = 0

                    });

                },
                add_question()
                {
                    let me        = this;
                    let question  = me.query
                    let run_id    = ''

                    if( me.query == '' || me.escribiendo == 1 )
                        return 

                    me.escribiendo  = 1

                    axios.post('/consulta/question',{'question':question,'contexto': me.id_file,'asistente': this.tp_asistente}) 
                    .then(response => 
                    {
                        me.info         = response.data.response.messages
                        run_id          = response.data.run_id

                        me.info.sort(function(a, b) {return a.created_at - b.created_at;});
                        me.info[me.info.length - 1].last = 1

                        this.$nextTick(() => {
                            
                            me.get_hilo(run_id)
                            this.scrollDown('#scroll_chat')
                        })

                        


                    })
                        .catch(error => {
                        console.log(error);
                        me.escribiendo   = 0

                    });

                },
                scrollDown(element) 
                {
                    let el = document.querySelector(element);

                    if(!el)
                        return 

                    if (el) 
                        {
                            let px = el.scrollHeight;
                            $(el).animate({ scrollTop: px }, 1000);
                        }
                },
                async get_chats()
                {
                    let me      = this;
                    me.info     = []

                    if(me.id_file == 0)
                        return


                    await   axios.post('/get/chats/openai',{'contexto':me.id_file,'asistente': this.tp_asistente})
                    .then(response => 
                    {

                        if(!response.data.response)
                            return 

                        me.info = response.data.response.messages

                        if(me.info)
                            me.info.sort(function(a, b) {return a.created_at - b.created_at;});

                        this.$nextTick(() => 
                        { 
                            this.scrollDown('#scroll_chat')
                        })


                    }).catch(error => {
                        console.log(error);
                    });
                    
                        
                },
                async selectPDF() 
                {
                    if(this.id_file == 0)
                        return

                    this.current_doc    = this.pdfs.find(item => item.id == this.id_file)

                    this.str_archivo    = this.current_doc.ruta
                    this.current_index  = this.current_doc.index_qdrant
                    this.nombre_real    = this.current_doc.nombre_real
                    //this.bottomScroll('.nk-content')
                    this.get_chats()
                },
                modalSweetAlert(resp)
                {
                    Swal.fire({
                                title: resp.title,
                                text: resp.text,
                                icon: resp.icon,
                                confirmButtonText: 'Cerrar'
                                })
                },
                async  uploadPdf() 
                {
                    let formData        = new FormData();
                    let file_pdf        = document.querySelector("#file_pdf");

                    if(file_pdf.files.length == 0)
                    {
                        this.modalSweetAlert({title:'Error',text:'Debe seleccionar un archivo',icon:'error'})
                        return
                    }

                    if(file_pdf.files[0].size > 5000000)
                    {
                        this.modalSweetAlert({title:'Error',text:'El tamaño del archivo no puede ser superior a 5MB',icon:'error'})
                        file_pdf.value = null
                        return
                    }

                    this.tp_cargando    = 1
                    let file            = file_pdf.files[0]
                    formData.append('pdf', file);

                    await axios.post('/upload/pdf', formData, {headers: {'Content-Type': 'multipart/form-data'}})
                        .then(res => 
                        {
                            let resp = res.data
                            this.modalSweetAlert({title:resp.title,text:resp.msj,icon:resp.color})
                            this.get_pdfs()
                            this.tp_cargando = 0
                            file_pdf.value = null

                        })
                        .catch(error => 
                        {
                        let mensaje_error = 'Error al cargar el archivo'
                        if(error && error.response.status == 422)
                            {
                                this.errors = error.response.data.errors; 
                                if(this.errors.pdf)
                                    mensaje_error = this.errors.pdf[0]
                            }

                            this.modalSweetAlert({title:'Error',text:mensaje_error,icon:'error'})
                            this.tp_cargando = 0
                            file_pdf.value = null

                        })
                },
                get_pdfs() 
                {
                    axios.get('/get/pdfs')
                        .then(res => {
                            this.pdfs = res.data.pdfs
                        })
                        .catch(err => {
                            console.log(err)
                        })
                },
                
                
            },

            mounted() {
                this.get_pdfs()
            }
        });
    </script>
<style lang="">

</style>
@endsection()


