<!DOCTYPE html>
<html lang="es">
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
		<title>Sistema Atención al Vecino</title>
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no, minimal-ui">
		<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

		<script src="https://code.jquery.com/jquery-3.5.0.js" ></script>
		<script src="https://cdn.jsdelivr.net/npm/vue@2/dist/vue.js"></script>
		<script src="https://unpkg.com/vue-multiselect@2.1.0"></script>
		<script src="https://cdn.jsdelivr.net/npm/axios@0.26.0/dist/axios.min.js"></script>		
		<script src="<?php echo e(asset('/lib/tinymce/tinymce.min.js')); ?>"></script>
		<script src="<?php echo e(asset('/lib/printThis/printThis.js')); ?>"></script>
    	<script src="<?php echo e(asset('/lib/moment/moment.js')); ?>"></script>
    	<script src="<?php echo e(asset('/lib/echarts/echarts.min.js')); ?>"></script>
    	<script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>

    	<script src="<?php echo e(asset('/js/bootstrap.bundle.min.js')); ?>"></script>

		<link rel="stylesheet" href="<?php echo e(asset('/lib/flatpickr/css/flatpickr.min.css')); ?>"> 
		<script src="<?php echo e(asset('/lib/flatpickr/js/flatpickr.js')); ?>"></script> 
		<script src="<?php echo e(asset('/lib/flatpickr/locales/es.js')); ?>"></script> 
		
		
		<link rel="stylesheet" href="https://unpkg.com/vue-multiselect@2.1.0/dist/vue-multiselect.min.css">
		<link href="<?php echo e(asset('/css/bootstrap.min.css')); ?>"  rel="stylesheet">
		
		<link href="<?php echo e(asset('/css/icons.min.css')); ?>" rel="stylesheet" type="text/css" >
		<link href="<?php echo e(asset('/css/app.min.css')); ?>"  rel="stylesheet" type="text/css">
		
		<style type="text/css">
			.waves-effect{
				text-decoration: none;
			}
			.sub-menu li a {
				text-decoration: none;
			}
			.modal {
			  position: fixed;
			  top: 0;
			  left: 0;
			  z-index: 1060;
			  display: none;
			  width: 100%;
			  height: 100%;
			  overflow-x: hidden;
			  overflow-y: auto;
			  outline: 0;
			}

			@media (min-width: 1200px) {
			  	.modal-xxl {
			    	max-width: 1600px; 
			    } 
			}

			.to-print { display: none; }

	        .multiselect--active { z-index: 10; }
		</style>

		<script type="text/javascript">
			//-----------------------------------------------------------------
			$( document ).ready(function() {
				$("#cant_clave").html(8)
			});
			//-----------------------------------------------------------------
			function contadorClave()
			{
				var largo = $("#new_pass").val()
				$("#cant_clave").html(8-largo.length)
			}
			//-----------------------------------------------------------------
			function cambiar_clave() 
			{
			      var new_pass 	= $("#new_pass").val();
			      var rnew_pass = $("#rnew_pass").val();

			      if (new_pass.trim().length < 5) {
			        $("#error_pass").html("La contraseña debe tener por lo menos 5 caracteres");
			        return
			      } else 
			        $("#error_pass").html("");

			      if (new_pass != rnew_pass) {
			        $("#error_pass").html("Contraseñas distintas favor reingresar");
			        return;
			      } else 
			        $("#error_pass").html("");


			      axios.post('/update/password', {
			        'new_pass': new_pass,
			        'rnew_pass': rnew_pass,
			      }).then(function(response) 
			      {
			        var respuesta = response.data;
			        var error 		= respuesta.error;
			        var msj 			= respuesta.mensaje;

			        Swal.fire({
			          type: 'success',
			          title: msj,
			          text: '',
			          timer: 2000
			        });

			        if(error == 0)
			        {
			          	$("#modal_password").modal("hide");
			          	$("#new_pass").val('');
			      			$("#rnew_pass").val('');

			      			setTimeout(function(){ location.reload(); }, 3000);	      			
			        }
			      }).catch(function(error) {
			        console.log(error);
			      });
	    	}
	    	//-----------------------------------------------------------------
	    	function changeRol() {
      			var nr_rol = $("#nr_rol").val();
      			var salida = null;

      			axios.post('/user/update/rol', {
        			'nr_rol'	: 	nr_rol
      			}).then(function(response) {
        			let respuesta 	= 	response.data;
        			salida 	=	respuesta.str_destino;
        			console.log(salida);
      			}).catch(function(error) {
      			  	console.log(error);
      			});

      			setTimeout(function() {
      			   	window.location = salida;
      			}, 1500);
    		}
	        //-----------------------------------------------------------------
	        function activeTinyMCE(str_textarea = '')
	        {
	            setTimeout(function(){
	            	tinymce.init({
						selector: 'textarea.tinymce',
						entity_encoding:'html',
						language: 'es',
						language_url : '/lib/tinymce/langs/es.js',
						height: 200,
						plugins: 'paste ' + 
								'importcss ' + 
								'autolink ' + 
								'code ' + 
								'pagebreak ' + 
								'nonbreaking ' + 
								'anchor ' + 
								'advlist ' + 
								'lists ' + 
								'noneditable ' + 
								'wordcount ',
						menubar: '',
						toolbar: 'undo redo | ' + 
								'bold italic underline strikethrough | ' + 
								'fontselect fontsizeselect | ' + 
								'alignleft aligncenter alignright alignjustify | ' + 
								'outdent indent | ' + 
								'numlist bullist | ' + 
								'forecolor backcolor removeformat |',
						setup: function(editor) {
							var maxLength = 2000;
							editor.on('init', function(e) {
								console.log('The Editor has initialized.');
							});

							// Agrega un elemento personalizado a la barra de estado para el conteo de caracteres
					        editor.on('init', function() {
					            // Oculta el contador de palabras predeterminado
					            var wordCountEl = editor.getContainer().querySelector('.tox-statusbar__wordcount');
					            if (wordCountEl) {
					                wordCountEl.style.display = 'none';
					            }

					            // Crea y agrega el contador de caracteres personalizado
					            var statusBar = editor.getContainer().querySelector('.tox-statusbar__text-container');
					            if (statusBar) {
					                var charCountElement = document.createElement('div');
					                charCountElement.id = 'custom-character-count';
					                charCountElement.className = 'tox-statusbar__wordcount';
					                charCountElement.textContent = '0 caracteres';
					                statusBar.appendChild(charCountElement);
					            }
					        });

					        // Función para verificar si el contenido excede el límite máximo
						    function isMaxLengthExceeded() {
						        var textLength = editor.getContent({ format: 'text' }).length;
						        return textLength > maxLength;
						    }

						    // Manejador para el evento 'beforeinput'
						    editor.on('beforeinput', function(event) {
						        var textLength = editor.getContent({ format: 'text' }).length;
						        
						        // Permite acciones de edición específicas incluso después de alcanzar el límite
						        if (textLength >= maxLength && !isEditingAction(event.inputType)) {
						            event.preventDefault();
						            return false;
						        }
						    });

						    function isEditingAction(inputType) {
						        // Lista de tipos de entrada permitidos que no agregan caracteres
						        return ['deleteContentBackward', 'deleteContentForward', 'deleteWordBackward', 'deleteWordForward', 'cut'].indexOf(inputType) > -1;
						    }

					        // Función para actualizar el contador de caracteres
					        function updateCharacterCount() {
					            var textLength = editor.getContent({ format: 'text' }).length;
					            var charCountElement = document.getElementById('custom-character-count');
					            if (charCountElement) {
					                charCountElement.textContent = textLength + ' caracteres';
					            }
					        }

					        // Actualiza el contador de caracteres y verifica el límite en cada evento de entrada
					        editor.on('input keyup', function() {
					            updateCharacterCount();
					        });
						}
					});
	            }, 1000);
	        }
	        //-----------------------------------------------------------------
	        function activeTextArea(str_textarea = '')
	        {
	            try{
	                if($('.tinymce'))
	                {
	                    // console.log('existe #'+str_textarea);
	                    // $('#'+str_textarea).attr('disabled',true);
	                    activeTinyMCE();
	                }
	                // else
	                //     console.log('NO existe #'+str_textarea);
	            }catch(error) {
	                // -------------
	            }
	        }
	        //-----------------------------------------------------------------
	    </script>		
	</head>

	<body data-sidebar="dark">
		<!-- change role -->
		<div class="modal fade" id="modal_rol" tabindex="0" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
			<div class="modal-dialog" role="document">
			    <div class="modal-content">
			      	<div class="modal-header bg--primary">
			        	<h5 class="modal-title" id="exampleModalLabel">Cambiar Rol</h5>
			        	<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
			          		<span aria-hidden="true">&times;</span>
			        	</button>
			      	</div>
			      	<div class="modal-body">
				    	<div class="row">
		            		<div class="col-12">
		              			<div class="form-group">
		                			<label>Seleccionar Rol:</label>
		                			<select class="form-control" id="nr_rol">
		                				<?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $roles): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
		                					<option value="<?php echo e($roles->id); ?>"><?php echo e($roles->nombre); ?></option>
		                				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		                			</select>
		              			</div>
		            		</div>
		          		</div>
			      	</div>
			      	<div class="modal-footer">
	          			<button type="button" class="btn btn-light btn_activo" data-bs-dismiss="modal">Cancelar</button>
	          			<button type="button" class="btn btn-primary btn_activo" onclick="changeRol()">Guardar Cambios</button>
	        		</div>
			    </div>
			</div>
		</div>

		<!-- change password -->
		<div class="modal fade" id="modal_password" tabindex="0" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
			<div class="modal-dialog" role="document">
			    <div class="modal-content">
			      	<div class="modal-header bg--primary">
			        	<h5 class="modal-title" id="exampleModalLabel">Cambiar Contraseña</h5>
			        	<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
			          		<span aria-hidden="true">&times;</span>
			        	</button>
			      	</div>
			      	<div class="modal-body">
				    	<div class="row">
		            		<div class="col-12">
		              			<div class="form-group">
		                			<label>Ingresar Contraseña Nueva:</label>
		                			<input onkeyup="contadorClave()" onkeypress="contadorClave()" id="new_pass" maxlength="8" type="password" class="form-control tp_editar" placeholder="Contraseña">
		                			<small>Le quedan <strong id="cant_clave"></strong> caracteres por ingresar.</small>
		              			</div>
		            		</div>

		            		<div class="col-12">
		              			<div class="form-group">
		                			<label>Re Ingresar Contraseña Nueva:</label>
		                			<input id="rnew_pass" maxlength="8" type="password" class="form-control tp_editar" placeholder="Repetir Contraseña">
		              			</div>
		            		</div>

		            		<div class="row-fluid">
			            		<div class="col-md-12">
			              			<h6 style="color:red" class="text-error" id="error_pass"></h6>
			            		</div>
			          		</div>
		          		</div>
			      	</div>
			      	<div class="modal-footer">
	          			<button type="button" class="btn btn-light btn_activo" data-bs-dismiss="modal">Cancelar</button>
	          			<button type="button" class="btn btn-primary btn_activo" onclick="cambiar_clave()">Guardar Cambios</button>
	        		</div>
			    </div>
			</div>
		</div>

		<?php echo $__env->yieldContent('content'); ?>
		
		<script src="<?php echo e(asset('/js/funciones_generales.js')); ?>"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/metisMenu/3.0.7/metisMenu.min.js" integrity="sha512-o36qZrjup13zLM13tqxvZTaXMXs+5i4TL5UWaDCsmbp5qUcijtdCFuW9a/3qnHGfWzFHBAln8ODjf7AnUNebVg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/simplebar/3.1.0/simplebar.min.js" integrity="sha512-BAuu8EflZpIaGvbVQU/kEAHbiENMFlyewimZOSxV9HPqOCGuifmxxIdpeTNQSZWREeIdFdoAtRGx5yGvTzsjaQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/node-waves/0.7.6/waves.min.js" integrity="sha512-MzXgHd+o6pUd/tm8ZgPkxya3QUCiHVMQolnY3IZqhsrOWQaBfax600esAw3XbBucYB15hZLOF0sKMHsTPdjLFg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>

		<script src="<?php echo e(asset('js/app_stoke.js')); ?>"></script>
	</body>
</html>
<?php /**PATH C:\repositorio\atencion_vecino\resources\views/template/adminlte.blade.php ENDPATH**/ ?>