<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

use DB;

class EncuestaLlamada extends Model
{
    protected $table       =   'gsut_encuesta_llamada';
    protected $primaryKey   =   'id';
    protected $fillable     =   [
                                    'id_solicitud',
                                    'id_autor',
                                    'nr_rut',
                                    'nr_prefijo',
                                    'nr_telefono',
                                    'fc_inicio',
                                    'fc_termino',
                                    'str_observacion',
                                    'fc_inicio_ring',
                                    'fc_termino_ring',
                                    'fc_inicio_contacto',
                                    'fc_termino_contacto',
                                    'fc_inicio_servicio',
                                    'fc_termino_servicio',
                                    'id_estado',
                                    'tp_activo'
                                ];

    public $timestamps = true;
    //-----------------------------------------------------------
    public function respuestas()
    {
        return  $this->hasMany('App\EncuestaRespuesta','id_llamada','id')
                    ->leftjoin('gsut_encuesta_pregunta as pregunta','pregunta.id','=','gsut_encuesta_respuestas.id_pregunta')
                    ->select([
                        'gsut_encuesta_respuestas.id',
                        'gsut_encuesta_respuestas.id_llamada',
                        'gsut_encuesta_respuestas.id_pregunta',
                        'gsut_encuesta_respuestas.id_alternativa',
                        'pregunta.tp_pregunta',
                        'gsut_encuesta_respuestas.nm_pregunta',
                        'gsut_encuesta_respuestas.nm_alternativa',
                        'gsut_encuesta_respuestas.vl_alternativa'
                    ])
                    ->where('gsut_encuesta_respuestas.tp_activo','=','1');
    }
    //-----------------------------------------------------------
    public function vecino()
    {
        return $this->belongsTo('App\Vecino','nr_rut','nr_rut')
               ->select([
                    'nr_rut',
                    'nm_vecino',
                    'ap_paterno',
                    'ap_materno',
                    DB::raw('(concat(nm_vecino," ",ap_paterno," ",ap_materno)) as nmc_vecino'),
                    'id_region',
                    'id_comuna',
                    'id_ubicacion',
                    'id_macroterritorio',
                    'id_unidadvecinal',                                    
                    'nr_calle',
                    'nm_calle',
                    'nm_ubicacion',
                    'tp_direccion',
                    'str_latitud',
                    'str_longitud',
                    'str_aclaratoria',
                    'nr_prefijo',
                    'nr_telefono',
                    'nm_mail',
                    'tp_vecino',
                    'id_autor',
                    'tp_activo'
               ]);
    }
    //-----------------------------------------------------------
}
