<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class EncuestaPregunta extends Model
{
    protected $table       =   'gsut_encuesta_pregunta';
    protected $primaryKey   =   'id';
    protected $fillable     =   [
                                    'id_encuesta',
                                    'tp_categoria',
                                    'nr_pregunta',
                                    'cod_pregunta',
                                    'tp_pregunta',
                                    'tp_obligatorio',
                                    'str_formdata',
                                    'str_pregunta',
                                    'str_indicacion',
                                    'tp_activo'
                                ];

    public $timestamps = true;

    public function alternativa()
    {
        return  $this->hasMany('App\EncuestaAlternativa','id_pregunta','id')
                    ->where('gsut_encuesta_alternativa.tp_activo','=','1');
    }

    public function logica()
    {
        return  $this->hasMany('App\EncuestaLogica','nr_pregunta','id')
                    ->leftjoin('gsut_encuesta_pregunta as actual','actual.id','=','gsut_encuesta_logica.nr_pregunta')
                    ->leftjoin('gsut_encuesta_pregunta as siguiente','siguiente.id','=','gsut_encuesta_logica.nr_siguiente')
                    ->leftjoin('gsut_encuesta_pregunta as anterior','anterior.id','=','gsut_encuesta_logica.nr_anterior')
                    ->leftjoin('gsut_encuesta_alternativa as alternativa','alternativa.id','=','gsut_encuesta_logica.nr_alternativa')
                    ->where('gsut_encuesta_logica.tp_activo','=','1')
                    ->select([
                        'gsut_encuesta_logica.nr_pregunta',
                        'gsut_encuesta_logica.nr_alternativa',
                        'gsut_encuesta_logica.nr_valor',
                        'gsut_encuesta_logica.tp_accion',
                        'gsut_encuesta_logica.nr_anterior',
                        'gsut_encuesta_logica.nr_siguiente',
                        'gsut_encuesta_logica.tp_anterior',
                        'gsut_encuesta_logica.tp_siguiente',
                        'gsut_encuesta_logica.tp_save',
                        'gsut_encuesta_logica.tp_evento_fecha',
                        'gsut_encuesta_logica.tp_evento_estado',
                        'alternativa.cod_alternativa',
                        'alternativa.str_alternativa',
                        'actual.cod_pregunta as actual_cod_pregunta',
                        'actual.str_formdata as actual_str_formdata',
                        'actual.tp_pregunta as actual_tp_pregunta',
                        'actual.str_pregunta as actual_str_pregunta',
                        'actual.str_indicacion as actual_str_indicacion',
                        'anterior.cod_pregunta as back_cod_pregunta',
                        'anterior.str_formdata as back_str_formdata',
                        'anterior.tp_pregunta as back_tp_pregunta',
                        'anterior.str_indicacion as back_str_indicacion',
                        'siguiente.cod_pregunta as next_cod_pregunta',
                        'siguiente.str_formdata as next_str_formdata',
                        'siguiente.tp_pregunta as next_tp_pregunta',
                        'siguiente.str_indicacion as next_str_indicacion'
                    ]);
    }
}
