<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Illuminate\Support\Facades\Auth;
use App\Solicitud;
use App\Http\Controllers\UtilController;
use Illuminate\Support\Carbon;
use DB;

class ExportSolicitudes implements FromCollection,WithHeadings
{
    protected $fl_mostrar;
    protected $fl_direccion;
    protected $fl_depto;
    protected $fl_servicio;
    protected $fl_macrozona;
    protected $fl_undvecinal;
    protected $fl_ticket;
    protected $fl_vecino;
    protected $fl_motivo;
    protected $fl_ubicacion;
    protected $fl_persona;
    protected $tp_criterio;
    protected $tp_orden;
    protected $fc_desde;
    protected $fc_hasta;

    function __construct($tp_criterio, $tp_orden, $fl_mostrar, $fc_desde, $fc_hasta, $fl_direccion, $fl_depto, $fl_servicio, $fl_macrozona, $fl_unidadvecinal, $fl_ticket, $fl_motivo, $fl_ubicacion, $fl_persona)
    {
        $this->tp_criterio          =   $tp_criterio;
        $this->tp_orden             =   $tp_orden;
        $this->fl_mostrar           =   $fl_mostrar;
        $this->fc_desde             =   $fc_desde;
        $this->fc_hasta             =   $fc_hasta;
        $this->fl_direccion         =   $fl_direccion;
        $this->fl_depto             =   $fl_depto;
        $this->fl_servicio          =   $fl_servicio;
        $this->fl_macrozona         =   $fl_macrozona;
        $this->fl_unidadvecinal     =   $fl_unidadvecinal;
        $this->fl_ticket            =   $fl_ticket;
        $this->fl_motivo            =   $fl_motivo;
        $this->fl_ubicacion         =   $fl_ubicacion;
        $this->fl_persona           =   $fl_persona;
    }

    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $tp_criterio    =   $this->tp_criterio;
        $tp_orden       =   $this->tp_orden;
        $fl_mostrar     =   $this->fl_mostrar;
        $fc_desde       =   $this->fc_desde;
        $fc_hasta       =   $this->fc_hasta;
        $fl_direccion   =   $this->fl_direccion;
        $fl_depto       =   $this->fl_depto;
        $fl_servicio    =   $this->fl_servicio;
        $fl_macrozona   =   $this->fl_macrozona;
        $fl_undvecinal  =   $this->fl_unidadvecinal;
        $fl_ticket      =   $this->fl_ticket;
        $fl_motivo      =   $this->fl_motivo;
        $fl_ubicacion   =   $this->fl_ubicacion;
        $fl_persona     =   $this->fl_persona;

        $data           =   Solicitud::
                            join('gsut_direccion as dir','dir.id','=','gsut_solicitud.id_direccion')
                            ->join('gsut_depto as depto','depto.id','=','gsut_solicitud.id_depto')
                            ->join('gsut_tipo as servicio','servicio.id','=','gsut_solicitud.id_tipo')
                            ->join('gsut_prioridad as prioridad','prioridad.id','=','gsut_solicitud.id_prioridad')
                            ->join('gsut_motivo as motivo','motivo.id','=','gsut_solicitud.id_motivo')
                            ->join('gsut_direccion as dir_destino','dir_destino.id','=','gsut_solicitud.id_direccion_destino')
                            ->join('gsut_depto as depto_destino','depto_destino.id','=','gsut_solicitud.id_depto_destino')
                            ->leftjoin('gsut_macroterritorio as mt','mt.id','=','gsut_solicitud.id_macroterritorio')
                            ->leftjoin('gsut_unidadvecinal as uv','uv.id','=','gsut_solicitud.id_unidadvecinal')
                            ->join('gsut_estado as estado','estado.id','=','gsut_solicitud.id_estado')
                            ->join('gsut_tipo_ingreso as ingreso','ingreso.id','=','gsut_solicitud.tp_ingreso')
                            ->join('users as autor','autor.id','=','gsut_solicitud.id_autor')
                            ->leftjoin('gsut_vecino as vecino','vecino.nr_rut','=','gsut_solicitud.nr_rut_vecino')
                            ->leftjoin('cut_comuna as comuna','comuna.id','=','vecino.id_comuna')
                            ->leftjoin('gsut_roles as rol','rol.id','=','gsut_solicitud.id_rol')
                            ->select('gsut_solicitud.id',
                                'gsut_solicitud.id_estado',
                                'estado.nm_estado',
                                'gsut_solicitud.nr_anio',
                                'gsut_solicitud.nr_mes',
                                'gsut_solicitud.nr_dia',
                                'gsut_solicitud.nr_ticket',
                                'dir.nm_direccion',
                                'depto.nm_depto',                                
                                'prioridad.nm_prioridad',
                                'motivo.nm_motivo',
                                'dir_destino.nm_direccion as nm_direccion_destino',
                                'depto_destino.nm_depto as nm_depto_destino',
                                'servicio.nm_tipo as nm_servicio',
                                'mt.cod_territorio',
                                'uv.nm_unidadvecinal',
                                'gsut_solicitud.nm_ubicacion',
                                'gsut_solicitud.str_aclaratoria',
                                'gsut_solicitud.str_observacion',
                                'gsut_solicitud.nr_rut_vecino',
                                'vecino.nm_vecino',
                                'vecino.ap_paterno',
                                'vecino.ap_materno',
                                'vecino.nm_mail',
                                'vecino.nr_prefijo',
                                'vecino.nr_telefono',
                                'comuna.nm_comuna',
                                'vecino.nm_ubicacion as nm_domicilio',                                
                                'gsut_solicitud.fc_creacion as fc_ingreso',
                                'gsut_solicitud.fc_revisado',
                                'gsut_solicitud.fc_feedback as fc_feedback_territorial',
                                'gsut_solicitud.tp_satisfaccion as tp_satisfaccion_territorial',
                                'gsut_solicitud.str_feedback as str_feedback_territorial',
                                'gsut_solicitud.fc_feedback_vecino',
                                'gsut_solicitud.tp_satisfaccion_vecino',
                                'gsut_solicitud.str_feedback_vecino',
                                'ingreso.nm_ingreso',
                                'autor.name',
                                'rol.nombre',
                                DB::raw('(case 
                                        when (select count(*) 
                                            from gsut_respuesta as r 
                                            where r.id_solicitud = gsut_solicitud.id 
                                            and r.tp_respuesta = 2) != 0 
                                        then "SI" 
                                        else "NO" 
                                    end) as tiene_publicacion_parcial'),
                                DB::raw('(select count(*) 
                                    from gsut_respuesta as r 
                                    where r.id_solicitud = gsut_solicitud.id 
                                    and r.tp_respuesta = 2 
                                    and r.tp_activo = 1) 
                                    as cantidad_publicacion_parcial'),
                                DB::raw('(case 
                                        when (select count(*) 
                                            from gsut_respuesta as r 
                                            where r.id_solicitud = gsut_solicitud.id 
                                            and r.tp_respuesta = 1) != 0 
                                        then "SI" 
                                        else "NO" 
                                    end) as tiene_publicacion_definitiva'),
                                DB::raw('(select count(*) 
                                    from gsut_respuesta as r 
                                    where r.id_solicitud = gsut_solicitud.id 
                                    and r.tp_respuesta = 1 
                                    and r.tp_activo = 1) 
                                    as cantidad_publicacion_definitiva'),
                                DB::raw('(select r.fc_ingreso from gsut_respuesta as r where r.id_solicitud = gsut_solicitud.id and r.tp_respuesta = 1 and r.tp_activo = 1 limit 1) as fc_publicacion_definitiva'),
                                DB::raw('(select r.str_observacion from gsut_respuesta as r where r.id_solicitud = gsut_solicitud.id and r.tp_respuesta = 1 and r.tp_activo = 1 limit 1) as str_publicacion_definitiva'),
                                DB::raw('(select concat(u.nombre," ",u.ap_paterno," ",u.ap_materno) 
                                        from gsut_respuesta as r inner join users as u on u.id = r.id_autor 
                                        where r.id_solicitud = gsut_solicitud.id and r.tp_respuesta = 1 and r.tp_activo = 1 limit 1) as autor_publicacion_definitiva'))
                            ->where('gsut_solicitud.tp_activo','=','1');

        /* ----- Inicio - Filtro ----- */
            if($fl_mostrar != 0)
            {
                if($fl_mostrar != 5)
                    $data   =   $data->where('gsut_solicitud.id_estado','=',$fl_mostrar);
                else
                    $data   =   $data->whereIn('gsut_solicitud.id_estado',[5,6]);
            }

            if($fl_direccion) 
                $data   =   $data->where('gsut_solicitud.id_direccion_destino','=',$fl_direccion);

            if($fl_depto) 
                $data   =   $data->where('gsut_solicitud.id_depto_destino','=',$fl_depto);

            if($fl_servicio)
                $data   =   $data->where('gsut_solicitud.id_tipo','=',$fl_servicio);

            if($fl_macrozona)
                $data   =   $data->where('gsut_solicitud.id_macroterritorio','=',$fl_macrozona);

            if($fl_undvecinal)
                $data   =   $data->where('gsut_solicitud.id_unidadvecinal','=',$fl_undvecinal);

            if($fl_ticket)
                $data   =   $data->where('gsut_solicitud.nr_ticket','=',$fl_ticket);

            if($fl_persona)
                $data   =   $data->where('gsut_solicitud.nr_rut_vecino','=',$fl_persona);

            if($fl_motivo)
                $data   =   $data->where('gsut_solicitud.id_motivo','=',$fl_motivo);

            if($fl_ubicacion)
                $data   =   $data->where('gsut_solicitud.id_ubicacion','=',$fl_ubicacion);

            if($fc_desde && $fc_hasta)
            {
                $fc_desde   =   Carbon::parse($fc_desde)->format('Y-m-d');
                $fc_hasta   =   Carbon::parse($fc_hasta)->format('Y-m-d');
                $data       =   $data->whereDate('gsut_solicitud.created_at','>=',$fc_desde)
                                     ->whereDate('gsut_solicitud.created_at','<=',$fc_hasta);
            }
        /* ----- Termino - Filtro ----- */

        /*----- Inicio - Orden por Campos -----*/
            if(in_array($tp_criterio, ['id','id_macroterritorio','id_unidadvecinal','created_at']))
                $data   =   $data->orderBy('gsut_solicitud.'.$tp_criterio, $tp_orden);

            if($tp_criterio === 'nm_direccion')
                $data   =   $data->orderBy('dir_destino.nm_direccion',$tp_orden);

            if($tp_criterio === 'nm_depto')
                $data   =   $data->orderBy('depto_destino.nm_depto',$tp_orden);

            if($tp_criterio === 'nm_estado')
                $data   =   $data->orderBy('estado.nm_estado',$tp_orden);
        /*----- Termino - Orden por Campos -----*/

        $data   =   $data->orderby('gsut_solicitud.id','asc')->get();

        foreach ($data as $key => $value) {            
            // $value->tiene_publicacion_parcial       =   (UtilController::getCantidadRespuestas(2, $value->id) != 0) ? 'SI' : 'NO'; // Tiene Publicaciones Parciales
            // $value->cantidad_publicacion_parcial    =   (UtilController::getCantidadRespuestas(2, $value->id)); // Cantidad Publicaciones Parciales
            // $value->tiene_publicacion_definitiva    =   (UtilController::getCantidadRespuestas(1, $value->id) != 0) ? 'SI' : 'NO'; // Tiene Publicacion Definitiva
            // $value->cantidad_publicacion_definitiva =   (UtilController::getCantidadRespuestas(1, $value->id)); // Cantidad Publicacion Definitiva
            // $publicacion                            =   (UtilController::getPublicacion(1, $value->id));
            // $value->fc_publicacion_definitiva       =   ($publicacion != null) ? $publicacion->fc_ingreso : '';
            // $value->str_publicacion_definitiva      =   ($publicacion != null) ? $publicacion->str_observacion : '';
            $value->tiempo_tramitado                =   UtilController::getTiempoTramitacion($value->fc_ingreso, $value->fc_publicacion_definitiva, $value->id_estado);
        }

        $data   =   $data->makeHidden(['id','id_estado'])->toArray();

        return collect($data);
    }
    //-----------------------------------------------------------------
    public function headings(): array
    {
        return ['ESTADO',
                'AÑO',
                'MES',
                'DIA',
                'NT_TICKET',
                'DIRECCION_ORIGEN',
                'DEPTO_ORIGEN',                
                'PRIORIDAD',
                'MOTIVO',
                'DIRECCION_DESTINO',
                'DEPTO_DESTINO',
                'SERVICIO',
                'MACROZONA',
                'UND_VECINAL',
                'UBICACION_REQUERIMIENTO',
                'ACLARATORIA_UBICACION',
                'STR_REQUERIMIENTO',
                'RUT_VECINO',
                'NOMBRE_VECINO',
                'PATERNO_VECINO',
                'MATERNO_VECINO',
                'EMAIL_VECINO',
                'PREFIJO_VECINO',
                'TELEFONO_VECINO',
                'COMUNA_VECINO',
                'DOMICICIO_VECINO',
                'FC_INGRESO_REQUERIMIENTO',
                'FC_REVISION_REQUERIMIENTO',
                'FC_FEEDBACK_TERRITORIAL',
                'NV_SATISFACCION_TERRITORIAL',
                'STR_FEEDBACK_TERRITORIAL',
                'FC_FEEDBACK_VECINO',
                'NV_SATISFACCION_VECINO',
                'STR_FEEDBACK_VECINO',
                'TIPO_INGRESO',
                'AUTOR',
                'ROL',
                'TIENE_PUBLICACION_PARCIAL',
                'CANTIDAD_PUBLICACION_PARCIAL',
                'TIENE_PUBLICACION_DEFINITIVA',
                'CANTIDAD_DE_PUBLICACION_DEFINITIVA',
                'FC_PUBLICACION_DEFINITIVA',
                'STR_PUBLICACION_DEFINITIVA',
                'AUTOR_PUBLICACION_DEFINITIVA',
                'TIEMPO_TRAMITADO',
            ];
    }
    //-----------------------------------------------------------------
    
}