<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Vecino;
use App\Solicitud;
use App\Respuesta;
use App\ApiUser;

use DB;
use Validator;
use Freshwork\ChileanBundle\Rut;
use Illuminate\Support\MessageBag;

use App\Http\Controllers\UtilController;
use App\Http\Controllers\LogController;

class ApiController extends Controller
{
    //------------------------------------------------------------
    private $log;
    //------------------------------------------------------------
    public function __construct() {
        $this->log = new LogController();
    }
    //------------------------------------------------------------
    public function storeSolicitud(Request $request)
    {
        $validacion     =   $this->validarDatosStoreSolicitud($request);

        if ($validacion)
            return $validacion;

        return  $this->registrarSolicitud($request);
    }
    //------------------------------------------------------------
    public function detailSolicitud(Request $request)
    {
        $validacion     =   $this->validarDatosDetailSolicitud($request);

        if ($validacion)
            return $validacion;

        return  $this->detalleSolicitud($request);
    }
    //------------------------------------------------------------
    public function getSolicitudes(Request $request)
    {
        $validacion     =   $this->validarDatosGetSolicitudes($request);

        if ($validacion)
            return $validacion;

        return  $this->obtenerSolicitudes($request);
    }
    //------------------------------------------------------------
    public function getTicket(Request $request)
    {
        $validacion     =   $this->validarDatosGetTicket($request);

        if ($validacion)
            return $validacion;

        return  $this->obtenerTicket($request);
    }
    //------------------------------------------------------------
    public function storeFeedbackVecino(Request $request)
    {
        $validacion     =   $this->validarFeedbackVecino($request);

        if ($validacion)
            return $validacion;

        return  $this->registrarFeedbackVecino($request);
    }
    //------------------------------------------------------------
    public function registrarSolicitud(Request $request)
    {
        // dd([
        //     'request'   =>  $request->all(),
        // ]);
        //-------------------------------------------------------------------------
        // Marca el tiempo de inicio
        $startTime  =    microtime(true);
        // Registro de log
        $data_log   =   $this->log->iniciarLog($request,__FUNCTION__);
        //-------------------------------------------------------------------------
        $app_token          =   $request->attributes->get('app-token');
        //-------------------------------------------------------------------------
        $dominio            =   $request->root(); // 'https://atencionvecino.lascondes.cl';
        $id_rol             =   0;
        //-------------------------------------------------------------------------
        /*----- Datos de la Solicitud -----*/
        $nr_motivo          =   $request->nr_motivo;
        $nr_tipo            =   $request->nr_tipo;
        $nm_tipo            =   $request->nm_tipo;
        $nr_dir_destino     =   $request->nr_dir_municipal;
        $nr_depto_destino   =   $request->nr_depto;
        $tp_ubicacion       =   $request->tp_ubicacion;
        $str_solicitud      =   $request->str_aclaratoria_solicitud;
        $str_descripcion    =   $request->str_observacion;
        $str_html           =   $request->str_observacion_html;
        $rut_vecino         =   Rut::parse($request->rut_vecino)->format(Rut::FORMAT_WITH_DASH);
        //-------------------------------------------------------------------------
        /*----- Datos Complementarios -----*/
        $nr_anio            =   Date('Y');
        $nr_mes             =   Date('m');
        $nr_dia             =   Date('d');
        $fc_actual          =   Date("Y-m-d H:i:s");
        $nr_folio           =   1;
        $nr_ticket          =   '';
        $id_autor           =   0; // 69070400-5 - Municipalidad de Las Condes
        $id_municipio       =   2; // Las Condes
        $id_direccion       =   22; // Externo
        $id_depto           =   90; // Plataforma Tecnologica
        $tp_vecino          =   1; 
        $tp_direccion       =   1; // frente
        $tp_municipal       =   1; // Contexto Municipal
        $nr_prioridad       =   2; // 1. SI | 2. NO
        $tp_ingreso         =   $request->tp_ingreso;
        $id_estado          =   1; // 1. Ingresada | 2. Revision
        $tp_visado_jmt      =   0;
        $tp_rechazado       =   0;
        $tp_activo          =   1; // 1. Activo | 0. Inactivo
        //-------------------------------------------------------------------------
        $arr_valida         =   [];
        $nr_id              =   0;
        $arr_dir_solicitud  =   null;
        $obj_dir_solicitud  =   null;
        $str_msj            =   '';
        $nr_folio           =   UtilController::generarNumeroFolio($nr_anio);
        $nr_ticket          =   UtilController::generarNumeroTicket($nr_anio, $nr_folio);
        $arr_archivo        =   $request->arr_archivo;
        $arr_observacion    =   $request->arr_observacion;            
        //-------------------------------------------------------------------------
        \Log::debug(__METHOD__ . " Ingreso Solicitud API : " . print_r($request->all(), true));
        //-------------------------------------------------------------------------
        try {
            if($tp_ubicacion  == 1)
            {
                $arr_dir_solicitud  =   json_decode($request['arr_direccion_solicitud'], true);

                // dd(['arr_dir_solicitud' => $arr_dir_solicitud]);

                foreach ($arr_dir_solicitud as $index => $value) {
                    $info_location      =   (Object) $value;
                    $obj_dir_solicitud  =   (Object) [
                        'value'                 =>  $info_location->value,
                        'label'                 =>  $info_location->label,
                        'nr_calle'              =>  $info_location->nr_calle,
                        'nm_calle'              =>  $info_location->nm_calle,
                        'str_latitud'           =>  $info_location->str_latitud,
                        'str_longitud'          =>  $info_location->str_longitud,
                        'cod_territorial'       =>  $info_location->cod_territorial,
                        'id_macroterritorio'    =>  UtilController::getIdMacroTerritorio($info_location->cod_territorial),
                        'cod_unidadvecinal'     =>  $info_location->cod_unidadvecinal,
                        'id_unidadvecinal'      =>  UtilController::getIdUnidadVecinal($info_location->cod_unidadvecinal),
                    ];
                }
            }
            else 
            {
                $arr_dir_solicitud      =   UtilController::getUbicacionDeptoMunicipal($nr_depto_destino);
                $obj_dir_solicitud      =   (Object) [
                    'value'                 =>  $arr_dir_solicitud->value,
                    'label'                 =>  $arr_dir_solicitud->label,
                    'nr_calle'              =>  $arr_dir_solicitud->nr_calle,
                    'nm_calle'              =>  $arr_dir_solicitud->nm_calle,
                    'str_latitud'           =>  $arr_dir_solicitud->str_latitud,
                    'str_longitud'          =>  $arr_dir_solicitud->str_longitud,
                    'cod_territorial'       =>  $arr_dir_solicitud->cod_territorial,
                    'id_macroterritorio'    =>  UtilController::getIdMacroTerritorio($arr_dir_solicitud->cod_territorial),
                    'cod_unidadvecinal'     =>  $arr_dir_solicitud->cod_unidadvecinal,
                    'id_unidadvecinal'      =>  UtilController::getIdUnidadVecinal($arr_dir_solicitud->cod_unidadvecinal),
                ];
            }
            //-------------------------------------------------------------------------
            $info   =   [
                'nr_anio'               =>  $nr_anio,
                'nr_mes'                =>  $nr_mes,
                'nr_dia'                =>  $nr_dia,
                'nr_folio'              =>  $nr_folio,
                'nr_ticket'             =>  $nr_ticket,
                'id_municipio'          =>  $id_municipio,                                      // interno
                'id_direccion'          =>  $id_direccion,                                      // interno
                'id_depto'              =>  $id_depto,                                          // interno
                'id_motivo'             =>  $nr_motivo,                                         // form
                'id_tipo'               =>  $nr_tipo,                                           // form 
                'nm_tipo'               =>  $nm_tipo,                                           // form
                'id_prioridad'          =>  $nr_prioridad,                                      // form
                'id_direccion_destino'  =>  $nr_dir_destino,                                    // form 
                'id_depto_destino'      =>  $nr_depto_destino,                                  // form 
                'id_ubicacion'          =>  $obj_dir_solicitud->value,                          // form 
                'id_macroterritorio'    =>  $obj_dir_solicitud->id_macroterritorio,             // form 
                'id_unidadvecinal'      =>  $obj_dir_solicitud->id_unidadvecinal,               // form                         
                'nr_direccion'          =>  $obj_dir_solicitud->nr_calle,                       // form 
                'nm_direccion'          =>  strtoupper(trim($obj_dir_solicitud->nm_calle)),     // form 
                'nm_ubicacion'          =>  strtoupper(trim($obj_dir_solicitud->label)),        // form 
                'str_latitud'           =>  $obj_dir_solicitud->str_latitud,                    // form 
                'str_longitud'          =>  $obj_dir_solicitud->str_longitud,                   // form 
                'tp_direccion'          =>  $tp_direccion,                                      // form 
                'nr_rut_vecino'         =>  $rut_vecino,                                        // form 
                'str_observacion'       =>  strtoupper(trim($str_descripcion)),                 // form 
                'str_observacion_html'  =>  strtoupper(trim($str_html)),                        // form 
                'str_aclaratoria'       =>  strtoupper(trim($str_solicitud)),                   // form 
                'fc_creacion'           =>  $fc_actual,                                         // interno
                'tp_visado_mt'          =>  $tp_visado_jmt,                                     // interno
                'tp_rechazado'          =>  $tp_rechazado,                                      // interno
                'id_estado'             =>  $id_estado,                                         // interno
                'contexto_municipal'    =>  $tp_municipal,                                      // form 
                'tp_ingreso'            =>  $tp_ingreso,                                        // interno
                'id_autor'              =>  $id_autor,                                          // interno
                'id_rol'                =>  $id_rol,                                            // interno
                'tp_vecino'             =>  $tp_vecino,                                         // Interno
                'tp_activo'             =>  $tp_activo,                                         // Interno
            ];
            //-------------------------------------------------------------------------
            // dd(['info'=>$info]);
            //-------------------------------------------------------------------------
            $model      =   Solicitud::create($info);
            $nr_id      =   $model->id;
            $str_msj    =   'Se ha registrado la solicitud correctamente con el número de ticket <strong>#'.$nr_ticket .'</strong>'.
                            '<br> <center><i>Favor tomar nota del numero de ticket</i></center>';
            //-------------------------------------------------------------------------
            if($nr_id) {
                // Validar si existe vecino
                if(!UtilController::existeVecino($rut_vecino))
                    GsutVecinoController::setRegistrarVecino($request);

                // Proceso Ingreso Flujo
                GsutFlujoController::ingresoSolicitud($nr_id,$nr_tipo,$tp_ingreso);

                // Proceso de Almacenamiento de Archivos
                ArchivosController::registrarArchivo('tb_solicitud', $nr_id, $arr_archivo, $arr_observacion);

                $arr_valida =   [
                                    'success'   =>  true,
                                    'title'     =>  'Registro de Solicitud',
                                    'msj'       =>  $str_msj . '<br> Para descargar el Ticket de Atención favor haga clic en el link de descarga 
                                                    <a target="_blank" href="'.$dominio.'/atencion_vecino/ticket/'.$nr_ticket.'" class="btn btn-sm btn-danger">Descargar</a>',
                                ];
                                
                EmailController::enviarNotificacionVecino(101, $nr_id, ''); // 101. Notificación de ingreso solicitud al vecino
                EmailController::enviarNotificaciones(50, $nr_id); // 50. Notificación de ingreso de solicitud a administrador de Atención al Vecino

                $this->log->finalizarLog($data_log,200,$arr_valida,$startTime);

                return response()->json($arr_valida, 200);
            }
            else {
                $str_msj    =   'No se ha podido registrar la solicitud, favor intente nuevamente.';
                $arr_valida =   [
                                    'error'     =>  true,
                                    'title'     =>  'Registro de Solicitud',
                                    'msj'       =>  $str_msj,
                                ];

                $this->log->finalizarLog($data_log,422,$arr_valida,$startTime);

                return response()->json($arr_valida, 422);
            }
        } catch (Exception $e) {
            $str_msj        =   'Se ha producido un problema al registrar la solicitud.';
            $arr_valida     =   [
                                    'error'     =>  true,
                                    'title'     =>  'Registro de Solicitud',
                                    'msj'       =>  $str_msj,
                                ];
            $arr_error      =   [
                                    'exception'=>$e->getMessage(),
                                    'toString'=>$e->__toString(),
                                ];

            $this->log->finalizarLog($data_log,500,$arr_valida,$startTime);

            \Log::error(__METHOD__ . " Exception : " . print_r($arr_error, true));

            return response()->json($arr_valida, 500);
        } catch (\Throwable $t) {
            $str_msj        =   'Se ha producido un error inesperado.';
            $arr_valida     =   [
                                    'error'     => true,
                                    'codigo'    => 500,
                                    'title'     => 'Error inesperado',
                                    'msj'       => $str_msj . ' - ' . $t->getMessage(),
                                ];
            $arr_error      =   [
                                    'request'   => $request->all(),
                                    'exception' => $t->getMessage(),
                                    'toString'  => $t->__toString(),
                                ];

            $this->log->finalizarLog($data_log,500,$arr_valida,$startTime);

            \Log::error(__METHOD__ . " Throwable : " . print_r($arr_error, true));

            return response()->json($arr_valida, 500);
        }
    }
    //------------------------------------------------------------
    public function detalleSolicitud(Request $request)
    {
        //-------------------------------------------------------------------------
        // Marca el tiempo de inicio
        $startTime  =    microtime(true);
        // Registro de log
        $data_log   =   $this->log->iniciarLog($request,__FUNCTION__);
        //-------------------------------------------------------------------------
        $nr_rut         =   Rut::parse($request->rut_vecino)->format(Rut::FORMAT_WITH_DASH);
        $nr_ticket      =   $request->nr_ticket;
        $arr_detalle    =   $this->getDetalle($nr_ticket, $nr_rut);
        $arr_respuestas =   $this->getRespuestas($nr_ticket, $nr_rut);
        //-------------------------------------------------------------------------
        $arr_valida     =   [
                                'info_detalle'      =>  $arr_detalle, 
                                'info_respuestas'   =>  $arr_respuestas,
                            ];
        //-------------------------------------------------------------------------
        $this->log->finalizarLog($data_log,200,$arr_valida,$startTime);
        return response()->json($arr_valida, 200);
    }
    //------------------------------------------------------------
    public function obtenerSolicitudes(Request $request)
    {
        //-------------------------------------------------------------------------
        // Marca el tiempo de inicio
        $startTime  =    microtime(true);
        // Registro de log
        $data_log   =   $this->log->iniciarLog($request,__FUNCTION__);
        //-------------------------------------------------------------------------
        $api_token  =   $request->attributes->get('api-token');
        $nr_user    =   $this->getApiUserIdToToken($api_token);
        $arr_user   =   [3]; // 3. Contact Center
        //-------------------------------------------------------------------------
        $nr_rut     =   Rut::parse($request->rut_vecino)->format(Rut::FORMAT_WITH_DASH);

        $data       =   Solicitud:: 
                        leftjoin('gsut_motivo as motivo','motivo.id','=','gsut_solicitud.id_motivo')
                        ->leftjoin('gsut_tipo as tipo','tipo.id','=','gsut_solicitud.id_tipo')
                        ->leftjoin('gsut_estado as estado','estado.id','=','gsut_solicitud.id_estado')
                        ->leftjoin('gsut_direccion as dir_destino','dir_destino.id','=','gsut_solicitud.id_direccion_destino')
                        ->leftjoin('gsut_depto as depto_destino','depto_destino.id','=','gsut_solicitud.id_depto_destino')
                        ->leftjoin('gsut_macroterritorio as mt','mt.id','=','gsut_solicitud.id_macroterritorio')
                        ->leftjoin('gsut_unidadvecinal as uv','uv.id','=','gsut_solicitud.id_unidadvecinal')
                        ->leftjoin('gsut_tipo_ingreso as ti','ti.id','=','gsut_solicitud.tp_ingreso')
                        ->leftjoin('gsut_vecino as vecino','vecino.nr_rut','=','gsut_solicitud.nr_rut_vecino')
                        ->select('gsut_solicitud.id',
                            'gsut_solicitud.id_estado',
                            'gsut_solicitud.nr_ticket',
                            'dir_destino.nm_direccion as nm_direccion_municipal',
                            'depto_destino.nm_depto as nm_depto_municipal',
                            'gsut_solicitud.nm_tipo as nm_servicio',
                            'motivo.nm_motivo',
                            'mt.cod_territorio',
                            'uv.nm_unidadvecinal',
                            'gsut_solicitud.tp_direccion',
                            'gsut_solicitud.nr_direccion',
                            'gsut_solicitud.nm_direccion',
                            'gsut_solicitud.nm_ubicacion',
                            'gsut_solicitud.str_latitud',
                            'gsut_solicitud.str_longitud',
                            'gsut_solicitud.nr_rut_vecino',
                            'gsut_solicitud.str_observacion',
                            'gsut_solicitud.str_observacion_html',
                            'gsut_solicitud.str_aclaratoria',
                            'estado.nm_color',
                            'ti.nm_ingreso',
                            'gsut_solicitud.fc_creacion as fc_ingreso',
                            'gsut_solicitud.fc_publicado')
                        ->selectRaw("(case 
                            when estado.id = 1 then 'Ingresada'
                            when estado.id = 2 then 'En Revisión'
                            when estado.id = 3 then 'En Revisión'
                            when estado.id = 4 then 'En Revisión'
                            when (estado.id = 5 && gsut_solicitud.tp_feedback_vecino = 0) then 'Cerrado sin Calificación'
                            when (estado.id = 5 && gsut_solicitud.tp_feedback_vecino = 1) then 'Cerrado con Calificación'
                            when (estado.id = 6 && gsut_solicitud.tp_feedback_vecino = 0) then 'Cerrado sin Calificación'
                            when (estado.id = 6 && gsut_solicitud.tp_feedback_vecino = 1) then 'Cerrado con Calificación'
                            when estado.id = 7 then 'Anulada'
                            when estado.id = 8 then 'Derivado'
                            when estado.id = 9 then 'Derivado'
                            when estado.id = 10 then 'Derivado'
                            end) as nm_estado") 
                        ->where('gsut_solicitud.nr_rut_vecino','=',$nr_rut)
                        ->where('gsut_solicitud.tp_activo','=',1)
                        ->with('respuestas_para_vecino')
                        ->orderBy('gsut_solicitud.fc_creacion','DESC');

        if(in_array($nr_user, $arr_user)) {
            $data   =   $data->whereIn('gsut_solicitud.id_estado',[1,2,3,4,8,9,10]);
        }

        $data   =   $data->get()->makeHidden(['id','id_estado']);

        foreach ($data as $key => $value) {
            $value->tiempo_tramitado    =   UtilController::getTiempoTramitacion($value->fc_ingreso, $value->fc_publicado, $value->id_estado);
        }
        //-------------------------------------------------------------------------
        $arr_valida     =   [
                                'arr_solicitudes'   =>  $data
                            ];
        //-------------------------------------------------------------------------
        $this->log->finalizarLog($data_log,200,$arr_valida,$startTime);
        return response()->json($arr_valida, 200);
    }
    //------------------------------------------------------------
    public function obtenerTicket(Request $request)
    {
        //-------------------------------------------------------------------------
        // Marca el tiempo de inicio
        $startTime  =    microtime(true);
        // Registro de log
        $data_log   =   $this->log->iniciarLog($request,__FUNCTION__);
        //-------------------------------------------------------------------------
        $api_token  =   $request->attributes->get('api-token');
        $nr_user    =   $this->getApiUserIdToToken($api_token);
        $arr_user   =   [3]; // 3. Contact Center
        //-------------------------------------------------------------------------
        $nr_rut     =   Rut::parse($request->rut_vecino)->format(Rut::FORMAT_WITH_DASH);

        $data       =   Solicitud:: 
                        join('gsut_estado as estado','estado.id','=','gsut_solicitud.id_estado')
                        ->select('gsut_solicitud.id',
                            'gsut_solicitud.id_estado',
                            'gsut_solicitud.nr_ticket',
                            'gsut_solicitud.nm_tipo as nm_servicio')
                        ->selectRaw("(case 
                            when estado.id = 1 then 'Ingresada'
                            when estado.id = 2 then 'En Revisión'
                            when estado.id = 3 then 'En Revisión'
                            when estado.id = 4 then 'En Revisión'
                            when (estado.id = 5 && gsut_solicitud.tp_feedback_vecino = 0) then 'Cerrado sin Calificación'
                            when (estado.id = 5 && gsut_solicitud.tp_feedback_vecino = 1) then 'Cerrado con Calificación'
                            when (estado.id = 6 && gsut_solicitud.tp_feedback_vecino = 0) then 'Cerrado sin Calificación'
                            when (estado.id = 6 && gsut_solicitud.tp_feedback_vecino = 1) then 'Cerrado con Calificación'
                            when estado.id = 7 then 'Anulada'
                            when estado.id = 8 then 'Derivado'
                            when estado.id = 9 then 'Derivado'
                            when estado.id = 10 then 'Derivado'
                            end) as nm_estado") 
                        ->where('gsut_solicitud.nr_rut_vecino','=',$nr_rut)
                        ->where('gsut_solicitud.tp_activo','=',1)
                        ->orderBy('gsut_solicitud.fc_creacion','DESC')
                        ->take(10)->get();

        $arr_cantidad   =   [
            'total_ticket'  =>  $data->count(),
            'total_ingresada'  =>  $data->whereIn('id_estado',[1])->count(),
            'total_en_revision'  =>  $data->whereIn('id_estado',[2,3,4])->count(),
            'total_cerrado_sin_calificacion'  =>  $data->whereIn('id_estado',[5,6])->where('tp_feedback_vecino',0)->count(),
            'total_cerrado_con_calificacion'  =>  $data->whereIn('id_estado',[5,6])->where('tp_feedback_vecino',1)->count(),
            'total_derivado'  =>  $data->whereIn('id_estado',[8,9,10])->count(),
        ];
        $data   =   $data->makeHidden(['id','id_estado']);
        //-------------------------------------------------------------------------
        $arr_valida     =   [
                                'arr_solicitudes'   =>  $data, 
                                'resumen_cantidad'  =>  $arr_cantidad
                            ];
        //-------------------------------------------------------------------------
        $this->log->finalizarLog($data_log,200,$arr_valida,$startTime);
        return response()->json($arr_valida, 200);
    }
    //------------------------------------------------------------
    public function registrarFeedbackVecino(Request $request)
    {
        //-------------------------------------------------------------------------
        // Marca el tiempo de inicio
        $startTime  =    microtime(true);
        // Registro de log
        $data_log   =   $this->log->iniciarLog($request,__FUNCTION__);
        //-------------------------------------------------------------------------
        $nr_rut     =   Rut::parse($request->rut_vecino)->format(Rut::FORMAT_WITH_DASH);
        $nr_ticket  =   $request->nr_ticket;
        $str_fb     =   $request->str_feedback;
        $nr_nvl     =   $request->nvl_satisfaccion;
        $fc_fecha   =   Date("Y-m-d H:i:s");
        //-------------------------------------------------------------------------
        try {
            $existe =   Solicitud::where('nr_ticket','=',$nr_ticket)->where('nr_rut_vecino','=',$nr_rut)->count();
            if($existe)
            {
                $data_ticket    =   Solicitud::where('nr_ticket','=',$nr_ticket)->where('nr_rut_vecino','=',$nr_rut)->get();
                $info_ticket    =   $data_ticket->first();

                if(($info_ticket->id_estado == 5 || $info_ticket->id_estado == 6) && $info_ticket->tp_feedback_vecino == 0) {
                    Solicitud::
                    where('nr_ticket','=',$nr_ticket)
                    ->where('nr_rut_vecino','=',$nr_rut)
                    ->update([
                        'tp_feedback_vecino'        =>  1,
                        'str_feedback_vecino'       =>  $str_fb,
                        'fc_feedback_vecino'        =>  $fc_fecha,
                        'tp_satisfaccion_vecino'    =>  $nr_nvl
                    ]);

                    $arr_valida =   [
                                        'success'   =>  true,
                                        'title'     =>  'Registro de Feedback',
                                        'msj'       =>  'Se ha registrado el Feedback correctamente',
                                    ];
                    $this->log->finalizarLog($data_log,200,$arr_valida,$startTime);
                    return response()->json($arr_valida, 200);
                } else {
                    if($info_ticket->tp_feedback_vecino == 1)
                    {
                        $arr_valida =   [
                                            'warning'   =>  true,
                                            'title'     =>  'Registro de Feedback',
                                            'msj'       =>  'No es posible registrar el feedback, ya se ha realizado una calificación al servicio',
                                        ];
                        $this->log->finalizarLog($data_log,422,$arr_valida,$startTime);
                        return response()->json($arr_valida, 422);
                    }
                    else
                    {
                        $arr_valida =   [
                                            'warning'   =>  true,
                                            'title'     =>  'Registro de Feedback',
                                            'msj'       =>  'No es posible registrar el feedback, la Solicitud debe estar con estado "cerrada"',
                                        ];
                        $this->log->finalizarLog($data_log,422,$arr_valida,$startTime);
                        return response()->json($arr_valida, 422);
                    }
                }
            }
            else 
            {
                $arr_valida =   [
                                    'warning'   =>  true,
                                    'title'     =>  'Registro de Feedback',
                                    'msj'       =>  'No se encuetra el Nro. de Solicitud #'.$nr_ticket.' para realizar el feedback',
                                ];

                $this->log->finalizarLog($data_log,404,$arr_valida,$startTime);
                return response()->json($arr_valida, 404);
            }
        } catch (Exception $e) {
            $str_msj        =   'Se ha producido un problema al registrar el feedback.';
            $arr_valida     =   [
                                    'error'     =>  true,
                                    'title'     =>  'Registro de Feedback',
                                    'msj'       =>  $str_msj,
                                ];
            $arr_error      =   [
                                    'exception'=>$e->getMessage(),
                                    'toString'=>$e->__toString(),
                                ];

            $this->log->finalizarLog($data_log,500,$arr_valida,$startTime);

            \Log::error(__METHOD__ . " Exception : " . print_r($arr_error, true));

            return response()->json($arr_valida, 500);
        }
        //-------------------------------------------------------------------------
        $this->log->finalizarLog($data_log,200,$arr_valida,$startTime);
        return response()->json($arr_valida, 200);
    }
    //------------------------------------------------------------
    public function getDetalle($nr_ticket, $nr_rut)
    {
        $data   =   Solicitud:: 
                    leftjoin('gsut_motivo as motivo','motivo.id','=','gsut_solicitud.id_motivo')
                    ->leftjoin('gsut_tipo as tipo','tipo.id','=','gsut_solicitud.id_tipo')
                    ->leftjoin('gsut_estado as estado','estado.id','=','gsut_solicitud.id_estado')
                    ->leftjoin('gsut_direccion as dir_destino','dir_destino.id','=','gsut_solicitud.id_direccion_destino')
                    ->leftjoin('gsut_depto as depto_destino','depto_destino.id','=','gsut_solicitud.id_depto_destino')
                    ->leftjoin('gsut_macroterritorio as mt','mt.id','=','gsut_solicitud.id_macroterritorio')
                    ->leftjoin('gsut_unidadvecinal as uv','uv.id','=','gsut_solicitud.id_unidadvecinal')
                    ->leftjoin('gsut_tipo_ingreso as ti','ti.id','=','gsut_solicitud.tp_ingreso')
                    ->leftjoin('gsut_vecino as vecino','vecino.nr_rut','=','gsut_solicitud.nr_rut_vecino')
                    ->select('gsut_solicitud.id',
                        'gsut_solicitud.nr_ticket',
                        'dir_destino.nm_direccion as nm_direccion_municipal',
                        'depto_destino.nm_depto as nm_depto_municipal',
                        'gsut_solicitud.nm_tipo as nm_servicio',
                        'gsut_solicitud.nm_tipo as nm_servicio',
                        'motivo.nm_motivo',
                        'mt.cod_territorio',
                        'uv.nm_unidadvecinal',
                        'gsut_solicitud.tp_direccion',
                        'gsut_solicitud.nr_direccion',
                        'gsut_solicitud.nm_direccion',
                        'gsut_solicitud.nm_ubicacion',
                        'gsut_solicitud.str_latitud',
                        'gsut_solicitud.str_longitud',
                        'gsut_solicitud.nr_rut_vecino',
                        'gsut_solicitud.str_observacion',
                        'gsut_solicitud.str_observacion_html',
                        'gsut_solicitud.str_aclaratoria',
                        'estado.nm_color',
                        'ti.nm_ingreso',
                        'gsut_solicitud.tp_feedback',
                        'gsut_solicitud.tp_recepcion',
                        'gsut_solicitud.tp_satisfaccion',
                        'gsut_solicitud.str_feedback',
                        'gsut_solicitud.tp_feedback_vecino',
                        'gsut_solicitud.fc_feedback_vecino',
                        'gsut_solicitud.tp_satisfaccion_vecino',
                        'gsut_solicitud.str_feedback_vecino',
                        'gsut_solicitud.fc_creacion as fc_ingreso',
                        'gsut_solicitud.fc_publicado',
                        DB::raw('concat(vecino.nm_vecino," ",vecino.ap_paterno," ",vecino.ap_materno) as nm_vecino'),
                        DB::raw('date_format(gsut_solicitud.fc_creacion,"%d-%m-%Y") as fc_creacion'),
                        DB::raw('date_format(gsut_solicitud.fc_creacion," %h:%i") as hr_creacion'))
                    ->selectRaw("(case 
                        when estado.id = 1 then 'Ingresada'
                        when estado.id = 2 then 'En Revisión'
                        when estado.id = 3 then 'En Revisión'
                        when estado.id = 4 then 'En Revisión'
                        when (estado.id = 5 && gsut_solicitud.tp_feedback_vecino = 0) then 'Cerrado sin Calificación'
                        when (estado.id = 5 && gsut_solicitud.tp_feedback_vecino = 1) then 'Cerrado con Calificación'
                        when (estado.id = 6 && gsut_solicitud.tp_feedback_vecino = 0) then 'Cerrado sin Calificación'
                        when (estado.id = 6 && gsut_solicitud.tp_feedback_vecino = 1) then 'Cerrado con Calificación'
                        when estado.id = 7 then 'Anulada'
                        when estado.id = 8 then 'Derivado'
                        when estado.id = 9 then 'Derivado'
                        when estado.id = 10 then 'Derivado'
                        end) as nm_estado") 
                    ->where('gsut_solicitud.nr_ticket','=',$nr_ticket)
                    ->where('gsut_solicitud.nr_rut_vecino','=',$nr_rut)
                    ->where('gsut_solicitud.tp_activo','=',1)
                    ->with(['archivos' => function ($query) {
                        $query->select('nr_id','nm_archivo','str_observacion','str_archivo','ext_archivo');
                    }])
                    ->orderBy('gsut_solicitud.fc_creacion','DESC')
                    ->get()->makeHidden('id');

        return  $data;
    }
    //------------------------------------------------------------
    public function getRespuestas($nr_ticket, $nr_rut)
    {
        $data   =   Respuesta::
                    join('users as autor','autor.id','=','gsut_respuesta.id_autor')
                    ->join('gsut_direccion as dir','dir.id','=','autor.id_direccion')
                    ->join('gsut_depto as depto','depto.id','=','autor.id_depto')
                    ->select('gsut_respuesta.id',
                        'gsut_respuesta.fc_ingreso',                        
                        'depto.nm_depto',
                        'dir.nm_direccion',
                        DB::raw('concat(autor.nombre, autor.ap_paterno) as nm_autor'),
                        'gsut_respuesta.str_observacion',
                        'gsut_respuesta.str_observacion_html',
                        'gsut_respuesta.tp_respuesta',
                        DB::raw('date_format(gsut_respuesta.fc_ingreso,"%d-%m-%Y %H:%i") as fc_ingreso'),
                        DB::raw('(case 
                            when gsut_respuesta.tp_respuesta = 1 then "Publicación Definitiva" 
                            when gsut_respuesta.tp_respuesta = 2 then "Publicación Parcial" 
                            when gsut_respuesta.tp_respuesta = 3 then "Pre-Publicación Definitiva" 
                            when gsut_respuesta.tp_respuesta = 4 then "Pre-Publicación Parcial" 
                            when gsut_respuesta.tp_respuesta = 5 then "Pre-Publicación Definitiva Rechazada" 
                            when gsut_respuesta.tp_respuesta = 6 then "Pre-Publicación Parcial Rechazada" 
                            when gsut_respuesta.tp_respuesta = 7 then "Expediente" 
                            when gsut_respuesta.tp_respuesta = 8 then "VB Jefatura" 
                            when gsut_respuesta.tp_respuesta = 9 then "VB Director" 
                            when gsut_respuesta.tp_respuesta = 10 then "Rechazo VB Jefatura"  
                            when gsut_respuesta.tp_respuesta = 11 then "Rechazo VB Director"  
                            when gsut_respuesta.tp_respuesta = 12 then "Respuesta Automática Enviada"  
                            when gsut_respuesta.tp_respuesta = 13 then "Respuesta Automática Fallida"  
                            else "Respuesta Interna" end) as nm_respuesta'))
                    ->whereExists(function ($query) use ($nr_ticket, $nr_rut) {
                        $query->select(DB::raw(1))
                            ->from('gsut_solicitud')
                            ->whereRaw('gsut_solicitud.id = gsut_respuesta.id_solicitud')
                            ->whereRaw('gsut_solicitud.tp_activo = 1')
                            ->where('gsut_solicitud.nr_ticket','=',$nr_ticket)
                            ->where('gsut_solicitud.nr_rut_vecino','=',$nr_rut);
                    })
                    ->orderBy('gsut_respuesta.created_at','asc')
                    ->whereIn('gsut_respuesta.tp_respuesta',[1,2])
                    ->where('gsut_respuesta.tp_activo','=',1)
                    ->with(['archivos' => function ($query) {
                        $query->select('nr_id','nm_archivo','str_observacion','str_archivo','ext_archivo');
                    }])
                    ->get()
                    ->makeHidden('id');

        return $data;
    }
    //------------------------------------------------------------
    public function getSolicitudesActivas(Request $request)
    {
        set_time_limit(60);
        $tipo_id                = $request->input('tipo_id',0);
        $nr_ticket              = $request->input('nr_ticket',0);
        $fecha_desde            = $request->fecha_desde;
        $fecha_hasta            = $request->fecha_hasta;
        $id_direccion_destino   = $request->input('id_direccion_destino',0);
        $id_depto_destino       = $request->input('id_depto_destino',0);
        $id_motivo              = $request->input('id_motivo',0);
        $id_unidad_vecinal      = $request->id_unidad_vecinal;
        $nr_rut_vecino          = $request->input('nr_rut_vecino','');
        //-------------------------------------------------------------------------
        // return $request->all();
        //-------------------------------------------------------------------------
        // Marca el tiempo de inicio
        $startTime  =    microtime(true);
        // Registro de log
        $data_log   =   $this->log->iniciarLog($request,__FUNCTION__);
        //-------------------------------------------------------------------------
        try {
            $data       =   Solicitud:: 
                            leftjoin('gsut_motivo as motivo','motivo.id','=','gsut_solicitud.id_motivo')
                            ->leftjoin('gsut_tipo as tipo','tipo.id','=','gsut_solicitud.id_tipo')
                            ->leftjoin('gsut_estado as estado','estado.id','=','gsut_solicitud.id_estado')
                            ->leftjoin('gsut_direccion as dir_destino','dir_destino.id','=','gsut_solicitud.id_direccion_destino')
                            ->leftjoin('gsut_depto as depto_destino','depto_destino.id','=','gsut_solicitud.id_depto_destino')
                            ->leftjoin('gsut_macroterritorio as mt','mt.id','=','gsut_solicitud.id_macroterritorio')
                            ->leftjoin('gsut_unidadvecinal as uv','uv.id','=','gsut_solicitud.id_unidadvecinal')
                            ->leftjoin('gsut_tipo_ingreso as ti','ti.id','=','gsut_solicitud.tp_ingreso')
                            ->leftjoin('gsut_vecino as vecino','vecino.nr_rut','=','gsut_solicitud.nr_rut_vecino')
                            ->select('gsut_solicitud.id',
                                'gsut_solicitud.id_estado',
                                'gsut_solicitud.nr_ticket',
                                'gsut_solicitud.id_direccion_destino',
                                'gsut_solicitud.id_depto_destino',
                                'dir_destino.nm_direccion as nm_direccion_municipal',
                                'depto_destino.nm_depto as nm_depto_municipal',
                                'gsut_solicitud.nm_tipo as nm_servicio',
                                'motivo.nm_motivo',
                                'motivo.id as id_motivo',
                                'tipo.id as id_tipo',
                                'mt.cod_territorio',
                                'uv.nm_unidadvecinal',
                                'uv.id as id_unidadvecinal',
                                'gsut_solicitud.tp_direccion',
                                'gsut_solicitud.nr_direccion',
                                'gsut_solicitud.nm_direccion',
                                'gsut_solicitud.nm_ubicacion',
                                'gsut_solicitud.str_latitud as lat',
                                'gsut_solicitud.str_longitud as lng',
                                'gsut_solicitud.nr_rut_vecino',
                                'gsut_solicitud.str_observacion',
                                'gsut_solicitud.str_observacion_html',
                                'gsut_solicitud.str_aclaratoria',
                                'estado.nm_color',
                                'ti.nm_ingreso',
                                'gsut_solicitud.fc_creacion as fc_ingreso',
                                'gsut_solicitud.fc_publicado')
                            ->selectRaw("(case 
                                when estado.id = 1 then 'Ingresada'
                                when estado.id = 2 then 'En Revisión'
                                when estado.id = 3 then 'En Revisión'
                                when estado.id = 4 then 'En Revisión'
                                when (estado.id = 5 && gsut_solicitud.tp_feedback_vecino = 0) then 'Cerrado sin Calificación'
                                when (estado.id = 5 && gsut_solicitud.tp_feedback_vecino = 1) then 'Cerrado con Calificación'
                                when (estado.id = 6 && gsut_solicitud.tp_feedback_vecino = 0) then 'Cerrado sin Calificación'
                                when (estado.id = 6 && gsut_solicitud.tp_feedback_vecino = 1) then 'Cerrado con Calificación'
                                when estado.id = 7 then 'Anulada'
                                when estado.id = 8 then 'Derivado'
                                when estado.id = 9 then 'Derivado'
                                when estado.id = 10 then 'Derivado'
                                end) as nm_estado") 
                            ->with('archivos')
                            ->where('gsut_solicitud.tp_activo','=',1)
                            ->whereIn('gsut_solicitud.id_estado',[1,2,3,4]);
            //-------------------------------------------------------------------------
                if($tipo_id != 0)
                    $data = $data->where('tipo.id','=',$tipo_id);
                
                if($nr_ticket != 0)
                    $data = $data->where('gsut_solicitud.nr_ticket','=',$nr_ticket);

                if($fecha_desde) 
                    $data = $data->whereDate('gsut_solicitud.fc_creacion', '>=', $fecha_desde);
            
                if($fecha_hasta) 
                    $data = $data->whereDate('gsut_solicitud.fc_creacion', '<=', $fecha_hasta);

                if($id_direccion_destino != 0)
                    $data = $data->where('gsut_solicitud.id_direccion_destino','=',$id_direccion_destino);

                if($id_depto_destino != 0)
                    $data = $data->where('gsut_solicitud.id_depto_destino','=',$id_depto_destino);

                if($id_motivo != 0)
                    $data = $data->where('gsut_solicitud.id_motivo','=',$id_motivo);

                if($id_unidad_vecinal)
                    $data = $data->where('gsut_solicitud.id_unidadvecinal','=',$id_unidad_vecinal);

                if($nr_rut_vecino) 
                    $data = $data->where('gsut_solicitud.nr_rut_vecino', 'LIKE', "%{$nr_rut_vecino}%");
            //-------------------------------------------------------------------------
            $data = $data->get();
            //-------------------------------------------------------------------------
            foreach ($data as $key => $value) 
            {
                $value->tiempo_tramitado    = UtilController::getTiempoTramitacion($value->fc_ingreso, $value->fc_publicado, $value->id_estado);
                $value->lat                 = str_replace(',', '.', $value->lat);
                $value->lng                 = str_replace(',', '.', $value->lng);

                switch ($value->id_motivo) {
                    case '1':
                        $value->icono               = '/images/ubicaciones/atencion_vecino_informacion.png';
                    break;

                    case '2':
                        $value->icono               = '/images/ubicaciones/atencion_vecino_reclamo.png';
                    break;

                    case '3':
                        $value->icono               = '/images/ubicaciones/atencion_vecino_sugerencia.png';
                    break;

                    case '4':
                        $value->icono               = '/images/ubicaciones/atencion_vecino_felicitacion.png';
                    break;

                    case '5':
                        $value->icono               = '/images/ubicaciones/atencion_vecino_solicitud.png';
                    break;

                    case '6':
                        $value->icono               = '/images/ubicaciones/atencion_vecino_denuncia.png';
                    break;
                    
                    default:
                        $value->icono               = '/images/ubicaciones/atencion_vecino.png';
                    break;
                }
            }
            //-------------------------------------------------------------------------
            $arr_valida     =   ['arr_solicitudes'   =>  $data->toArray()];
            //-------------------------------------------------------------------------
            $this->log->finalizarLog($data_log,200,null,$startTime);
            //-------------------------------------------------------------------------
        } catch (Exception $e) {
            $str_msj        =   'Se ha producido un problema al obtener los registros de Solicitudes Activas.';
            $arr_valida     =   [
                                    'error'     =>  true,
                                    'title'     =>  'Solicitudes Activas',
                                    'msj'       =>  $str_msj,
                                ];
            $arr_error      =   [
                                    'exception'=>$e->getMessage(),
                                    'toString'=>$e->__toString(),
                                ];

            $this->log->finalizarLog($data_log,500,$arr_valida,$startTime);

            \Log::error(__METHOD__ . " Exception : " . print_r($arr_error, true));

            return response()->json($arr_valida, 500);
        }
            
        return response()->json($arr_valida, 200);
    }
    //------------------------------------------------------------
    private function validarDatosStoreSolicitud(Request $request)
    {
        // dd(['request' => $request->all()]);

        // Datos recibidos del header
        $api_token          =   $request->header('api-token');
        $app_token          =   $request->header('app-token');
        $nr_rut             =   UtilController::getDataTokenApp($app_token);
        // campos que contienen JSON codificado
        $arr_solicitud      =   [];
        $arr_vecino         =   [];
        $errors             =   new MessageBag();
        // Campos de Validación de Ubicación del Vecino
        $vecinoMessages     =   [];
        $vecinoRules        =   [];
        $vecinoAttributes   =   [];
        // campos de resultado de validaciones 
        $tp_validar         =   false;
        $validatorRequest   =   null;
        $validatorLocation  =   null;
        $validatorVecino    =   null;
        $validatorSpecial   =   null;
        $validatorArchivo   =   null;
        // --------------------------------------------------------------
        /*
        dd([
            'api-token'     =>  $api_token,
            'app-token'     =>  $app_token,
            'rut_vecino'    =>  $nr_rut,
        ]);
        */
        // --------------------------------------------------------------
        if($nr_rut == null && !isset($request->rut_vecino))
        {
            return response()->json([
                'error'     =>  true,
                'title'     =>  'Validar Datos',
                'msj'       =>  'app-token no es valido. <br><br>',
                'validar'   =>  $errors
            ], 400);
        }
        $request['rut_vecino']  =   ($nr_rut) ? $nr_rut : $request->rut_vecino;
        // --------------------------------------------------------------
        //  Mensajes Generales
        $generalMessages    =       [
            'required'              =>  'El campo :attribute es requerido.',
            'numeric'               =>  'El campo :attribute debe ser númerico.',
            'size'                  =>  'El campo :attribute debe tener :size caracteres',
            'required_if'           =>  'El campo :attribute es requerido.',
            'required_unless'       =>  'El campo :attribute es requerido',
        ];
        //  Atributos Generales
        $generalAttributes  =       [
            'rut_vecino'            =>  'Rut',
            'nm_vecino'             =>  'Nombre',
            'ap_paterno'            =>  'Primer Apellido',
            'ap_materno'            =>  'Segundo Apellido',
            'nm_mail'               =>  'Correo',
            'pre_fijo'              =>  'Prefijo Teléfono',
            'nr_telefono'           =>  'Número Teléfono',
            'nr_region'             =>  'Región',
            'nr_comuna'             =>  'Comuna',
            // 'tp_comuna'             =>  '',
            'tp_ubicacion_vecino'   =>  'Tipo de Ubicación',
            'nr_motivo'             =>  'Tipo de Requerimiento',
            'nr_dir_municipal'      =>  'Dirección Municipal',
            'nr_depto'              =>  'Depto. Municipal',
            'nr_tipo'               =>  'Tipo de Servicio',
            'tp_ubicacion'          =>  'Servicio Requiere Ubicación',
            'tp_ingreso'            =>  'Tipo de Ingreso',
            'nm_ubicacion_vecino'   =>  'Dirección del Vecino',
        ];
        // Reglas Generales 
        $generalRules       =       [
            'rut_vecino'            =>  'required|cl_rut',
            'nr_motivo'             =>  'required|numeric|min:1',
            'nr_dir_municipal'      =>  'required|numeric|min:1',
            'nr_depto'              =>  'required|numeric|min:1',
            'nr_tipo'               =>  'required|numeric|min:1',
            'tp_ubicacion'          =>  'required|numeric',
            'str_observacion'       =>  'required|string|min:10',
            'str_observacion_html'  =>  'required|string|min:10',
            'tp_ingreso'            =>  'required|numeric',
        ];
        //  Reglas del Vecino
        $specialRules       =       [
            'rut_vecino'            =>  'required|cl_rut',
            'nm_vecino'             =>  'required|string|min:2',
            'ap_paterno'            =>  'required|string|min:2',
            'ap_materno'            =>  'required|string|min:2',
            'nm_mail'               =>  'required|string',
            'pre_fijo'              =>  'required|string|min:3',
            'nr_telefono'           =>  'required|string|size:8',          
            'tp_ubicacion_vecino'   =>  'required|numeric|min:1',
            // 'tp_comuna'             =>  'required|numeric',
            'nr_region'             =>  'required|numeric|min:1',
            'nr_comuna'             =>  'required|numeric|min:1',
            'nm_ubicacion_vecino'   =>  'required_unless:nr_comuna,=,271|string|min:5',
        ];
        // 'nr_rut.exists'=>'El Rut ingresado no esta Afiliado al Sistema de Bienestar.'
        // --------------------------------------------------------------
        try {
            if($request->rut_vecino)
            {
                //  Decodificar Json - Ubicación del Vecino
                if (is_string($request['arr_ubicacion_vecino'])) 
                {
                    $arr_vecino     =   [
                                            'nr_comuna'                 =>  $request->nr_comuna, 
                                            'arr_ubicacion_vecino'      =>  json_decode($request['arr_ubicacion_vecino'], true),
                                        ];
                }
                //  Valida si el vecino es de la comuna Las Condes
                if($request->nr_comuna == 271 && count($arr_vecino) == 0)
                {
                    $vecinoAttributes   +=  [
                                                'rut_vecino'                    =>  'Rut',
                                                "arr_ubicacion_vecino"          =>  'Dirección del Vecino',
                                            ];
                    $vecinoMessages     +=  [
                                                "arr_ubicacion_vecino.min"      =>  'La Dirección del Vecino es requerida',
                                            ];
                    $vecinoRules        +=  [
                                                'rut_vecino'                    =>  'required|cl_rut',
                                                "arr_ubicacion_vecino"          =>  'required|present|array|min:1|max:1',
                                            ];

                    foreach ($arr_vecino['arr_ubicacion_vecino'] as $index => $value) {
                        // dd(['paso'=>'forech arr_ubicacion_vecino', 'arr_ubicacion_vecino' => $arr_solicitud]);

                        $vecinoAttributes   +=  [
                            "arr_ubicacion_vecino"                              =>  'Dirección del Vecino',
                            "arr_ubicacion_vecino.$index.value"                 =>  'Código Ubicación',
                            "arr_ubicacion_vecino.$index.label"                 =>  'Dirección Ubicación',
                            "arr_ubicacion_vecino.$index.nr_calle"              =>  'Numeración Ubicación',
                            "arr_ubicacion_vecino.$index.nm_calle"              =>  'Nombre Ubicación',
                            "arr_ubicacion_vecino.$index.str_latitud"           =>  'Latitud',
                            "arr_ubicacion_vecino.$index.str_longitud"          =>  'Longitud',
                            "arr_ubicacion_vecino.$index.cod_territorial"       =>  'Código Macrozona',
                            "arr_ubicacion_vecino.$index.cod_unidadvecinal"     =>  'Código Unidad Vecinal',
                        ];
                        $vecinoMessages     +=  [
                            "arr_ubicacion_vecino.min"                          =>  'La Dirección del Vecino es requerida',
                            "arr_ubicacion_vecino.$index.value.min"             =>  'El :attribute es requerido',
                            "arr_ubicacion_vecino.$index.label"                 =>  'La :attribute es requerida',
                            "arr_ubicacion_vecino.$index.nr_calle"              =>  'La :attribute es requerida',
                            "arr_ubicacion_vecino.$index.nm_calle"              =>  'El :attribute es requerido',
                            "arr_ubicacion_vecino.$index.str_latitud"           =>  'La :attribute es requerida',
                            "arr_ubicacion_vecino.$index.str_longitud"          =>  'La :attribute es requerida',
                            "arr_ubicacion_vecino.$index.cod_territorial"       =>  'La :attribute es requerida',
                            "arr_ubicacion_vecino.$index.cod_unidadvecinal"     =>  'La :attribute es requerida',
                        ];
                        $vecinoRules        +=  [
                            "arr_ubicacion_vecino"                              =>  'required_if:nr_comuna,==,271|present|array|min:1|max:1',
                            "arr_ubicacion_vecino.$index.value"                 =>  'required_if:nr_comuna,==,271|numeric|min:1',
                            "arr_ubicacion_vecino.$index.label"                 =>  'required_if:nr_comuna,==,271|string|min:3',
                            "arr_ubicacion_vecino.$index.nr_calle"              =>  'required_if:nr_comuna,==,271|numeric',
                            "arr_ubicacion_vecino.$index.nm_calle"              =>  'required_if:nr_comuna,==,271|string|min:3',
                            "arr_ubicacion_vecino.$index.str_latitud"           =>  'required_if:nr_comuna,==,271|string',
                            "arr_ubicacion_vecino.$index.str_longitud"          =>  'required_if:nr_comuna,==,271|string',
                            "arr_ubicacion_vecino.$index.cod_territorial"       =>  'required_if:nr_comuna,==,271|string',
                            "arr_ubicacion_vecino.$index.cod_unidadvecinal"     =>  'required_if:nr_comuna,==,271|string',
                        ];
                    }
                }

                $validatorVecino    =   Validator::make($arr_vecino, $vecinoRules, $vecinoMessages, $vecinoAttributes);

                if(Rut::parse($request->rut_vecino)->quiet()->validate())
                {
                    if(UtilController::getVecino($request->rut_vecino)->first() == null)
                    {
                        $validatorSpecial   =   Validator::make($request->all(), $specialRules, $generalMessages, $generalAttributes);
                        // $validatorVecino->errors()->merge($validatorSpecial->errors());
                    }

                    /*
                    foreach ($specialRules as $field => $rule) {
                        $validatorVecino->sometimes($field, $rule, function ($input) {
                            return !Vecino::where('nr_rut', $input->rut_vecino)->exists();
                        });
                    }
                    */
                }

                // dd(['request' => $request->all(), 'validatorVecino_fails' => $validatorVecino->fails(), 'validatorVecino_passes' => $validatorVecino->passes(), 'validatorVecino_errors' => $validatorVecino->errors()]);
            }
        } catch (Exception $e) {
            $str_msj        =   'Se ha producido una exception.';
            $arr_valida     =   [
                                    'error'     => true,
                                    'title'     => 'exception',
                                    'msj'       => $str_msj . ' - ' . $e->getMessage(),
                                    'validar'   => null,
                                ];
            $arr_error      =   [
                                    'request'   => $request->all(),
                                    'exception' => $e->getMessage(),
                                    'toString'  => $e->__toString(),
                                ];

            \Log::error(__METHOD__ . " Throwable : " . print_r($arr_error, true));

            return response()->json($arr_valida, 500);
        } catch (\Throwable $t) {
            $str_msj        =   'Se ha producido un error inesperado.';
            $arr_valida     =   [
                                    'error'     => true,
                                    'title'     => 'Error inesperado',
                                    'msj'       => $str_msj . ' - ' . $t->getMessage(),
                                    'validar'   => null,
                                ];
            $arr_error      =   [
                                    'request'   => $request->all(),
                                    'exception' => $t->getMessage(),
                                    'toString'  => $t->__toString(),
                                ];

            \Log::error(__METHOD__ . " Throwable : " . print_r($arr_error, true));

            return response()->json($arr_valida, 500);
        }
            
        // --------------------------------------------------------------
        //  Decodificar Json - Ubicación del Requerimiento
        if (is_string($request['arr_direccion_solicitud'])) 
        {
            $arr_solicitud  =   [
                                    'tp_ubicacion'               =>  $request->tp_ubicacion, 
                                    'arr_direccion_solicitud'    =>  json_decode($request['arr_direccion_solicitud'], true),
                                ];
        }        

        if (json_last_error() !== JSON_ERROR_NONE) {
            return response()->json([
                'error' => true,
                'title' => 'Error de JSON',
                'msj' => 'Datos JSON inválidos.',
            ], 400);
        }

        $validatorRequest   =   Validator::make($request->all(), $generalRules, $generalMessages, $generalAttributes);
        // dd(['request' => $request->all(), 'validatorRequest' => $validatorRequest->errors()]);

        // Validación de Archivos Adjuntos
        $archivoMessages   =   [];
        $archivoRules      =   [];
        $archivoAttributes =   [];

        if($request->arr_archivo)
        {
            $totalSize      =   0;
            $maxSize        =   (2 * 1024 * 1024); // 20 MB en bytes
            $arr_ext        =   ['jpeg','jpg','png','doc','docx','xls','xlsx','ppt','pptx','pdf','dwg','dgn','rar','zip'];
            $arr_archivos   =   $request->arr_archivo;

            foreach ($arr_archivos as $index => $file) {
                if ($file->getError() != UPLOAD_ERR_OK) {
                    $archivoMessages["arr_archivo.$index"]  =   'Error al cargar el archivo: ' . $file->getClientOriginalName();
                }
                else {
                    $file_ext   =   $file->getClientOriginalExtension();
                    if(!in_array($file_ext, $arr_ext))
                    {
                        $file_nombre        =   $file->getClientOriginalName();
                        $archivoMessages    +=  ["arr_archivo.$index" => 'El archivo ['.$file_nombre.'] no es admitido, debe ser de tipo [jpeg, jpg, png, doc, docx, xls, xlsx, ppt, pptx, pdf, dwg, dgn, rar, zip] '];
                    }

                    $totalSize = $totalSize + $file->getSize();
                }
            }

            if ($totalSize > $maxSize)
                $archivoMessages['arr_archivo'] = 'La suma total del tamaño de los archivos excede el límite de 2 MB.';

            $validatorArchivo   =   (count($archivoMessages)) ? true : false;

            // dd(['archivoMessages' => $archivoMessages]);
        }

        // Validación de Ubicación de la Solicitud
        $locationMessages   =   [];
        $locationRules      =   [];
        $locationAttributes =   [];

        try {
            if($request['tp_ubicacion'] == 1 && count($arr_solicitud) == 0)
            {
                $locationAttributes +=  [
                    "arr_direccion_solicitud"                               =>  'Dirección del Requerimiento',
                ];
                $locationMessages   +=  [
                    "arr_direccion_solicitud.min"                           =>  'La :attribute es requerida',
                ];
                $locationRules      +=  [
                    "arr_direccion_solicitud"                               =>  'required_if:tp_ubicacion,==,1|present|array|min:1|max:1',
                ];
            }
            else
            {
                foreach ($arr_solicitud['arr_direccion_solicitud'] as $index => $value) {
                    // dd(['paso'=>'forech arr_solicitud', 'arr_solicitud' => $arr_solicitud, 'key' => $index, 'value' => $value]);
                    $locationAttributes +=  [
                        "arr_direccion_solicitud"                           =>  'Dirección del Requerimiento',
                        "arr_direccion_solicitud.$index.value"              =>  'Código Ubicación',
                        "arr_direccion_solicitud.$index.label"              =>  'Dirección Ubicación',
                        "arr_direccion_solicitud.$index.nr_calle"           =>  'Numeración Ubicación',
                        "arr_direccion_solicitud.$index.nm_calle"           =>  'Nombre Ubicación',
                        "arr_direccion_solicitud.$index.str_latitud"        =>  'Latitud',
                        "arr_direccion_solicitud.$index.str_longitud"       =>  'Longitud',
                        "arr_direccion_solicitud.$index.cod_territorial"    =>  'Código Macrozona',
                        "arr_direccion_solicitud.$index.cod_unidadvecinal"  =>  'Código Unidad Vecinal',
                    ];
                    $locationMessages   +=  [
                        "arr_direccion_solicitud.min"                       =>  'La :attribute es requerida',
                        "arr_direccion_solicitud.$index.value.min"          =>  'El :attribute es requerido',
                        "arr_direccion_solicitud.$index.label"              =>  'La :attribute es requerida',
                        "arr_direccion_solicitud.$index.nr_calle"           =>  'La :attribute es requerida',
                        "arr_direccion_solicitud.$index.nm_calle"           =>  'El :attribute es requerido',
                        "arr_direccion_solicitud.$index.str_latitud"        =>  'La :attribute es requerida',
                        "arr_direccion_solicitud.$index.str_longitud"       =>  'La :attribute es requerida',
                        "arr_direccion_solicitud.$index.cod_territorial"    =>  'El :attribute es requerido',
                        "arr_direccion_solicitud.$index.cod_unidadvecinal"  =>  'El :attribute es requerido',
                    ];
                    $locationRules  +=  [
                        "arr_direccion_solicitud"                           =>  'required_if:tp_ubicacion,==,1|present|array|min:1|max:1',
                        "arr_direccion_solicitud.$index.value"              =>  'required_if:tp_ubicacion,==,1|numeric|min:1',
                        "arr_direccion_solicitud.$index.label"              =>  'required_if:tp_ubicacion,==,1|string|min:3',
                        "arr_direccion_solicitud.$index.nr_calle"           =>  'required_if:tp_ubicacion,==,1|numeric',
                        "arr_direccion_solicitud.$index.nm_calle"           =>  'required_if:tp_ubicacion,==,1|string|min:3',
                        "arr_direccion_solicitud.$index.str_latitud"        =>  'required_if:tp_ubicacion,==,1|string',
                        "arr_direccion_solicitud.$index.str_longitud"       =>  'required_if:tp_ubicacion,==,1|string',
                        "arr_direccion_solicitud.$index.cod_territorial"    =>  'required_if:tp_ubicacion,==,1|string',
                        "arr_direccion_solicitud.$index.cod_unidadvecinal"  =>  'required_if:tp_ubicacion,==,1|string',
                    ];
                }
            }
        } catch (Exception $e) {
            $str_msj        =   'Se ha producido una exception.';
            $arr_valida     =   [
                                    'error'     => true,
                                    'title'     => 'exception',
                                    'msj'       => $str_msj . ' - ' . $e->getMessage(),
                                    'validar'   => null,
                                ];
            $arr_error      =   [
                                    'request'   => $request->all(),
                                    'exception' => $e->getMessage(),
                                    'toString'  => $e->__toString(),
                                ];

            \Log::error(__METHOD__ . " Throwable : " . print_r($arr_error, true));

            return response()->json($arr_valida, 500);
        } catch (\Throwable $t) {
            $str_msj        =   'Se ha producido un error inesperado.';
            $arr_valida     =   [
                                    'error'     => true,
                                    'title'     => 'Error inesperado',
                                    'msj'       => $str_msj . ' - ' . $t->getMessage(),
                                    'validar'   => null,
                                ];
            $arr_error      =   [
                                    'request'   => $request->all(),
                                    'exception' => $t->getMessage(),
                                    'toString'  => $t->__toString(),
                                ];

            \Log::error(__METHOD__ . " Throwable : " . print_r($arr_error, true));

            return response()->json($arr_valida, 500);
        }

        $validatorLocation  =   Validator::make($arr_solicitud, $locationRules, $locationMessages, $locationAttributes);
        // dd(['validatorLocation' => $validatorLocation->errors()]);

        if(isset($validatorRequest))
        {
            $tp_validar     =   ($tp_validar || $validatorRequest->fails()) ? true : false;
            // $errors         =   $validatorRequest->errors();

            if (!isset($errors)) {
                $errors     =   $validatorRequest->errors();
            } else {
                $errors     =   $errors->merge($validatorRequest->errors());
            }
        }
        if(isset($validatorLocation))
        {
            $tp_validar     =   ($tp_validar || $validatorLocation->fails()) ? true : false;
            // $errors         =   $validatorRequest->errors()->merge($validatorLocation->errors());

            if (!isset($errors)) {
                $errors     =   $validatorLocation->errors();
            } else {
                $errors     =   $errors->merge($validatorLocation->errors());
            }
        }
        if(isset($validatorVecino))
        {
            $tp_validar     =   ($tp_validar || $validatorVecino->fails()) ? true : false;
            // $errors         =   $validatorRequest->errors()->merge($validatorVecino->errors());

            if (!isset($errors)) {
                $errors     =   $validatorVecino->errors();
            } else {
                $errors     =   $errors->merge($validatorVecino->errors());
            }
        }
        if(isset($validatorSpecial))
        {
            $tp_validar     =   ($tp_validar || $validatorSpecial->fails()) ? true : false;
            // $errors         =   $validatorRequest->errors()->merge($validatorSpecial->errors());

            if (!isset($errors)) {
                $errors     =   $validatorSpecial->errors();
            } else {
                $errors     =   $errors->merge($validatorSpecial->errors());
            }
        }
        if(isset($validatorArchivo))
        {
            $tp_validar     =   ($tp_validar || $validatorArchivo) ? true : false;
            // $errors         =   $validatorRequest->errors()->merge($archivoMessages);

            if (!isset($errors)) {
                $errors     =   $validatorVecino->errors();
            } else {
                $errors     =   $errors->merge($archivoMessages);
            }
        }

        // dd(['tp_validar' => $tp_validar, 'validatorRequest' => $validatorRequest->fails(), 'errors' => $errors]);

        if ($tp_validar) {
            return response()->json([
                'error'     =>  true,
                'title'     =>  'Validar Datos',
                'msj'       =>  'Favor revisar los datos faltantes. <br><br>' . 
                                'Si requiere ayuda para ingresar su requerimiento favor comunicarse al <strong>Fono Ayuda: 22 950 7800</strong>',
                'validar'   =>  $errors
            ], 400);
        }

        // dd(['validator'=>$errors]);

        return false;
    }
    //------------------------------------------------------------
    private function validarDatosDetailSolicitud(Request $request)
    {
        // --------------------------------------------------------------
        // dd(['request'=>$request]);
        // --------------------------------------------------------------
        $app_token          =   $request->header('app-token');
        $nr_ticket          =   $request->nr_ticket;
        $nr_rut             =   UtilController::getDataTokenApp($app_token);
        $errors             =   [];
        // --------------------------------------------------------------
        // Valida app-token
        if($nr_rut == null && !isset($request->rut_vecino))
        {
            return response()->json([
                'error'     =>  true,
                'title'     =>  'Validar Datos',
                'msj'       =>  'app-token no es valido.',
            ], 400);
        }
        $request['rut_vecino']  =   ($nr_rut) ? $nr_rut : $request->rut_vecino;
        // --------------------------------------------------------------
        //  Mensajes Generales
        $generalMessages    =       [
            'required'              =>  'El campo :attribute es requerido.',
            'numeric'               =>  'El campo :attribute debe ser númerico.',
        ];
        //  Atributos Generales
        $generalAttributes  =       [
            'rut_vecino'            =>  'Rut',
            'nr_ticket'             =>  'Nro. Ticket',
        ];
        // Reglas Generales 
        $generalRules       =       [
            'rut_vecino'            =>  'required|cl_rut',
            'nr_ticket'             =>  'required|numeric|min:1',
        ];
        // --------------------------------------------------------------
        $validatorData      =   Validator::make($request->all(), $generalRules, $generalMessages, $generalAttributes);

        if ($validatorData->fails()) {
            return response()->json([
                'error'     =>  true,
                'title'     =>  'Validar Datos',
                'msj'       =>  'Favor revisar los datos faltantes.',
                'validar'   =>  $validatorData->errors(),
            ], 400);
        }

        return  false;
    }
    //------------------------------------------------------------
    private function validarDatosGetSolicitudes(Request $request)
    {
        // --------------------------------------------------------------
        // dd(['request'=>$request]);
        // --------------------------------------------------------------
        $app_token          =   $request->header('app-token');
        $nr_rut             =   UtilController::getDataTokenApp($app_token);
        $errors             =   [];
        // --------------------------------------------------------------
        // Valida app-token
        if($nr_rut == null && !isset($request->rut_vecino))
        {
            return response()->json([
                'error'     =>  true,
                'title'     =>  'Validar Datos',
                'msj'       =>  'app-token no es valido.',
            ], 400);
        }
        $request['rut_vecino']  =   ($nr_rut) ? $nr_rut : $request->rut_vecino;
        // --------------------------------------------------------------
        //  Mensajes Generales
        $generalMessages    =       [
            'required'              =>  'El campo :attribute es requerido.',
            'numeric'               =>  'El campo :attribute debe ser númerico.',
        ];
        //  Atributos Generales
        $generalAttributes  =       [
            'rut_vecino'            =>  'Rut',
        ];
        // Reglas Generales 
        $generalRules       =       [
            'rut_vecino'            =>  'required|cl_rut',
        ];
        // --------------------------------------------------------------
        $validatorData      =   Validator::make($request->all(), $generalRules, $generalMessages, $generalAttributes);

        if ($validatorData->fails()) {
            return response()->json([
                'error'     =>  true,
                'title'     =>  'Validar Datos',
                'msj'       =>  'Favor revisar los datos faltantes.',
                'validar'   =>  $validatorData->errors(),
            ], 400);
        }

        return  false;
    }
    //------------------------------------------------------------
    private function validarDatosGetTicket(Request $request)
    {
        // --------------------------------------------------------------
        // dd(['request'=>$request]);
        // --------------------------------------------------------------
        $app_token          =   $request->header('app-token');
        $nr_rut             =   UtilController::getDataTokenApp($app_token);
        $errors             =   [];
        // --------------------------------------------------------------
        // Valida app-token
        if($nr_rut == null && !isset($request->rut_vecino))
        {
            return response()->json([
                'error'     =>  true,
                'title'     =>  'Validar Datos',
                'msj'       =>  'app-token no es valido.',
            ], 400);
        }
        $request['rut_vecino']  =   ($nr_rut) ? $nr_rut : $request->rut_vecino;
        // --------------------------------------------------------------
        //  Mensajes Generales
        $generalMessages    =       [
            'required'              =>  'El campo :attribute es requerido.',
            'numeric'               =>  'El campo :attribute debe ser númerico.',
        ];
        //  Atributos Generales
        $generalAttributes  =       [
            'rut_vecino'            =>  'Rut',
        ];
        // Reglas Generales 
        $generalRules       =       [
            'rut_vecino'            =>  'required|cl_rut',
        ];
        // --------------------------------------------------------------
        $validatorData      =   Validator::make($request->all(), $generalRules, $generalMessages, $generalAttributes);

        if ($validatorData->fails()) {
            return response()->json([
                'error'     =>  true,
                'title'     =>  'Validar Datos',
                'msj'       =>  'Favor revisar los datos faltantes.',
                'validar'   =>  $validatorData->errors(),
            ], 400);
        }

        return  false;
    }
    //------------------------------------------------------------
    private function validarFeedbackVecino(Request $request)
    {
        // --------------------------------------------------------------
        // dd(['request'=>$request]);
        // --------------------------------------------------------------
        $app_token          =   $request->header('app-token');
        $nr_rut             =   UtilController::getDataTokenApp($app_token);
        $errors             =   [];
        // --------------------------------------------------------------
        // Valida app-token
        if($nr_rut == null && !isset($request->rut_vecino))
        {
            return response()->json([
                'error'     =>  true,
                'title'     =>  'Validar Datos',
                'msj'       =>  'app-token no es valido.',
            ], 400);
        }
        $request['rut_vecino']  =   ($nr_rut) ? $nr_rut : $request->rut_vecino;
        // --------------------------------------------------------------
        //  Mensajes Generales
        $generalMessages    =       [
            'required'              =>  'El campo :attribute es requerido.',
            'numeric'               =>  'El campo :attribute debe ser númerico.',
        ];
        //  Atributos Generales
        $generalAttributes  =       [
            'rut_vecino'            =>  'Rut',
            'nr_ticket'             =>  'Nro. Ticket',
            'str_feedback'          =>  'Observación del Feedback',
            'nvl_satisfaccion'      =>  'Satisfacción',
        ];
        // Reglas Generales 
        $generalRules       =       [
            'rut_vecino'            =>  'required|cl_rut',
            'nr_ticket'             =>  'required|numeric|min:1',
            'str_feedback'          =>  'required|string|min:5',
            'nvl_satisfaccion'      =>  'required|numeric',
        ];
        // --------------------------------------------------------------
        $validatorData      =   Validator::make($request->all(), $generalRules, $generalMessages, $generalAttributes);

        if ($validatorData->fails()) {
            return response()->json([
                'error'     =>  true,
                'title'     =>  'Validar Datos',
                'msj'       =>  'Favor revisar los datos faltantes.',
                'validar'   =>  $validatorData->errors(),
            ], 400);
        }

        return  false;
    }
    //------------------------------------------------------------
    public function getApiUserIdToToken($api_token)
    {
        $nr_id  =   0;

        try {
            $data   =   ApiUser::where('api_token', $api_token)->get();
            if($data->count())
                $nr_id  =   $data->first()->id;
        } catch (Exception $e) {
            $nr_id  =   0;
        }
        return  $nr_id;
    }
    //------------------------------------------------------------
}
