<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Foundation\Auth\SendsPasswordResetEmails;

use App\User;

class ForgotPasswordController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset emails and
    | includes a trait which assists in sending these notifications from
    | your application to your users. Feel free to explore this trait.
    |
    */

    use SendsPasswordResetEmails;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    // Se sobreescribe metodo de generar link de restablecimiento de password
    public function sendResetLinkEmail(Request $request)
    {
        $request->validate(['email' => 'required|email|exists:users,email']);
        $response   =   null;        

        $info_user  =   User::where('email', $request->email)->first();

        if ($info_user) {
            if($info_user->tp_activo == 0) {
                return back()->with([
                    'customError' => 'Estimado, favor comunicarse con el administrador del sistema.',
                ]);
            } else {
                $response   =   $this->broker()->sendResetLink(
                                    $request->only('email')
                                );

                return  $response == \Password::RESET_LINK_SENT
                    ? back()->with('status', trans($response))
                    : back()->withErrors(['email' => trans($response)]);
            }
        }
    }
}
