<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Solicitud;
use App\Tipo;

use DB;
use Illuminate\Support\Facades\Auth;

use App\Http\Controllers\UtilController;

class DashboardController extends Controller
{
    //---------------------------------------------------------------------------------------------------------------
    public function index(Request $request)
    {
        $arr_datos      =   $this->listarDatosRedesSociales($request);
        $arr_servicios  =   $this->getServicios($arr_datos);
        $arr_totales    =   (Object) [
                                'nr_global'     =>  UtilController::getCantidadSolicitudes(),
                                'nr_total'      =>  $this->getCantidadSolicitudes($arr_datos),
                                'nr_gestion'    =>  $this->getCantidadPorEstado($arr_datos, 3), // 3. => En Gestion
                                'nr_revision'   =>  $this->getCantidadPorEstado($arr_datos, 4), // 4. => En Revision 
                                'nr_publicado'  =>  $this->getCantidadPorEstado($arr_datos, 5), // 5. => Publicado
                            ];
        $data_grafico   =   $this->ensamblarDataGrafico($arr_datos);
        
        return [
            'datos'     =>  $arr_datos,
            'servicio'  =>  $arr_servicios,
            'totales'   =>  $arr_totales,
            'grafico'   =>  $data_grafico,
        ];
    }
    //---------------------------------------------------------------------------------------------------------------
    private function ensamblarDataGrafico($arr_data)
    {
        $arr_datos      =   [
                                'grid'          =>  (Object) [
                                                        'left'      =>  '10%',
                                                        'right'     =>  '4%',
                                                        'bottom'    =>  '3%',
                                                        'containLabel'  =>  true,
                                                    ],
                                'title'         =>  (Object) ['text' => 'Requeriminentos ingresados por Redes Sociales'],
                                'yAxis'         =>  null,
                                'xAxis'         =>  (Object) [],
                                'dataGroupId'   =>  '',
                                'animationDurationUpdate'   =>  500,
                                'series'        =>  null,
                                'universalTransition'   =>  (Object) ['enabled' => true, 'divideShape' => 'clone'],
                            ];

        $arr_servicios  =   $this->getServicios($arr_data);
        $xAxis_id       =   [];
        $xAxis_data     =   [];
        $arr_series     =   [];

        foreach ($arr_servicios as $keys => $value) {
            $xAxis_id       =   array_merge($xAxis_id, [$value['id_servicio']]);
            $xAxis_data     =   array_merge($xAxis_data, [$value['nm_servicio']]);
            $temp           =   (Object) [
                                    'value'     =>  $this->getCantidadPorServicio($arr_data, $value['id_servicio']),
                                    'name'      =>  $value['nm_servicio'],
                                    'groupId'   =>  $value['id_servicio'],
                                ];

            array_push($arr_series, $temp);
        }        

        $arr_datos  =   array_merge($arr_datos, [
                            'yAxis'     =>  (Object) [
                                                'id'    =>  $xAxis_id,
                                                'data'  =>  $xAxis_data
                                            ],
                            'series'    =>  [
                                                'type'  =>  'bar',
                                                'data'  =>  $arr_series
                                            ],
                        ]);

        return $arr_datos;
    }
    //---------------------------------------------------------------------------------------------------------------
    private function getServicios($arr_data)
    {
        $data   =   $arr_data->map(function ($items) {
                        return [
                            'id_servicio'   =>  $items->id_servicio,
                            'nm_servicio'   =>  $items->nm_servicio,
                        ];
                    })->unique();

        return $data;
    }
    //---------------------------------------------------------------------------------------------------------------
    private function getCantidadSolicitudes($arr_data)
    {
        $data   =   $arr_data->count();
        return $data;
    }
    //---------------------------------------------------------------------------------------------------------------
    private function getCantidadPorServicio($arr_data, $nr_servicio)
    {
        $data   =   $arr_data->where('id_servicio','=',$nr_servicio)->count();
        return $data;
    }
    //---------------------------------------------------------------------------------------------------------------
    private function getCantidadPorEstado($arr_data, $nr_estado)
    {
        $data   =   $arr_data->where('id_estado','=',$nr_estado)->count();
        return $data;
    }
    //---------------------------------------------------------------------------------------------------------------
    private function listarDatosRedesSociales(Request $request)
    {
        $fl_direccion   =   $request->fl_direccion;
        $fl_depto       =   $request->fl_depto;
        $fl_servicio    =   $request->fl_servicio;

        $arr_ingresos   =   UtilController::getIngresoCanViewRelaionesPublicas();

        $data   =   Solicitud::
                    join('gsut_tipo as servicio','servicio.id','=','gsut_solicitud.id_tipo')
                    ->join('gsut_direccion as dir','dir.id','=','gsut_solicitud.id_direccion_destino')
                    ->join('gsut_depto as depto','depto.id','=','gsut_solicitud.id_depto_destino')
                    ->join('gsut_tipo_ingreso as ingreso','ingreso.id','=','gsut_solicitud.tp_ingreso')
                    ->join('gsut_estado as estado','estado.id','=','gsut_solicitud.id_estado')
                    ->select('gsut_solicitud.tp_ingreso',
                        'gsut_solicitud.id_estado',
                        'gsut_solicitud.id_tipo as id_servicio',
                        'gsut_solicitud.id_direccion_destino',
                        'gsut_solicitud.id_depto_destino',
                        'servicio.nm_tipo as nm_servicio',
                        'dir.nm_direccion',
                        'depto.nm_depto',
                        'ingreso.nm_ingreso',
                        'estado.nm_estado')
                    ->whereIn('gsut_solicitud.tp_ingreso',$arr_ingresos)
                    ->where('gsut_solicitud.tp_activo','=','1');

        /* ----- Inicio - Filtro ----- */
            if(isset($fl_direccion)) 
                $data   =   $data->where('gsut_solicitud.id_direccion_destino','=',$fl_direccion);

            if(isset($fl_depto)) 
                $data   =   $data->where('gsut_solicitud.id_depto_destino','=',$fl_depto);

            if(isset($fl_servicio))
                $data   =   $data->where('gsut_solicitud.id_tipo','=',$fl_servicio);
        /* ----- Termino - Filtro ----- */

        $data   =   $data->get();        

        return $data;
    }
    //---------------------------------------------------------------------------------------------------------------
}
