<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use DB;
use Validator;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Auth;

use App\PreguntaRespuesta;

use App\Http\Controllers\UtilController;

class GPTController extends Controller
{
    public function index()
    {
        $id_user            = Auth::user()->id;
        $pregunta_respuesta = PreguntaRespuesta::select('consulta_text as question',
                                                'fc_ingreso as date',
                                                'tp_consulta as tp',
                                                'id',
                                                'str_respuesta',
                                                'str_comentario as comentario',
                                                'id_telefonista as id_telefonista')
                                                ->where('id_user', $id_user)
                                                ->orderBy('fc_ingreso', 'asc')
                                                ->take(10)
                                                ->get();

        return ['preguntas' => $pregunta_respuesta];
    }

    public function setComentario(Request $request)
    {
        //sesion
        $id_user        = Auth::user()->id;

        //request
        $id_respuesta   = $request->id_respuesta;
        $str_comentario = $request->str_comentario;
        
        //Logica
        $title          = 'Exito';
        $text           = 'Comentario agregado exitosamente.';
        $error          = 0;
        $icon           = 'success';

        PreguntaRespuesta::where('id', $id_respuesta)->update(['str_comentario' => $str_comentario,'id_telefonista'=>$id_user]);
       
        return ['title' => $title, 'text' => $text, 'icon' => $icon,'error'=>$error];

    }

    public function insert_query($question, $tp_gpt, $tp_prompt,$tp_pregunta = 1,$id = 0,$index_query = null,$payload_search= null)
    {
        // crear una variable de datetime con la zona horaria de santiago/Chile
        date_default_timezone_set('America/Santiago');
        $time           = date('Y-m-d H:i:s');

        if($id == 0)
            {
                $pregunta_respuesta                  = new PreguntaRespuesta;
                $pregunta_respuesta->id_user         = Auth::user()->id;
                $pregunta_respuesta->tp_consulta     = $tp_pregunta;
                #$pregunta_respuesta->tp_gpt          = $tp_gpt?:35;
                $pregunta_respuesta->tp_gpt          = 35;
                $pregunta_respuesta->nr_promt        = $tp_prompt;
                $pregunta_respuesta->consulta_text   = $question;
                $pregunta_respuesta->fc_ingreso      = $time;
                $pregunta_respuesta->index_query     = $index_query;
                $pregunta_respuesta->filter_query    = $payload_search;
                $pregunta_respuesta->save();

            }

        else
            $pregunta_respuesta = PreguntaRespuesta::where('id','=', $id)->update(['str_respuesta' => $question]);

        return $pregunta_respuesta;
        
    }

    public function  insert_base_conocimiento($data,$id)
    {

        $utils              = new UtilController();
        $bearer_token       = env('BEARER_TOKEN');
        $name_collection    = env('NAME_COLLECTION');
        $endpoint           = env('ENDPOINT').'/protected/baseconocimiento';


        try {

            
            $form_params        =  
                        ['form_params'       => 
                                [
                                    'id_db'             => $id,
                                    'text'              => $data['pregunta'].'/n'.$data['respuesta'],
                                    'name_collection'   => $name_collection
                                    ]
                        ];

            

            $utils->PeticionHttp($bearer_token,'POST',$endpoint,$form_params);
            

            } catch (\Throwable $th) {
                \Log::error($th);
                return ['msj' => 'Error al guardar la pregunta','error'=>1,'color' => 'error','title'=>'Error'];

            }

        return ['msj' => 'Pregunta guardada correctamente','error'=>0,'color' => 'success'];

    }

    public function deleteQuestion($name_collection,$key,$value_key)
    {
        $token            = env('BEARER_TOKEN');
        $endpoint         = env('ENDPOINT').'/protected/delete/payload';

        $utils            = new UtilController();

        $form_params = [
            'form_params' => 
                [   'name_collection'   => $name_collection,
                    'key'               => $key,
                    'value_key'         => $value_key,
                ]
        ];

        $output = $utils->PeticionHttp($token,'POST',$endpoint,$form_params);

        return $output;


    }
    public function get_query(Request $request)
    {
        // crea variable con timestamp
        ini_set('max_execution_time', 300);
        $time           = date('Y-m-d H:i:s');
        $question       = $request->question;
        #$index_query    = $request->index_query;
        $index_query     = env('NAME_COLLECTION');
        $payload_search = $request->payload_search;
        $key_search     = $request->key_search;
        $key_search     = $request->key_search;
        $tp_asistente   = $request->tp_asistente;
        $tp_gpt         = '35';
        $tp_prompt      = $request->tp_prompt?:1;
        $token          = env('BEARER_TOKEN');
        $endpoint       = env('ENDPOINT');

        $utils          = new UtilController();

        $tp_pregunta    = 1;
        $pr             = $this->insert_query($question, $tp_gpt, $tp_prompt,$tp_pregunta,0,$index_query,$payload_search,$tp_asistente);
        
        $form_params = [
                            'form_params' => 
                                ['question'        => $question,
                                'index_query'       => $index_query,
                                'payload_search'    => $payload_search,
                                'key_search'        => $key_search,
                                'tp_asistente'      => $tp_asistente,
                                ]
                        ];

        $output = $utils->PeticionHttp($token,'POST',$endpoint.'/protected/query',$form_params);
        $json   = json_decode($output, true);
        $answer = $json['question'];
        $output = $json['output'];

        $this->insert_query($answer, $tp_gpt, $tp_prompt,0,$pr->id,null,null,$tp_asistente);

        return ['answer' => $answer,'id'=>$pr->id,'output'=>$output,'time'=>$time];
    }
    //------------------------------------------------------------
    public function page($tp_destino)
    {


        $destino    =   '';
        $id_usuario =   Auth::user()->id;
        $id_rol     =   Auth::user()->id_rol;
        $rol_actual =   UtilController::getRolActivo($id_usuario);
        $roles      =   UtilController::listarRolesUsuario($id_usuario);

        if($tp_destino === 'inicio')
            $destino = 'ia_gpt.inicio_ia';

        if($tp_destino === 'base_conocimiento')
            $destino = 'ia_gpt.base_conocimiento';

        if($tp_destino === 'doc_pdfs')
            $destino = 'ia_gpt.doc_pdfs';




        return view($destino)
                ->with('id_rol',$id_rol)
                ->with('rol_actual',$rol_actual)
                ->with('data',$roles)
                ->with('count',count($roles));
    }
    //------------------------------------------------------------
    function store(Request $request) ## servicio ATENCION VECINO auto sugerencia de respuesta
    {
        $token              = env('BEARER_TOKEN');
        $base_url           = env('ENDPOINT');
        
        $nm_tipo            = $request->input('nm_tipo');
        $str_observacion    = $request->input('str_observacion');
        $nm_vecino          = $request->input('nm_vecino');
        $nm_motivo          = $request->input('nm_motivo');
        $id_motivo          = $request->input('id_motivo');

        $utils              = new UtilController();

        $form_params = [
                        'form_params' => 
                        [
                            'nr_tipo'           => $nm_tipo,
                            'str_observacion'   => $str_observacion,
                            'nm_vecino'         => $nm_vecino,
                            'id_motivo'         => $id_motivo,
                        ]
                    ];

        $res = $utils->PeticionHttp($token,'POST',$base_url.'/protected/av/',$form_params);
        

        $json   = json_decode($res, true);
        $answer = $json['question'];

        return ['answer' => $answer]; 
    }
    //------------------------------------------------------------
}
