<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Prioridad;
use DB;
use Validator;
class GsutPrioridadController extends Controller
{
    //------------------------------------------------------------
    public function page()
    {
        return view('opciones.administrador.solicitud.prioridad.index');
    }
    //------------------------------------------------------------
    public function index()
    {
        $data   =   Prioridad::
                    select('id',
                        'nm_prioridad',
                        'color_prioridad',
                        'tp_tiempo',
                        'timer_atencion',
                        'tp_activo');

        $data   =   $data->paginate(50);

        return [
            'pagination' => [
                'total'        => $data->total(),
                'current_page' => $data->currentPage(),
                'per_page'     => $data->perPage(),
                'last_page'    => $data->lastPage(),
                'from'         => $data->firstItem(),
                'to'           => $data->lastItem(),
            ],
            'info' => $data
        ];
    }
    //------------------------------------------------------------
    public static function listado()
    {
        $data   =   Prioridad::
                    select('id as value',
                        'nm_prioridad as label',
                        'color_prioridad',
                        'tp_tiempo',
                        'timer_atencion',
                        'tp_activo')
                    ->where('tp_activo','=',1)
                    ->get();

        return  $data;
    }
    //------------------------------------------------------------
    public function store(Request $request)
    {
        $valida     =   $this->validarDatos($request);

        if($valida['error'] == 1)
            return $valida;

        $existe     =   $this->existeRegistro($request);

        if($existe['existe'] == 1)
            return $existe;
        else
            return $this->insertarRegistro($request);
    }
    //------------------------------------------------------------
    public function edit(Request $request)
    {
        $valida     =   $this->validarDatos($request);

        if($valida['error'] == 1)
            return $valida;

        $existe     =   $this->existeRegistro($request);

        if($existe['existe'] == 1)
            return $existe;
        else
            return $this->editarRegistro($request);
    }
    //------------------------------------------------------------
    public function state(Request $request)
    {
        $valida     =   $this->validarDatos($request);

        if($valida['error'] == 1)
            return $valida;

        $existe     =   $this->existeRegistro($request);

        if($existe['existe'] == 1)
            return $this->estadoRegistro($request);
        else
            return $existe;
    }
    //------------------------------------------------------------
    private function validarDatos(Request $request)
    {
        $customMessages     =   [
            'required'      =>  'El campo :attribute es requerido.',
            'numeric'       =>  'El campo :attribute debe ser númerico.',
        ];

        $attributes         =   [
            'nr_prioridad'      =>  'Id prioridad',
            'nm_prioridad'      =>  'Nombre prioridad',
            'color_prioridad'   =>  'Color prioridad',
            'tp_tiempo'         =>  'Defenir tiempo',
            'timer_atencion'    =>  'Tiempo de atención',
            'tp_activo'         =>  'Estado',
        ];

        $rules              =   [
            'nr_prioridad'      =>  'required|numeric',
            'nm_prioridad'      =>  'required|string|min:3',
            'color_prioridad'   =>  'required|string|min:3',
            'tp_tiempo'         =>  'required|numeric',
            'timer_atencion'    =>  'required|numeric',
            'tp_activo'         =>  'required|numeric',
        ];

        $validator  =   Validator::make($request->all(), $rules, $customMessages, $attributes);

        if ($validator->fails())
            return [
                'error'     =>  1,
                'title'     =>  'Validar Datos',
                'msj'       =>  'Favor revisar los campos requeridos',
                'validar'   =>  $validator->errors()
            ];

        return [
            'error'     =>  0,
            'title'     =>  'Validar Datos',
            'msj'       =>  'Campos requeridos validados',
            'validar'   =>  'Ok'
        ];
    }
    //------------------------------------------------------------
    private function existeRegistro(Request $request)
    {
        $nm_prioridad   =   strtoupper(trim($request->nm_prioridad));
        $data           =   [];
        $valida         =   [];
        $existe         =   0;

        try {
            $data   =   Prioridad::
                        select(DB::raw('(case when count(id) != 0 then 1 else 0 end) as existe'))
                        ->where('nm_prioridad','=',$nm_prioridad)
                        ->get();

            if($data->count())
            {
                $existe     =   $data->first()->existe;
                $msj        =   ($existe == 1) ? 'La Prioridad "' .$nm_estado. '", ya se encuentra registrado' :
                                                       'La Prioridad "'.$nm_estado.'", No se encuentra registrado';
                $valida     =   array_merge($valida, [
                                    'error'     =>  0,
                                    'existe'    =>  $existe,
                                    'tp_icon'   =>  'info',
                                    'title'     =>  'Valida Prioridad',
                                    'msj'       =>  $msj
                                ]);
            }
        } catch (Exception $e) {
            $valida     =   array_merge($valida, [
                                'error'     =>  1,
                                'existe'    =>  0,
                                'tp_icon'   =>  'error',
                                'title'     =>  'Valida Prioridad',
                                'msj'       =>  'Ha ocurrido un error al validar el registro'
                            ]);
        }

        return $valida;
    }
    //------------------------------------------------------------
    private function insertarRegistro(Request $request)
    {
        $nm_prioridad       =   $request->nm_prioridad;
        $color_prioridad    =   $request->color_prioridad;
        $tp_tiempo          =   $request->tp_tiempo;
        $timer_atencion     =   $request->timer_atencion;
        $tp_activo          =   1;
        $valida             =   [];

        try {
            $model      =   new Prioridad();
            $model->nm_prioridad        =   strtoupper(trim($nm_prioridad));
            $model->color_prioridad     =   $color_prioridad;
            $model->tp_tiempo           =   $tp_tiempo;
            $model->timer_atencion      =   $timer_atencion;
            $model->tp_activo           =   $tp_activo;
            $model->save();

            $valida     =   $this->existeRegistro($request);

            if($valida['existe'] == 1)
            {
                $valida =   array_merge($valida, [
                                'error'     =>  0,
                                'existe'    =>  1,
                                'tp_icon'   =>  'success',
                                'title'     =>  'Registro de Prioridad',
                                'msj'       =>  'Se ha registrado la prioridad : "' . $nm_prioridad . '"'
                            ]);
            }
        } catch (Exception $e) {
            $valida     =   array_merge($valida, [
                                'error'     =>  1,
                                'existe'    =>  0,
                                'tp_icon'   =>  'error',
                                'title'     =>  'Registro de Prioridad',
                                'msj'       =>  'Se ocurrido un error al registrar la prioridad : "' . $nm_prioridad . '"'
                            ]);
        }

        return $valida;
    }
    //------------------------------------------------------------
    private function editarRegistro(Request $request)
    {
        $nr_prioridad       =   $request->nr_prioridad;
        $nm_prioridad       =   strtoupper(trim($request->nm_prioridad));
        $color_prioridad    =   $request->color_prioridad;
        $tp_tiempo          =   $request->tp_tiempo;
        $timer_atencion     =   $request->timer_atencion;
        $valida             =   [];

        try {
            Prioridad::
            where('id','=',$nr_prioridad)
            ->update([
                'nm_prioridad'      =>  $nm_prioridad,
                'color_prioridad'   =>  $color_prioridad,
                'tp_tiempo'         =>  $tp_tiempo,
                'timer_atencion'    =>  $timer_atencion,
            ]);

            $valida     =   array_merge($valida, $this->existeRegistro($request));

            if($valida['existe'] == 1)
            {
                $valida =   array_merge($valida, [
                                'error'     =>  0,
                                'existe'    =>  1,
                                'tp_icon'   =>  'success',
                                'title'     =>  'Actualizar Prioridad',
                                'msj'       =>  'Se ha actualizado la prioridad a : "' . $nm_prioridad . '"'
                            ]);
            }
        } catch (Exception $e) {
            $valida     =   array_merge($valida, [
                                'error'     =>  1,
                                'existe'    =>  0,
                                'tp_icon'   =>  'error',
                                'title'     =>  'Actualizar Prioridad',
                                'msj'       =>  'Se ocurrido un error al actualizar la prioridad a : "' . $nm_prioridad . '"'
                            ]);
        }

        return $valida;
    }
    //------------------------------------------------------------
    private function estadoRegistro(Request $request)
    {
        $nr_prioridad       =   $request->nr_prioridad;
        $nm_prioridad       =   strtoupper(trim($request->nm_prioridad));
        $tp_activo          =   $request->tp_activo;
        $valida             =   [];
        $title              =   '';
        $msj                =   '';

        try {
            $title  =   ($tp_activo == 1) ? 'Habilitar Prioridad' : 'Inhabilitar Prioridad';
            $msj    =   ($tp_activo == 1) ? 'Se ha habilitado la prioridad : "' . $nm_prioridad . '"' :
                                            'Se ha inhabilitado la prioridad : "' . $nm_prioridad . '"';

            Prioridad::
            where('id','=',$nr_prioridad)
            ->update([
                'tp_activo'     =>  $tp_activo
            ]);

            $valida =   array_merge($valida, [
                            'error'     =>  0,
                            'existe'    =>  1,
                            'tp_icon'   =>  'success',
                            'title'     =>  $title,
                            'msj'       =>  $msj
                        ]);
        } catch (Exception $e) {
            $valida =   array_merge($valida, [
                            'error'     =>  1,
                            'existe'    =>  0,
                            'tp_icon'   =>  'error',
                            'title'     =>  $title,
                            'msj'       =>  'ha ocurrido un error al '. $title .' : "' . $nm_prioridad . '"'
                        ]);
        }

        return $valida;
    }
    //------------------------------------------------------------
}
