<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Tipo;
use App\RespuestaServicio;

use DB;
use Validator;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\UtilController;

class GsutRespuestaServicioController extends Controller
{
    //------------------------------------------------------------
    public function index(Request $request)
    {
        $nr_servicio    =   $request->nr_servicio;

        $data   =   RespuestaServicio::
                    select('id',
                        'nr_respuesta',
                        'id_direccion',
                        'id_depto',
                        'id_tipo',
                        'tp_respuesta',
                        'nr_tiempo',
                        'str_respuesta',
                        'str_respuesta_html',
                        'fc_inicio',
                        'fc_termino',
                        DB::raw('concat(nr_tiempo," Hrs.") as str_tiempo'),
                        DB::raw('(case when tp_activo=1 then "Habilitado" else "Deshabilitado" end) as nm_estado'),
                        'tp_activo')
                    ->where('id_tipo','=',$nr_servicio);

        $data   =   $data->paginate(5);

        return [
            'pagination' => [
                'total'        => $data->total(),
                'current_page' => $data->currentPage(),
                'per_page'     => $data->perPage(),
                'last_page'    => $data->lastPage(),
                'from'         => $data->firstItem(),
                'to'           => $data->lastItem(),
            ],
            'info' => $data
        ];
    }
    //------------------------------------------------------------
    public function store(Request $request)
    {
        $valida     =   $this->validarDatos($request);

        if($valida['error'] == 1)
            return $valida;

        $existe     =   $this->existeRegistroServicio($request);

        if($existe == 1)
            return $this->registrarRespuesta($request);
        else
            return [
                'error'     =>  1,
                'tp_icon'   =>  'warning',
                'title'     =>  'Respuesta Automatica del Servicio',
                'msj'       =>  'El servicio no se encuentra disponible',
            ];
    }
    //------------------------------------------------------------
    public function update(Request $request)
    {
        $valida     =   $this->validarDatos($request);

        if($valida['error'] == 1)
            return $valida;

        $existe     =   $this->existeRegistroRespuestaServicio($request);

        if($existe == 1)
            return $this->actualizarRespuesta($request);
        else
            return [
                'error'     =>  1,
                'tp_icon'   =>  'warning',
                'title'     =>  'Respuesta Automatica del Servicio',
                'msj'       =>  'No se ha encontrado la Respuesta Automatica del Servicio',
            ];
    }
    //------------------------------------------------------------
    public function state(Request $request)
    {
        $existe     =   $this->existeRegistroRespuestaServicio($request);

        if($existe == 1)
            return $this->estadoRespuestaServicio($request);
        else
            return [
                'error'     =>  1,
                'tp_icon'   =>  'warning',
                'title'     =>  'Respuesta Automatica del Servicio',
                'msj'       =>  'El servicio no se encuentra disponible',
            ];
    }
    //------------------------------------------------------------
    public function registrarRespuesta(Request $request)
    {
        $nr_direccion   =   $request->nr_direccion;
        $nr_depto       =   $request->nr_depto;
        $nr_servicio    =   $request->nr_servicio;
        $nm_servicio    =   $request->nm_servicio;
        $tp_respuesta   =   $request->tp_publicacion;
        $nr_tiempo      =   $request->nr_tiempo;
        $str_respuesta  =   $request->str_respuesta;
        $str_html       =   $request->str_respuesta_html;
        $str_title      =   'Respuesta Automatica del Servicio';
        $str_msj        =   '';
        $arr_valida     =   [
                                'error'     =>  0,
                                'tp_icon'   =>  'success',
                                'title'     =>  $str_title,
                                'msj'       =>  $str_msj,
                            ];

        try {
            $nr_num     =   $this->generarNumeracionRespuesta($nr_servicio);

            $arr_datos  =   [
                                'nr_respuesta'          =>  $nr_num,
                                'id_direccion'          =>  $nr_direccion,
                                'id_depto'              =>  $nr_depto,
                                'id_tipo'               =>  $nr_servicio,
                                'tp_respuesta'          =>  $tp_respuesta,
                                'nr_tiempo'             =>  $nr_tiempo,
                                'str_respuesta'         =>  $str_respuesta,
                                'str_respuesta_html'    =>  $str_html,
                                'fc_inicio'             =>  null,
                                'fc_termino'            =>  null,
                                'tp_activo'             =>  1,
                            ];
            RespuestaServicio::create($arr_datos);

            $str_msj    =   'Se ha registrado la Respuesta Automatica para el Servicio : "'.$nm_servicio.'"';

            $arr_valida =   [
                'error'     =>  0,
                'tp_icon'   =>  'success',
                'title'     =>  $str_title,
                'msj'       =>  $str_msj,
            ];
        } catch (Exception $e) {
            $arr_valida =   [
                                'error'     =>  1,
                                'tp_icon'   =>  'error',
                                'title'     =>  $str_title,
                                'msj'       =>  'Ha ocurrido un error al registrar la "Respuesta Automatica del Servicio"',
                            ];
        }

        return $arr_valida;
    }
    //------------------------------------------------------------
    public function actualizarRespuesta(Request $request)
    {
        $nr_respuesta   =   $request->nr_respuesta;
        $nr_servicio    =   $request->nr_servicio;
        $nm_servicio    =   $request->nm_servicio;
        $nr_tiempo      =   $request->nr_tiempo;
        $str_respuesta  =   $request->str_respuesta;
        $str_html       =   $request->str_respuesta_html;
        $str_title      =   'Respuesta Automatica del Servicio';
        $str_msj        =   '';
        $arr_valida     =   [
                                'error'     =>  0,
                                'tp_icon'   =>  'success',
                                'title'     =>  $str_title,
                                'msj'       =>  $str_msj,
                            ];

        try {
            RespuestaServicio::
            where('id','=',$nr_respuesta)
            ->where('id_tipo','=',$nr_servicio)
            ->update([
                'nr_tiempo'             =>  $nr_tiempo,
                'str_respuesta'         =>  $str_respuesta,
                'str_respuesta_html'    =>  $str_html
            ]);

            $str_msj    =   'Se ha actualizado la Respuesta Automatica para el Servicio : "'.$nm_servicio.'"';

            $arr_valida =   [
                'error'     =>  0,
                'tp_icon'   =>  'success',
                'title'     =>  $str_title,
                'msj'       =>  $str_msj,
            ];
        } catch (Exception $e) {
            $arr_valida =   [
                                'error'     =>  1,
                                'tp_icon'   =>  'error',
                                'title'     =>  $str_title,
                                'msj'       =>  'Ha ocurrido un error al actualizar la "Respuesta Automatica del Servicio"',
                            ];
        }

        return $arr_valida;
    }
    //------------------------------------------------------------
    public function estadoRespuestaServicio(Request $request)
    {
        $nr_respuesta   =   $request->nr_respuesta;
        $nr_servicio    =   $request->nr_servicio;
        $nm_servicio    =   $request->nm_servicio;
        $tp_activo      =   $request->tp_activo;
        $str_title      =   'Respuesta Automatica del Servicio';
        $str_msj        =   '';
        $arr_valida     =   [
                                'error'     =>  0,
                                'tp_icon'   =>  'success',
                                'title'     =>  $str_title,
                                'msj'       =>  $str_msj,
                            ];

        try {
            $str_msj    =   ($tp_activo == 1) ? 'Se ha Habilitado la Respuesta Automatica para el Servicio "'.$nm_servicio.'"' : 
                                                'Se ha Deshabilitado la Respuesta Automatica para el Servicio "'.$nm_servicio.'"';

            RespuestaServicio::
            where('id','=',$nr_respuesta)
            ->where('id_tipo','=',$nr_servicio)
            ->update([
                'tp_activo'     =>  $tp_activo
            ]);

            $arr_valida     =   [
                                    'error'     =>  0,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  $str_title,
                                    'msj'       =>  $str_msj,
                                ];
        } catch (Exception $e) {
            $arr_valida     =   [
                                    'error'     =>  0,
                                    'tp_icon'   =>  'success',
                                    'title'     =>  $str_title,
                                    'msj'       =>  'Ha ocurrido un error al deshabilitar la respuesta automatica.',
                                ];
        }

        return $arr_valida;
    }
    //------------------------------------------------------------
    public function existeRegistroServicio(Request $request)
    {
        $nr_servicio    =   trim($request->nr_servicio);
        $existe         =   Tipo::where('id','=',$nr_servicio)->count();
        return $existe;
    }
    //------------------------------------------------------------
    public function existeRegistroRespuestaServicio(Request $request)
    {
        $nr_respuesta   =   trim($request->nr_respuesta);
        $existe         =   RespuestaServicio::where('id','=',$nr_respuesta)->count();
        return $existe;
    }
    //------------------------------------------------------------
    public function generarNumeracionRespuesta($nr_servicio)
    {
        $nr_numeracion  =   1;

        try {
            $data   =   RespuestaServicio::
                        select('nr_respuesta')
                        ->where('id_tipo','=',$nr_servicio)
                        ->orderBy('nr_respuesta','DESC')
                        ->get()->take(1);

            if($data->count())
                $nr_numeracion  =   $data->first()->nr_respuesta + 1;
        } catch (Exception $e) {
            $nr_numeracion      =   1;
        }

        return $nr_numeracion;
    }
    //------------------------------------------------------------
    public function validarDatos(Request $request)
    {
        $customMessages = [
            'required'          =>  'El campo :attribute es requerido.',
            'numeric'           =>  'El campo :attribute debe ser númerico.',
        ];

        $attributes = [
            'nr_direccion'      =>  'Dirección Municipal',
            'nr_depto'          =>  'Departamento Municipal',
            'nr_servicio'       =>  'Servicio',
            'nr_tiempo'         =>  'Tiempo',
            'str_respuesta'     =>  'Respuesta'
        ];

        $validator = Validator::make($request->all(), [
            'nr_direccion'      =>  'required|numeric|min:1',
            'nr_depto'          =>  'required|numeric|min:1',
            'nr_servicio'       =>  'required|integer',
            'nr_tiempo'         =>  'required|integer',
            'str_respuesta'     =>  'required|string|min:5',
        ], $customMessages,$attributes);

        if ($validator->fails())
            return [
                'error'     =>  1,
                'tp_icon'   =>  'warning',
                'title'     =>  'Validar Datos',
                'msj'       =>  'Favor revisar los datos requeridos',
                'valida'    =>  $validator->errors(),
            ];

        return [
            'error'     =>  0,
            'tp_icon'   =>  'success',
            'title'     =>  'Validar Datos',
            'msj'       =>  'Datos validos',
            'valida'    =>  null,
        ];
    }
    //------------------------------------------------------------
}
