<?php

namespace App\Http\Controllers;

use App\UserThread;
use App\PDFs;
use App\Asistentes;

use Auth;

use App\Http\Controllers\UtilController;

use Illuminate\Http\Request;
use Guzzle\Http\Exception\ClientErrorResponseException;

class OpenAIController extends Controller
{
    public function get_query_pdf(Request $request)
    {
        ini_set('max_execution_time', 300);
        $time           = date('Y-m-d H:i:s');
        $id_user        = Auth::user()->id;  
        $n_preguntas    = env('N_PREGUNTAS',3); 
        $token          = env('BEARER_TOKEN');
        $endpoint       = env('ENDPOINT_OPENAI');
        $asistente      = $request->asistente;
        $asistente_id   = env($asistente);
        $ruta           = '/protected/question/pdf';

        $key_search     = $request->key_search;
        $id_file        = $request->id_file;
        $payload_key    = $request->payload_key;
        $question       = $request->question;
        $contexto       = $request->contexto;
        $id_file        = $contexto;

        $thread_id      = '';
        $run_id         = '';

        $id_user        = Auth::user()->id;
        $existe_thread  = UserThread::where('user_id',$id_user)->where('asistente_id',$asistente_id)->where('contexto','=',$contexto)->count();

        if($existe_thread)
        {
            $info = UserThread::where('user_id',$id_user)->where('asistente_id',$asistente_id)->where('contexto','=',$contexto)->first();
            
            $thread_id      = $info->thread_id;

            if($info->run_id)
                $run_id         = $info->run_id;
            else
                $run_id         = '';
      
        }

        $file = PDFs::where('id',$id_file)->count();

        if(!$file)
            return ['error'=>1,'text'=>'No se encontró el archivo','title'=>'Error al buscar','icon'=>'error'];

        $file           = PDFs::where('id',$id_file)->first();
        $payload_value  = $file->nombre_real;

        
        $index_query    = 'collection_user_'.$id_user;
        $form_params    = ['form_params' =>[
                            'question'          => $question,
                            'index_query'       => 'collection_user_'.$id_user,
                            'payload_key'       => $payload_key?:'pdf_name',
                            'payload_value'     => $payload_value,
                            'id_thread'         => $thread_id,
                            'run_id'            => $run_id,
                            'id_assistant'      => $asistente_id
                         ]];

        
        $client             = new \GuzzleHttp\Client(['headers' => ['Authorization' => 'Bearer ' . $token,'Content-Type' => 'application/json']]);
        $res                = $client->request('POST', $endpoint.$ruta, $form_params);
        $statusCode         = $res->getStatusCode();
        $response           = $res->getBody()->getContents();
    
        return response()->json(['response' => json_decode($response, true)],$statusCode);
    }

    public function delete_thread(Request $request)
    {
        $token          =   env('BEARER_TOKEN');
        $endpoint       =   env('ENDPOINT_OPENAI').'/protected/thread/delete';
        $asistente      =   $request->asistente;
        $contexto       =   $request->contexto?:0;
        $asistente_id   =   env($asistente);
        $id_user        =   Auth::user()->id;
        $count_thread   =   UserThread::where('user_id',$id_user)->where('asistente_id',$asistente_id)->where('contexto','=',$contexto)->count();

        if($count_thread)
        {
            $user_thread    =   UserThread::where('user_id',$id_user)->where('asistente_id',$asistente_id)->where('contexto','=',$contexto)->first();
            $form_params    =   ['id_thread'=> $user_thread->thread_id];

            try {
                $client     =   new \GuzzleHttp\Client(['headers' => ['Authorization' => 'Bearer ' . $token,'Content-Type' => 'application/json']]);
                $res        =   $client->request('POST', $endpoint, ['form_params' => $form_params])->getBody()->getContents();
                $json       =   json_decode($res, true);
              
                $user_thread->delete();
                return $json;
            } catch (ClientErrorResponseException $th) 
            { 
                return ['error'=>1,'text'=>'Error al eliminar la conversación','title'=>'Error al eliminar','icon'=>'error'];
            }
        }

        return ['error'=>1,'text'=>'No se encontró la conversación','title'=>'Error al eliminar','icon'=>'error'];
    }

    public function set_query_openai(Request $request)
    {
        ini_set('max_execution_time', 300);
        $time           = date('Y-m-d H:i:s');
        
        $id_user        = Auth::user()->id;  
        $token          = env('BEARER_TOKEN');
        $endpoint       = env('ENDPOINT_OPENAI');
        $asistente      = $request->asistente;
        $question       = $request->question;
        $contexto       = $request->contexto;
        $asistente_id   = env($asistente);

        $ruta           = '/protected/question';
        $messages       = [];
        $thread_id      = '';
        

        $thread_id      = '';
        $run_id         = '';

        $existe_thread  = UserThread::where('user_id',$id_user)
                                    ->where('asistente_id',$asistente_id)
                                    ->where('contexto','=',$contexto)
                                    ->count();

        if($existe_thread)
        {
            $info       = UserThread::where('user_id',$id_user)
                                    ->where('asistente_id',$asistente_id)
                                    ->where('contexto','=',$contexto)
                                    ->first();

            $thread_id  = $info->thread_id;
            $run_id     = $info->run_id?:'';
      
        }

        $form_params         = ['run_id'=> $run_id,'id_thread'=> $thread_id,'question'=> $question,'id_assistant'=> $asistente_id];
        $client             = new \GuzzleHttp\Client(['headers' => ['Authorization' => 'Bearer ' . $token,'Content-Type' => 'application/json']]);

        $response           = $client->request('POST', $endpoint.$ruta, ['form_params' => $form_params]);
        $res                = $response->getBody()->getContents();
        $statusCode         = $response->getStatusCode();

        $json               = json_decode($res, true);
        $thread_id          = $json['thread_id'];
        $run_id             = $json['run_id'];

        if(!$existe_thread)
            UserThread::create(['user_id'       =>$id_user,
                                'asistente_id'  =>$asistente_id,
                                'thread_id'     =>$thread_id,
                                'run_id'        =>$run_id,
                                'contexto'      =>$contexto]);
        else
            UserThread::where('user_id',$id_user)->where('asistente_id',$asistente_id)->where('contexto',$contexto)->update(['thread_id'=>$thread_id,'run_id'=>$run_id]);
       
        return response()->json(['response' => json_decode($res, true),'thread_id'=>$thread_id,'run_id'=>$run_id],$statusCode);
    }

    public function get_asistentes_openai()
    {
        $user               = Auth::user();
        $nombre_user        = $user->nombre.'-'.$user->ap_paterno;
        
        $utils              = new UtilController();
        $bearer_token       = env('BEARER_TOKEN');
        $endpoint           = env('ENDPOINT_OPENAI').'/protected/asistentes';

        $form_params        = [];

        $res                = $utils->PeticionHttp($bearer_token,'POST',$endpoint,$form_params);
        $json               = json_decode($res, true);

        return ['asistentes' => $json,'name_user'=>$nombre_user];
    }

    public function get_query_openai(Request $request)
    {
        ini_set('max_execution_time', 300);
        $n_preguntas    =   env('N_PREGUNTAS',3); 
        $token          =   env('BEARER_TOKEN');
        $endpoint       =   env('ENDPOINT_OPENAI');

        $time           =   date('Y-m-d H:i:s');
        $run_id         =   $request->run_id;
        $contexto       =   $request->contexto;
        $asistente      =   $request->asistente;
        $asistente_id   =   env($asistente);        
        $id_user        =   Auth::user()->id;
        $ruta           =   '/protected/runs';
        
        $existe_thread  =   UserThread::where('user_id',$id_user)->where('asistente_id',$asistente_id)->where('contexto',$contexto)->first();
        $thread_id      =   $existe_thread?$existe_thread->thread_id:'';
        $form_params    =   ['form_params' => ['run_id'=>$run_id,'id_thread'=> $thread_id] ];
        
        $client         =   new \GuzzleHttp\Client(['headers' => ['Authorization' => 'Bearer ' . $token,'Content-Type' => 'application/json']]);
        $res            =   $client->request('POST', $endpoint.$ruta, $form_params);
        $statusCode     =   $res->getStatusCode();
        $response       =   $res->getBody()->getContents();
    
        return response()->json(['response' => json_decode($response, true)],$statusCode);
    }

    public function get_chats_open_ai(Request $request)
    {
        $id_user        = Auth::user()->id;  
        $token          = env('BEARER_TOKEN');
        $endpoint       = env('ENDPOINT_OPENAI');
        $asistente      = $request->asistente;
        $asistente_id   = env($asistente);
        $contexto       = $request->contexto;
        $ruta           = '/protected/answers';
        $existe_thread  = UserThread::where('user_id', $id_user)->where('asistente_id', '=', $asistente_id)->where('contexto', '=', $contexto)->first();

        if ($existe_thread)
            $thread_id = $existe_thread->thread_id;
        else
            return ['messages' => [], 'thread_id' => []];

        $form_params    = ['id_thread' => $thread_id];
        $json           = []; // Asegúrate de inicializar $json para que esté disponible en el catch
        $statusCode     = 500; // Un código de estado por defecto en caso de error

        $client = new \GuzzleHttp\Client(['headers' => ['Authorization' => 'Bearer ' . $token, 'Content-Type' => 'application/json']]);

        try {
            $res        = $client->request('POST', $endpoint . $ruta, ['form_params' => $form_params]);
            $statusCode = $res->getStatusCode();
            $response   = $res->getBody()->getContents();
            $json       = json_decode($response, true);

        } catch (\Throwable $th) {
            UserThread::where('user_id', $id_user)->where('asistente_id', '=', $asistente_id)->where('contexto', '=', $contexto)->delete();
        } finally {
            // El bloque finally es opcional aquí y se usaría si necesitas ejecutar código que debe correr tanto si hay una excepción como si no la hay
            return response()->json(['response' => $json], $statusCode);
        }

        // Retornar fuera de try-catch asegura que se retorne tanto en éxito como en fallo
    }
}
