<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\User;
use App\Solicitud;

use DB;
use Validator;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Facades\Excel;

use App\Http\Controllers\UtilController;
use App\Export\ExportSolicitudes;

class RevisorController extends Controller
{
    //------------------------------------------------------------
    public function page($tp_destino)
    {
        $destino    =   '';
        $id_usuario =   Auth::user()->id;
        $id_rol     =   Auth::user()->id_rol;
        $rol_actual =   UtilController::getRolActivo($id_usuario);
        $roles      =   UtilController::listarRolesUsuario($id_usuario);

        if($tp_destino === 'inicio')
            $destino = 'revisor.inicio_revisor';

        if($tp_destino == 'ingreso')
            $destino = 'revisor.ingreso_revisor';

        if($tp_destino === 'solicitud')
            $destino = 'revisor.bandeja_revisor';

        return view($destino)
                ->with('id_rol',$id_rol)
                ->with('rol_actual',$rol_actual)
                ->with('data',$roles)
                ->with('count',count($roles));
    }
    //------------------------------------------------------------
    public function index(Request $request)
    {
        $id_rol         =   Auth::user()->id_rol;
        $tp_admin       =   Auth::user()->tp_admin;
        $nr_direccion   =   Auth::user()->id_direccion;
        $nr_depto       =   Auth::user()->id_depto;
        $fl_mostrar     =   $request->fl_mostrar;
        $fl_direccion   =   $request->fl_direccion;
        $fl_depto       =   $request->fl_depto;
        $fl_servicio    =   $request->fl_servicio;
        $fl_macrozona   =   $request->fl_macrozona;
        $fl_undvecinal  =   $request->fl_unidadvecinal;
        $fl_ticket      =   $request->fl_ticket;
        $fl_ingreso     =   $request->fl_ingreso;
        $fl_vecino      =   $request->fl_persona;
        $fl_motivo      =   $request->fl_motivo;
        $fl_ubicacion   =   $request->fl_ubicacion;
        $tp_criterio    =   $request->tp_criterio;
        $tp_orden       =   $request->tp_orden;
        $page           =   $request->page;
        $fc_desde       =   $request->fc_desde;
        $fc_hasta       =   $request->fc_hasta;
        $tp_validar     =   $request->tp_validar;

        $data           =   Solicitud:: 
                            join('gsut_prioridad as prioridad','prioridad.id','=','gsut_solicitud.id_prioridad')
                            ->join('gsut_motivo as motivo','motivo.id','=','gsut_solicitud.id_motivo')
                            ->join('gsut_tipo as tipo','tipo.id','=','gsut_solicitud.id_tipo')
                            ->join('gsut_estado as estado','estado.id','=','gsut_solicitud.id_estado')
                            ->join('gsut_direccion as dir_destino','dir_destino.id','=','gsut_solicitud.id_direccion_destino')
                            ->join('gsut_depto as depto_destino','depto_destino.id','=','gsut_solicitud.id_depto_destino')
                            ->leftjoin('gsut_macroterritorio as mt','mt.id','=','gsut_solicitud.id_macroterritorio')
                            ->leftjoin('gsut_unidadvecinal as uv','uv.id','=','gsut_solicitud.id_unidadvecinal')
                            ->leftjoin('gsut_distribucion_territorio as dt', function ($join) 
                            {
                                $join->on('dt.nr_id','=','mt.id')
                                     ->where('dt.tp_tabla','=','tb_macroterritorio');
                            })
                            ->join('gsut_tipo_ingreso as ti','ti.id','=','gsut_solicitud.tp_ingreso')
                            ->select('gsut_solicitud.id',
                                'gsut_solicitud.nr_ticket',
                                'gsut_solicitud.id_municipio',
                                'gsut_solicitud.id_direccion',
                                'gsut_solicitud.id_depto',
                                'gsut_solicitud.id_tipo',
                                'gsut_solicitud.nm_tipo',
                                'gsut_solicitud.id_prioridad',
                                'gsut_solicitud.id_motivo',
                                'motivo.nm_motivo',
                                'gsut_solicitud.tp_clonado',
                                'gsut_solicitud.nr_fuente',
                                'gsut_solicitud.id_direccion_destino',
                                'dir_destino.nm_direccion as nm_direccion_destino',
                                'gsut_solicitud.id_depto_destino',
                                'depto_destino.nm_depto as nm_depto_destino',
                                'gsut_solicitud.id_ubicacion',
                                'gsut_solicitud.id_macroterritorio',
                                'mt.cod_territorio',
                                'gsut_solicitud.id_unidadvecinal',
                                'uv.cod_unidadvecinal',
                                'uv.nm_unidadvecinal',
                                'gsut_solicitud.tp_direccion',
                                'gsut_solicitud.nr_direccion',
                                'gsut_solicitud.nm_direccion',
                                'gsut_solicitud.nm_ubicacion',
                                'gsut_solicitud.str_latitud',
                                'gsut_solicitud.str_longitud',
                                'gsut_solicitud.nr_rut_vecino',
                                'gsut_solicitud.str_observacion',
                                'gsut_solicitud.str_observacion_html',
                                'gsut_solicitud.str_aclaratoria',
                                'gsut_solicitud.tp_visado_mt',
                                'gsut_solicitud.tp_rechazado',
                                'gsut_solicitud.id_estado',
                                'estado.nm_estado',
                                'estado.nm_color',
                                'gsut_solicitud.contexto_municipal',
                                'gsut_solicitud.tp_ingreso',
                                'ti.nm_ingreso',
                                'gsut_solicitud.id_autor',
                                'gsut_solicitud.tp_activo',
                                'gsut_solicitud.tp_feedback',
                                'gsut_solicitud.tp_recepcion',
                                'gsut_solicitud.tp_satisfaccion',
                                'gsut_solicitud.str_feedback',
                                'gsut_solicitud.fc_creacion as fc_ingreso',
                                'gsut_solicitud.fc_publicado',
                                'gsut_solicitud.created_at',
                                'gsut_solicitud.updated_at as fc_tramitacion')
                            ->selectRaw("(case when tp_vecino = 1 then 'SI' else 'NO' end) as tp_vecino")
                            ->where('gsut_solicitud.tp_activo','=',1)
                            //->orderBy('gsut_solicitud.created_at','DESC')
                            ->with('tipo','prioridad','vecino','archivos','ubicacion','asignados','archivos_asignacion','solicitud','derivacion');

        /* ----- Inicio - Filtro ----- */
            if($fl_mostrar != 0)
            {
                if($fl_mostrar != 5)
                    $data   =   $data->where('gsut_solicitud.id_estado','=',$fl_mostrar);
                else
                    $data   =   $data->whereIn('gsut_solicitud.id_estado',[5,6]);
            }

            if(isset($fl_direccion)) 
                $data   =   $data->where('gsut_solicitud.id_direccion_destino','=',$fl_direccion);

            if(isset($fl_depto)) 
                $data   =   $data->where('gsut_solicitud.id_depto_destino','=',$fl_depto);

            if(isset($fl_ingreso))
                $data   =   $data->where('gsut_solicitud.tp_ingreso','=',$fl_ingreso);

            if(isset($fl_servicio))
                $data   =   $data->where('gsut_solicitud.id_tipo','=',$fl_servicio);

            if(isset($fl_macrozona))
                $data   =   $data->where('gsut_solicitud.id_macroterritorio','=',$fl_macrozona);

            if(isset($fl_undvecinal))
                $data   =   $data->where('gsut_solicitud.id_unidadvecinal','=',$fl_undvecinal);

            if(isset($fl_ticket))
                $data   =   $data->where('gsut_solicitud.nr_ticket','=',$fl_ticket);

            if(isset($fl_vecino))
                $data   =   $data->where('gsut_solicitud.nr_rut_vecino','=',$fl_vecino);

            if(isset($fl_motivo))
                $data   =   $data->where('gsut_solicitud.id_motivo','=',$fl_motivo);

            if(isset($fl_ubicacion))
                $data   =   $data->where('gsut_solicitud.id_ubicacion','=',$fl_ubicacion);

            if(isset($fc_desde) && isset($fc_hasta))
            {
                $fc_desde   =   Carbon::parse($fc_desde)->format('Y-m-d');
                $fc_hasta   =   Carbon::parse($fc_hasta)->format('Y-m-d');
                $data       =   $data->whereDate('gsut_solicitud.created_at','>=',$fc_desde)
                                     ->whereDate('gsut_solicitud.created_at','<=',$fc_hasta);
            }
        /* ----- Termino - Filtro ----- */

        /*----- Inicio - Orden por Campos -----*/
            if(in_array($tp_criterio, ['id','id_macroterritorio','id_unidadvecinal','created_at']))
                $data   =   $data->orderBy('gsut_solicitud.'.$tp_criterio, $tp_orden);

            if($tp_criterio === 'nm_direccion')
                $data   =   $data->orderBy('dir_destino.nm_direccion',$tp_orden);

            if($tp_criterio === 'nm_depto')
                $data   =   $data->orderBy('depto_destino.nm_depto',$tp_orden);

            if($tp_criterio === 'nm_estado')
                $data   =   $data->orderBy('estado.nm_estado',$tp_orden);
        /*----- Termino - Orden por Campos -----*/

        $data   =   $data->groupBy('gsut_solicitud.id')->paginate(20);

        $data->getCollection()->transform(function ($value) use ($id_rol) {
            $value->tiempo_tramitado    =   UtilController::getTiempoTramitacion($value->fc_ingreso, $value->fc_publicado, $value->id_estado);
            $value->tiene_pp            =   (UtilController::getCantidadRespuestas(2, $value->id) != 0) ? 'SI' : 'NO'; // Tiene Publicaciones Parciales
            $value->is_admin            =   ($id_rol == 7) ? 1 : 0;
            return $value;
        });

        return [
            'pagination' => [
                'total'        => $data->total(),
                'current_page' => $data->currentPage(),
                'per_page'     => $data->perPage(),
                'last_page'    => $data->lastPage(),
                'from'         => $data->firstItem(),
                'to'           => $data->lastItem(),
            ],
            'info'      => $data,
        ];
    }
    //------------------------------------------------------------
}
