<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class BuscarRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
        {
            return              
                    [  
                        'g-recaptcha-response' => 'required|captcha'
                    ];
        }


    public function messages()
        {
            return  [       'required'   => 'El campo :attribute es requerido.',
                            'captcha'    => 'Completar captcha.',
        ];
                    
        }


        public function attributes()
            {
                return ['captcha'      => 'Captcha'];
            }
}
