<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

use DB;
use App\Http\Controllers\UtilController;

class Solicitud extends Model
{
    protected $table        =   'gsut_solicitud';
    protected $primaryKey   =   'id';
    protected $fillable     =   [
                                    'key_uuid',
                                    'nr_anio',
                                    'nr_mes',
                                    'nr_dia',
                                    'nr_folio',
                                    'nr_ticket',
                                    'id_municipio',
                                    'id_direccion',
                                    'id_depto',
                                    'id_tipo',
                                    'nm_tipo',
                                    'id_prioridad',
                                    'id_motivo',
                                    'tp_interno',
                                    'id_direccion_destino',
                                    'id_depto_destino',
                                    'id_ubicacion',
                                    'id_macroterritorio',
                                    'id_unidadvecinal',
                                    'tp_direccion',
                                    'nr_direccion',
                                    'nm_direccion',
                                    'nm_ubicacion',
                                    'str_latitud',
                                    'str_longitud',
                                    'nr_rut_vecino',
                                    'str_observacion',
                                    'str_observacion_html',
                                    'str_aclaratoria',
                                    'fc_creacion',
                                    'tp_clonado',
                                    'str_clonado',
                                    'str_clonado_html',
                                    'nr_fuente',
                                    'tp_visado_mt',
                                    'fc_visado_mt',
                                    'tp_asignador',
                                    'fc_asignador',
                                    'str_rechazado',
                                    'tp_rechazado',
                                    'fc_derivado',
                                    'fc_publicado',
                                    'fc_finalizado',
                                    'tp_revisado',
                                    'fc_revisado',
                                    'tp_director',
                                    'fc_director',
                                    'tp_jefedepto',
                                    'fc_jefedepto',
                                    'tp_feedback',
                                    'fc_feedback',
                                    'tp_recepcion',
                                    'tp_satisfaccion',
                                    'str_feedback',
                                    'tp_feedback_vecino',
                                    'fc_feedback_vecino',
                                    'tp_satisfaccion_vecino',
                                    'str_feedback_vecino',
                                    'id_estado',
                                    'contexto_municipal',
                                    'tp_ingreso',
                                    'id_autor',
                                    'id_rol',
                                    'tp_vecino',
                                    'id_telefonista',
                                    'id_estado_encuesta',
                                    'str_estado_encuesta',
                                    'tp_utilizar_encuesta',
                                    'tp_utilizar_telefonista',
                                    'token_report',
                                    'token_report_expires_at',
                                    'token_report_used',
                                    'tp_activo'
                                ];

    public $timestamps = true;
    //-----------------------------------------------------------
    public function tipo()
    {
        return $this->belongsTo('App\Tipo','id_tipo','id')
                    ->join('gsut_direccion as dir','dir.id','=','gsut_tipo.id_direccion')
                    ->join('gsut_depto as depto','depto.id','=','gsut_tipo.id_depto')
                    ->select(['gsut_tipo.id',
                        'gsut_tipo.id_direccion',
                        'gsut_tipo.id_depto',
                        'gsut_tipo.nm_tipo',
                        'dir.nm_direccion',
                        'depto.nm_depto']);
    }
    //-----------------------------------------------------------
    public function prioridad()
    {
        return $this->belongsTo('App\Prioridad','id_prioridad','id')
                    ->select(['id','nm_prioridad','color_prioridad','tp_tiempo','timer_atencion','tp_activo']);
    }
    //-----------------------------------------------------------
    public function direccion()
    {
        return $this->belongsTo('App\Direccion','id_direccion','id')
                    ->select(['id','nm_direccion','tp_activo']);
    }
    //-----------------------------------------------------------
    public function vecino()
    {
        return $this->belongsTo('App\Vecino','nr_rut_vecino','nr_rut')
               ->select([
                    'nr_rut',
                    'nm_vecino',
                    'ap_paterno',
                    'ap_materno',
                    DB::raw('(concat(nm_vecino," ",ap_paterno," ",ap_materno)) as nmc_vecino'),
                    'id_region',
                    'id_comuna',
                    'id_ubicacion',
                    'id_macroterritorio',
                    'id_unidadvecinal',                                    
                    'nr_calle',
                    'nm_calle',
                    'nm_ubicacion',
                    'tp_direccion',
                    'str_latitud',
                    'str_longitud',
                    'str_aclaratoria',
                    'nr_prefijo',
                    'nr_telefono',
                    'nm_mail',
                    'tp_vecino',
                    'id_autor',
                    'tp_activo'
               ]);
    }
    //-----------------------------------------------------------
    public function ubicacion()
    {
        return $this->belongsTo('App\MaestroDirecciones','id_ubicacion','id')
                    ->select(['id',
                        'tp_via',
                        'nr_calle',
                        'nm_calle',
                        'nm_direccion',
                        'rol_sii',
                        'str_latitud',
                        'str_longitud',
                        'cod_territorial',
                        'cod_unidadvecinal',
                        'tp_activo']);
    }
    //-----------------------------------------------------------
    public function archivos()
    {
        return  $this->hasMany('App\Archivos','nr_id','id')
                     ->where('tp_tabla','=','tb_solicitud');
    }
    //-----------------------------------------------------------
    public function asignados()
    {
        return $this->hasMany('App\EncargadoSolicitud','id_solicitud','id')
                ->join('users as u','u.id','=','gsut_encargado_solicitud.id_encargado')
                ->join('gsut_direccion as dir','dir.id','=','u.id_direccion')
                ->join('gsut_depto as depto','depto.id','=','u.id_depto')
                ->select([
                    'gsut_encargado_solicitud.id_solicitud',
                    'gsut_encargado_solicitud.id_encargado',
                    DB::raw('concat(u.nombre," ",u.ap_paterno," ",u.ap_materno) as nm_funcionario'),
                    'dir.nm_direccion',
                    'depto.nm_depto',
                    'gsut_encargado_solicitud.fc_asignado',
                    'gsut_encargado_solicitud.tp_activo'
                ])
                ->where('gsut_encargado_solicitud.tp_activo','=',1);
    }
    //-----------------------------------------------------------
    public function archivos_asignacion()
    {
        return  $this->hasMany('App\Archivos','nr_id','id')
                     ->where('tp_tabla','=','tb_asignacion');
    }
    //-----------------------------------------------------------
    public function solicitud()
    {
        return  $this->belongsTo('App\Solicitud','nr_fuente','id')
                    ->join('gsut_tipo as servicio','servicio.id','=','gsut_solicitud.id_tipo')
                    ->join('gsut_depto as depto','depto.id','=','servicio.id_depto')
                    ->join('gsut_direccion as dir','dir.id','=','servicio.id_direccion')
                    ->select([
                        'gsut_solicitud.id',
                        'gsut_solicitud.nr_ticket',
                        'gsut_solicitud.nm_tipo',
                        'depto.nm_depto',
                        'dir.nm_direccion',
                        'gsut_solicitud.fc_creacion',
                        'gsut_solicitud.tp_activo'
                    ]);
    }
    //-----------------------------------------------------------
    public function derivacion()
    {
        return  $this->hasMany('App\Historial','id_solicitud','id')
                    ->join('gsut_tipo as servicio','servicio.id','=','gsut_historial.id_tipo')
                    ->join('gsut_direccion as dir_servicio','dir_servicio.id','=','servicio.id_direccion')
                    ->join('gsut_depto as depto_servicio','depto_servicio.id','=','servicio.id_depto')
                    ->select(['gsut_historial.id',
                            'gsut_historial.id_solicitud',
                            'gsut_historial.nr_historia',
                            'gsut_historial.id_tipo',
                            'gsut_historial.id_direccion',
                            'gsut_historial.id_depto',
                            'gsut_historial.id_autor',
                            'servicio.nm_tipo',
                            'dir_servicio.nm_direccion',
                            'depto_servicio.nm_depto',
                            'gsut_historial.fc_inicio',
                            'gsut_historial.fc_termino',
                            DB::raw('date_format(gsut_historial.fc_inicio,"%d-%m-%Y %H:%i") as fc_inicio_derivacion'),
                            DB::raw('date_format(gsut_historial.fc_termino,"%d-%m-%Y %H:%i") as fc_termino_derivacion'),
                            'gsut_historial.id_estado'])
                    ->whereIn('gsut_historial.id_estado',[1,8,9,10])
                    ->where('gsut_historial.tp_activo','=','1');
    }
    //-----------------------------------------------------------
    public function publicacion()
    {
        return  $this->hasMany('App\Respuesta','id_solicitud','id')
                    ->where('tp_activo','=','1')
                    ->where('tp_respuesta','=','1')
                    ->select([
                                'id',
                                'id_solicitud',
                                'fc_ingreso',
                                'str_observacion',
                                'str_observacion_html',
                                'tp_respuesta'
                            ]);
    }
    //-----------------------------------------------------------
    public function respuestas_para_vecino()
    {
        return  $this->hasMany('App\Respuesta','id_solicitud','id')
                    ->where('tp_activo','=','1')
                    ->whereIn('tp_respuesta',[1,2])
                    ->select([
                                'id',
                                'id_solicitud',
                                'fc_ingreso',
                                'str_observacion',
                                'str_observacion_html',
                                'tp_respuesta',
                                DB::raw('(case 
                                    when tp_respuesta = 1 then "Publicación Definitiva" 
                                    when tp_respuesta = 2 then "Publicación Parcial" 
                                    else "Respuesta" end) as nm_respuesta')
                            ]);
    }
    //-----------------------------------------------------------
    public function encuesta_parcial()
    {
        /*
        return  $this->hasMany('App\EncuestaLlamada','id_solicitud','id')
                ->join('gsut_encuesta_respuestas as er','er.id_llamada','=','gsut_encuesta_llamada.id')
                ->where('gsut_encuesta_llamada.id_estado','=','2')
                ->orderBy('gsut_encuesta_llamada.fc_inicio','DESC');


                return $this->hasManyThrough('App\Ticket_TipoTicket','App\Ticket_TipoSolicitud_Depto',
                                    'id','id',
                                    'idtipo','id_tipo')
                                ->select(['ticket_tiposolicitud_depto.id as value',
                              'ticket_tipo.id as id_solicitud',
                              'ticket_tiposolicitud_depto.id as id_ttsd',
                              'ticket_tipo.nm_tipo as label',
                              'id_depto']);
        */
    }
    //-----------------------------------------------------------
    public function agendados()
    {
        return  $this->hasManyThrough('App\EncuestaRespuesta','App\EncuestaLlamada',
                                        'id_solicitud','id_llamada',
                                        'id','id')
                ->join('gsut_encuesta_pregunta as pregunta','pregunta.id','=','gsut_encuesta_respuestas.id_pregunta')
                ->where('pregunta.tp_pregunta','=','4');
    }
    //-----------------------------------------------------------
    public function createTokenTicket()
    {
        $str_token  =   UtilController::generarUniqueTokenToTicketReport();
        $this->token_report             =   $str_token;
        $this->token_report_expires_at  =   now()->addHours(24);
        $this->save();
    }
    //-----------------------------------------------------------
}
