<?php

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Contracts\Auth\CanResetPassword;
use App\Notifications\ResetPasswordNotification;
use Illuminate\Support\Facades\Auth;
use DB;

class User extends Authenticatable  
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'id_municipio',
        'id_direccion',
        'id_depto',
        'rut',
        'nombre',
        'ap_paterno',
        'ap_materno',
        'name',
        'movil',
        'email',
        'tp_derivar',
        'password',
        'tp_admin',
        'tp_activo',
        'id_rol',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function generateToken()
    {
        $this->api_token = str_random(60);
        $this->save();

        return $this->api_token;
    }

    public function direccion()
    {
        return $this->belongsTo('App\Direccion','id_direccion','id')
                    ->select(['id as value','nm_direccion as label','tp_activo','id'])
                    ->where('tp_activo','=',1);
    }

    public function depto()
    {
        return $this->belongsTo('App\Depto','id_depto','id')
                    ->select(['id as value','nm_depto as label','tp_activo','id'])
                    ->where('tp_activo','=',1);
    }

    public function macrozona()
    {
        return  $this->hasManyThrough('App\MacroTerritorio','App\DistribucionTerritorio','id_user','id','id','nr_id')
                    ->select(['gsut_macroterritorio.id as value','gsut_macroterritorio.cod_territorio as label'])
                    ->where('gsut_distribucion_territorio.tp_tabla','=','tb_macroterritorio');
    }

    public function unidadvecinal()
    {
        return  $this->hasManyThrough('App\UnidadVecinal','App\DistribucionTerritorio','id_user','id','id','nr_id')
                    ->join('gsut_unidadvecinal_macroterritorio as mt','mt.id_unidadvecinal','=','gsut_unidadvecinal.id')
                    ->select(['gsut_unidadvecinal.id as id_unidadvecinal','gsut_unidadvecinal.nm_unidadvecinal','mt.id_macroterritorio as value'])
                    ->where('gsut_distribucion_territorio.tp_tabla','=','tb_unidadvecinal');
    }

    public function roles()
    {
        return  $this->hasMany('App\User_rol','id_user','id')
                    ->join('gsut_roles as roles','roles.id','=','gsut_user_rol.id_rol')
                    ->join('users as funcionario','funcionario.id','=','gsut_user_rol.id_user')
                    ->join('gsut_direccion as dir','dir.id','=','funcionario.id_direccion')
                    ->join('gsut_depto as depto','depto.id','=','funcionario.id_depto')
                    ->select(['gsut_user_rol.id',
                        'gsut_user_rol.id_user',
                        'gsut_user_rol.id_rol',
                        'roles.nombre as nm_rol',
                        'funcionario.name',
                        'funcionario.tp_admin',
                        DB::raw('(case 
                            when funcionario.tp_admin = 1 then "Administrador Global" 
                            when funcionario.tp_admin = 2 then "Administrador de Dirección" 
                            when funcionario.tp_admin = 3 then "Administrador de Depto." 
                            when funcionario.tp_admin = 0 then "Ninguno" 
                        end) as nm_admin'),
                        'dir.nm_direccion',
                        'depto.nm_depto']);
    }

    /**
     * Send the password reset notification.
     *
     * @param  string  $token
     * @return void
     */
    public function sendPasswordResetNotification($token)
    {
        $this->notify(new ResetPasswordNotification($token));
    }

    public function isRelacionesPublicas()
    {
        return (Auth::user()->id_depto === 92);
    }
}
