<?php
 
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
 
class CreateGsutRoles extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('gsut_roles', function (Blueprint $table) {
            $table->increments('id');
            $table->string('nombre', 100);
            $table->string('descripcion', 100)->nullable();
            $table->boolean('condicion')->default(1);          
            $table->string('str_sidebar')->nullable();          
            $table->string('nm_cabecera')->nullable();          
            $table->integer('tp_agrupacion')->nullable();  
            $table->integer('tp_cabecera')->nullable();  
			$table->timestamps();

        });
      
        DB::table('gsut_roles')->insert(array(   'id'            =>  '1',
                                            'nombre'        =>  'Administrador', 
                                            'descripcion'   =>  'Administrador Sistema',
                                            'str_sidebar'   =>  'plantilla.sidebarAdministrador',
                                            'nm_cabecera'   =>  'ADMINISTRADOR'
    ));

      /*  DB::table('roles')->insert(array('id'=>'2','nombre'=>'Usuario FONDEVE', 'descripcion'=>'Administradores Sistema FONDEVE')); */
        //DB::table('roles')->insert(array('id'=>'3','nombre'=>'Almacenero', 'descripcion'=>'Almacenero área compras'));
 
    }
 
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('gsut_roles');
    }
}