<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGsutDistribucionTerritorioTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('gsut_distribucion_territorio', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('tp_tabla',50)->nullable(); // Tabla Territorial o Unidad Vecinal
            $table->integer('nr_id')->unsigned(); // id tabla relacionada 
            $table->integer('id_user')->unsigned(); // usuario encargado 
            $table->integer('tp_cargo')->default(1); // 1- territorial | 2- Jefe MT | 3- Jefe Territorial
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('gsut_distribucion_territorio');
    }
}
