<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGsutTipoTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('gsut_tipo', function(Blueprint $table)
		{
			$table->bigIncrements('id');
			$table->integer('id_direccion')->unsigned()->default(0);
			$table->integer('id_depto')->nullable();
			$table->string('nm_tipo', 150);
			$table->text('str_tipo')->nullable();
			$table->text('str_tipo_html')->nullable();
			$table->integer('tp_ubicacion')->unsigned()->default(1);
            $table->integer('tp_macrozona')->default(1);
            $table->integer('tp_asignacion')->default(1);
            $table->integer('tp_director')->default(1);
            $table->integer('tp_depto')->default(1);
            $table->integer('nr_nivel')->default(3);
			$table->integer('tp_activo')->unsigned()->default(1);
			$table->timestamps();
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::dropIfExists('gsut_tipo');
	}

}
