<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGsutEncargadoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('gsut_encargado', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_despacho')->nullable();
            $table->integer('id_encargado')->nullable();
            $table->integer('tp_revisar')->unsigned()->default(0);
            $table->integer('tp_responsable')->unsigned()->default(0);
            $table->integer('tp_participante')->unsigned()->default(0);
            $table->integer('tp_validado')->unsigned()->default(0);
            $table->dateTime('fc_validado')->nullable();
            $table->integer('id_autor')->nullable();
            $table->integer('tp_activo')->unsigned()->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('gsut_encargado');
    }
}
