<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGsutHistorialTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('gsut_historial', function(Blueprint $table)
		{
			$table->bigIncrements('id');
			$table->integer('id_solicitud')->unsigned();
			$table->integer('nr_historia')->unsigned();
			$table->integer('id_tipo')->unsigned();
			$table->integer('id_direccion')->unsigned();
			$table->integer('id_depto')->unsigned();
			$table->integer('id_autor')->unsigned();
			$table->dateTime('fc_inicio')->nullable();
			$table->dateTime('fc_termino')->nullable();
			$table->text('str_observacion', 65535)->nullable();
			$table->text('str_observacion_html', 65535)->nullable();
			$table->integer('id_estado')->unsigned();
			$table->integer('id_accion')->unsigned()->default(0);
			$table->integer('tp_activo')->unsigned()->default(1);
			$table->timestamps();
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::dropIfExists('gsut_historial');
	}

}
