<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGsutNotificacionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('gsut_notificacion', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('nr_solicitud')->unsigned()->default(0);
            $table->string('nr_ticket', 150)->nullable();
            $table->string('desde', 150)->nullable();
            $table->text('para')->nullable();
            $table->integer('tp_notificacion')->unsigned()->default(1);
            $table->string('str_asunto', 150)->nullable();
            $table->integer('tp_activo')->unsigned()->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('gsut_notificacion');
    }
}
