<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGsutEncuestaLlamadaTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('gsut_encuesta_llamada', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('id_solicitud')->unsigned();
            $table->integer('id_autor')->unsigned();
            $table->string('nr_rut', 20);
            $table->dateTime('fc_inicio')->nullable();
            $table->dateTime('fc_termino')->nullable();
            $table->dateTime('fc_inicio_contacto')->nullable();
            $table->dateTime('fc_termino_contacto')->nullable();
            $table->dateTime('fc_inicio_servicio')->nullable();
            $table->dateTime('fc_termino_servicio')->nullable();
            $table->integer('id_estado')->unsigned();
            $table->integer('tp_activo')->unsigned()->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('gsut_encuesta_llamada');
    }
}
