<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGsutRespuestaServicioTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('gsut_respuesta_servicio', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('nr_respuesta')->unsigned()->default(1);
            $table->integer('id_direccion')->unsigned();
            $table->integer('id_depto')->unsigned();
            $table->integer('id_tipo')->unsigned();
            $table->integer('tp_respuesta')->unsigned();
            $table->integer('nr_tiempo')->nullable();
            $table->text('str_respuesta')->nullable();
            $table->text('str_respuesta_html')->nullable();
            $table->date('fc_inicio')->nullable();
            $table->date('fc_termino')->nullable();
            $table->integer('tp_activo')->unsigned()->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('gsut_respuesta_servicio');
    }
}
