<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddAtributosTokenTicketInGsutSolicitud extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('gsut_solicitud', function (Blueprint $table) {
            $table->string('token_report',250)->nullable()->after('tp_utilizar_telefonista');
            $table->dateTime('token_report_expires_at')->nullable()->after('token_report');
            $table->boolean('token_report_used')->default(false)->after('token_report_expires_at');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('gsut_solicitud', function (Blueprint $table) {
            $table->dropColumn('token_report');
            $table->dropColumn('token_report_expires_at');
            $table->dropColumn('token_report_used');
        });
    }
}
