<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAnalisisSentimientoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('analisis_sentimiento', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->text('str_observacion')->nullable();
            $table->double('neutral_score', 8, 2)->nullable();
            $table->double('positive_score', 8, 2)->nullable();
            $table->double('negative_score', 8, 2)->nullable();
            $table->double('mixed_score', 8, 2)->nullable();
            $table->dateTime('processed_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('analisis_sentimiento');
    }
}
