@extends('Template.adminlte')

@section('main-title')
    {{ 'Administración de Usuarios' }}
@endsection

@section('main-navigation')
    <li class="">Administración</li>
    <li class="active">Ingreso de Solicitud</li>
@endsection

@push('styles')
    <style>
        .chart-container {
            height: 600px;
        }

        @media screen and (min-width: 1200px) {
            .chart-container {
              height: 800px;
            }
        }

        .mt-5 {
            margin-top: 2rem;
        }
    </style>
@endpush()

@section('main-content')
    <div class="box" id="app">
        
    <div class="card mt-2 ml-2 mr-2">
        <div class="card-header bg--primary">
            Filtros de Búsqueda
        </div>
        <div class="card-body">

            <div class="row">

                <div class="col-md-3">
                    <div class="form-group">
                        <label>Búsqueda:</label>
                        <select v-model="criterio"  class="form-control">
                            <option value="nombre">Nombre</option>
                            <option value="ap_paterno">Apellido Paterno</option>
                            <option value="ap_materno">Apellido Materno</option>
                            <option value="email">Email</option>
                            <option value="rut">Rut</option>
                            <option value="movil">Teléfono</option>
                        </select>
                    </div>
                </div>

                <div class="col-md-2">
                    <div class="form-group">
                    <label>Texto a buscar:</label>
                        <input @keyup.enter="listarUser(1,buscar,criterio)" type="text" v-model="buscar" class="form-control" placeholder="Texto a buscar">
                    </div>
                </div>

                <div class="col-md-2">
                    <div class="form-group">
                    <label>Unidad:</label>
                        <select v-model="id_direccion"  class="form-control" > </select>
                    </div>
                </div>

                <div class="col-md-2">
                    <div class="form-group">
                    <label>Departamento:</label>
                    <select  class="form-control" > </select>
                       
                    </div>
                </div>

                <div class="col-md-1">
                <label style="visibility:hidden">Búsqueda:</label>
                    <button @click="listarUser(1,buscar,criterio)" type="submit" class="btn btn-block btn-primary"><i class="fas fa-search"></i> Buscar</button>
                </div>

                <div class="col-md-2">
                <label style="visibility:hidden">Crear Usuario:</label>
                    <button @click="abrirModal('user','registrar')"  class="btn btn-block btn-success"><i class="fas fa-plus"></i> Crear Usuario</button>
                </div>

            </div>

        </div>
    </div>

            <div class="x_content">
                <div class="col-md-12 col-sm-12 mt-5">
                    <div class="content__panel">
                    <div class="content__buttons">
                        <div class="table-responsive">
                            <table class="table table-sm table-bordered table-striped" id="tabla_jvecino">
                                <thead class="bg--primary">
                                    <tr>
                                        <th style="min-width: 90px;">Opciones</th>
                                        <th>Nombre</th>
                                        <th>Ap. Paterno</th>
                                        <th>Ap. Materno</th>
                                        <th>Rut</th>
                                        <th>Email</th>
                                        <th>Fono</th>
                                        <th>Dirección Municipal</th>
                                        <th>Departamento</th>
                                        <th>Rol</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <template v-if="arrayUser.length">
                                        <tr v-for="user in arrayUser" :key="user.id">
                                            <td style="min-width: 90px;">
                                                <div class="buttons">
                                                    <button type="button" @click="abrirModal('user','actualizar',user)" class="btn btn-sm btn-warning">
                                                        <i class="fas fa-pencil-alt"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-sm btn-danger" @click="deleteJvecino(user.id)">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </div>
                                            </td>
                                            <td v-text="user.nombre"></td>
                                            <td v-text="user.ap_paterno"></td>
                                            <td v-text="user.ap_materno"></td>
                                            <td v-text="user.rut"></td>
                                            <td v-text="user.email"></td>
                                            <td v-text="user.movil"></td>
                                            <td v-text="user.direccion"></td>
                                            <td v-text="user.nm_depto"></td>
                                            <td v-text="user.rol"></td>
                                           
                                        </tr> 
                                    </template>
                                    <template v-else>
                                        <td colspan="15">
                                            <div class="empty" empty-text="Sin registros para mostrar"></div>
                                        </td>
                                    </template>
                                </tbody>
                            </table>
                        </div>
                        <nav>
                            <ul class="pagination">
                                <li class="page-item" v-if="pagination.current_page > 1">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.current_page - 1,buscar,criterio)">Ant</a>
                                </li>
                                <li class="page-item" v-for="page in pagesNumber" :key="page" :class="[page == isActived ? 'active' : '']">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(page,buscar,criterio)" v-text="page"></a>
                                </li>
                                <li class="page-item" v-if="pagination.current_page < pagination.last_page">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.current_page + 1,buscar,criterio)">Sig</a>
                                </li>
                            </ul>
                        </nav>

                        <div class="modal" tabindex="-1" id="modaluser" >
                        <div class="modal-dialog modal-lg">
                        <div class="modal-content">
                        <div class="modal-header bg--primary">
                            <h5 class="modal-title" v-text="tituloModal"></h5>
                            <button type="button" class="close" @click="cerrarModal()" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <form action="" method="post" enctype="multipart/form-data">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">    
                                            <label>RUT:</label>
                                            <input @change="correccionRut(rut)" maxlength="15" v-model="rut" type="text" class="form-control" placeholder="11.111.111-1">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Nombre(*):</label>
                                            <input v-model="nombre" type="text" class="form-control" placeholder="Nombre" maxlength="50">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Apellido Paterno(*):</label>
                                            <input maxlength="50" v-model="ap_paterno" type="text" class="form-control" placeholder="Apellido Paterno">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Apellido Materno:</label>
                                            <input maxlength="50" v-model="ap_materno" type="text" class="form-control" placeholder="Apellido Materno">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Direccion(*):</label>
                                            <select @change="selectDeptos();" v-model="id_direccion" class="custom-select">
                                                <option :value="0">Seleccionar Dirección</option>
                                                <option v-for="dir in arrayUnidad" :key="dir.id" :value="dir.id" v-text="dir.nm_dir_municipalidad"></option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Departamento(*):</label>
                                            <select v-model="id_depto" class="custom-select">
                                                <option :value="0">Seleccionar Departamento</option>
                                                <option v-for="deptos in arrayDeptos" :key="deptos.id" :value="deptos.id" v-text="deptos.nm_depto"></option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group">
                                            <label>Rol/es(*):</label>
                                            <multiselect
                                                :show-labels="false"
                                                :searchable="true"
                                                v-model="salidaRoles"
                                                :options="optionRoles"
                                                :multiple="true"
                                                :clear-on-select="false"
                                                placeholder="Seleccionar Rol"
                                                label="label"
                                                track-by="label">
                                            </multiselect>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-sm-6">
                                        <div class="form-group">
                                            <label>Email:</label>
                                            <input maxlength="100" v-model="email" type="text" class="form-control" placeholder="Email">
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-sm-6">
                                        <div class="form-group">
                                            <label>Contraseña(*):</label>
                                            <input maxlength="8" v-model="clave" type="password" class="form-control" placeholder="Contraseña">
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-sm-6">
                                        <div class="form-group">
                                            <label>Fono:</label>
                                            <input onkeypress="return justNumbers(event);" maxlength="12" v-model="movil" type="text" class="form-control" placeholder="Fono">
                                        </div>
                                    </div>

                                </div>
                            </form>
                            <div v-show="errorPersonas" class="alert alert-danger" role="alert">
                                <div class="text-center">
                                    <div v-for="error in errorMostrarMsjuser" :key="error" v-text="error"></div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-light" @click="cerrarModal()">Cerrar</button>
                            <button type="button" v-if="tipoAccion==1" class="btn btn-primary" @click="registrarPersona()"><i class="fas fa-save"></i> Guardar</button>
                            <button type="button" v-if="tipoAccion==2" class="btn btn-primary" @click="actualizarPersonas()"><i class="fas fa-pen"></i> Actualizar</button>
                        </div>
                    </div>
                        </div>
                    </div>
                </div>
             </div>
        </div>
    </div>
</div>

    <script type="text/javascript">
        Vue.component('vue-multiselect', window.VueMultiselect.default);


var app = new Vue({
    el: '#app',
    data: {
        //---------------------Data Usuario------------
        modal           : 0,
        optionRoles     : [],
        salidaRoles     : [],
        optionFunciones : [],
        tipoAccion      : 1,
        tituloModal     : 'Registrar Usuario',
        id_depto        : 0,
        id_direccion    : 0,
        nombre          : '',
        ap_paterno      : '',
        ap_materno      : '',
        movil           : '',
        anexo           : '',
        email           : '',
        rut          : '',
        clave           : '',
        //------------------------------
        buscar                  :   '',
        criterio                :   'nombre',
        arrayUser               :   [],
        arrayUnidad             :   [],
        arrayDeptos             :   [],
        arrayRol                :   [],
        errorMostrarMsjuser     :   [],
        validationErrors        :   [],
        errorPersonas           : 0,
        pagination              : 
            {
                'total' : 0,
                'current_page' : 0,
                'per_page' : 0,
                'last_page' : 0,
                'from' : 0,
                'to' : 0,
            },
        offset                   :   3,
    },

    components: {
        Multiselect: window.VueMultiselect.default
    },
    filters:{
        resumir: function ($texto, $limite=90, $final=' ...->')
        {
            var largo = $texto.toString().length;
            if(largo > $limite){
                for (var i = 0; i < largo; i++) {
                    if($texto[i] == ' ' && i >= $limite){
                        $texto = $texto.substring(0,i);
                        $texto = $texto + $final;
                        return $texto;
                    }
                }                    
            }
            return $texto;
        },

        formatDate: function (fecha)
        {
            if(fecha)
                return moment(String(fecha)).format('DD-MM-YYYY')
            
        },

        formatDateTime: function (fecha)
        {
            if(fecha)
                return moment(String(fecha)).format('DD-MM-YYYY HH:mm')
        },
    },

    computed:{
        isActived: function()
            {
            return this.pagination.current_page;
            },

        pagesNumber: function() 
            {
                if(!this.pagination.to) {
                    return [];
                }
                
                var from = this.pagination.current_page - this.offset; 
                if(from < 1) {
                    from = 1;
                }

                var to = from + (this.offset * 2); 
                if(to >= this.pagination.last_page){
                    to = this.pagination.last_page;
                }  

                var pagesArray = [];
                while(from <= to) {
                    pagesArray.push(from);
                    from++;
                }
                return pagesArray;             

            }
    },

    methods: 
    {  
        correccionRut(rut)
            {
                let me = this;
                var salida = Rut(rut);

                if(salida)
                    me.rut = salida;
            },
        registrarPersona()
            {
                let me = this;
                if (me.validarPersona())
                    return;

                axios.post('/user/registrar',{
                    'nombre': me.nombre.toUpperCase(),
                    'ap_paterno': me.ap_paterno.toUpperCase(),
                    'ap_materno': me.ap_materno.toUpperCase(),
                    'movil': me.movil,
                    'anexo': me.anexo,
                    'email': me.email.toLowerCase(),
                    'rut': me.rut,
                    'id_depto': me.id_depto,
                    'id_direccion': me.id_direccion,
                    'id_rol': me.salidaRoles,
                    'clave': me.clave,
                  }).then(function (response) {
                    me.cerrarModal();
                    me.listarUser(1,'','nombre');
                }).catch(function (error) {
                     
                if (error.response.status == 422)
                   {
                     validationErrors = error.response.data.errors;
                   
                  }
                });
            },
        validarEmail(valor) 
           {
               var validacion = formatoMail(valor);
               return validacion;
            },
        validaRut(text_rut,opcion)
            {
                let aux=null;
                aux = Rut(text_rut);
                if(aux)
                {
                    if(opcion == 1)
                      this.rut=aux;

                    if(opcion == 2)
                      this.rut_re=aux;

                    return true;
                }else
                     return false;
            },
        validarPersona()
            {
                let me                  = this;
                me.errorPersonas        =   0;
                me.errorMostrarMsjuser  =   [];

                if (!me.nombre) me.errorMostrarMsjuser.push("Ingresar Nombre.");
                if (!me.ap_paterno) me.errorMostrarMsjuser.push("Ingresar Apellido Paterno.");
                if (!me.ap_materno) me.errorMostrarMsjuser.push("Ingresar Apellido Materno.");
                if (!me.movil) me.errorMostrarMsjuser.push("Ingresar Fono.");
                if (!me.email) me.errorMostrarMsjuser.push("Ingresar Email.");
                
                if (!me.id_depto) me.errorMostrarMsjuser.push("Seleccionar Departamento al cual pertenece el usuario.");
                if (me.clave!="" &&  me.clave.length<4) 
                me.errorMostrarMsjuser.push("La contraseña debe tener como mínimo cuatro caracteres.");
                
                
                if(!me.salidaRoles.length) me.errorMostrarMsjuser.push("Seleccionar Rol al cual pertenece el usuario.");
                if(!me.validaRut(me.rut)) me.errorMostrarMsjuser.push("Rut Ingresado Incorrecto");
                if(!me.validarEmail(me.email)) me.errorMostrarMsjuser.push("Formato de email Incorrecto");

                if(me.errorMostrarMsjuser.length) me.errorPersonas = 1;
                return me.errorPersonas;

            },
        actualizarPersonas()
        {
            if (this.validarPersona())
                return;
            
            let me = this;
            axios.put('/user/actualizar',{
                'nombre'      : me.nombre.toUpperCase(),
                'ap_paterno'  : me.ap_paterno.toUpperCase(),
                'ap_materno'  : me.ap_materno.toUpperCase(),
                'movil'       : me.movil,
                'anexo'       : me.anexo,
                'email'       : me.email.toLowerCase(),
                'rut'      : me.rut,
                'id'          : me.persona_id,
                'id_depto'    : me.id_depto,
                'id_direccion': me.id_direccion,
                'id_rol'      : me.salidaRoles,
                'clave'       : me.clave,
            }).then(function (response) {
                console.log(response)
                me.cerrarModal();
                me.listarUser(1,'','nombre');
            }).catch(function (error) {
                console.log(error);
            }); 
        },
        cerrarModal()
        {
            let me          = this;
            $("#modaluser").toggle()
        },
        selectRolUser()
        {
            let me  =   this;
            var url =   '/selectRolesUsuario/?id_user='+me.persona_id
            axios.get(url).then(function (response) 
            {
                var respuesta   = response.data;
                me.salidaRoles  = respuesta.roles;
            })
            .catch(function (error) {
                console.log(error); 
            });
        }, 
        abrirModal(modelo, accion, data = [])
            {
            let me = this;
                switch(accion)
                {
                    case 'registrar':
                        {  
                            $(".text-error").html("")
                            $("#modaluser").show("show")
                            me.optionRoles  = [];
                            me.salidaRoles  = [];
                            me.tipoAccion   = 1;
                            me.tituloModal  = 'Registrar Usuario';
                            me.id_depto     = 0;
                            me.id_direccion = 0;
                            me.nombre       = '';
                            me.ap_paterno   = '';
                            me.ap_materno   = '';
                            me.movil        = '';
                            me.anexo        = '';
                            me.email        = '';
                            me.rut       = '';
                            me.clave        = '';
                            me.nr_grado     = 0;
                            me.nr_contrato  = 1;
                            me.nm_cargo     = '';
                            me.errorMostrarMsjuser =[];
                            me.selectDirecciones();
                            me.busquedaRoles();
                            break;
                        }
                                
                    case 'actualizar':
                        {
                            me.zero = 0;
                            $(".text-error").html("")
                            $("#modaluser").show("show")
                            me.tituloModal              = 'Actualizar datos de Usuario';
                            me.tipoAccion               = 2;
                            me.persona_id               = data['id'];
                            me.id_direccion             = data['id_direccion'];
                            me.id_depto                 = data['id_depto'];
                            me.nombre                   = data['nombre'];
                            me.ap_paterno               = data['ap_paterno'];
                            me.ap_materno               = data['ap_materno'];
                            me.movil                    = data['movil'];
                            me.email                    = data['email'];
                            me.rut                   = data['rut'];
                            me.id_rol                   = data['idrol'];
                            me.nr_grado                 = data['nr_grado'];
                            me.errorMostrarMsjuser      = [];
                            me.clave                    = '';
                            me.selectDirecciones();
                            me.selectDeptos();
                            me.busquedaRoles();
                            me.selectRolUser();
                            break;
                        }
                }
            },
        busquedaRoles()
            {
                let me      =   this;
                var url     = '/selectRolesSistema';
                axios.get(url).then(function (response) {
                    var respuesta       = response.data;
                    me.optionRoles      = respuesta.roles;
                })
                .catch(function (error) {
                    console.log(error);
                });
            },
        selectDeptos()
            {
                let me          =   this;
                let cant_depto  =   0;
                var url         =   '/selectDeptos?id_nr_direccion='+this.id_direccion;
                axios.get(url).then(function (response) 
                {
                    var respuesta= response.data;
                    me.arrayDeptos = respuesta.deptos;

                    

                })
                .catch(function (error) {
                    console.log(error);
                });
            },
        selectDirecciones()
            {
                let me=this;
                var url= '/selectDireccionMunicipal';

                axios.get(url).then(function (response) {
                    var respuesta   = response.data;
                    me.arrayUnidad  = respuesta.direcciones;
                })
                .catch(function (error) {
                    console.log(error);
                });
            },
        listarUser (page,buscar,criterio)
            {
                    let me=this;
                    var url= '/user?page=' + page + '&buscar='+ buscar + '&criterio='+ criterio+ '&tp_usuario=1';
                    axios.get(url).then(function (response) {
                        var respuesta= response.data;
                        me.arrayUser = respuesta.personas.data;
                        me.pagination= respuesta.pagination;
                    })
                    .catch(function (error) {
                        console.log(error);
                    });
                },
            },

        mounted() 
        {
            let me = this;
            me.listarUser(1,me.buscar,me.criterio);
        }
        });
    </script>

    
@endsection()


