@extends('template.home')

@section('body')
<div class="page-content">
    <div class="container-fluid" id="app">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18">Gestión de Usuarios</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Gestión de Usuarios</a></li>
                            <li class="breadcrumb-item active">Usuarios</li>
                        </ol>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-12 col-sm-12" style="text-align:right">
                        <button id="btn_actualizar" class="btn btn-success btn_activo" @click="abrirModal('usuario', 'registrar')">
                            <i class="fas fa-sync"></i> Crear Usuario
                        </button>

                        <button id="btn_actualizar" class="btn btn-primary btn_activo" @click="refrescarDatos();">
                            <i class="fas fa-sync"></i> Actualizar
                        </button>
                    </div>
                </div>

                <div class="row">
                    <!-- Buscar -->
                    <div class="col-lg-12 col-md-12 col-sm-12 mb-5">
                        <div class="row ml-2 mr-2">                            
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>Búsqueda por:</label>
                                    <select v-model="tp_criterio"  class="form-control">
                                        <option value="nombre">Nombre</option>
                                        <option value="ap_paterno">Apellido Paterno</option>
                                        <option value="ap_materno">Apellido Materno</option>
                                        <option value="email">Email</option>
                                        <option value="rut">Rut</option>
                                        <option value="movil">Teléfono</option>
                                        <option value="id_direccion">Dirección</option>
                                    </select>
                                </div>
                            </div>

                            <template v-if="tp_criterio != 'id_direccion'">
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Texto a buscar:</label>
                                        <input @keyup.enter="cargarDatos(tp_buscar, tp_criterio)" type="text" v-model="tp_buscar" 
                                            class="form-control" placeholder="Texto a buscar">
                                    </div>
                                </div>
                            </template>
                            <template v-else>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Seleccionar Dirección:</label>
                                        <select v-model="tp_buscar" class="form-control buscador">
                                            <option value="0">Seleccionar Dirección</option>
                                            <option v-for="direccion in arr_direccion" :value="direccion.value" v-text="direccion.label"></option>
                                        </select>
                                    </div>
                                </div>
                            </template>

                            <div class="col-md-2 mt-4">
                                <button @click="filtrarDatos()" type="button" class="btn btn-primary btn_activo"><i class="fas fa-search"></i>
                                    Realizar Búsqueda
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Tabla de Datos -->
                    <div class="responsive-table">
                        <table  class="table table-bordered border-info table-striped table-sm table-hover bl-1">
                            <thead class="bg-primary">
                                <th colspan="16" >
                                    <h6 class="text-center" style="color:white" >
                                        Listado de Usuarios
                                    </h6>
                                </th>
                            </thead>
                            <thead class="bg-primary ticky-header"  style="color:white">
                                <th class="text-center">#</th>
                                <th class="text-center">Opciones</th>
                                <th class="text-center">Nombre</th>
                                <th class="text-center">Ap. Paterno</th>
                                <th class="text-center">Ap. Materno</th>
                                <th class="text-center">Unidad Municipal</th>
                                <th class="text-center">Rol</th>
                                <th class="text-center">Tipo Administrador</th>
                                <th class="text-center">Publicación Definitiva</th>
                                <th class="text-center">Publicación Parcial</th>
                                <th class="text-center">Respuesta Interna</th>
                                <th class="text-center">Derivación Total</th>
                                <th class="text-center">Derivación Interna</th>
                                <th class="text-center">VB° Jefatura</th>
                                <th class="text-center">VB° Director</th>       
                                <th class="text-center">Estado</th>
                            </thead>
                            <tbody>
                                <template v-if="arr_index.length">
                                    <tr v-for="(datos, index) in arr_index" :key="datos.id">
                                        <td style="text-align:center;">
                                            @{{ (index + 1) }}
                                        </td>
                                        <td style="text-align:center;">
                                            <div class="dropdown">
                                                <button class="btn btn-secondary" type="button" id="menu_opcion" data-bs-toggle="dropdown" aria-expanded="false">
                                                    Opción <i class="mdi mdi-chevron-down"></i>
                                                </button>
                                                <div class="dropdown-menu" aria-labelledby="menu_opcion">
                                                    <!-- Actualizar Usuario -->
                                                    <a href="#" class="dropdown-item" 
                                                        @click="abrirModal('usuario', 'actualizar', datos)">
                                                            <i class="fas fa-edit" style="color: blue;"></i>
                                                            Actualizar Usuario
                                                    </a>

                                                    <!-- Inhabilitar Usuario -->
                                                    <a href="#" class="dropdown-item" v-if="datos.tp_activo == 1" 
                                                        @click="abrirModal('usuario', 'inhabilitar', datos)">
                                                            <i class="far fa-minus-square" style="color: red;"></i>
                                                            Inhabilitar Usuario
                                                    </a>
                                                    
                                                    <!-- Habilitar Usuario -->
                                                    <a href="#" class="dropdown-item" v-if="datos.tp_activo == 0" 
                                                        @click="abrirModal('usuario', 'habilitar', datos)">
                                                            <i class="far fa-plus-square" style="color: green;"></i>
                                                            Habilitar Usuario
                                                    </a>
                                                </div>
                                            </div>
                                        </td>
                                        <td style="text-align:center;">
                                            @{{ datos.nombre }}
                                        </td>
                                        <td style="text-align:center;">
                                            @{{ datos.ap_paterno }}
                                            </td>
                                        <td style="text-align:center;">
                                            @{{ datos.ap_materno }}
                                        </td>
                                         <td style="text-align:center;">
                                            @{{ datos.nm_direccion }} <br>
                                            @{{ datos.nm_depto }}
                                        </td>
                                        <td  style="text-align:center; color: black;">
                                            @{{ datos.nm_rol }}
                                        </td>
                                        <td  style="text-align:center; color: black;">
                                            <template v-if="datos.tp_admin == 0">Ninguno</template>
                                            <template v-if="datos.tp_admin == 1">Administrador Global</template>
                                            <template v-if="datos.tp_admin == 2">Administrador de Dirección</template>
                                            <template v-if="datos.tp_admin == 3">Administrador de Depto</template>
                                        </td>
                                        <td style="text-align:center;">
                                            <template v-if="datos.tp_publicar == 1">
                                                <button type="button" title="Desactivar Permiso Publicación Definitiva" class="btn btn-success" @click="actualizarPermiso('tp_finalizar', 0, datos)">
                                                    <i class="fas fa-check"></i>
                                                </button>
                                            </template>
                                            <template v-else>
                                                <button type="button" title="Activar Permiso Publicación Definitiva" class="btn btn-danger" @click="actualizarPermiso('tp_finalizar', 1, datos)">
                                                    <i class="fas fa-times"></i>
                                                </button>
                                            </template>
                                        </td>                                        
                                        <td style="text-align:center;">
                                            <template v-if="datos.tp_informar == 1">
                                                <button type="button" title="Desactivar Permiso Publicación Parcial" class="btn btn-success" @click="actualizarPermiso('tp_informar', 0, datos)">
                                                    <i class="fas fa-check"></i>
                                                </button>
                                            </template>
                                            <template v-else>
                                                <button type="button" title="Activar Permiso Publicación Parcial" class="btn btn-danger" @click="actualizarPermiso('tp_informar', 1, datos)">
                                                    <i class="fas fa-times"></i>
                                                </button>
                                            </template>
                                        </td>
                                        <td style="text-align:center;">
                                            <template v-if="datos.tp_responder == 1">
                                                <button type="button" title="Desactivar Permiso Respuesta Interna" class="btn btn-success" @click="actualizarPermiso('tp_responder', 0, datos)">
                                                    <i class="fas fa-check"></i>
                                                </button>
                                            </template>
                                            <template v-else>
                                                <button type="button" title="Activar Permiso Respuesta Interna" class="btn btn-danger" @click="actualizarPermiso('tp_responder', 1, datos)">
                                                    <i class="fas fa-times"></i>
                                                </button>
                                            </template>
                                        </td>
                                        <td style="text-align:center;">
                                            <template v-if="datos.tp_derivar == 1">
                                                <button type="button" title="Desactivar Permiso Derivar" class="btn btn-success" @click="actualizarPermiso('tp_derivar', 0, datos)">
                                                    <i class="fas fa-check"></i>
                                                </button>
                                            </template>
                                            <template v-else>
                                                <button type="button" title="Activar Permiso Derivar" class="btn btn-danger" @click="actualizarPermiso('tp_derivar', 1, datos)">
                                                    <i class="fas fa-times"></i>
                                                </button>
                                            </template>
                                        </td>
                                        <td style="text-align:center;">
                                            <template v-if="datos.tp_derivar == 2">
                                                <button type="button" title="Desactivar Permiso Derivar" class="btn btn-success" @click="actualizarPermiso('tp_derivar', 0, datos)">
                                                    <i class="fas fa-check"></i>
                                                </button>
                                            </template>
                                            <template v-else>
                                                <button type="button" title="Activar Permiso Derivar" class="btn btn-danger" @click="actualizarPermiso('tp_derivar', 2, datos)">
                                                    <i class="fas fa-times"></i>
                                                </button>
                                            </template>
                                        </td>
                                        <td style="text-align:center;">
                                            <template v-if="datos.tp_publicar == 1">
                                                <template v-if="datos.tp_vb_depto == 1">
                                                    <button type="button" title="Desactivación No Disponible" class="btn btn-warning">
                                                        <i class="fas fa-check"></i>
                                                    </button>
                                                </template>
                                                <template v-else>                                                    
                                                    <button type="button" title="Activación No Disponible" class="btn btn-warning">
                                                        <i class="fas fa-times"></i>
                                                    </button>
                                                </template>  
                                            </template>
                                            <template v-else>
                                                <template v-if="datos.id_rol == 7">
                                                    <template v-if="datos.tp_vb_depto == 1">
                                                        <button type="button" title="Desactivar VB° Jefe Depto." class="btn btn-success" @click="actualizarPermiso('tp_vb_depto', 0, datos)">
                                                            <i class="fas fa-check"></i>
                                                        </button>
                                                    </template>
                                                    <template v-else>
                                                        <button type="button" title="Activación No Disponible" class="btn btn-warning">
                                                            <i class="fas fa-times"></i>
                                                        </button>
                                                    </template>
                                                </template>
                                                <template v-else>
                                                    <template v-if="datos.tp_vb_director == 0">
                                                        <template v-if="datos.tp_vb_depto == 1">
                                                            <button type="button" title="Desactivar VB° Jefe Depto." class="btn btn-success" @click="actualizarPermiso('tp_vb_depto', 0, datos)">
                                                                <i class="fas fa-check"></i>
                                                            </button>
                                                        </template>
                                                        <template v-else>
                                                            <button type="button" title="Activar VB° Jefe Depto." class="btn btn-danger" @click="actualizarPermiso('tp_vb_depto', 1, datos)">
                                                                <i class="fas fa-times"></i>
                                                            </button>
                                                        </template>
                                                    </template>
                                                    <template v-else>
                                                        <button type="button" title="Activación No Disponible" class="btn btn-warning">
                                                            <i class="fas fa-times"></i>
                                                        </button>
                                                    </template>
                                                </template>
                                            </template>
                                        </td>
                                        <td style="text-align:center;">
                                            <template v-if="datos.tp_publicar == 1">
                                                <template v-if="datos.tp_vb_director == 1">
                                                    <button type="button" title="Desactivación No Disponible" class="btn btn-warning">
                                                        <i class="fas fa-check"></i>
                                                    </button>
                                                </template>
                                                <template v-else>
                                                    <button type="button" title="Activación No Disponible" class="btn btn-warning">
                                                        <i class="fas fa-times"></i>
                                                    </button>
                                                </template>  
                                            </template>
                                            <template v-else>
                                                <template v-if="datos.id_rol == 7 && datos.tp_admin == 2">
                                                    <template v-if="datos.tp_vb_director == 1">
                                                        <button type="button" title="Desactivar VB° Director" class="btn btn-success" @click="actualizarPermiso('tp_vb_director', 0, datos)">
                                                            <i class="fas fa-check"></i>
                                                        </button>
                                                    </template>
                                                    <template v-else>
                                                        <button type="button" title="Activación No Disponible" class="btn btn-warning">
                                                            <i class="fas fa-times"></i>
                                                        </button>
                                                    </template>
                                                </template>
                                                <template v-else>
                                                    <template v-if="datos.tp_vb_depto == 0">
                                                        <template v-if="datos.tp_vb_director == 1">
                                                            <button type="button" title="Desactivar VB° Director" class="btn btn-success" @click="actualizarPermiso('tp_vb_director', 0, datos)">
                                                                <i class="fas fa-check"></i>
                                                            </button>
                                                        </template>
                                                        <template v-else>
                                                            <button type="button" title="Activar VB° Director" class="btn btn-danger" @click="actualizarPermiso('tp_vb_director', 1, datos)">
                                                                <i class="fas fa-times"></i>
                                                            </button>
                                                        </template>
                                                    </template>
                                                    <template v-else>
                                                        <button type="button" title="Activación No Disponible" class="btn btn-warning">
                                                            <i class="fas fa-times"></i>
                                                        </button>
                                                    </template>
                                                </template>
                                            </template>
                                        </td>
                                        <td style="text-align:center;">
                                            <template v-if="datos.tp_activo == 1">Habilitado</template>
                                            <template v-else>Inhabilitado</template>
                                        </td>
                                    </tr>
                                </template>
                                <template v-else>
                                    <tr>
                                        <td colspan="16">
                                            <h5 class="text-center">
                                                No hay datos para listar
                                            </h5>
                                        </td>
                                    </tr>
                                </template>
                            </tbody>
                        </table>
                    </div>

                    <!-- Paginacion -->
                    <div class="col-md-12 col-sm-12">
                        <nav>
                            <ul class="pagination">
                                <li class="page-item" v-if="pagination.current_page > 1">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.current_page - 1)">Ant</a>
                                </li>
                                <li class="page-item" v-for="page in pagesNumber" :key="page" :class="[page == isActivedPagination ? 'active' : '']">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(page, 1)" v-text="page"></a>
                                </li>
                                <li class="page-item" v-if="pagination.current_page < pagination.last_page">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.current_page + 1)">Sig</a>
                                </li>
                            </ul>
                        </nav>
                    </div>                      
                </div>
            </div>
        </div>        

        <!-- modal - registro de usuario -->
        <div class="modal" tabindex="-1" id="modal_usuario">
            <div class="modal-dialog modal-dialog-scrollable modal-xl">
                <div class="modal-content">
                  <div class="modal-header bg-primary">
                    <h5 class="modal-title text-white">@{{ titulo_modal }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                  </div>
                  <div class="modal-body">
                        <div class="col-md-12 col-sm-12 mt-2">
                            <div class="row-flow">
                                <!-- Datos de Funcionario -->
                                <div class="card mt-2 border-info">
                                    <div class="card-header bg-primary border-info">
                                        <div class="form-check form-check-inline">
                                            <h5 class="form-check-label text-white">Información del Usuario</h5>
                                        </div>
                                    </div>

                                    <div class="card-body">
                                        <div class="row" >
                                            <!-- Rut -->
                                            <div class="col-md-3 col-sm-6 mt-2">
                                                <div class="form-group">
                                                    <label>Rut</label>
                                                    <input @change="validarRut(0);" type="text" class="form-control" id="nr_rut" v-model="nr_rut" :disabled="(tp_accion == 2)">
                                                    <small class="text-error text-danger" v-if="arr_valida.nr_rut" v-text="arr_valida.nr_rut[0]"></small>
                                                    <small class="text-error text-danger" v-if="arr_form.nr_rut"  v-text="arr_form.nr_rut"></small>
                                                </div>
                                            </div>
                                            <!-- Nombre -->
                                            <div class="col-md-3 col-sm-6 mt-2">
                                                <div class="form-group">
                                                    <label>Nombre</label>
                                                    <input type="text" maxlength="20" class="form-control" v-model="nombre">
                                                    <small class="text-error text-danger" v-if="arr_valida.nombre" v-text="arr_valida.nombre[0]"></small>
                                                    <small class="text-error text-danger" v-if="arr_form.nombre"  v-text="arr_form.nombre"></small>
                                                </div>
                                            </div>
                                            <!-- Ap Paterno -->
                                            <div class="col-md-3 col-sm-6 mt-2">
                                                <div class="form-group">
                                                    <label>Apellido Paterno</label>
                                                    <input type="text" maxlength="20" class="form-control" v-model="ap_paterno">
                                                    <small class="text-error text-danger" v-if="arr_valida.ap_paterno" v-text="arr_valida.ap_paterno[0]"></small>
                                                    <small class="text-error text-danger" v-if="arr_form.ap_paterno"  v-text="arr_form.ap_paterno"></small>
                                                </div>
                                            </div>
                                            <!-- Ap Materno -->
                                            <div class="col-md-3 col-sm-6 mt-2">
                                                <div class="form-group">
                                                    <label>Apellido Materno</label>
                                                    <input type="text" maxlength="50" class="form-control" v-model="ap_materno">
                                                    <small class="text-error text-danger" v-if="arr_valida.ap_materno" v-text="arr_valida.ap_materno[0]"></small>
                                                    <small class="text-error text-danger" v-if="arr_form.ap_materno"  v-text="arr_form.ap_materno"></small>
                                                </div>
                                            </div>
                                            <!-- Telfono -->                                                    
                                            <div class="col-md-3 mt-2">
                                                <div class="form-group">
                                                    <label>Teléfono</label>
                                                    <div class=" input-group">
                                                        <div class="input-group-prepend">
                                                            
                                                            <div class="input-group-text">
                                                            <select v-model="nr_prefijo">
                                                                <option value="+569">+569</option>
                                                                <option value="+562">+562</option>
                                                            </select>
                                                            </div>
                                                        </div>
                                                        <input v-model="nr_telefono" type="text"  maxlength="8" type="text" class="form-control" 
                                                            onkeypress="return justNumbers(event);">
                                                    </div>
                                                    <small class="text-error text-danger" v-if="arr_valida.nr_telefono" v-text="arr_valida.nr_telefono[0]"></small>
                                                    <small class="text-error text-danger" v-if="arr_form.nr_telefono"  v-text="arr_form.nr_telefono"></small>
                                                </div>
                                            </div>
                                            <!-- Mail -->
                                            <div class="col-md-3 col-sm-6 mt-2">
                                                <div class="form-group">
                                                    <label>Correo Electrónico</label>
                                                    <input type="text" maxlength="50" id="nm_email" class="form-control" v-model="nm_email" @change="validarMail(0)">
                                                    <small v-if="arr_valida.nm_email" v-text="arr_valida.nm_email[0]"></small>
                                                    <small class="text-error text-danger" v-if="arr_form.nm_email"  v-text="arr_form.nm_email"></small>
                                                </div>
                                            </div>
                                            <!-- Confirmar Mail -->
                                            <div class="col-md-3 col-sm-6 mt-2">
                                                <div class="form-group">
                                                    <label>Confirmar Correo</label>
                                                    <input type="text" maxlength="50" id="confirmar_mail" class="form-control tp_bloquear_accion" 
                                                        v-model="confirmar_mail" @change="validarMail(0)">
                                                    <small class="text-error text-danger" v-if="arr_form.confirmar_mail"  v-text="arr_form.confirmar_mail"></small>
                                                </div>
                                            </div>
                                            <!-- Password -->
                                            <div class="col-md-3 col-sm-6 mt-2">
                                                <div class="form-group">
                                                    <label>Contraseña</label>
                                                    <div class="input-group auth-pass-inputgroup">
                                                        <input type="password" class="form-control" placeholder="Contraseña" id="password" aria-label="Contraseña" aria-describedby="password-addon">
                                                        <button class="btn btn-light " type="button" id="password-addon" style="z-index: 1;"><i class="mdi mdi-eye-outline"></i></button>
                                                    </div>
                                                    <small class="text-error text-danger" v-if="arr_form.password"  v-text="arr_form.password"></small>
                                                </div>
                                            </div>
                                            <!-- Direccion Municipal -->
                                            <div class="col-md-6 col-sm-6 mt-2">
                                                <div class="form-group">
                                                    <label>Dirección Municipal</label>
                                                    <multiselect 
                                                        :show-labels="false"
                                                        :searchable="true"
                                                        v-model="nr_direccion"
                                                        :options="arr_direccion"
                                                        :multiple="false"
                                                        :showNoOptions ="false" 
                                                        @select="asyncDeptos" 
                                                        placeholder="Seleccionar Dirección Municipal"
                                                        label="label"                                                                 
                                                        track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                    </multiselect>
                                                    <small class="text-error text-danger" v-if="arr_valida.nr_direccion" v-text="arr_valida.nr_direccion[0]"></small>
                                                    <small class="text-error text-danger" v-if="arr_form.nr_direccion"  v-text="arr_form.nr_direccion"></small>
                                                </div>
                                            </div>
                                            <!-- Depto Municipal -->
                                            <div class="col-md-6 col-sm-6 mt-2">
                                                <div class="form-group">
                                                    <label>Depto Municipal</label>
                                                    <multiselect 
                                                        :show-labels="false"
                                                        :searchable="true"
                                                        v-model="nr_depto"
                                                        :options="arr_depto"
                                                        :multiple="false"
                                                        :showNoOptions ="false" 
                                                        placeholder="Seleccionar Depto Municipal"
                                                        label="label"                                                                 
                                                        track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                    </multiselect>
                                                    <small class="text-error text-danger" v-if="arr_valida.nr_depto" v-text="arr_valida.nr_depto[0]"></small>
                                                    <small class="text-error text-danger" v-if="arr_form.nr_depto"  v-text="arr_form.nr_depto"></small>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Asignación de Roles -->
                                <div class="card mt-4">
                                    <div class="card-header bg-primary" style="color:white">
                                        <div class="form-check form-check-inline">
                                            <h5 class="form-check-label text-white">Asignación de Roles</h5>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <!-- Registro de Asignación de roles -->
                                            <div class="col-lg-12 col-md-12 col-sm-12">
                                                <!-- Roles -->
                                                <div class="col-md-12 col-sm-12">
                                                    <div class="row">
                                                        <!-- Rol -->
                                                        <div class="col-md-4 col-sm-6 mt-2">
                                                            <div class="form-group">
                                                                <label>Rol</label>
                                                                <multiselect 
                                                                    :show-labels="false"
                                                                    :searchable="true"
                                                                    v-model="nr_rol"
                                                                    :options="arr_temp_roles"
                                                                    :multiple="false"
                                                                    :showNoOptions ="false" 
                                                                    placeholder="Seleccionar Rol"
                                                                    label="label"                                                                 
                                                                    track-by="label">
                                                                    <span slot="noResult">No se han encontrado resultados</span>
                                                                </multiselect>
                                                                <small class="text-error text-danger" v-if="arr_valida.nr_rol" v-text="arr_valida.nr_rol[0]"></small>
                                                                <small class="text-error text-danger" v-if="arr_form.nr_rol"  v-text="arr_form.nr_rol"></small>
                                                            </div>
                                                        </div>
                                                        <!-- Tipo Administrador --> <!-- Solo para Administradores --><!--
                                                        <div class="col-md-4 col-sm-6 mt-2" v-if="getValue(nr_rol) == 7"> 
                                                            <div class="form-group">
                                                                <label>Tipo Administrador</label>
                                                                <multiselect 
                                                                    :show-labels="false"
                                                                    :searchable="true"
                                                                    v-model="nr_administrador"
                                                                    :options="arr_temp_admin"
                                                                    :multiple="false"
                                                                    :showNoOptions ="false" 
                                                                    placeholder="Seleccionar Tipo Administrador"
                                                                    label="label"                                                                 
                                                                    track-by="label">
                                                                    <span slot="noResult">No se han encontrado resultados</span>
                                                                </multiselect>
                                                                <small class="text-error text-danger" v-if="arr_valida.nr_administrador" v-text="arr_valida.nr_administrador[0]"></small>
                                                                <small class="text-error text-danger" v-if="arr_form.nr_administrador"  v-text="arr_form.nr_administrador"></small>
                                                            </div>
                                                        </div>-->
                                                        <!-- Macrozona --> <!-- Para el Rol Territorial | Macrozona -->
                                                        <div class="col-md-4 col-sm-6 mt-2" v-if="(getValue(nr_rol) == 1 || getValue(nr_rol) == 3)"> 
                                                            <div class="form-group">
                                                                <label>Macrozona</label>
                                                                <multiselect 
                                                                    :show-labels="false"
                                                                    :searchable="true"
                                                                    v-model="nr_macrozona"
                                                                    :options="arr_temp_mz" 
                                                                    @input="asyncAddUnidadVecinal" 
                                                                    :multiple="true"
                                                                    :showNoOptions ="false" 
                                                                    placeholder="Seleccionar Macrozona"
                                                                    label="label"                                                                 
                                                                    track-by="label">
                                                                    <span slot="noResult">No se han encontrado resultados</span>
                                                                </multiselect>
                                                                <small class="text-error text-danger" v-if="arr_valida.nr_macrozona" v-text="arr_valida.nr_macrozona[0]"></small>
                                                                <small class="text-error text-danger" v-if="arr_form.nr_macrozona"  v-text="arr_form.nr_macrozona"></small>
                                                            </div>
                                                        </div>
                                                        <!-- Unidad Vecinal --> <!-- Para el Rol Territorial -->
                                                        <div class="col-md-4 col-sm-6 mt-2" v-if="getValue(nr_rol) == 1"> 
                                                            <div class="form-group">
                                                                <label>Unidad Vecinal</label>
                                                                <multiselect 
                                                                    :searchable="true"  
                                                                    v-model="nr_unidadvecinal" 
                                                                    :options="arr_temp_uv" 
                                                                    :multiple="true" 
                                                                    group-values="unidadvecinal" 
                                                                    group-label="nm_macrozona" 
                                                                    :group-select="true" 
                                                                    placeholder="Seleccionar Unidad Vecinal" 
                                                                    track-by="label" 
                                                                    label="label">
                                                                        <span slot="noResult">No se han encontrado resultados.</span>
                                                                    </multiselect>
                                                                <small class="text-error text-danger" v-if="arr_valida.nr_unidadvecinal" v-text="arr_valida.nr_unidadvecinal[0]"></small>
                                                                <small class="text-error text-danger" v-if="arr_form.nr_unidadvecinal"  v-text="arr_form.nr_unidadvecinal"></small>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12 col-sm-12 mt-2 pt-2 text-center">
                                                        <button type="button" class="btn btn-success waves-effect waves-light col-6" 
                                                            @click="agregarRol()">
                                                            <i class="fas fa-portrait"></i> Asignar
                                                        </button>
                                                    </div>
                                                </div>

                                                <div class="col-lg-12 col-md-12 col-sm-12 table-responsive mt-2">
                                                    <table class="table table-bordered table-striped table-sm">
                                                        <thead>
                                                            <tr class="bg-primary">
                                                                <th colspan="5" class="text-center" style="color: white;">Lista de Roles</th>
                                                            </tr>
                                                            <tr>
                                                                <th style="min-width:100px; text-align:center;">#</th>
                                                                <th style="min-width:100px; text-align:center;">Opción</th>
                                                                <th style="min-width:150px; text-align:center;">Rol</th>
                                                                <th style="min-width:200px; text-align:center;">Detalle</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <template v-if="arr_roles_seleccionados.length">
                                                                <tr v-for="(seleccionado, index) in arr_roles_seleccionados" :key="seleccionado.value">
                                                                    <td class="text-center">@{{ (index + 1) }}</td>
                                                                    <td class="text-center">
                                                                        <button type="button" class="btn btn-success  waves-effect waves-light" title="Desasignar" 
                                                                            @click="quitarRol(index)">
                                                                            <i class="fas fa-user-times"></i>
                                                                        </button>
                                                                    </td>
                                                                    <td class="text-center">
                                                                        @{{ seleccionado.nm_rol }}                                                                        
                                                                    </td>
                                                                    <td class="text-center">
                                                                        <template v-if="seleccionado.id_rol == 7">
                                                                            @{{ seleccionado.nm_admin }}
                                                                        </template>
                                                                        <template v-if="seleccionado.id_rol == 1">
                                                                            <label>Unidades Vecinales</label>
                                                                            <template v-if="seleccionado.arr_distribucion.length">
                                                                                <div class="row col-12">
                                                                                    <div class="col-lg-3 col-md-4 col-sm-6" v-for="(uv,index) in seleccionado.arr_distribucion" :key="uv.value">
                                                                                        @{{ (index+1)+'.- '+ uv.label }}
                                                                                    </div>
                                                                                </div>
                                                                            </template>
                                                                        </template>
                                                                        <template v-if="seleccionado.id_rol == 3">
                                                                            <label>Macroterritorio</label>
                                                                            <template v-if="seleccionado.arr_distribucion.length">
                                                                                <div class="row col-12">
                                                                                    <div class="col-lg-3 col-md-4 col-sm-6" v-for="(mz,index) in seleccionado.arr_distribucion" :key="mz.value">
                                                                                        @{{ (index+1)+'.- '+ mz.label }}
                                                                                    </div>
                                                                                </div>
                                                                            </template>
                                                                        </template>
                                                                    </td>
                                                                </tr>
                                                            </template>
                                                            <template v-if="arr_roles_asignados.length">
                                                                <tr v-for="(asignado, index) in arr_roles_asignados" :key="asignado.id">
                                                                    <td class="text-center">@{{ (index + 1) }}</td>
                                                                    <td class="text-center">
                                                                        <button type="button" class="btn btn-danger waves-effect waves-light" title="Desasignar" 
                                                                            @click="abrirModal('usuario','desasignar',asignado)">
                                                                            <i class="fas fa-portrait"></i>
                                                                        </button>
                                                                    </td>
                                                                    <td class="text-center">
                                                                        @{{ asignado.nm_rol }}
                                                                    </td>
                                                                    <td class="text-center">
                                                                        <template v-if="asignado.id_rol == 7">
                                                                            @{{ asignado.nm_admin }}
                                                                        </template>
                                                                        <template v-if="asignado.id_rol == 1">
                                                                            <label>Unidades Vecinales</label>
                                                                            <template v-if="arr_info.unidadvecinal.length">
                                                                                <div class="row col-12">
                                                                                    <div class="col-lg-3 col-md-4 col-sm-6" v-for="(uv,index) in arr_info.unidadvecinal" :key="uv.id_unidadvecinal">
                                                                                        @{{ (index+1)+'.- '+ uv.nm_unidadvecinal }}
                                                                                    </div>
                                                                                </div>
                                                                            </template>
                                                                        </template>
                                                                        <template v-if="asignado.id_rol == 3">
                                                                            <label>Macroterritorio</label>
                                                                            <template v-if="arr_info.macrozona.length">
                                                                                <div class="row col-12">
                                                                                    <div class="col-lg-3 col-md-4 col-sm-6" v-for="(mz,index) in arr_info.macrozona" :key="mz.value">
                                                                                        @{{ (index+1)+'.- '+ mz.label }}
                                                                                    </div>
                                                                                </div>
                                                                            </template>
                                                                        </template>
                                                                    </td>
                                                                </tr>
                                                            </template>
                                                            <template v-else>
                                                                <td colspan="5">
                                                                    <div class="empty" empty-text="No hay datos para listar"></div>
                                                                </td>
                                                            </template>
                                                        </tbody>
                                                    </table>
                                                </div>

                                                <small class="text-error text-danger" v-if="arr_form.arr_roles_seleccionados"  v-text="arr_form.arr_roles_seleccionados"></small>
                                                <small class="text-error text-danger" v-if="arr_form.arr_roles_asignados"  v-text="arr_form.arr_roles_asignados"></small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>                            
                        </div>                            
                    </div>
                    <div class="modal-footer">
                        <div class="col-lg-12 col-md-12 col-sm-12" style="text-align: center;">
                            <template v-if="tp_accion == 1">
                                <button v-if="btn_envio == 0 " type="button" class="btn btn-success  waves-effect waves-light col-8" @click="ensamblarDatos('registrar')">
                                    <i class="fas fa-save"></i> Registrar
                                </button>
                                <button v-else type="button"  class="btn btn-success">Registrando <i  class="fas fa-spin fa-spinner col-8"></i></button>
                            </template>
                            <template v-else>
                                <button v-if="btn_envio == 0 " type="button" class="btn btn-success  waves-effect waves-light col-8" @click="ensamblarDatos('actualizar')">
                                    <i class="fas fa-edit"></i> Actualizar
                                </button>
                                <button v-else type="button"  class="btn btn-success">Actualizando <i  class="fas fa-spin fa-spinner col-8"></i></button>
                            </template>
                            <button type="button" class="btn btn-secondary" style="float: right;" data-bs-dismiss="modal">Cerrar</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    <script type="text/javascript">
        Vue.component('vue-multiselect', window.VueMultiselect.default);

        var app = new Vue({
            el: '#app',
            data: {
                //-------------------------------------
                tp_modal                    :   0,
                tp_accion                   :   0,
                tp_btn                      :   0,
                titulo_modal                :   '',
                btn_envio                   :   0,                
                //-------------------------------------
                arr_valida                  :   [],
                arr_error                   :   [],
                arr_form                    :   {},
                str_msj                     :   '',
                //-------------------------------------
                pagination                  : {
                    'total' : 0,
                    'current_page' : 0,
                    'per_page' : 0,
                    'last_page' : 0,
                    'from' : 0,
                    'to' : 0,
                },
                //-------------------------------------
                offset                      :   3,
                //-------------------------------------
                tp_criterio                 :   'nombre',
                tp_buscar                   :   '',
                //-------------------------------------
                arr_info                    :   null,
                arr_index                   :   [],
                arr_direccion               :   [],
                arr_depto                   :   [],
                arr_roles                   :   [],
                arr_macrozona               :   [],
                arr_unidadvecinal           :   [],
                arr_nivel                   :   [
                    {
                        value : 1,
                        label : 'Usuario Nivel 1',
                    },
                    {
                        value : 2,
                        label : 'Usuario Nivel 2',
                    },
                    {
                        value : 3,
                        label : 'Usuario Nivel 3',
                    },

                ],
                arr_administrador           :   [
                    {
                        value : 1,
                        label : 'Administrador Global',
                    },
                    {
                        value : 2,
                        label : 'Administrador de Dirección',
                    },
                    {
                        value : 3,
                        label : 'Administrador de Depto',
                    },
                ],
                //-------------------------------------
                arr_temp_roles              :   [],
                arr_temp_admin              :   [],
                arr_temp_uv                 :   [],
                arr_temp_mz                 :   [],
                //-------------------------------------
                nr_direccion                :   {
                    value : 0,
                    label : 'Seleccionar Dirección Municipal',
                },
                nr_depto                    :   {
                    value : 0,
                    label : 'Seleccionar Depto Municipal',
                },
                nr_rol                      :   {
                    value : 0,
                    label : 'Seleccionar Rol',
                },
                nr_nivel                    :   {
                    value : 3,
                    label : 'Usuario Nivel 3',
                },
                nr_administrador            :   {
                    value : 0,
                    label : 'Seleccionar Tipo Administrador',
                },
                nr_macrozona                :   [],
                nr_unidadvecinal            :   [],
                arr_roles_seleccionados     :   [],
                arr_roles_asignados         :   [],
                nr_rol_quitar               :   0,
                nm_rol_quitar               :   '',
                //-------------------------------------
                nr_usuario                  :   0,
                data_usuario                :   [],
                tp_activo                   :   0,
                //-------------------------------------
                nr_rut                      :   '',
                nm_usuario                  :   '',
                nombre                      :   '',
                ap_paterno                  :   '',
                ap_materno                  :   '',
                nr_prefijo                  :   '+562',
                nr_telefono                 :   '',
                nm_email                    :   '',
                confirmar_mail              :   '',
                password                    :   '',
                //-------------------------------------
            },

            components: {
                Multiselect: window.VueMultiselect.default
            },

            filters:{
                resumir: function (texto, limite=300, final=' ...')
                {
                    let me  = this;
                    var largo = texto.toString().length;
                    if(largo > limite){
                        for (var i = 0; i < largo; i++) {
                            if(texto[i] == ' ' && i >= limite) {
                                texto   =   texto.substring(0,i);
                                texto   =   texto + final;
                                return texto;
                            }
                        }                    
                    }
                    return texto;
                },

                formatDate: function (fecha)
                {
                    if(fecha)
                        return moment(String(fecha)).format('DD-MM-YYYY')
                },

                formatDateTime: function (fecha)
                {
                    if(fecha)
                    {
                        return moment(String(fecha)).format('DD-MM-YYYY HH:mm')
                    }
                },
            },

            computed:{
                //-------------------------------------------------------------------------------------------
                isActivedPagination: function()
                {
                    return this.pagination.current_page;
                },
                //-------------------------------------------------------------------------------------------
                pagesNumber: function()
                {
                    if(!this.pagination.to) {
                        return [];
                    }

                    var from = this.pagination.current_page - this.offset;
                    if(from < 1) {
                        from = 1;
                    }

                    var to = from + (this.offset * 2);
                    if(to >= this.pagination.last_page){
                        to = this.pagination.last_page;
                    }

                    var pagesArray = [];
                    while(from <= to) {
                        pagesArray.push(from);
                        from++;
                    }
                    return pagesArray;
                },
                //-------------------------------------------------------------------------------------------
            },

            methods: {
                //-------------------------------------------------------------------------------------------
                setScrollTo(tag_id)
                {
                    // var container   =   $('.modal #historia_solicitud'); // $('html, body, .main-content');
                    // var scrollTo    =   $('#' + tag_id);

                    $("#" + tag_id).animate({
                        scrollTop: $(document).height()
                    }, 500);

                    // container.animate({scrollTop : $('#' + tag_id).offset().top +1000 }, 'slow');
                },
                //-------------------------------------------------------------------------------------------
                cambiarPagina(page)
                {
                    let me  =   this;
                    me.pagination.current_page = page;
                    me.cargarDatos(page);
                },
                //-------------------------------------------------------------------------------------------
                refrescarDatos()
                {
                    let me  =   this;

                    me.cargarRoles();
                    me.cargarDireccionesMunicipales();
                    me.cargarDatos(me.pagination.current_page);
                },
                //-------------------------------------------------------------------------------------------
                getLabel(data)
                {
                    var valor   =   '';

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.label;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                getValue(data)
                {
                    var valor   =   0;

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.value;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                getElemento(tp_elemento, data = [])
                {
                    let me      =   this;
                    var temp    =   [];
                    var arr     =   [];
                    var element =   [];

                    switch(tp_elemento)
                    {
                        case 'macrozona':
                        {
                            temp    =   data.macrozona;

                            for (var i = 0; i < temp.length; i++) {
                                if(!arr.includes(temp[i].value))
                                    arr.push(temp[i].value);
                            }

                            for (var i = 0; i < arr.length; i++) {
                                for (var j = 0; j < me.arr_macrozona.length; j++) {
                                    if(me.arr_macrozona[j].value === arr[i])
                                        element.push(me.arr_macrozona[j]);
                                }
                            }

                            break;
                        }
                        case 'zona_uv':
                        {
                            temp    =   data.unidadvecinal;

                            for (var i = 0; i < temp.length; i++) {
                                if(!arr.includes(temp[i].value))
                                    arr.push(temp[i].value);
                            }

                            for (var i = 0; i < arr.length; i++) {
                                for (var j = 0; j < me.arr_macrozona.length; j++) {
                                    if(me.arr_macrozona[j].value === arr[i])
                                        element.push(me.arr_macrozona[j]);
                                }
                            }

                            break;
                        }
                        case 'unidadvecinal':
                        {                            
                            temp    =   data.unidadvecinal;

                            console.log('----- Macrozona -----');
                            console.log(me.nr_macrozona);
                            console.log('----- Unidad Vecinal -----');
                            console.log(me.arr_unidadvecinal);
                            console.log('----- temp -----');
                            console.log(temp);
                            

                            for (var i = 0; i < temp.length; i++) {
                                if(!arr.includes(temp[i].id_unidadvecinal))
                                    arr.push(temp[i].id_unidadvecinal);
                            }

                            var uv  =   [];

                            if(me.arr_unidadvecinal.length)
                            {
                                uv  =   me.arr_unidadvecinal;

                                for (var i = 0; i < arr.length; i++) {
                                    for (var j = 0; j < uv.length; j++) {
                                        for (var k = 0; k < uv[j].unidadvecinal.length; k++) {
                                            if(uv[j].unidadvecinal[k].value == arr[i])
                                                element.push(uv[j].unidadvecinal[k]);
                                        }
                                    }
                                }
                            }

                            console.log('----- element -----');
                            console.log(element);

                            break;
                        }
                    }

                    return element;
                },
                //-------------------------------------------------------------------------------------------
                cerrarModal(modelo)
                {
                    let me  =   this;

                    switch(modelo)
                    {
                        case 'registrar':
                        {
                            $('#modal_usuario').modal('hide');
                            me.limpiarDatos(modelo);

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                asyncDeptos(item)
                {
                    let me  =   this;

                    if(item)
                    {
                        me.nr_direccion     =   item;
                        me.cargarDeptosMunicipales(me.getValue(me.nr_direccion));
                    }
                    else
                        me.arr_depto        =   [];
                },
                //-------------------------------------------------------------------------------------------
                asyncAddUnidadVecinal(item)
                {
                    let me  =   this;
                    me.cargarUnidadVecinalPorMacrozona(me.nr_macrozona);
                },
                //-------------------------------------------------------------------------------------------
                cargarDireccionesMunicipales()
                {
                    let me      =   this;
                    var ruta    =   '/listado/direcciones_municipales';
                    me.arr_direccion    =   [];
                    
                    axios.get(ruta).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_direccion    =   respuesta.listado;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarDeptosMunicipales(nr_direccion)
                {
                    let me      =   this;
                    var ruta    =   '/listado/deptos_municipales';
                    me.arr_depto    =   [];

                    axios.post(ruta,{
                        'nr_direccion'      :   nr_direccion,
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_depto        =   respuesta.listado;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarRoles()
                {
                    let me      =   this;
                    var ruta    =   '/listado/roles';
                    me.arr_depto    =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_roles        =   respuesta.roles;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarMacrozona()
                {
                    let me      =   this;
                    var ruta    =   '/listado/macrozona';
                    me.arr_macrozona    =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_macrozona    =   respuesta.macrozona;
                        me.arr_temp_mz      =   respuesta.macrozona;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarUnidadVecinal(arr_macrozona = [])
                {
                    let me      =   this;
                    var ruta    =   '/listado/unidadvecinal';
                    me.arr_unidadvecinal    =   [];

                    axios.post(ruta,{
                        'arr_macrozona'      :   arr_macrozona,
                    }).then(function (response)
                    {
                        var respuesta           =   response.data;
                        me.arr_unidadvecinal    =   respuesta.unidadvecinal;
                        me.arr_temp_uv          =   respuesta.unidadvecinal;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarUnidadVecinalPorMacrozona(arr_macrozona = [])
                {
                    let me      =   this;
                    var ruta    =   '/listado/unidadvecinal_por_macrozona';
                    var formData            =   new FormData();
                    me.arr_unidadvecinal    =   [];

                    if(arr_macrozona.length != 0)
                    {
                        for (var i = 0; i < arr_macrozona.length; i++) 
                        {
                            formData.append('arr_macrozona['+i+']', arr_macrozona[i].value);
                        }

                        axios.post(ruta, formData, {
                        headers: {'Content-Type': 'multipart/form-data'}
                        }).then(function (response) 
                        {
                            var respuesta           =   response.data;
                            me.arr_unidadvecinal    =   respuesta;
                            me.arr_temp_uv          =   respuesta;
                        })
                        .catch(function (error){
                            console.log(error);
                        });
                    }                    
                },
                //-------------------------------------------------------------------------------------------
                cargarDatos(page = 1)
                {
                    let me          =   this;
                    var ruta        =   '/gestion/usuarios';

                    axios.post(ruta,{
                        'page'              :   page,
                        'tp_criterio'       :   me.tp_criterio,
                        'tp_buscar'         :   me.tp_buscar,
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_index        =   respuesta.info.data ;
                        me.pagination       =   respuesta.pagination;
                        me.rows             =   respuesta.info.data;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },                
                //-------------------------------------------------------------------------------------------
                filtrarDatos()
                {
                    let me  =   this;
                    me.cargarDatos();
                },
                //-------------------------------------------------------------------------------------------
                limpiarFiltros()
                {
                    let me  =   this;

                    me.tp_criterio  =   'nombre';
                    me.tp_buscar    =   '';

                    me.cargarDatos();
                },
                //-------------------------------------------------------------------------------------------
                limpiarDatos(modelo)
                {
                    let me  =   this;

                    switch(modelo)
                    {
                        case 'registrar':
                        {
                            me.nr_direccion     =   {
                                value : 0,
                                label : 'Seleccionar Dirección Municipal',
                            };
                            me.nr_depto         =   {
                                value : 0,
                                label : 'Seleccionar Depto Municipal',
                            };
                            me.nr_rol           =   {
                                value : 0,
                                label : 'Seleccionar Rol',
                            };
                            me.nr_nivel         =   {
                                value : 3,
                                label : 'Usuario Nivel 3',
                            };
                            me.nr_administrador =   {
                                value : 0,
                                label : 'Seleccionar Tipo Administrador',
                            };
                            me.nr_macrozona     =   [];
                            me.nr_unidadvecinal =   [];
                            me.arr_roles_asignados      =   [];
                            me.arr_roles_seleccionados  =   [];
                            me.arr_temp_roles   =   [];
                            me.nr_rut           =   '';
                            me.nombre           =   '';
                            me.ap_paterno       =   '';
                            me.ap_materno       =   '';
                            me.nr_prefijo       =   '+562';
                            me.nr_telefono      =   '';
                            me.nm_email         =   '';
                            me.confirmar_mail   =   '';
                            me.nr_usuario       =   0;

                            $('#password').val('');

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                asyncRolUsuario()
                {
                    let me  =   this;
                    me.arr_temp_roles   =   [];

                    if(me.arr_roles_asignados.length)
                        
                        me.arr_temp_roles   =   me.arr_roles.filter(
                                                    (roles) => !me.arr_info.roles.find(
                                                        (item) => roles.value === item.id_rol
                                                    )
                                                );
                    else
                        me.arr_temp_roles   =   me.arr_roles;
                },
                //-------------------------------------------------------------------------------------------
                agregarRol()
                {
                    let me      =   this;
                    let title   =   ''; 
                    let error   =   0;
                    let tabla   =   '';
                    let arr_uv  =   [];
                    let arr_mz  =   [];
                    let distribucion    =   [];

                    titulo  =   'Agregar Rol';
                    error   =   me.validarDatos('rol');

                    if(error == 1)
                        me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos.');
                    else
                    {
                        arr_mz          =   (me.getValue(me.nr_rol) == 3) ? me.nr_macrozona : [] ;
                        arr_uv          =   (me.getValue(me.nr_rol) == 1) ? me.nr_unidadvecinal : [] ;
                        tabla           =   (me.getValue(me.nr_rol) == 1) ? 'tb_unidadvecinal' : (me.getValue(me.nr_rol) == 3) ? 'tb_macroterritorio' : '' ;
                        distribucion    =   (me.getValue(me.nr_rol) == 1) ? arr_uv : (me.getValue(me.nr_rol) == 3) ? arr_mz : [] ;

                        me.arr_roles_seleccionados.push({
                            id_rol              :   me.getValue(me.nr_rol),
                            id_user             :   me.nr_usuario,
                            nr_rut              :   me.nr_rut,
                            nm_rol              :   me.getLabel(me.nr_rol),
                            tp_tabla            :   tabla,
                            arr_distribucion    :   distribucion,
                            // unidadvecinal       :   JSON.stringify(me.nr_unidadvecinal), // (me.getValue(me.nr_rol) == 1) ? me.nr_unidadvecinal : null,
                            // macrozona           :   JSON.stringify(me.nr_macrozona), // (me.getValue(me.nr_rol) == 3) ? me.nr_macrozona : null,
                        });

                        // se resetean los valores de los campos
                        me.nr_rol               =   {
                            value : 0,
                            label : 'Seleccionar Rol',
                        };
                        me.nr_administrador     =   {
                            value : 0,
                            label : 'Seleccionar Tipo Administrador',
                        };
                        me.nr_macrozona         =   [];
                        me.nr_unidadvecinal     =   [];

                        me.arr_temp_roles       =   me.arr_roles.filter(
                                                        (roles) => !me.arr_roles_seleccionados.find(
                                                            (item) => roles.value === item.id_rol
                                                        )
                                                    );
                    }
                },
                //-------------------------------------------------------------------------------------------
                quitarRol(index)
                {
                    let me      =   this;
                    me.arr_roles_seleccionados.splice(index, 1);

                    me.arr_temp_roles   =   me.arr_roles.filter(
                                                (roles) => !me.arr_roles_seleccionados.find(
                                                    (item) => roles.value === item.id_rol
                                                )
                                            );
                },
                //-------------------------------------------------------------------------------------------
                validarRut(tp_validar = 0)
                {
                    let me          =   this;
                    var valida      =   null;
                    
                    if(tp_validar == 0)
                        me.arr_form    =   {};

                    var nr_rut  =   $("#nr_rut").val();
                    var valida  =   Rut(nr_rut.trim());

                    if(me.nr_rut.trim().length && valida == false)
                        me.arr_form.nr_rut = 'Rut ingresado no es valido';

                    if(!me.nr_rut.trim().length)
                        me.arr_form.nr_rut = 'Debe ingresar Rut';

                    if(Object.keys(me.arr_form).length == 0)
                        $("#nr_rut").val(valida);
                },
                //-------------------------------------------------------------------------------------------
                validarMail(tp_validar = 0)
                {
                    let me          =   this;
                    var valida      =   null; // Valida Mail
                    var error       =   0;

                    me.nm_email          =   me.nm_email.trim().toLowerCase();
                    me.confirmar_mail   =   me.confirmar_mail.trim().toLowerCase();

                    if(tp_validar == 0)
                        me.arr_form    =   {};
                    
                    if(me.nm_email.trim().length)
                    {                            
                        valida     =   formatoMail(me.nm_email.trim());

                        if(valida == false)
                            me.arr_form.nm_email =   'Correo electrónico no es valido';
                    }
                    else
                        me.arr_form.nm_email     =   'Debe ingresar correo electrónico';


                    if(me.confirmar_mail.trim().length)
                    {
                        valida     =   formatoMail(me.confirmar_mail.trim());

                        if(valida == false)
                            me.arr_form.confirmar_mail  =   'Correo electrónico no es valido';
                    }
                    else
                        me.arr_form.confirmar_mail      =   'Debe ingresar correo electrónico';

                    if(!(me.nm_email.trim() === me.confirmar_mail.trim()) && 
                        (me.nm_email.trim().length && me.confirmar_mail.trim().length))
                            me.arr_form.confirmar_mail  =   'Los correos electrónicos no coinciden, favor validar';

                    if(Object.keys(me.arr_form).length)
                        error   =   1;                    

                    return error;
                },
                //-------------------------------------------------------------------------------------------
                ensamblarDatos(accion)
                {
                    let me              =   this;
                    var ruta            =   '';
                    var titulo          =   '';
                    var tiempo          =   3000;
                    var error           =   0;
                    var formData        =   new FormData();
                    var fc_format       =   'YYYY-MM-DD';
                    let roles           =   [];
                    //----------------------------------------------------------------
                    switch(accion)
                    {
                        case 'registrar':
                        {
                            titulo  =   'Registrar Usuario';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                ruta    =   '/gestion/usuarios/store';                            
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                // roles   =   me.arr_roles_seleccionados.map(item => item.id_rol);
                                //------------------------------------
                                formData.append('tp_accion', 1); // registrar
                                formData.append('nr_rut', me.nr_rut);
                                formData.append('nombre', me.nombre);
                                formData.append('ap_paterno', me.ap_paterno);
                                formData.append('ap_materno', me.ap_materno);
                                formData.append('nr_prefijo', me.nr_prefijo);
                                formData.append('nr_telefono', me.nr_telefono);
                                formData.append('nm_email', me.nm_email);
                                formData.append('password', $('#password').val());
                                formData.append('id_direccion', me.getValue(me.nr_direccion));
                                formData.append('id_depto', me.getValue(me.nr_depto));
                                // formData.append('id_rol', me.getValue(me.nr_rol));
                                formData.append('arr_roles[]', JSON.stringify(me.arr_roles_seleccionados));
                                formData.append('tp_rol', (me.arr_roles_seleccionados.length)? 1 : 0);
                                formData.append('nr_nivel', me.getValue(me.nr_nivel));

                                // if(me.getValue(me.nr_rol) == 7)
                                //     formData.append('tp_admin', me.getValue(me.nr_administrador));
                                // else
                                //     formData.append('tp_admin', 0);

                                // if(me.getValue(me.nr_rol) == 1)
                                // {
                                //     formData.append('tp_tabla', 'tb_unidadvecinal');
                                //     formData.append('nr_usuario', me.nr_usuario);
                                // }
                                // if(me.getValue(me.nr_rol) == 3)
                                // {
                                //     formData.append('tp_tabla', 'tb_macroterritorio');
                                //     formData.append('nr_usuario', me.nr_usuario);
                                // }
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'actualizar':
                        {
                            titulo  =   'Actualizar Usuario';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                ruta    =   '/gestion/usuarios/update';
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('tp_accion', 2); // actualizar
                                formData.append('nr_usuario', me.nr_usuario);
                                formData.append('nr_rut', me.nr_rut);
                                formData.append('nombre', me.nombre);
                                formData.append('ap_paterno', me.ap_paterno);
                                formData.append('ap_materno', me.ap_materno);
                                formData.append('nr_prefijo', me.nr_prefijo);
                                formData.append('nr_telefono', me.nr_telefono);
                                formData.append('nm_email', me.nm_email);
                                formData.append('password', $('#password').val());
                                formData.append('id_direccion', me.getValue(me.nr_direccion));
                                formData.append('id_depto', me.getValue(me.nr_depto));
                                // formData.append('id_rol', me.getValue(me.nr_rol));
                                formData.append('arr_roles[]', JSON.stringify(me.arr_roles_seleccionados));
                                formData.append('tp_rol', (me.arr_roles_seleccionados.length)? 1 : 0);
                                formData.append('nr_nivel', me.getValue(me.nr_nivel));

                                // if(me.getValue(me.nr_rol) == 7)
                                //     formData.append('tp_admin', me.getValue(me.nr_administrador));
                                // else
                                //     formData.append('tp_admin', 0);

                                // if(me.getValue(me.nr_rol) == 1)
                                // {
                                //     formData.append('arr_distribucion', JSON.stringify(me.nr_unidadvecinal));
                                //     formData.append('tp_tabla', 'tb_unidadvecinal');
                                // }
                                // if(me.getValue(me.nr_rol) == 3)
                                // {
                                //     formData.append('arr_distribucion', JSON.stringify(me.nr_macrozona));
                                //     formData.append('tp_tabla', 'tb_macroterritorio');
                                // }
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'estado':
                        {
                            titulo  =   (me.tp_activo == 1) ? 'Habilitar Usuario': 'Inhabilitar Usuario';
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'No es posible realizar la accion : "'+titulo+'"');
                            else
                            {
                                //------------------------------------
                                ruta    =   '/gestion/usuarios/state';
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_rut', me.nr_rut);
                                formData.append('nm_usuario', me.nm_usuario);
                                formData.append('tp_activo', me.tp_activo);
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'desasignar':
                        {
                            titulo  =   'Desasignar Rol';
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'No es posible realizar la accion : "'+titulo+'" <br>'+me.str_msj);
                            else
                            {
                                //------------------------------------
                                ruta    =   '/gestion/usuarios/quitar/rol';
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_usuario', me.nr_usuario);
                                formData.append('nm_usuario', me.nm_usuario);
                                formData.append('nr_rol', me.nr_rol_quitar);
                                formData.append('nm_rol', me.nm_rol_quitar);
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                    }
                    //----------------------------------------------------------------
                },
                //-------------------------------------------------------------------------------------------
                actualizarPermiso(tp_permiso, nr_valor = 1, data = [])
                {
                    let me              =   this;
                    var ruta            =   '';
                    var titulo          =   '';
                    var tiempo          =   3000;
                    var error           =   0;                    
                    var formData        =   new FormData();
                    var fc_format       =   'YYYY-MM-DD';
                    //------------------------------------------------------------------------
                    titulo  =   (nr_valor == 1) ? 'Habilitar Permiso': 'Inhabilitar Permiso';
                    //------------------------------------------------------------------------
                    ruta    =   '/gestion/usuarios/permisos';
                    me.zonaDeEspera(titulo, tiempo);
                    //------------------------------------------------------------------------
                    formData.append('nr_rut', data.nr_rut);
                    formData.append('tp_permiso', tp_permiso);
                    formData.append('nr_valor', nr_valor);
                    //------------------------------------------------------------------------
                    axios.post(ruta, formData, {
                        headers: {'Content-Type': 'multipart/form-data'}
                    }).then(function (response) 
                    {
                        var result  =   response.data;                       
                        tp_icon     =   result.tp_icon;
                        titulo      =   result.title;
                        mensaje     =   result.msj;
                        me.desplegarVentana(tp_icon, titulo, mensaje);
                        me.refrescarDatos();
                    })
                    .catch(function (error) 
                    {
                        if (error.response.status == 422)
                            me.validationErrors = error.response.data.errors;
                    });
                    //------------------------------------------------------------------------
                },
                //-------------------------------------------------------------------------------------------
                validarDatos(tp_validacion)
                {
                    let me          =   this;
                    var error       =   0;
                    me.arr_valida   =   [];    
                    me.arr_form     =   {}; 
                    me.str_msj      =   '';

                    switch(tp_validacion)
                    {
                        case 'registrar':
                        {
                            var valida_rut  =   Rut(me.nr_rut);
                            var valida_mail =   formatoMail(me.nm_email);
                            var str_pass    =   $('#password').val();

                            me.validarRut(1);
                            me.validarMail(1);

                            if(valida_rut == false)
                                me.arr_form.nr_rut      =   'Rut no es valido';

                            if(valida_mail == false)
                                me.arr_form.nm_email    =   'Correo no es valido';

                            if(me.nombre.trim().length < 3)
                                me.arr_form.nombre      =   'El nombre debe tener minimo 3 caracteres';

                            if(me.ap_paterno.trim().length < 3)
                                me.arr_form.ap_paterno  =   'El Ap. Paterno debe tener minimo 3 caracteres';

                            if(me.ap_materno.trim().length < 3)
                                me.arr_form.ap_materno  =   'El Ap. Materno debe tener minimo 3 caracteres';

                            if(str_pass.trim().length < 5)
                                me.arr_form.password    =   'La contraseña debe tener minimo 5 caracteres';

                            if(me.getValue(me.nr_direccion) == 0)
                                me.arr_form.nr_direccion    =   'Debe seleccionar la dirección municipal';

                            if(me.getValue(me.nr_depto) == 0)
                                me.arr_form.nr_depto        =   'Debe seleccionar el depto. municipal';

                            if(!me.arr_roles_seleccionados.length) 
                                me.arr_form.arr_roles_asignados     =   'Debe asignar un Rol al usuario';

                            /*
                            if(me.getValue(me.nr_rol) == 0)
                                me.arr_form.nr_rol      =   'Debe seleccionar el rol';

                            if(me.getValue(me.nr_administrador) == 0 && me.getValue(me.nr_rol) == 7)
                                me.arr_form.nr_administrador    =   'Debe seleccionar el Tipo de Administrador';

                            if(me.nr_macrozona.length == 0 && (me.getValue(me.nr_rol) == 1 || me.getValue(me.nr_rol) == 3))
                                me.arr_form.nr_macrozona    =   'Debe seleccionar la Macrozona';

                            if(me.nr_unidadvecinal.length == 0 && me.getValue(me.nr_rol) == 1)
                                me.arr_form.nr_unidadvecinal    =   'Debe seleccionar una Unidad Vecinal';
                            */

                            if(Object.keys(me.arr_form).length != 0)
                                error   =   1;

                            break;
                        }
                        case 'actualizar':
                        {
                            var valida_rut  =   Rut(me.nr_rut);
                            var valida_mail =   formatoMail(me.nm_email);

                            me.validarRut(1);
                            me.validarMail(1);

                            if(valida_rut == false)
                                me.arr_form.nr_rut      =   'Rut no es valido';

                            if(valida_mail == false)
                                me.arr_form.nm_email    =   'Correo no es valido';

                            if(me.nombre.trim().length < 3)
                                me.arr_form.nombre      =   'El nombre debe tener minimo 3 caracteres';

                            if(me.ap_paterno.trim().length < 3)
                                me.arr_form.ap_paterno  =   'El Ap. Paterno debe tener minimo 3 caracteres';

                            if(me.ap_materno.trim().length < 3)
                                me.arr_form.ap_materno  =   'El Ap. Materno debe tener minimo 3 caracteres';

                            if(me.getValue(me.nr_direccion) == 0)
                                me.arr_form.nr_direccion    =   'Debe seleccionar la dirección municipal';

                            if(me.getValue(me.nr_depto) == 0)
                                me.arr_form.nr_depto        =   'Debe seleccionar el depto. municipal';

                            if(!me.arr_roles_asignados.length && !me.arr_roles_seleccionados.length) 
                                me.arr_form.arr_roles_asignados     =   'Debe asignar un Rol al usuario';

                            /*
                            if(me.getValue(me.nr_rol) == 0)
                                me.arr_form.nr_rol      =   'Debe seleccionar el rol';

                            if(me.getValue(me.nr_administrador) == 0 && me.getValue(me.nr_rol) == 7)
                                me.arr_form.nr_administrador    =   'Debe seleccionar el Tipo de Administrador';

                            if(me.nr_macrozona.length == 0 && (me.getValue(me.nr_rol) == 1 || me.getValue(me.nr_rol) == 3))
                                me.arr_form.nr_macrozona    =   'Debe seleccionar la Macrozona';

                            if(me.nr_unidadvecinal.length == 0 && me.getValue(me.nr_rol) == 1)
                                me.arr_form.nr_unidadvecinal    =   'Debe seleccionar una Unidad Vecinal';
                            */

                            if(Object.keys(me.arr_form).length != 0)
                                error   =   1;

                            break;
                        }
                        case 'estado':
                        {
                            if(me.nr_usuario == 0)
                                me.str_msj  =   me.str_msj + 'No es posible encontrar el id del usuario';

                            if((typeof me.nr_rut === "") || (me.nr_rut === null))
                                me.str_msj  =   me.str_msj + '<br>No se encuentra el rut del usuario';

                            if((typeof me.nm_usuario === "") || (me.nm_usuario === null))
                                me.str_msj  =   me.str_msj + '<br>No se encuentra el nombre del usuario';

                            if(me.str_msj.trim().length != 0)
                                error   =   1;

                            break;
                        }
                        case 'rol':
                        {
                            var valida_rut  =   Rut(me.nr_rut);

                            me.validarRut(1);

                            if(valida_rut == false)
                                me.arr_form.nr_rut      =   'Rut no es valido';

                            if(me.getValue(me.nr_rol) == 0)
                                me.arr_form.nr_rol      =   'Debe seleccionar el rol';

                            if(me.nr_macrozona.length == 0 && (me.getValue(me.nr_rol) == 1 || me.getValue(me.nr_rol) == 3))
                                me.arr_form.nr_macrozona    =   'Debe seleccionar la Macrozona';

                            if(me.nr_unidadvecinal.length == 0 && me.getValue(me.nr_rol) == 1)
                                me.arr_form.nr_unidadvecinal    =   'Debe seleccionar una Unidad Vecinal';

                            if(Object.keys(me.arr_form).length != 0)
                                error   =   1;

                            break;
                        }
                        case 'desasignar':
                        {
                            if(me.nr_usuario == 0)
                                me.str_msj  =   me.str_msj + 'No se encuentra el Código Identificador del usuario <br>';

                            if(me.nm_usuario == 0)
                                me.str_msj  =   me.str_msj + 'No se encuentra el Nombre del usuario <br>';

                            if(me.nr_rol_quitar == 0)
                                me.str_msj  =   me.str_msj + 'No se encuentra el Código Identificador del Rol a quitar <br>';

                            if(me.nm_rol_quitar == 0)
                                me.str_msj  =   me.str_msj + 'No se encuentra el Nombre del rol a quitar <br>';

                            if(Object.keys(me.arr_form).length != 0)
                                error   =   1;

                            break;
                        }
                    }                    

                    return error;
                },
                //-------------------------------------------------------------------------------------------
                registrarDatos(ruta, formData)
                {
                    let me              =       this;
                    var tp_icon         =       '';
                    var titulo          =       '';
                    var mensaje         =       '';
                    var error           =       '';
                    me.validationErrors =       [];
                    me.btn_envio        =        1;

                    axios.post(ruta, formData, {
                        headers: {'Content-Type': 'multipart/form-data'}
                    }).then(function (response) 
                    {
                        var result  =   response.data;                       
                        tp_icon     =   result.tp_icon;
                        titulo      =   result.title;
                        mensaje     =   result.msj;
                        error       =   result.error;

                        me.desplegarVentana(tp_icon, titulo, mensaje);

                        //Limpiar Modelos
                        if(error == 0)
                        {
                            me.limpiarDatos('registrar');
                            me.refrescarDatos();
                            $('#modal_usuario').modal('hide');
                        }

                        me.btn_envio    =   0;
                    })
                    .catch(function (error) 
                    {
                        me.btn_envio    =   0;

                        if (error.response.status == 422)
                            me.validationErrors = error.response.data.errors;
                        /*// Formato de Archivo Incorrecto
                        if (error.response.status == 413)
                        {
                            //------------------------------
                        }
                        */
                    });
                },
                //-------------------------------------------------------------------------------------------
                abrirModal(modelo, accion, data = [])
                {
                    let me      =   this;
                    me.arr_form =   {};

                    switch(modelo)
                    {
                        case 'usuario':
                        {
                            switch(accion)
                            {
                                case 'registrar':
                                {
                                    me.tp_modal                 =   1;
                                    me.tp_accion                =   1;
                                    me.tp_btn                   =   1;
                                    me.btn_envio                =   0;
                                    me.titulo_modal             =   'Registrar Usuario';
                                    me.arr_info                 =   null;
                                    me.limpiarDatos(accion);
                                    me.asyncRolUsuario();
                                    $('#modal_usuario').modal('show');

                                    break;
                                }
                                case 'actualizar':
                                {
                                    me.nr_macrozona             =   [];
                                    me.nr_unidadvecinal         =   [];
                                    me.arr_roles_asignados      =   [];
                                    me.arr_roles_seleccionados  =   [];
                                    me.tp_modal                 =   1;
                                    me.tp_accion                =   2;
                                    me.tp_btn                   =   2;
                                    me.btn_envio                =   0;
                                    me.titulo_modal             =   'Actualizar Usuario';
                                    //---------------------------------------------------
                                    me.arr_info                 =   data;
                                    me.nr_usuario               =   data.id;
                                    me.nr_rut                   =   Rut(data.nr_rut);
                                    me.nm_usuario               =   data.nm_usuario;
                                    me.nombre                   =   data.nombre;
                                    me.ap_paterno               =   data.ap_paterno;
                                    me.ap_materno               =   data.ap_materno;
                                    me.nr_prefijo               =   data.movil.substr(0,4);
                                    me.nr_telefono              =   data.movil.substr(4,10);
                                    me.nm_email                 =   data.email;
                                    //---------------------------------------------------
                                    me.nr_direccion             =   {
                                        'value' : data.id_direccion,
                                        'label' : data.nm_direccion,
                                    };
                                    me.nr_depto                 =   {
                                        'value' : data.id_depto,
                                        'label' : data.nm_depto,
                                    };
                                    /*
                                    me.nr_rol                   =   {
                                        'value' : data.id_rol,
                                        'label' : data.nm_rol,
                                    };
                                    */
                                    me.arr_roles_asignados      =   data.roles;
                                    //---------------------------------------------------
                                    me.cargarDeptosMunicipales(data.id_direccion);
                                    me.asyncRolUsuario();
                                    //---------------------------------------------------
                                    // obtiene el tipo de administrador
                                    /*
                                    for (var i = 0; i < me.arr_administrador.length; i++) {
                                        if(me.arr_administrador[i].value === data.tp_admin)
                                            me.nr_administrador     =   me.arr_administrador[i];
                                    }

                                    if(data.macrozona.length)
                                        me.nr_macrozona     =   me.getElemento('macrozona', data);

                                    if(data.unidadvecinal.length)
                                    {                                       
                                        me.nr_macrozona     =   me.getElemento('zona_uv', data);
                                        me.cargarUnidadVecinalPorMacrozona(me.nr_macrozona);

                                        setTimeout(function(){
                                            me.nr_unidadvecinal =   me.getElemento('unidadvecinal', data);
                                        }, 1000);
                                    }
                                    */                                    
                                    //---------------------------------------------------
                                    console.log('----------------------------');
                                    console.log(data);
                                    console.log('----------------------------');
                                    //---------------------------------------------------
                                    $('#modal_usuario').modal('show');

                                    break;
                                }
                                case 'inhabilitar':
                                {
                                    me.nr_usuario           =   data.id;
                                    me.nr_rut               =   data.nr_rut;
                                    me.nm_usuario           =   data.nm_usuario;
                                    me.tp_activo            =   0;
                                    me.ensamblarDatos('estado');

                                    break;
                                }
                                case 'habilitar':
                                {
                                    me.nr_usuario           =   data.id;
                                    me.nr_rut               =   data.nr_rut;
                                    me.nm_usuario           =   data.nm_usuario;
                                    me.tp_activo            =   1;
                                    me.ensamblarDatos('estado');

                                    break;
                                }
                                case 'desasignar':
                                {
                                    me.tp_modal             =   1;
                                    me.tp_accion            =   3;
                                    me.nr_usuario           =   data.id_user;
                                    me.nm_usuario           =   data.name;
                                    me.nr_rol_quitar        =   data.id_rol;
                                    me.nm_rol_quitar        =   data.nm_rol;
                                    me.tp_activo            =   0;
                                    me.ensamblarDatos('desasignar');

                                    break;
                                }
                            }

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                zonaDeEspera(titulo, tiempo)
                {
                    Swal.fire({
                        title : '<h5>'+titulo+'</h5>',
                        html: '<strong> </strong>',
                        showConfirmButton: false,
                        timer: tiempo,
                        onBeforOpen: () => {
                            Swal.showLoading()
                        },
                    }).then((result) => {
                        if(result.dismiss == Swal.DismissReason.timer)
                        {
                            //----------------------------------------
                        }
                    });
                },
                //-------------------------------------------------------------------------------------------
                desplegarVentana(tp_icon, titulo, mensaje, tp_btn = 1)
                {
                    Swal.fire({
                        icon: tp_icon,
                        title: titulo,
                        html: mensaje,
                        backdrop:false,
                        showConfirmButton: tp_btn
                    });                       
                },
                //-------------------------------------------------------------------------------------------
            },

            mounted() {
                let me = this;
                me.cargarDatos();
                me.cargarRoles();
                me.cargarDireccionesMunicipales();
                me.cargarMacrozona();
            }
        });
    </script>

    <script type="text/javascript">
        //-----------------------------------------------------------------
        $(document).ready(function(){
            /*----- Inicio - Filtrar -----*/
            $("#btn_filtrar_datos").click(function () {
                $content = $("#filtrar_datos");
                $content.slideToggle(500, function () {
                    // ---------------------------                    
                });
            });

            $("#close_filtrar_datos").click(function () {
                $content = $("#filtrar_datos");
                $content.slideToggle(500, function () {
                    // ---------------------------                    
                });
            });
            /*----- Inicio - Modal -----*/

            /*----- Inicio - Bloquear Acciones -----*/
            $('#nm_email').on('cut copy paste', function(e){
                e.preventDefault();
            });

            $('#confirmar_mail').on('cut copy paste', function(e){
                e.preventDefault();
            });
            /*----- Termino - Bloquear Acciones -----*/

            /*----- Formatea Rut -----*/
            $("#nr_rut").change(function()
            { 
                var nr_rut = $("#nr_rut").val();
                var salida = Rut(nr_rut);

                if(salida)
                    $("#nr_rut").val(salida);
            });

            $('#modal_usuario').modal({backdrop: 'static', keyboard: false});
        });
        //-----------------------------------------------------------------
        function justNumbers(e)
        {
            var keynum = window.event ? window.event.keyCode : e.which;
            if (keynum == 8)
                return true;

            return /\d/.test(String.fromCharCode(keynum));
        }
        //-----------------------------------------------------------------
        function Rut(texto)
        { 
            var tmpstr = "";

            for ( i=0; i < texto.length ; i++ )   
                if ( texto.charAt(i) != ' ' && texto.charAt(i) != '.' && texto.charAt(i) != '-' )
                    tmpstr = tmpstr + texto.charAt(i);

            texto = tmpstr; 
            largo = texto.length; 

            if ( largo < 2 ) 
                return false; 

            for (i=0; i < largo ; i++ )    
                if (texto.charAt(i) !="0" && texto.charAt(i) != "1" && texto.charAt(i) !="2" && texto.charAt(i) != "3" && 
                    texto.charAt(i) != "4" && texto.charAt(i) !="5" && texto.charAt(i) != "6" && texto.charAt(i) != "7" && 
                    texto.charAt(i) !="8" && texto.charAt(i) != "9" && texto.charAt(i) !="k" && texto.charAt(i) != "K")   
                    return false;

            var invertido = "";

            for ( i=(largo-1),j=0; i>=0; i--,j++ )    
                invertido = invertido + texto.charAt(i);

            var dtexto = "";  
            dtexto = dtexto + invertido.charAt(0);  
            dtexto = dtexto + '-';  
            cnt = 0;  

            for ( i=1,j=2; i<largo; i++,j++ ) 
            { 
                if ( cnt == 3 )   
                {     
                    dtexto = dtexto + '.';      
                    j++;      
                    dtexto = dtexto + invertido.charAt(i);      
                    cnt = 1;    
                }   
                else    
                {       
                    dtexto = dtexto + invertido.charAt(i);      
                    cnt++;    
                } 
            } 

            invertido = "";

            for ( i=(dtexto.length-1),j=0; i>=0; i--,j++ )    
                invertido = invertido + dtexto.charAt(i);

            if (revisarDigito2(texto))
                return  invertido.toUpperCase();

            return false;
        }
        //-----------------------------------------------------------------
        function formatoMail(valor)
        {
            if (/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test(valor))
                return true;
            else
                return false;
        }
        //-----------------------------------------------------------------
    </script>

@endsection()


