<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Documento PDF</title>

    <style>
        @page {
            margin: 35pt 20pt 30pt 20pt; /* top right bottom left - espacio para header y footer */
            header: html_myHeader;
            footer: html_myFooter;
        }

        @page :first {
            margin-bottom: 30pt; 
            footer: html_myFooter;
        }
        
        :root {
            --primary-color: #1664c0;
            --primary-light: #d1e1f7; /* Versión clara */
            --primary-lighter: #e8f1fd; /* Versión muy clara */
        }

        /* Estilos base */
        body {
            font-family: Arial, sans-serif;
            font-size: 10pt;
            margin: 0;
            padding: 0;
            color: #333;
            line-height: 1.4;
        }

        /* Evitar saltos de página no deseados */
        .avoid-break {
            page-break-inside: avoid;
            break-inside: avoid;
        }

        /* Encabezado */
        .pdf-header {
            text-align: center;
            width: 100%;
            background-color: #1664c0;
            color: white;
            padding: 5pt 20pt 5pt 20pt; /* top right bottom left */
        }

        .pdf-header h1 {
            margin: 0;
            font-size: 15pt;
        }

        .logo-lascondes {
            width: 30%;
            height: auto;
            margin-top: 2pt;
        }

        /* Cuerpo del documento */
        .pdf-body {
            padding: 35pt;
        }

        /* Pie de página */
        .pdf-footer {
            position: fixed;
            bottom: -20pt;
            left: 0;
            right: 0;
            height: 20pt;
            background-color: #1664c0;
            color: white;
            text-align: center;
            line-height: 20pt;
            font-size: 10pt;
        }

        .page-number {
            font-weight: bold;
        }

        /* Resto de estilos igual que en tu plantilla original */
        /* Imágenes */
        .anexo-img {
            max-width: 100%;
            height: auto;
            margin-top: 10pt;
            display: block;
        }

        /* Versión mejorada de row/col para PDF */
        .grid {
            width: 100%;
            display: table;
            table-layout: fixed;
            border-collapse: collapse;
            margin-bottom: 0pt;
        }
        
        .grid-row {
            display: table-row;
        }
        
        .col {
            display: table-cell;
            vertical-align: top;
            padding: 5pt;
        }
        
        .col-1 { width: 8.33%; }
        .col-2 { width: 16.66%; }
        .col-3 { width: 25%; }
        .col-4 { width: 33.33%; }
        .col-5 { width: 41.66%; }
        .col-6 { width: 50%; }
        .col-7 { width: 58.33%; }
        .col-8 { width: 66.66%; }
        .col-9 { width: 75%; }
        .col-10 { width: 83.33%; }
        .col-11 { width: 91.66%; }
        .col-12 { width: 100%; }
        
        /* COMPONENTES REUTILIZABLES */
        .card {
            border: 1pt solid #ddd;
            border-radius: 3pt;
            margin-bottom: 15pt;
            page-break-inside: avoid;
        }
        
        .card-header {
            background-color: #1664c0;
            color: white;
            padding: 8pt;
            font-weight: bold;
            border-bottom: 1pt solid #ddd;
        }
        
        .card-body {
            padding: 10pt;
        }
        
        .card-footer {
            padding: 8pt;
            background-color: #fafafa;
            border-top: 1pt solid #eee;
            font-size: 8.5pt;
        }
        
        /* TABLAS MEJORADAS */
        .table {
            width: 100%;
            border-collapse: collapse;
            margin: 5pt 0;
            font-size: 8pt;
        }
        
        .table th {
            background-color: #f2f2f2;
            font-weight: bold;
            text-align: left;
        }
        
        .table th, 
        .table td {
            border: 1pt solid #ddd;
            padding: 5pt;
            vertical-align: top;
        }
        
        .table-striped tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        
        /* UTILIDADES */
        .mt-0 { margin-top: 0 !important; }
        .mt-5 { margin-top: 5pt !important; }
        .mt-10 { margin-top: 10pt !important; }
        .mb-0 { margin-bottom: 0 !important; }
        .mb-5 { margin-bottom: 5pt !important; }
        .mb-10 { margin-bottom: 10pt !important; }
        
        .pt-0 { padding-top: 0 !important; }
        .pt-5 { padding-top: 5pt !important; }
        .pt-10 { padding-top: 10pt !important; }
        .pb-0 { padding-bottom: 0 !important; }
        .pb-5 { padding-bottom: 5pt !important; }
        .pb-10 { padding-bottom: 10pt !important; }
        
        .text-left { text-align: left; }
        .text-center { text-align: center; }
        .text-right { text-align: right; }
        
        .bold { font-weight: bold; }
        .italic { font-style: italic; }
        .underline { text-decoration: underline; }
        
        .bg-gray { background-color: #f5f5f5; }
        .bg-yellow { background-color: #fffde7; }
        .bg-blue { background-color: #e3f2fd; }
        
        /* CONTROL DE SALTO DE PÁGINA */
        .page-break-before { page-break-before: always; }
        .page-break-after { page-break-after: always; }
        .avoid-break { page-break-inside: avoid; }
        
        /* Permitir saltos de página en elementos específicos */
        .allow-break {
            page-break-inside: auto;
            break-inside: auto;
        }
        
        /* ESTILOS ESPECÍFICOS PARA EL VECINO */
        .info-section {
            margin-top: 5pt;
            border-top: 1pt solid #eee;
            padding-top: 10pt;
        }
        
        .info-grid {
            width: 100%;
            display: table;
            table-layout: fixed;
            border-collapse: collapse;
        }

        .info-field {
            margin-bottom: 0pt;
        }

        .no-gap {
            margin: 0;
            padding: 0;
        }

        .info-container {
            margin-top: 0;
            padding-top: 0;
        }

        /*-------------------------------------------------------------------------*/
        /*-------------------------------------------------------------------------*/

        /* Timeline mejorado y estilizado */
        .timeline {
            list-style: none;
            padding-left: 0;
            margin: 0 0 20pt 0;
            position: relative;
        }

        .timeline:before {
            content: '';
            position: absolute;
            top: 0;
            bottom: 0;
            width: 2pt;
            background: #1664c0;
            left: 10pt;
            margin-left: -1pt;
        }

        .timeline-item {
            margin-bottom: 20pt;
            position: relative;
            padding-left: 35pt;
        }

        .timeline-icon {
            width: 20pt;
            height: 20pt;
            border-radius: 50%;
            background-color: #1664c0;
            position: absolute;
            left: 0;
            top: 2pt;
            text-align: center;
            color: white;
            font-weight: bold;
            line-height: 20pt;
            font-size: 12pt;
        }

        .timeline-date {
            display: inline-block;
            padding: 3pt 8pt;
            background-color: #1664c0;
            border-radius: 3pt;
            font-size: 9pt;
            color: white;
            margin-bottom: 5pt;
        }

        .timeline-label {
            font-weight: bold;
            display: block;
            margin-bottom: 3pt;
            color: #1664c0;
        }

        .timeline-content {
            font-size: 9pt;
            padding: 8pt;
            color: black;
            border-radius: 3pt;
            background-color: #fff;
            border-left: 3pt solid #5090e0;
        }

        /* Control específico de salto de página para elementos timeline */
        .timeline-item.avoid-break {
            page-break-inside: avoid;
        }

        /*-------------------------------------------------------------------------*/
        /*-------------------------------------------------------------------------*/

        /* Timeline de respuestas - estilo horizontal */
        .timeline-respuestas {
            list-style: none;
            padding-left: 0;
            margin: 0;
            position: relative;
        }

        .timeline-respuestas:before {
            content: '';
            position: absolute;
            top: 0;
            bottom: 0;
            width: 2pt;
            background: #1664c0;
            left: 10pt;
            margin-left: -1pt;
        }

        .timeline-respuesta-item {
            margin-bottom: 5px;
            position: relative;
            padding-left: 30pt;
            page-break-inside: avoid;
        }

        .timeline-respuesta-arrow {
            width: 15pt;
            height: 15pt;
            border-radius: 50%;
            background-color: #1664c0;
            position: absolute;
            left: 0;
            top: 2pt;
            text-align: center;
            color: white;
            font-weight: bold;
            line-height: 15pt;
            font-size: 10pt;
        }

        .timeline-respuesta-header {
            display: table;
            width: 100%;
            table-layout: fixed;
        }

        .timeline-respuesta-autor {
            display: table-cell;
            vertical-align: top;
            width: 70%;
            font-weight: bold;
            color: #1664c0;
        }

        .timeline-respuesta-fecha {
            display: table-cell;
            vertical-align: top;
            width: 30%;
            text-align: right;
            color: #666;
            font-size: 8pt;
        }

        .timeline-respuesta-contenido {
            margin-top: 3pt;
            font-size: 9pt;
            color: #333;
        }

        .timeline-respuesta-separador {
            border: 0;
            border-top: 1pt solid #eee;
            margin: 1pt 0;
        }

        /* Adaptación para que funcione bien en PDFs */
        .timeline-respuestas-container {
            width: 100%;
            margin-top: 5pt;
        }
    </style>
</head>
<body>
    @php
        function limpiarHTML($html) {
            // Reemplazar múltiples saltos de línea con uno solo
            $limpio = preg_replace('/(\r\n|\r|\n){2,}/', "\n", $html);
            
            // Reemplazar combinaciones de <br> múltiples
            $limpio = preg_replace('/<br\s*\/?>\s*<br\s*\/?>/i', '<br>', $limpio);
            
            // Eliminar espacios en blanco excesivos
            $limpio = preg_replace('/\s{2,}/', ' ', $limpio);
            
            return $limpio;
        }
    @endphp

    <!-- Pie de Pagína para la primera hoja -->
    <!-- <div style="position: fixed; bottom: -20pt; left: 0pt; right: 0pt; height: 30pt; background-color: #1664c0; z-index: 1000;"></div> -->
    
    <div style="position: fixed; bottom: -20pt; left: 0pt; right: 0pt; height: 30pt; background-color: #1664c0; z-index: -1;"></div>

    <script type="text/php">
        if (isset($pdf)) {
            $font = $fontMetrics->getFont("Arial", "normal");
            $size = 10;
            $y = $pdf->get_height() - 30; // Subimos un poco el texto
            $color = array(255, 255, 255);

            // Centrado
            $text = "Documento generado - {{ date('d/m/Y H:i') }}";
            $width = $fontMetrics->getTextWidth($text, $font, $size);
            $pdf->page_text(($pdf->get_width() - $width) / 2, $y, $text, $font, $size, $color);

            // A la derecha
            $pdf->page_text($pdf->get_width() - 100, $y, "Página {PAGE_NUM} de {PAGE_COUNT}", $font, $size, $color);
        }
    </script>

    <!-- Encabezado de páginas -->
    <div class="pdf-header">
        <div class="info-grid">
            <div class="grid-row">
                <div class="col col-6 no-gap" style="border-collapse: collapse;">
                    <img src="{{ file_exists($datos->str_logo) ? $datos->str_logo : '' }}" class="logo-lascondes" alt="Logo Las Condes">
                </div>
                <h1>{{ $datos->nm_sistema }}</h1>
            </div>
        </div>
    </div>

    <div class="pdf-body">
        <!-- Primera página -->
        <div class="card">
            <div class="card-header">
                Información del Ticket
                @if($datos->nr_ticket) - #{{ $datos->nr_ticket }} @endif
                @if($datos->nm_estado) - Estado Actual:{{ $datos->nm_estado }} @endif
            </div>
            <div class="card-body">
                <!-- Datos del Ticket -->
                <div class="info-grid">
                    <div class="grid-row">
                        <div class="col col-6 no-gap" style="border-collapse: collapse;">
                            @if($datos->info_ticket)
                                <div class="info-field">
                                    <span class="bold">Solicitud ingresada a las:</span> {{ $datos->info_ticket->fc_ingreso }}
                                </div>
                            @endif
                            @if($datos->info_ticket->nm_ingreso)
                                <div class="info-field">
                                    <span class="bold">Procedencia:</span> 
                                    {{ mb_convert_case($datos->info_ticket->nm_ingreso ?? '-', MB_CASE_TITLE, "UTF-8") }}
                                </div>
                            @endif
                            @if($datos->info_ticket)
                                <div class="info-field">
                                    <span class="bold">Estado Ticket:</span> {{ $datos->info_ticket->nm_estado }}
                                </div>
                            @endif
                        </div>
                        <div class="col col-6 no-gap">
                            @if($datos->info_ticket)
                                <div class="info-field">
                                    <span class="bold">Nro. Ticket:</span> {{ $datos->info_ticket->nr_ticket }}
                                </div>
                            @endif                            
                            @if($datos->info_ticket)
                                <div class="info-field">
                                    <span class="bold">Tipo Requerimiento:</span> {{ $datos->info_ticket->nm_motivo }}
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="info-grid">
                    <div class="grid-row">
                        <div class="col col-12 no-gap">
                            @if($datos->info_ticket)
                                <div class="info-field">
                                    <span class="bold">Servicio:</span> {{ $datos->info_ticket->nm_tipo }}
                                </div>
                            @endif 
                            @if($datos->info_ticket)
                                <div class="info-field">
                                    <span class="bold">Dirección Municipal:</span> {{ $datos->info_ticket->nm_direccion_destino }}
                                </div>
                            @endif
                            @if($datos->info_ticket)
                                <div class="info-field">
                                    <span class="bold">Depto. Municipal:</span> {{ $datos->info_ticket->nm_depto_destino }}
                                </div>
                            @endif
                            @if($datos->info_ticket)
                                <div class="info-field">
                                    <span class="bold">Descripción del Requerimiento:</span> {!! $datos->info_ticket->str_observacion_html !!}
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Datos del Vecino -->
        @if($datos->info_vecino)
            <div class="card">
                <div class="card-header">
                    Datos del Vecino
                </div>
                <div class="card-body allow-break">
                    <div class="info-grid">
                        <div class="grid-row">
                            <div class="col col-4 no-gap" style="border-collapse: collapse;">
                                @if($datos->info_vecino->nr_rut)
                                    <div class="info-field">
                                        <span class="bold">Rut:</span> {{ $datos->info_vecino->nr_rut }}
                                    </div>
                                @endif                                    
                                @if($datos->info_vecino->nr_telefono)
                                    <div class="info-field">
                                        <span class="bold">Teléfono:</span> {{ $datos->info_vecino->nr_prefijo }} - {{ $datos->info_vecino->nr_telefono }}
                                    </div>
                                @endif
                            </div>
                            <div class="col col-8 no-gap">
                                @if($datos->info_vecino->nmc_vecino)
                                    <div class="info-field">
                                        <span class="bold">Nombre:</span> 
                                        {{ mb_convert_case($datos->info_vecino->nmc_vecino ?? '-', MB_CASE_TITLE, "UTF-8") }}
                                    </div>
                                @endif                                    
                                @if($datos->info_vecino->nm_mail)
                                    <div class="info-field">
                                        <span class="bold">Correo:</span> {{ strtolower($datos->info_vecino->nm_mail) }}
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="info-grid">
                        <div class="grid-row">
                            <div class="col col-12 no-gap">
                                <div class="info-field">
                                    <span class="bold">Domicilio:</span> 
                                    {{ mb_convert_case($datos->info_vecino->nm_ubicacion ?? '-', MB_CASE_TITLE, "UTF-8") }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif

        <!-- Solicitud Clonada -->
        @if($datos->info_clonado)
            <div class="card">
                <div class="card-header">
                    Solicitud Clonada
                </div>
                <div class="card-body allow-break">
                    <div class="info-grid">
                        <div class="grid-row">
                            <div class="col col-12 no-gap" style="border-collapse: collapse;">
                                @if($datos->info_clonado->nr_ticket)
                                    <div class="info-field">
                                        <span class="bold">Ticket Original:</span> {{ $datos->info_clonado->nr_ticket }}
                                    </div>
                                @endif                                    
                                @if($datos->info_clonado->nm_tipo)
                                    <div class="info-field">
                                        <span class="bold">Servicio Origen:</span> {{ $datos->info_clonado->nm_tipo }}
                                    </div>
                                @endif
                                @if($datos->info_clonado->nm_depto)
                                    <div class="info-field">
                                        <span class="bold">Dirección Origen:</span> {{ $datos->info_clonado->nm_depto }}
                                    </div>
                                @endif                                    
                                @if($datos->info_clonado->nm_direccion)
                                    <div class="info-field">
                                        <span class="bold">Depto. Origen:</span> {{ $datos->info_clonado->nm_direccion}}
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Forzar un salto de página -->
            <div class="page-break-after"></div>
        @endif

        <!-- Solicitud Derivada -->
        @if($datos->info_derivado)
            @if($datos->info_ticket->str_observacion)
                <!-- Forzar un salto de página -->
                <div class="page-break-after"></div>
            @endif
            <div class="card">
                <div class="card-header">
                    Historial de Derivaciones
                </div>
                <div class="card-body allow-break">
                    <ul class="timeline">
                        @foreach($datos->info_derivado as $index => $derivar)
                        <li class="timeline-item avoid-break">
                            <div class="timeline-icon">{{ $index + 1 }}</div>
                            <div class="timeline-date">{{ $derivar->fc_inicio_derivacion ?? 'Sin fecha' }}</div>
                            <div class="timeline-label">@if($loop->first) - Solicitud Inicial @else - Solicitud Derivada @endif</div>
                            <div class="timeline-content">
                                <div class="mb-5"><span style="font-weight: bold;">Servicio:</span> {{ $derivar->nm_tipo }}</div>
                                <div class="mb-5"><span style="font-weight: bold;">Dirección:</span> {{ $derivar->nm_direccion }}</div>
                                <div><span style="font-weight: bold;">Depto:</span> {{ $derivar->nm_depto }}</div>
                            </div>
                        </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        @endif

        <!-- Historial del Ticket -->
        @if($datos->data_historial)
            <div class="card">
                <div class="card-header">
                    Historial del Ticket de Atención al Vecino
                </div>
                <div class="card-body allow-break">
                    <ul class="timeline">
                        @php
                            $is_muchos_encargado_servicio   =  false;
                        @endphp

                        @foreach($datos->data_historial as $index => $historia)
                            <!--  Solicitud Ingresada-->
                            @if($index == 0) 
                                <li class="timeline-item avoid-break">
                                    <div class="timeline-icon">{{ $index + 1 }}</div>
                                    <div class="timeline-date">Duración {{ $historia->fc_diferencia ?? ' 0 ' }} días</div>
                                    <div class="timeline-label">Solicitud Ingresada por {{ mb_convert_case($historia->nm_autor ?? '-', MB_CASE_TITLE, "UTF-8") }} | {{ $historia->fc_inicio ?? 'Sin fecha' }}</div>
                                    <div class="timeline-content">
                                        <div class="mb-5"><span style="font-weight: bold;">Servicio:</span> {{ $historia->nm_tipo }}</div>
                                        <div class="mb-5"><span style="font-weight: bold;">Dirección:</span> {{ $historia->nm_direccion }}</div>
                                        <div class="mb-5"><span style="font-weight: bold;">Depto:</span> {{ $historia->nm_depto }}</div>
                                        <div class="mb-5"><span style="font-weight: bold;">Descripción del Requerimiento:</span> {!! $datos->info_ticket->str_observacion_html !!}</div>
                                    </div>
                                </li>
                            @endif
                            <!-- Por Asignar -->
                            @if($historia->id_estado == 2) 
                                <li class="timeline-item avoid-break">
                                    <div class="timeline-icon">{{ $index + 1 }}</div>
                                    <div class="timeline-date">Duración {{ $historia->fc_diferencia ?? ' 0 ' }} días</div>
                                    <div class="timeline-label">Por Asignar | {{ $historia->fc_inicio ?? 'Sin fecha' }}</div>
                                    <div class="timeline-content">
                                        
                                    </div>
                                </li>
                            @endif
                            <!-- En Gestión -->
                            @if($historia->id_estado == 3) 
                                @if(($datos->info_derivado && count($datos->info_derivado) > 1) || $datos->info_vecino) 
                                    <!-- Insertar salto de página antes de este item -->
                                    <div style="page-break-before: always;"></div> 
                                    <div style="margin-top: 20px !important; padding-top: 15px !important; height: 15px !important;"></div>
                                @endif
                                <li class="timeline-item avoid-break">
                                    <div class="timeline-icon">{{ $index + 1 }}</div>
                                    <div class="timeline-date">Duración {{ $historia->fc_diferencia ?? ' 0 ' }} días</div>
                                    <div class="timeline-label">En Gestión | {{ $historia->fc_inicio ?? 'Sin fecha' }}</div>
                                    <div class="timeline-content">
                                        @php
                                            if(count($historia->encargado_servicio) >= 10) {
                                                $is_muchos_encargado_servicio   =  true;
                                            }
                                        @endphp

                                       @if(count($datos->info_respuestas))                                            
                                            <div class="card avoid-break" style="page-break-inside: avoid;">
                                                <div class="card-header" style="text-align: center;">
                                                    Gestiones Internas
                                                </div>
                                                <div class="card-body">
                                                    <div class="timeline-respuestas-container">
                                                        <ul class="timeline-respuestas">
                                                            @foreach($datos->info_respuestas as $index => $respuesta)
                                                                <li class="timeline-respuesta-item">
                                                                    <div class="timeline-respuesta-arrow">
                                                                        {{ $index + 1 }}
                                                                    </div>
                                                                    <div class="timeline-respuesta-header">
                                                                        <div class="timeline-respuesta-autor">
                                                                            {{ $respuesta->nm_respuesta ?? '' }} - {{ mb_convert_case($respuesta->usuario ?? '-', MB_CASE_TITLE, "UTF-8") }}
                                                                        </div>
                                                                        <div class="timeline-respuesta-fecha">
                                                                            <i class="far fa-calendar"></i> 
                                                                            {{ $respuesta->fc_ingreso ?? '' }}
                                                                        </div>
                                                                    </div>
                                                                    <div class="timeline-respuesta-contenido">
                                                                        {!! mb_convert_case(limpiarHTML($respuesta->str_observacion) ?? '-', MB_CASE_TITLE, "UTF-8") !!}
                                                                    </div>
                                                                    <hr class="timeline-respuesta-separador">
                                                                </li>
                                                            @endforeach
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        @else
                                            @if(count($historia->encargado_servicio))
                                                <table class="table table-striped">
                                                    <thead>
                                                        <tr>
                                                            <th colspan="2" style="text-align: center;">Funcionarios Encargados del Servicio</th>
                                                        </tr>
                                                        <tr>
                                                            <th style="text-align: center;">Unidad Municipal</th>
                                                            <th style="text-align: center;">Funcionario </th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @foreach($historia->encargado_servicio as $index => $encargado)
                                                            <tr>
                                                                <td>
                                                                    {{ $encargado->nm_direccion }} <br>
                                                                    {{ $encargado->nm_depto }}
                                                                </td>
                                                                <td>{{ mb_convert_case($encargado->nm_funcionario ?? '-', MB_CASE_TITLE, "UTF-8") }}</td>
                                                            </tr>
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            @else
                                                <table class="table table-striped">
                                                    <thead>
                                                        <tr>
                                                            <th colspan="2" style="text-align: center;">Funcionarios Encargados del Servicio</th>
                                                        </tr>
                                                        <tr>
                                                            <th style="text-align: center;">Unidad Municipal</th>
                                                            <th style="text-align: center;">Funcionario </th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td colspan="2">No se encontraron funcionarios encargados del servicio</td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            @endif
                                        @endif
                                    </div>
                                </li>
                            @endif
                            <!-- Publicada -->
                            @if($historia->id_estado == 5) 
                                <!-- Forzar un salto de página -->
                                <div class="page-break-after"></div>
                                <li class="timeline-item avoid-break">
                                    <div class="timeline-icon">{{ $index + 1 }}</div>
                                    <div class="timeline-date">Duración {{ $historia->fc_diferencia ?? ' 0 ' }} días</div>
                                    <div class="timeline-label">Respuesta Publicada por {{ mb_convert_case($historia->nm_autor ?? '-', MB_CASE_TITLE, "UTF-8") }} | {{ $historia->fc_inicio ?? 'Sin fecha' }}</div>
                                    <div class="timeline-content">
                                        <div class="mb-5"><span style="font-weight: bold;">Publicación:</span> {!! $historia->str_observacion_html !!}</div>

                                        @if($is_muchos_encargado_servicio)
                                            <div style="page-break-before: always;"></div> 
                                            <div style="margin-top: 20px !important; padding-top: 15px !important; height: 15px !important;"></div>
                                        @endif
                                    </div>
                                </li>
                            @endif
                            <!-- Finalizada -->
                            @if($historia->id_estado == 6) 
                                <li class="timeline-item avoid-break">
                                    <div class="timeline-icon">{{ $index + 1 }}</div>
                                    <div class="timeline-date">Duración {{ $historia->fc_diferencia ?? ' 0 ' }} días</div>
                                    <div class="timeline-label">Solicitud Finalizada | {{ $historia->fc_inicio ?? 'Sin fecha' }}</div>
                                    <div class="timeline-content">
                                        
                                    </div>
                                </li>
                            @endif
                            <!-- Rechazada -->
                            @if($historia->id_estado == 7) 
                                <li class="timeline-item avoid-break">
                                    <div class="timeline-icon">{{ $index + 1 }}</div>
                                    <div class="timeline-date">Duración {{ $historia->fc_diferencia ?? ' 0 ' }} días</div>
                                    <div class="timeline-label">Solicitud Rechazada | {{ $historia->fc_inicio ?? 'Sin fecha' }}</div>
                                    <div class="timeline-content">
                                        
                                    </div>
                                </li>
                            @endif
                            <!-- Derivado a Funcionario -->
                            @if($historia->id_estado == 8) 
                                <li class="timeline-item avoid-break">
                                    <div class="timeline-icon">{{ $index + 1 }}</div>
                                    <div class="timeline-date">Duración {{ $historia->fc_diferencia ?? ' 0 ' }} días</div>
                                    <div class="timeline-label">Solicitud Derivada por {{ mb_convert_case($historia->nm_autor ?? '-', MB_CASE_TITLE, "UTF-8") }} | {{ $historia->fc_inicio ?? 'Sin fecha' }}</div>
                                    <div class="timeline-content">
                                        <div class="mb-5"><span style="font-weight: bold;">Servicio:</span> {{ $historia->nm_tipo }}</div>
                                        <div class="mb-5"><span style="font-weight: bold;">Dirección:</span> {{ $historia->nm_direccion }}</div>
                                        <div class="mb-5"><span style="font-weight: bold;">Depto:</span> {{ $historia->nm_depto }}</div>
                                        
                                        @if($is_muchos_encargado_servicio)
                                            <div style="page-break-before: always;"></div> 
                                            <div style="margin-top: 20px !important; padding-top: 15px !important; height: 15px !important;"></div>
                                        @endif
                                        <div class="mb-5"><span style="font-weight: bold;">Descripción del Requerimiento:</span> {!! $datos->info_ticket->str_observacion_html !!}</div>
                                            
                                        @if(count($historia->encargado_servicio))
                                            <table class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th colspan="2" style="text-align: center;">Funcionarios Encargados del Servicio</th>
                                                    </tr>
                                                    <tr>
                                                        <th style="text-align: center;">Unidad Municipal</th>
                                                        <th style="text-align: center;">Funcionario </th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($historia->encargado_servicio as $index => $encargado)
                                                        <tr>
                                                            <td>
                                                                {{ $encargado->nm_direccion }} <br>
                                                                {{ $encargado->nm_depto }}
                                                            </td>
                                                            <td>{{ mb_convert_case($encargado->nm_funcionario ?? '-', MB_CASE_TITLE, "UTF-8") }}</td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        @else
                                            <table class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th colspan="2" style="text-align: center;">Funcionarios Encargados del Servicio</th>
                                                    </tr>
                                                    <tr>
                                                        <th style="text-align: center;">Unidad Municipal</th>
                                                        <th style="text-align: center;">Funcionario </th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td colspan="2">No se encontraron funcionarios encargados del servicio</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        @endif
                                    </div>
                                </li>
                            @endif
                            <!-- Derivado a Macrozona -->
                            @if($historia->id_estado == 9) 
                                <li class="timeline-item avoid-break">
                                    <div class="timeline-icon">{{ $index + 1 }}</div>
                                    <div class="timeline-date">Duración {{ $historia->fc_diferencia ?? ' 0 ' }} días</div>
                                    <div class="timeline-label">Solicitud Derivada por {{ mb_convert_case($historia->nm_autor ?? '-', MB_CASE_TITLE, "UTF-8") }} </div> | {{ $historia->fc_inicio ?? 'Sin fecha' }}</div>
                                    <div class="timeline-content">
                                        <div class="mb-5" style="text-align: center;"><span style="font-weight: bold;">Gestionada por Macrozona</span></div>
                                    </div>
                                </li>
                            @endif
                            <!-- Derivado a Asignador -->
                            @if($historia->id_estado == 10) 
                                <li class="timeline-item avoid-break">
                                    <div class="timeline-icon">{{ $index + 1 }}</div>
                                    <div class="timeline-date">Duración {{ $historia->fc_diferencia ?? ' 0 ' }} días</div>
                                    <div class="timeline-label">Solicitud Derivada por {{ mb_convert_case($historia->nm_autor ?? '-', MB_CASE_TITLE, "UTF-8") }} </div> | {{ $historia->fc_inicio ?? 'Sin fecha' }}</div>
                                    <div class="timeline-content">
                                        <div class="mb-5" style="text-align: center;"><span style="font-weight: bold;">Gestionada por Asignador</span></div>
                                    </div>
                                </li>
                            @endif
                        @endforeach
                    </ul>
                </div>
            </div>
        @endif
    </div>
</body>
</html>